/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.utils.PaletteQuantizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaletteQuantizerNeuQuant
implements PaletteQuantizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaletteQuantizerNeuQuant.class);
    private int parNcolors = 256;
    private int parNcycles = 330;
    private int _parCutnetsize;
    private int _parMaxnetpos;
    private int parRadiusbiasshift = 6;
    private int _parRadiusbias;
    private int _parInitBiasRadius;
    private int parRadiusdec = 30;
    private int parTransparencyThreshold = 127;
    private int parAlphabiasshift = 10;
    private int _parIinitalpha;
    private double parGamma = 1024.0;
    private double parBeta = 9.765625E-4;
    private double _parGammaBetta;
    private boolean parReserveAlphaColor = false;
    private int parMaxPixelsToSample = 30000;
    private int _parSamplefac;
    private double[][] network;
    protected int[][] colormap;
    private final int[] netindex = new int[256];
    private double[] bias;
    private double[] freq;
    private final int width;
    private final int height;
    private final PixelGetter pixelGetter;
    private boolean done = false;

    public PaletteQuantizerNeuQuant(int w, int h, PixelGetter pixelGetter) {
        this.width = w;
        this.height = h;
        this.pixelGetter = pixelGetter;
    }

    public int[] convert(int r, int g, int b) {
        this.initGuard();
        int i = this.indexSearch(b, g, r);
        int bb = this.colormap[i][0];
        int gg = this.colormap[i][1];
        int rr = this.colormap[i][2];
        return new int[]{rr, gg, bb};
    }

    public int[] convert(int r, int g, int b, int a) {
        this.initGuard();
        if (this.parReserveAlphaColor && a < this.parTransparencyThreshold) {
            return new int[]{0, 0, 0, 0};
        }
        int i = this.indexSearch(b, g, r);
        int bb = this.colormap[i][0];
        int gg = this.colormap[i][1];
        int rr = this.colormap[i][2];
        return new int[]{rr, gg, bb};
    }

    @Override
    public int[] getColor(int i) {
        this.initGuard();
        int index = i;
        if (this.parReserveAlphaColor && --index < 0) {
            return new int[]{0, 0, 0, 0};
        }
        if (index < 0 || index >= this.parNcolors) {
            throw new IllegalArgumentException("index out of range [0, " + this.parNcolors + "[");
        }
        int bb = this.colormap[index][0];
        int gg = this.colormap[index][1];
        int rr = this.colormap[index][2];
        return new int[]{rr, gg, bb, 255};
    }

    @Override
    public int getColorCount() {
        this.initGuard();
        return this.parReserveAlphaColor ? this.parNcolors + 1 : this.parNcolors;
    }

    @Override
    public int getTransparentIndex() {
        this.initGuard();
        return this.parReserveAlphaColor ? 0 : -1;
    }

    public boolean isParReserveAlphaColor() {
        return this.parReserveAlphaColor;
    }

    @Override
    public int lookup(int r, int g, int b) {
        this.initGuard();
        int i = this.indexSearch(b, g, r);
        return this.parReserveAlphaColor ? i + 1 : i;
    }

    @Override
    public int lookup(int r, int g, int b, int a) {
        if (a < this.parTransparencyThreshold) {
            return 0;
        }
        return this.indexSearch(b, g, r) + 1;
    }

    public void run() {
        if (this.done) {
            return;
        }
        this.initParams();
        this.setUpArrays();
        this.learn();
        this.fix();
        this.inxbuild();
        this.done = true;
    }

    public void setParAlphabiasshift(int parAlphabiasshift) {
        this.parAlphabiasshift = parAlphabiasshift;
    }

    public void setParBeta(double parBeta) {
        this.parBeta = parBeta;
    }

    public void setParGamma(double parGamma) {
        this.parGamma = parGamma;
    }

    public void setParMaxPixelsToSample(int parMaxPixelsToSample) {
        this.parMaxPixelsToSample = parMaxPixelsToSample;
    }

    public void setParNcolors(int parNcolors) {
        this.parNcolors = parNcolors;
    }

    public void setParNcycles(int parNcycles) {
        this.parNcycles = parNcycles;
    }

    public void setParRadiusbiasshift(int parRadiusbiasshift) {
        this.parRadiusbiasshift = parRadiusbiasshift;
    }

    public void setParRadiusdec(int parRadiusdec) {
        this.parRadiusdec = parRadiusdec;
    }

    public void setParReserveAlphaColor(boolean parReserveAlphaColor) {
        this.parReserveAlphaColor = parReserveAlphaColor;
    }

    public void setParTransparencyThreshold(int parTransparencyThreshold) {
        this.parTransparencyThreshold = parTransparencyThreshold;
    }

    protected void initGuard() {
        if (this.done) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("need to execute run() computation - fallback should be done prior in user-land");
        }
        this.run();
    }

    protected int indexSearch(int b, int g, int r) {
        int bestd = 1000;
        int best = -1;
        int i = this.netindex[g];
        int j = i - 1;
        while (i < this.parNcolors || j >= 0) {
            int a;
            int dist;
            int[] p;
            if (i < this.parNcolors) {
                p = this.colormap[i];
                dist = p[1] - g;
                if (dist >= bestd) {
                    i = this.parNcolors;
                } else {
                    if (dist < 0) {
                        dist = -dist;
                    }
                    if ((a = p[0] - b) < 0) {
                        a = -a;
                    }
                    if ((dist += a) < bestd) {
                        a = p[2] - r;
                        if (a < 0) {
                            a = -a;
                        }
                        if ((dist += a) < bestd) {
                            bestd = dist;
                            best = i;
                        }
                    }
                    ++i;
                }
            }
            if (j < 0) continue;
            p = this.colormap[j];
            dist = g - p[1];
            if (dist >= bestd) {
                j = -1;
                continue;
            }
            dist = Math.abs(dist);
            a = p[0] - b;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                a = p[2] - r;
                if (a < 0) {
                    a = -a;
                }
                if ((dist += a) < bestd) {
                    bestd = dist;
                    best = j;
                }
            }
            --j;
        }
        return best;
    }

    protected void setUpArrays() {
        this.network = new double[this.parNcolors][3];
        this.colormap = new int[this.parNcolors][4];
        this.bias = new double[this.parNcolors];
        this.freq = new double[this.parNcolors];
        this.network[0][0] = 0.0;
        this.network[0][1] = 0.0;
        this.network[0][2] = 0.0;
        this.network[1][0] = 255.0;
        this.network[1][1] = 255.0;
        this.network[1][2] = 255.0;
        for (int i = 0; i < this.parNcolors; ++i) {
            double[] p = this.network[i];
            p[0] = 255.0 * (double)i / (double)this._parCutnetsize;
            p[1] = 255.0 * (double)i / (double)this._parCutnetsize;
            p[2] = 255.0 * (double)i / (double)this._parCutnetsize;
            this.freq[i] = 1.0 / (double)this.parNcolors;
            this.bias[i] = 0.0;
        }
    }

    private void alterneigh(double alpha, int rad, int i, double b, double g, double r) {
        int hi;
        int lo = i - rad;
        if (lo < -1) {
            lo = -1;
        }
        if ((hi = i + rad) > this.parNcolors) {
            hi = this.parNcolors;
        }
        int j = i + 1;
        int k = i - 1;
        int q = 0;
        while (j < hi || k > lo) {
            double[] p;
            double a = alpha * (double)(rad * rad - q * q) / (double)(rad * rad);
            ++q;
            if (j < hi) {
                p = this.network[j];
                p[0] = p[0] - a * (p[0] - b);
                p[1] = p[1] - a * (p[1] - g);
                p[2] = p[2] - a * (p[2] - r);
                ++j;
            }
            if (k <= lo) continue;
            p = this.network[k];
            p[0] = p[0] - a * (p[0] - b);
            p[1] = p[1] - a * (p[1] - g);
            p[2] = p[2] - a * (p[2] - r);
            --k;
        }
    }

    private void altersingle(double alpha, int i, double b, double g, double r) {
        double[] n = this.network[i];
        n[0] = n[0] - alpha * (n[0] - b);
        n[1] = n[1] - alpha * (n[1] - g);
        n[2] = n[2] - alpha * (n[2] - r);
    }

    private int contest(double b, double g, double r) {
        int bestpos;
        double bestd;
        double bestbiasd = bestd = 3.4028234663852886E38;
        int bestbiaspos = bestpos = -1;
        for (int i = 0; i < this.parNcolors; ++i) {
            double biasdist;
            double a;
            double[] n = this.network[i];
            double dist = n[0] - b;
            if (dist < 0.0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0.0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0.0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i;
            }
            if ((biasdist = dist - this.bias[i]) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i;
            }
            int n2 = i;
            this.freq[n2] = this.freq[n2] - this.parBeta * this.freq[i];
            int n3 = i;
            this.bias[n3] = this.bias[n3] + this._parGammaBetta * this.freq[i];
        }
        int n = bestpos;
        this.freq[n] = this.freq[n] + this.parBeta;
        int n4 = bestpos;
        this.bias[n4] = this.bias[n4] - this._parGammaBetta;
        return bestbiaspos;
    }

    private void fix() {
        for (int i = 0; i < this.parNcolors; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x = (int)(0.5 + this.network[i][j]);
                this.colormap[i][j] = x = Math.max(Math.min(255, x), 0);
            }
            this.colormap[i][3] = i;
        }
    }

    private void initParams() {
        if (this.parReserveAlphaColor && this.parNcolors % 2 == 0) {
            --this.parNcolors;
        }
        this._parGammaBetta = this.parBeta * this.parGamma;
        this._parCutnetsize = this.parNcolors;
        this._parMaxnetpos = this.parNcolors - 1;
        int _parInitrad = (this.parNcolors + 7) / 8;
        this._parRadiusbias = 1 << this.parRadiusbiasshift;
        this._parInitBiasRadius = _parInitrad * this._parRadiusbias;
        this._parIinitalpha = 1 << this.parAlphabiasshift;
        this._parSamplefac = this.width * this.height / this.parMaxPixelsToSample;
        if (this._parSamplefac < 1) {
            this._parSamplefac = 1;
        } else if (this._parSamplefac > 30) {
            this._parSamplefac = 30;
        }
    }

    private void inxbuild() {
        int previouscol = 0;
        int startpos = 0;
        for (int i = 0; i < this.parNcolors; ++i) {
            int j;
            int[] p = this.colormap[i];
            int[] q = null;
            int smallpos = i;
            int smallval = p[1];
            for (j = i + 1; j < this.parNcolors; ++j) {
                q = this.colormap[j];
                if (q[1] >= smallval) continue;
                smallpos = j;
                smallval = q[1];
            }
            q = this.colormap[smallpos];
            if (i != smallpos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval == previouscol) continue;
            this.netindex[previouscol] = startpos + i >> 1;
            for (j = previouscol + 1; j < smallval; ++j) {
                this.netindex[j] = i;
            }
            previouscol = smallval;
            startpos = i;
        }
        this.netindex[previouscol] = startpos + this._parMaxnetpos >> 1;
        for (int j = previouscol + 1; j < 256; ++j) {
            this.netindex[j] = this._parMaxnetpos;
        }
    }

    private void learn() {
        int delta;
        int biasRadius = this._parInitBiasRadius;
        int alphadec = 30 + (this._parSamplefac - 1) / 3;
        int lengthcount = this.width * this.height;
        int samplepixels = lengthcount / this._parSamplefac;
        if (samplepixels < 1000) {
            samplepixels = 1000;
        }
        if (samplepixels > lengthcount) {
            samplepixels = lengthcount;
        }
        if ((delta = samplepixels / this.parNcycles) < 1) {
            delta = 1;
        }
        int alpha = this._parIinitalpha;
        int stepx = (int)(Math.sqrt(lengthcount / samplepixels) + 0.5);
        int stepy = (int)((double)lengthcount / ((double)samplepixels * (double)stepx) + 0.5);
        stepy = Math.max(1, stepy);
        int rad = biasRadius >> this.parRadiusbiasshift;
        if (rad <= 1) {
            rad = 0;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument((Object)samplepixels).addArgument((Object)rad).log("beginning 1D learning: samplepixels = {} rad = {}");
        }
        int i = 1;
        for (int row = 0; row < this.height; row += stepy) {
            for (int col = 0; col < this.width; col += stepx) {
                int aaa;
                int rgbaPixel = this.pixelGetter.getPixel(row, (col + row) % this.width);
                int n = aaa = !this.parReserveAlphaColor ? 255 : rgbaPixel >> 24 & 0xFF;
                if (aaa < this.parTransparencyThreshold) continue;
                double r = rgbaPixel >> 16 & 0xFF;
                double g = rgbaPixel >> 8 & 0xFF;
                double b = rgbaPixel & 0xFF;
                int j = this.contest(b, g, r);
                double a = 1.0 * (double)alpha / (double)this._parIinitalpha;
                this.altersingle(a, j, b, g, r);
                if (rad > 0) {
                    this.alterneigh(a, rad, j, b, g, r);
                }
                if (++i % delta != 0) continue;
                alpha -= alpha / alphadec;
                if ((rad = (biasRadius -= biasRadius / this.parRadiusdec) >> this.parRadiusbiasshift) > 1) continue;
                rad = 0;
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument((Object)(1.0 * (double)alpha / (double)this._parIinitalpha)).log("finished 1D learning: final alpha = {}");
        }
    }

    public static interface PixelGetter {
        public int getPixel(int var1, int var2);
    }
}

