/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.dataset.spi.utils.Tuple;
import java.math.BigDecimal;
import java.util.WeakHashMap;

public final class DigitNumberArithmetic {
    static WeakHashMap<Double, String> numberDigitsCache = new WeakHashMap();

    private DigitNumberArithmetic() {
    }

    public static Tuple<Double, Double> formatStringForSignificantDigits(double num1, double num2) {
        int exp1 = (int)Math.log10(Math.abs(num1)) + 1;
        int exp2 = (int)Math.log10(Math.abs(num2)) + 1;
        if (Math.signum(num1) != Math.signum(num2) || exp1 != exp2) {
            return new Tuple((Object)Math.max(exp1, exp2), (Object)0.0);
        }
        double inum1 = Math.floor(num1);
        double inum2 = Math.floor(num2);
        double frac1 = num1 - inum1;
        double frac2 = num2 - inum2;
        if (inum1 != inum2) {
            return new Tuple((Object)Math.max(exp1, exp2), (Object)0.0);
        }
        if (frac1 == 0.0 && frac2 == 0.0) {
            return new Tuple((Object)Math.max(exp1, exp2), (Object)0.0);
        }
        String stringNum1 = String.format("%.25f", frac1).replace(".", "");
        String stringNum2 = String.format("%.25f", frac2).replace(".", "");
        int count = 1;
        for (int i = 1; i < Math.min(stringNum1.length(), stringNum2.length()) && stringNum1.charAt(i) == stringNum2.charAt(i); ++i) {
            ++count;
        }
        return new Tuple((Object)Math.max(exp1, exp2), (Object)count);
    }

    public static int getNumberOfSignificantDigits(double val) {
        BigDecimal input = BigDecimal.valueOf(val);
        return (input = input.stripTrailingZeros()).scale() < 0 ? input.precision() - input.scale() : input.precision();
    }

    public static int getPrecision(double val) {
        BigDecimal input = BigDecimal.valueOf(val);
        input = input.stripTrailingZeros();
        return input.precision();
    }

    public static void main(String[] args) {
        double[][] test2;
        String msg;
        int digits;
        double[] test1;
        for (double num : test1 = new double[]{1.23, 1.0, 1.0, 1.23E19, 1.23456789E19, 1.23456789E-19}) {
            digits = DigitNumberArithmetic.getNumberOfSignificantDigits(num);
            msg = String.format("%f %E has %d significant digits", num, num, digits);
            System.out.println(msg);
        }
        System.out.println("");
        for (double[] pair : test2 = new double[][]{{1.23, 1.24}, {1000.0, 1001.0}, {0.001, 0.0011}, {5.001, 5.0011}, {10.001, 10.0011}, {1.0, 1.00001}, {1.6666666666666667, 1.6666766666666668}, {1.234567E9, 1.234567000001E9}, {1.234567E30, 1.234567E30}}) {
            digits = DigitNumberArithmetic.numberDigitsUntilFirstSignificantDigit(pair[0], pair[1]);
            msg = String.format("%f %f differs in digit %d", pair[0], pair[1], digits);
            System.out.println(msg);
        }
        System.out.println("");
        double val1 = 1.23456789E17;
        System.out.println("1: val1=" + String.format("%f", 1.23456789E17));
        System.out.println("2: val1=" + String.format("%100.50f", 1.23456789E17));
        double val2 = 1.2345678900000001E8;
        System.out.println("1: val2=" + String.format("%f", 1.2345678900000001E8));
        System.out.println("2: val2=" + String.format("%100.50f", 1.2345678900000001E8));
        System.out.println("3: val1=" + BigDecimal.valueOf(1.2345678900000001E8).toPlainString());
        System.out.println("4: val1=" + BigDecimal.valueOf(1.2345678900000001E8).stripTrailingZeros());
    }

    public static int numberDigitsUntilFirstSignificantDigit(double num1, double num2) {
        String stringNum1 = numberDigitsCache.computeIfAbsent(num1, k -> String.format("%.25e", k).replace(".", ""));
        String stringNum2 = numberDigitsCache.computeIfAbsent(num2, k -> String.format("%.25e", k).replace(".", ""));
        int count = 1;
        for (int i = 0; i < Math.min(stringNum1.length(), stringNum2.length()) && stringNum1.charAt(i) == stringNum2.charAt(i); ++i) {
            ++count;
        }
        return count;
    }

    public static double roundToFractionalDigits(double num, int n) {
        double power = Math.pow(10.0, n);
        return (double)Math.round(num * power) / power;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }
}

