/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import de.gsi.chart.renderer.spi.utils.FillPatternStyleHelper;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.utils.AssertUtils;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public final class DefaultRenderColorScheme {
    private static final String DEFAULT_FONT = "Helvetia";
    private static final int DEFAULT_FONT_SIZE = 18;
    private static final DefaultRenderColorScheme SELF = new DefaultRenderColorScheme();
    public static final ObservableList<Color> MISC = FXCollections.observableList(Arrays.asList(Color.valueOf((String)"#5DA5DA"), Color.valueOf((String)"#F15854"), Color.valueOf((String)"#FAA43A"), Color.valueOf((String)"#60BD68"), Color.valueOf((String)"#F17CB0"), Color.valueOf((String)"#B2912F"), Color.valueOf((String)"#B276B2"), Color.valueOf((String)"#DECF3F"), Color.valueOf((String)"#4D4D4D")));
    public static final ObservableList<Color> ADOBE = FXCollections.observableList(Arrays.asList(Color.valueOf((String)"#00a4e4"), Color.valueOf((String)"#ff0000"), Color.valueOf((String)"#fbb034"), Color.valueOf((String)"#ffdd00"), Color.valueOf((String)"#c1d82f"), Color.valueOf((String)"#8a7967"), Color.valueOf((String)"#6a737b")));
    public static final ObservableList<Color> DELL = FXCollections.observableList(Arrays.asList(Color.valueOf((String)"#0085c3"), Color.valueOf((String)"#7ab800"), Color.valueOf((String)"#f2af00"), Color.valueOf((String)"#dc5034"), Color.valueOf((String)"#6e2585"), Color.valueOf((String)"#71c6c1"), Color.valueOf((String)"#009bbb"), Color.valueOf((String)"#444444")));
    public static final ObservableList<Color> EQUIDISTANT = FXCollections.observableList(Arrays.asList(Color.valueOf((String)"#003f5c"), Color.valueOf((String)"#2f4b7c"), Color.valueOf((String)"#665191"), Color.valueOf((String)"#a05195"), Color.valueOf((String)"#d45087"), Color.valueOf((String)"#f95d6a"), Color.valueOf((String)"#ff7c43"), Color.valueOf((String)"#ffa600")));
    public static final ObservableList<Color> TUNEVIEWER = FXCollections.observableList(Arrays.asList(Color.valueOf((String)"#0000c8"), Color.valueOf((String)"#c80000"), Color.valueOf((String)"#00c800"), Color.ORANGE, Color.MAGENTA, Color.CYAN, Color.DARKGRAY, Color.PINK, Color.BLACK));
    private static final ListProperty<Color> strokeColours = new SimpleListProperty((Object)SELF, "defaulStrokeColours", FXCollections.observableList(TUNEVIEWER));
    private static final ListProperty<Color> fillColours = new SimpleListProperty((Object)SELF, "defaulFillColours", FXCollections.observableList(TUNEVIEWER));
    private static ListProperty<Paint> fillStyles = new SimpleListProperty((Object)SELF, "fillStyles");
    private static final ObjectProperty<Font> defaultFont = new SimpleObjectProperty((Object)SELF, "defaultFontSize", (Object)Font.font((String)"Helvetia", (double)18.0));
    private static final DoubleProperty markerLineWidth = new SimpleDoubleProperty((Object)SELF, "defaultLineWidth", 0.5);
    private static final DoubleProperty lineWidth = new SimpleDoubleProperty((Object)SELF, "lineWidth", 1.5);
    private static final DoubleProperty hatchShiftByIndex = new SimpleDoubleProperty((Object)SELF, "hatchShiftByIndex", 1.5);

    private DefaultRenderColorScheme() {
    }

    private AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf(61);
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
    }

    public static DoubleProperty defaultStrokeLineWidthProperty() {
        return lineWidth;
    }

    public static ListProperty<Color> fillColorProperty() {
        return fillColours;
    }

    public static ListProperty<Paint> fillStylesProperty() {
        return fillStyles;
    }

    public static ObjectProperty<Font> fontProperty() {
        return defaultFont;
    }

    private static Color getColorModifier(Map<String, List<String>> parameterMap, Color orignalColor) {
        Color color = orignalColor;
        List<String> intensityModifier = parameterMap.get("intensity".toLowerCase(Locale.UK));
        if (color != null && intensityModifier != null && !intensityModifier.isEmpty()) {
            try {
                double intensity = Double.parseDouble(intensityModifier.get(0));
                color = color.deriveColor(0.0, intensity / 100.0, 1.0, intensity / 100.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    public static Paint getFill(int index) {
        AssertUtils.gtEqThanZero((String)"fillStyles index", (int)index);
        int size = DefaultRenderColorScheme.fillStylesProperty().size();
        return (Paint)DefaultRenderColorScheme.fillStylesProperty().get(index % size);
    }

    public static Color getFillColor(int index) {
        AssertUtils.gtEqThanZero((String)"color index", (int)index);
        int size = DefaultRenderColorScheme.fillColorProperty().size();
        return (Color)DefaultRenderColorScheme.fillColorProperty().get(index % size);
    }

    public static final ObservableList<Paint> getStandardFillStyle() {
        ObservableList values = FXCollections.observableArrayList();
        for (Color colour : (ObservableList)DefaultRenderColorScheme.fillColorProperty().get()) {
            values.add((Object)FillPatternStyleHelper.getDefaultHatch((Paint)colour.brighter(), DefaultRenderColorScheme.hatchShiftByIndexProperty().get()));
        }
        return values;
    }

    public static Color getStrokeColor(int index) {
        AssertUtils.gtEqThanZero((String)"color index", (int)index);
        int size = DefaultRenderColorScheme.strokeColorProperty().size();
        return (Color)DefaultRenderColorScheme.strokeColorProperty().get(index % size);
    }

    public static DoubleProperty hatchShiftByIndexProperty() {
        return hatchShiftByIndex;
    }

    public static DoubleProperty markerLineWidthProperty() {
        return markerLineWidth;
    }

    public static void setFillScheme(GraphicsContext gc, String defaultStyle, int dsIndex) {
        AssertUtils.gtEqThanZero((String)"setFillScheme dsIndex", (int)dsIndex);
        Map<String, List<String>> map = DefaultRenderColorScheme.splitQuery(defaultStyle);
        Color fillColor = StyleParser.getColorPropertyValue(defaultStyle, "fillColor");
        if (fillColor != null) {
            Color rawColor = fillColor;
            Color color = DefaultRenderColorScheme.getColorModifier(map, rawColor);
            if (color == null) {
                return;
            }
            ImagePattern hatch = FillPatternStyleHelper.getDefaultHatch((Paint)color.brighter(), (double)dsIndex * DefaultRenderColorScheme.hatchShiftByIndexProperty().get());
            gc.setFill((Paint)hatch);
        } else {
            int size = DefaultRenderColorScheme.fillStylesProperty().size();
            gc.setFill((Paint)DefaultRenderColorScheme.fillStylesProperty().get(dsIndex % size));
        }
    }

    public static void setGraphicsContextAttributes(GraphicsContext gc, String style) {
        double[] dashPattern;
        Font font;
        Double strokeWidth;
        Color fillColor;
        if (gc == null || style == null) {
            return;
        }
        Color strokeColor = StyleParser.getColorPropertyValue(style, "strokeColor");
        if (strokeColor != null) {
            gc.setStroke((Paint)strokeColor);
        }
        if ((fillColor = StyleParser.getColorPropertyValue(style, "fillColor")) != null) {
            gc.setFill((Paint)fillColor);
        }
        if ((strokeWidth = StyleParser.getFloatingDecimalPropertyValue(style, "strokeWidth")) != null) {
            gc.setLineWidth(strokeWidth.doubleValue());
        }
        if ((font = StyleParser.getFontPropertyValue(style)) != null) {
            gc.setFont(font);
        }
        if ((dashPattern = StyleParser.getFloatingDecimalArrayPropertyValue(style, "strokeDashPattern")) != null) {
            gc.setLineDashes(dashPattern);
        }
    }

    public static void setLineScheme(GraphicsContext gc, String defaultStyle, int dsIndex) {
        AssertUtils.gtEqThanZero((String)"setLineScheme dsIndex", (int)dsIndex);
        Map<String, List<String>> map = DefaultRenderColorScheme.splitQuery(defaultStyle);
        Color lineColor = StyleParser.getColorPropertyValue(defaultStyle, "strokeColor");
        double[] lineDash = StyleParser.getStrokeDashPropertyValue(defaultStyle, "strokeDashPattern");
        Color rawColor = lineColor == null ? DefaultRenderColorScheme.getStrokeColor(dsIndex) : lineColor;
        gc.setLineWidth(DefaultRenderColorScheme.defaultStrokeLineWidthProperty().get());
        gc.setLineDashes(lineDash);
        gc.setFill(DefaultRenderColorScheme.getFill(dsIndex));
        gc.setStroke((Paint)DefaultRenderColorScheme.getColorModifier(map, rawColor));
    }

    public static void setMarkerScheme(GraphicsContext gc, String defaultStyle, int dsIndex) {
        AssertUtils.gtEqThanZero((String)"setMarkerScheme dsIndex", (int)dsIndex);
        Map<String, List<String>> map = DefaultRenderColorScheme.splitQuery(defaultStyle);
        Color color = DefaultRenderColorScheme.getColorModifier(map, DefaultRenderColorScheme.getStrokeColor(dsIndex));
        gc.setLineWidth(DefaultRenderColorScheme.markerLineWidthProperty().get());
        gc.setStroke((Paint)color);
        gc.setFill((Paint)color);
    }

    private static Map<String, List<String>> splitQuery(String styleString) {
        if (styleString == null || styleString.isEmpty()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(styleString.split(";")).map(SELF::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public static ListProperty<Color> strokeColorProperty() {
        return strokeColours;
    }

    static {
        DefaultRenderColorScheme.fillStylesProperty().clear();
        DefaultRenderColorScheme.fillStylesProperty().set(DefaultRenderColorScheme.getStandardFillStyle());
    }

    public static enum Palette {
        P_TUNEVIEWER(TUNEVIEWER),
        P_MISC(MISC),
        P_ADOBE(ADOBE),
        P_DELL(DELL),
        P_EQUIDISTANT(EQUIDISTANT);

        ObservableList<Color> list;

        private Palette(ObservableList<Color> list) {
            this.list = list;
        }

        public ObservableList<Color> getPalette() {
            return this.list;
        }

        public static Palette getValue(ObservableList<Color> list) {
            for (Palette p : Palette.values()) {
                if (!p.getPalette().equals(list)) continue;
                return p;
            }
            throw new IllegalArgumentException("unknown palette");
        }
    }
}

