/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import de.codecentric.centerdevice.javafxsvg.SvgImageLoaderFactory;
import de.gsi.chart.XYChart;
import javafx.scene.image.Image;

public final class ChartIconFactory {
    private static final String ICON_INFO = XYChart.class.getResource("icons/info_icon.svg").toString();
    private static final String ICON_WARN = XYChart.class.getResource("icons/warn_icon.svg").toString();
    private static final String ICON_ERROR = XYChart.class.getResource("icons/error_icon.svg").toString();
    private static final int MIN_WIDTH = 10;
    private static final int MIN_HEIGHT = 10;
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 32;
    private static final int MAX_WIDTH = 100;
    private static final int MAX_HEIGHT = 100;

    private ChartIconFactory() {
    }

    public static Image getErrorIcon() {
        return ChartIconFactory.getIcon(ICON_ERROR);
    }

    public static Image getErrorIcon(double width, double height) {
        return new Image(ICON_ERROR, width, height, true, false);
    }

    private static Image getIcon(String file) {
        return new Image(file, 32.0, 32.0, true, false);
    }

    public static Image getIcon(String file, double width, double height) {
        double w = Math.min(Math.max(width, 10.0), 100.0);
        double h = Math.min(Math.max(height, 10.0), 100.0);
        return new Image(file, w, h, true, false);
    }

    public static Image getInfoIcon() {
        return ChartIconFactory.getIcon(ICON_INFO);
    }

    public static Image getInfoIcon(double width, double height) {
        return new Image(ICON_INFO, width, height, true, false);
    }

    public static Image getWarningIcon() {
        return ChartIconFactory.getIcon(ICON_WARN);
    }

    public static Image getWarningIcon(double width, double height) {
        return new Image(ICON_WARN, width, height, true, false);
    }

    static {
        SvgImageLoaderFactory.install();
    }
}

