/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@Deprecated
public class LineRenderer
extends AbstractDataSetManagement<LineRenderer>
implements Renderer {
    private static final Color[] COLORS = new Color[]{Color.BLACK, Color.BLUE, Color.GREEN, Color.RED};

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    @Override
    protected LineRenderer getThis() {
        return this;
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        long start = ProcessingProfiler.getTimeStamp();
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xAxis.getWidth();
        double xmin = xAxis.getValueForDisplay(0.0);
        double xmax = xAxis.getValueForDisplay(xAxisWidth);
        int index = 0;
        for (DataSet dataset : datasets) {
            int lindex = index;
            index = (Integer)dataset.lock().readLockGuard(() -> {
                if (lindex == 0) {
                    CategoryAxis axis;
                    if (xyChart.getXAxis() instanceof CategoryAxis) {
                        axis = (CategoryAxis)xyChart.getXAxis();
                        axis.updateCategories(dataset);
                    }
                    if (xyChart.getYAxis() instanceof CategoryAxis) {
                        axis = (CategoryAxis)xyChart.getYAxis();
                        axis.updateCategories(dataset);
                    }
                }
                if (dataset.getDataCount(0) > 0) {
                    gc.setStroke((Paint)COLORS[(lindex + 1) % 4]);
                    int i = dataset.getIndex(0, xmin);
                    if (i < 0) {
                        i = 0;
                    }
                    double x0 = xAxis.getDisplayPosition(dataset.get(0, i));
                    double y0 = yAxis.getDisplayPosition(dataset.get(1, i));
                    ++i;
                    int maxIndex = Math.min(dataset.getIndex(0, xmax) + 1, dataset.getDataCount(0));
                    while (i < maxIndex) {
                        double x1 = xAxis.getDisplayPosition(dataset.get(0, i));
                        double y1 = yAxis.getDisplayPosition(dataset.get(1, i));
                        gc.strokeLine(x0, y0, x1, y1);
                        x0 = x1;
                        y0 = y1;
                        ++i;
                    }
                }
                return lindex + 1;
            });
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }
}

