/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.renderer.ContourType;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer3D;
import de.gsi.chart.renderer.datareduction.ReductionType;
import de.gsi.chart.renderer.spi.ContourDataSetRenderer;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.chart.utils.WritableImageCache;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DataRange;
import de.gsi.dataset.utils.ByteArrayCache;
import de.gsi.dataset.utils.CachedDaemonThreadFactory;
import de.gsi.dataset.utils.DoubleArrayCache;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContourDataSetCache
extends WritableImageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContourDataSetCache.class);
    private static final String PARALLEL_WORKER_ERROR = "one parallel worker thread finished execution with error";
    private static final int BGRA_BYTE_SIZE = 4;
    private static final int REF_WIDTH_PARALLEL = 1024;
    private static final int REF_HEIGHT_PARALLEL = 1000;
    protected final DataSet dataSet;
    protected final Axis xAxis;
    protected final Axis yAxis;
    protected final Axis zAxis;
    protected double xAxisWidth;
    protected double yAxisHeight;
    protected double xMin;
    protected double yMin;
    protected double xMax;
    protected double yMax;
    protected double xDataPixelMin;
    protected double xDataPixelMax;
    protected double xDataPixelRange;
    protected double yDataPixelMin;
    protected double yDataPixelMax;
    protected double yDataPixelRange;
    protected int indexXMin;
    protected int indexXMax;
    protected int indexYMin;
    protected int indexYMax;
    protected int xSize;
    protected int ySize;
    protected double zMin;
    protected double zMax;
    protected final boolean xInverted;
    protected final boolean yInverted;
    protected final boolean zInverted;
    protected final double[] dataBuffer;
    protected double[] tempDataBuffer;
    protected final double[] reduced;

    public ContourDataSetCache(XYChart chart, ContourDataSetRenderer renderer, DataSet dataSet) {
        if (dataSet.getDimension() < 3) {
            throw new IllegalArgumentException("dataSet needs be at least 3D but is " + dataSet.getDimension());
        }
        ContourDataSetCache.assertGridDimensions(dataSet);
        long start = ProcessingProfiler.getTimeStamp();
        this.dataSet = dataSet;
        this.xAxis = chart.getXAxis();
        this.yAxis = chart.getYAxis();
        this.zAxis = renderer.getZAxis();
        this.zMin = this.zAxis.getMin();
        this.zMax = this.zAxis.getMax();
        this.xInverted = this.xAxis.isInvertedAxis();
        this.yInverted = this.yAxis.isInvertedAxis();
        this.zInverted = this.zAxis.isInvertedAxis();
        this.xAxisWidth = this.xAxis.getWidth();
        this.yAxisHeight = this.yAxis.getHeight();
        this.xMin = this.xInverted ? this.xAxis.getValueForDisplay(this.xAxisWidth) : this.xAxis.getValueForDisplay(0.0);
        this.xMax = this.xInverted ? this.xAxis.getValueForDisplay(0.0) : this.xAxis.getValueForDisplay(this.xAxisWidth);
        this.yMin = this.yInverted ? this.yAxis.getValueForDisplay(0.0) : this.yAxis.getValueForDisplay(this.yAxisHeight);
        this.yMax = this.yInverted ? this.yAxis.getValueForDisplay(this.yAxisHeight) : this.yAxis.getValueForDisplay(0.0);
        double xDataPixelMinTemp = this.xAxis.getDisplayPosition(dataSet.getAxisDescription(0).getMin());
        double xDataPixelMaxTemp = this.xAxis.getDisplayPosition(dataSet.getAxisDescription(0).getMax());
        double yDataPixelMinTemp = this.yAxis.getDisplayPosition(dataSet.getAxisDescription(1).getMax());
        double yDataPixelMaxTemp = this.yAxis.getDisplayPosition(dataSet.getAxisDescription(1).getMin());
        this.xDataPixelMin = Math.max(Math.min(xDataPixelMinTemp, xDataPixelMaxTemp), 0.0);
        this.xDataPixelMax = Math.min(Math.max(xDataPixelMinTemp, xDataPixelMaxTemp), this.xAxisWidth);
        this.yDataPixelMin = Math.max(Math.min(yDataPixelMinTemp, yDataPixelMaxTemp), 0.0);
        this.yDataPixelMax = Math.min(Math.max(yDataPixelMinTemp, yDataPixelMaxTemp), this.yAxisHeight);
        this.xDataPixelRange = Math.abs(this.xDataPixelMax - this.xDataPixelMin);
        this.yDataPixelRange = Math.abs(this.yDataPixelMax - this.yDataPixelMin);
        int indexXMinTemp = Math.max(0, dataSet.getIndex(0, this.xMin));
        int indexXMaxTemp = Math.min(dataSet.getIndex(0, this.xMax), dataSet.getDataCount(0) - 1);
        int indexYMinTemp = Math.max(0, dataSet.getIndex(1, this.yMax));
        int indexYMaxTemp = Math.min(dataSet.getIndex(1, this.yMin), dataSet.getDataCount(1) - 1);
        this.indexXMin = Math.min(indexXMinTemp, indexXMaxTemp);
        this.indexXMax = Math.max(indexXMinTemp, indexXMaxTemp);
        this.indexYMin = Math.min(indexYMinTemp, indexYMaxTemp);
        this.indexYMax = Math.max(indexYMinTemp, indexYMaxTemp);
        this.xSize = Math.abs(this.indexXMax - this.indexXMin) + 1;
        this.ySize = Math.abs(this.indexYMax - this.indexYMin) + 1;
        this.dataBuffer = DoubleArrayCache.getInstance().getArrayExact(this.xSize * this.ySize);
        int minSizeThreshold = 1024000;
        boolean sufficientlyLarge = this.xSize * this.ySize < 1024000;
        ContourDataSetCache.copySubFrame(dataSet, this.dataBuffer, renderer.isParallelImplementation() && sufficientlyLarge, this.xInverted, this.indexXMin, this.indexXMax, this.yInverted, this.indexYMin, this.indexYMax);
        ProcessingProfiler.getTimeDiff((long)start, (String)"copySubFrame");
        this.reduced = this.reduceDataArray(this.dataBuffer, this.xSize, this.ySize, renderer);
        ProcessingProfiler.getTimeDiff((long)start, (String)"data reduction");
        boolean computeLocalRange = renderer.computeLocalRange() && (this.zAxis.isAutoRanging() || this.zAxis.isAutoGrowRanging());
        DataRange zDataRange = ContourDataSetCache.computeLocalRange(this.reduced, this.xSize, this.ySize, computeLocalRange);
        if (zDataRange.isDefined()) {
            this.zMin = zDataRange.getMin();
            this.zMax = zDataRange.getMax();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)"recompute local z range");
        AxisTransform axisTransform = this.zAxis.getAxisTransform();
        if (axisTransform == null) {
            throw new IllegalArgumentException("zAxis of renderer needs to have an axis transform for its z-Axis");
        }
        int nQuant = renderer.getNumberQuantisationLevels();
        ContourDataSetCache.quantizeData(this.reduced, this.xSize, this.ySize, this.zInverted, this.zMin, this.zMax, axisTransform, nQuant);
        ProcessingProfiler.getTimeDiff((long)start, (String)"quantized data");
    }

    private static void assertGridDimensions(DataSet dataSet) {
        if (dataSet.getDataCount(2) != dataSet.getDataCount(0) * dataSet.getDataCount(1)) {
            throw new IllegalArgumentException("n_z not equal to n_x * n_y");
        }
    }

    protected static void quantizeData(double[] input, int width, int height, boolean inverted, double min, double max, AxisTransform axisTransform, int nQuant) {
        double zMinPixel = axisTransform.forward(min);
        double zRange = Math.abs(axisTransform.forward(max) - zMinPixel);
        double zRangeInv = 1.0 / zRange;
        int length = width * height;
        for (int index = 0; index < length; ++index) {
            double z = input[index];
            double offset = (axisTransform.forward(z) - zMinPixel) * zRangeInv;
            input[index] = inverted ? ContourDataSetCache.quantize(1.0 - offset, nQuant) : ContourDataSetCache.quantize(offset, nQuant);
        }
    }

    public void releaseCachedVariables() {
        DoubleArrayCache.getInstance().add((Object)this.dataBuffer);
        DoubleArrayCache.getInstance().add((Object)this.tempDataBuffer);
    }

    protected double[] reduceDataArray(double[] input, int srcWidth, int srcHeight, ContourDataSetRenderer renderer) {
        boolean mayReduceY;
        int reductionFactorX = Math.max(renderer.getReductionFactorX(), 1);
        int reductionFactorY = Math.max(renderer.getReductionFactorY(), 1);
        ReductionType reductionType = renderer.getReductionType();
        double dataPixelSizeX = (double)reductionFactorX * (double)this.xSize / this.xAxisWidth;
        double dataPixelSizeY = (double)reductionFactorY * (double)this.ySize / this.yAxisHeight;
        boolean mayReduceX = dataPixelSizeX > 1.0 && this.xSize > 10;
        boolean bl = mayReduceY = dataPixelSizeY > 1.0 && this.ySize > 10;
        if ((mayReduceX || mayReduceY) && renderer.isActualReducePoints()) {
            int targetWidth = (int)((double)srcWidth / Math.max(dataPixelSizeX, 1.0));
            int targetHeight = (int)((double)srcHeight / Math.max(dataPixelSizeY, 1.0));
            ContourType contourType = renderer.getContourType();
            if (contourType.equals((Object)ContourType.HEATMAP_HEXAGON)) {
                double minReductionFactor = Math.min(reductionFactorX, reductionFactorY);
                double minPixelSizeX = Math.max(minReductionFactor * (double)this.xSize / this.xAxisWidth, 1.0);
                double minPixelSizeY = Math.max(minReductionFactor * (double)this.ySize / this.yAxisHeight, 1.0);
                targetWidth = (int)((double)srcWidth / minPixelSizeX);
                targetHeight = (int)((double)srcHeight / minPixelSizeY);
            }
            this.tempDataBuffer = DoubleArrayCache.getInstance().getArrayExact(targetWidth * targetHeight);
            DefaultDataReducer3D.resample(input, srcWidth, srcHeight, this.tempDataBuffer, targetWidth, targetHeight, reductionType);
            this.xSize = targetWidth;
            this.ySize = targetHeight;
            return this.tempDataBuffer;
        }
        double[] reducedData = input;
        return reducedData;
    }

    protected static void computeCoordinates(DataSet dataSet, double[] dataBuffer, int dataLength, boolean xAxisInverted, int xMinIndex, int xMaxIndex, boolean yAxisInverted, int yMinIndex, int yMaxIndex, int yMinDst) {
        int dataWidth = dataSet.getDataCount(0);
        int dstWidth = Math.abs(xMaxIndex - xMinIndex) + 1;
        switch (InvertedAxisCase.get(xAxisInverted, yAxisInverted)) {
            case X_ONLY: {
                for (int yIndex = yMinIndex; yIndex <= yMaxIndex; ++yIndex) {
                    int rowIndex = yIndex * dataWidth + xMinIndex;
                    int rowIndex2 = (yIndex - yMinDst + 1) * dstWidth - 1;
                    for (int xIndex = 0; xIndex < dstWidth; ++xIndex) {
                        dataBuffer[rowIndex2 - xIndex] = dataSet.get(2, rowIndex + xIndex);
                    }
                }
                break;
            }
            case Y_ONLY: {
                int rowIndex2 = dataLength - (yMinIndex - yMinDst + 1) * dstWidth;
                for (int yIndex = yMinIndex; yIndex <= yMaxIndex; ++yIndex) {
                    int rowIndex = yIndex * dataWidth + xMinIndex;
                    for (int xIndex = 0; xIndex < dstWidth; ++xIndex) {
                        dataBuffer[rowIndex2 + xIndex] = dataSet.get(2, rowIndex + xIndex);
                    }
                    rowIndex2 -= dstWidth;
                }
                break;
            }
            case BOTH: {
                int rowIndex2 = dataLength - 1 - (yMinIndex - yMinDst) * dstWidth;
                for (int yIndex = yMinIndex; yIndex <= yMaxIndex; ++yIndex) {
                    int rowIndex = yIndex * dataWidth + xMinIndex;
                    for (int xIndex = 0; xIndex < dstWidth; ++xIndex) {
                        dataBuffer[rowIndex2 - xIndex] = dataSet.get(2, rowIndex + xIndex);
                    }
                    rowIndex2 -= dstWidth;
                }
                break;
            }
            default: {
                for (int yIndex = yMinIndex; yIndex <= yMaxIndex; ++yIndex) {
                    int rowIndex = yIndex * dataWidth + xMinIndex;
                    int rowIndex2 = (yIndex - yMinDst) * dstWidth;
                    for (int xIndex = 0; xIndex < dstWidth; ++xIndex) {
                        dataBuffer[rowIndex2 + xIndex] = dataSet.get(2, rowIndex + xIndex);
                    }
                }
            }
        }
    }

    protected static DataRange computeLocalRange(double[] input, int srcWidth, int srcHeight, boolean computeLocalRange) {
        DataRange zDataRange = new DataRange();
        if (computeLocalRange) {
            int length = srcWidth * srcHeight;
            for (int i = 0; i < length; ++i) {
                zDataRange.add(input[i]);
            }
        }
        return zDataRange;
    }

    protected static void copySubFrame(DataSet dataSet, double[] dataBuffer, boolean parallelImplementation, boolean xInverted, int xMinIndex, int xMaxIndex, boolean yInverted, int yMinIndex, int yMaxIndex) {
        int width = Math.abs(xMaxIndex - xMinIndex) + 1;
        int height = Math.abs(yMaxIndex - yMinIndex) + 1;
        int dataLength = width * height;
        if (!parallelImplementation) {
            ContourDataSetCache.computeCoordinates(dataSet, dataBuffer, dataLength, xInverted, xMinIndex, xMaxIndex, yInverted, yMinIndex, yMaxIndex, yMinIndex);
            return;
        }
        int nMaxThreads = CachedDaemonThreadFactory.getNumbersOfThreads();
        int minthreshold = 500;
        int divThread = (int)Math.ceil((double)height / (double)nMaxThreads);
        int stepSize = Math.max(divThread, 500);
        ArrayList<Callable<Boolean>> workers = new ArrayList<Callable<Boolean>>();
        for (int i = yMinIndex; i < yMaxIndex; i += stepSize) {
            int start = i;
            workers.add(() -> {
                int yMinLocal = start;
                int yMaxLocal = Math.min(start + stepSize, yMaxIndex);
                ContourDataSetCache.computeCoordinates(dataSet, dataBuffer, dataLength, xInverted, xMinIndex, xMaxIndex, yInverted, yMinLocal, yMaxLocal, yMinIndex);
                return Boolean.TRUE;
            });
        }
        try {
            List jobs = CachedDaemonThreadFactory.getCommonPool().invokeAll(workers);
            for (Future future : jobs) {
                Boolean r = (Boolean)future.get();
                if (!Boolean.FALSE.equals(r)) continue;
                throw new IllegalStateException(PARALLEL_WORKER_ERROR);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(PARALLEL_WORKER_ERROR, e);
        }
    }

    protected static double quantize(double value, int nLevels) {
        return (double)((int)(value * (double)nLevels)) / (double)nLevels;
    }

    protected WritableImage convertDataArrayToImage(double[] inputData, int dataWidth, int dataHeight, ColorGradient colorGradient) {
        int length = dataWidth * dataHeight;
        byte[] byteBuffer = ByteArrayCache.getInstance().getArrayExact(length * 4);
        int rowSizeInBytes = 4 * dataWidth;
        WritableImage image = this.getImage(dataWidth, dataHeight);
        PixelWriter pixelWriter = image.getPixelWriter();
        if (pixelWriter == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.atError().log("Could not get PixelWriter for image");
            }
            return image;
        }
        int hMinus1 = dataHeight - 1;
        for (int yIndex = 0; yIndex < dataHeight; ++yIndex) {
            int rowIndex = dataWidth * yIndex;
            int rowPixelIndex = rowSizeInBytes * (hMinus1 - yIndex);
            for (int xIndex = 0; xIndex < dataWidth; ++xIndex) {
                int x = xIndex;
                int[] color = colorGradient.getColorBytes(inputData[rowIndex + xIndex]);
                int pixelIndex = rowPixelIndex + x * 4;
                byteBuffer[pixelIndex] = (byte)color[3];
                byteBuffer[pixelIndex + 1] = (byte)color[2];
                byteBuffer[pixelIndex + 2] = (byte)color[1];
                byteBuffer[pixelIndex + 3] = (byte)color[0];
            }
        }
        pixelWriter.setPixels(0, 0, dataWidth, dataHeight, (PixelFormat)PixelFormat.getByteBgraPreInstance(), byteBuffer, 0, rowSizeInBytes);
        ByteArrayCache.getInstance().add((Object)byteBuffer);
        return image;
    }

    protected static int roundDownEven(double d) {
        return (int)Math.floor(d / 2.0) * 2;
    }

    protected static enum InvertedAxisCase {
        NORMAL,
        X_ONLY,
        Y_ONLY,
        BOTH;


        public static InvertedAxisCase get(boolean xInverted, boolean yInverted) {
            if (xInverted && yInverted) {
                return BOTH;
            }
            if (xInverted) {
                return X_ONLY;
            }
            if (yInverted) {
                return Y_ONLY;
            }
            return NORMAL;
        }
    }
}

