/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.datareduction;

import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.math.ArrayUtils;

public class RamanDouglasPeukerDataReducer
implements RendererDataReducer {
    private double epsilon = 0.1;

    public double[][] filter(double[][] data) {
        return this.ramerDouglasPeuckerFunction(data, 0, data.length - 1);
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    protected double[][] ramerDouglasPeuckerFunction(double[][] points, int startIndex, int endIndex) {
        double dmax = 0.0;
        int idx = 0;
        double dx = points[endIndex][0] - points[startIndex][0];
        double dy = points[endIndex][1] - points[startIndex][1];
        double c = -(dy * points[startIndex][0] - dx * points[startIndex][1]);
        double norm = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        for (int i = startIndex + 1; i < endIndex; ++i) {
            double distance = Math.abs(dy * points[i][0] - dx * points[i][1] + c) / norm;
            if (!(distance > dmax)) continue;
            idx = i;
            dmax = distance;
        }
        if (dmax >= this.epsilon) {
            double[][] recursiveResult1 = this.ramerDouglasPeuckerFunction(points, startIndex, idx);
            double[][] recursiveResult2 = this.ramerDouglasPeuckerFunction(points, idx, endIndex);
            double[][] result = new double[recursiveResult1.length - 1 + recursiveResult2.length][2];
            System.arraycopy(recursiveResult1, 0, result, 0, recursiveResult1.length - 1);
            System.arraycopy(recursiveResult2, 0, result, recursiveResult1.length - 1, recursiveResult2.length);
            return result;
        }
        return new double[][]{points[startIndex], points[endIndex]};
    }

    @Override
    public int reducePoints(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long startTimeStamp = ProcessingProfiler.getTimeStamp();
        double[][] data = new double[indexMax - indexMin][2];
        int count = 0;
        for (int i = indexMin; i < indexMax; ++i) {
            data[count][0] = xValues[i];
            data[count][1] = yValues[i];
            ++count;
        }
        double[][] ret = this.ramerDouglasPeuckerFunction(data, 0, data.length - 1);
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double[] xValuesNew = new double[ret.length];
        double[] yValuesNew = new double[ret.length];
        for (int i = 0; i < ret.length; ++i) {
            xValuesNew[i] = ret[i][0];
            yValuesNew[i] = ret[i][1];
            minY = Math.min(minY, yValuesNew[i]);
            maxY = Math.max(maxY, yValuesNew[i]);
        }
        double range = maxY - minY;
        if (range <= 0.0) {
            range = 1.0;
        }
        this.epsilon = 100.0 / range;
        System.arraycopy(xValuesNew, 0, xValues, 0, xValuesNew.length);
        System.arraycopy(yValuesNew, 0, yValues, 0, yValuesNew.length);
        ArrayUtils.fillArray((double[])yPointErrorsPos, (double)this.epsilon);
        ArrayUtils.fillArray((double[])yPointErrorsNeg, (double)this.epsilon);
        ProcessingProfiler.getTimeDiff((long)startTimeStamp, (String)String.format("data reduction (from %d to %d)", indexMax - indexMin, xValuesNew.length));
        return xValuesNew.length;
    }

    public void setEpsilon(double epsilon) {
        AssertUtils.gtEqThanZero((String)"epsilon", (double)epsilon);
        this.epsilon = epsilon;
    }
}

