/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.datareduction;

import de.gsi.chart.renderer.datareduction.ReductionType;

public final class DefaultDataReducer3D {
    private DefaultDataReducer3D() {
    }

    public static void resample(double[] src, int srcWidth, int srcHeight, double[] target, int targetWidth, int targetHeight, ReductionType reductionType) {
        int xRatio = (srcWidth << 16) / targetWidth + 1;
        int yRatio = (srcHeight << 16) / targetHeight + 1;
        int xLimit = xRatio >> 16;
        int yLimit = yRatio >> 16;
        double norm = xLimit * yLimit;
        switch (reductionType) {
            case MIN: {
                for (int i = 0; i < targetHeight; ++i) {
                    int y2 = i * yRatio >> 16;
                    int srcRowStart = y2 * srcWidth;
                    int targetRowStart = i * targetWidth;
                    for (int j = 0; j < targetWidth; ++j) {
                        int x2 = j * xRatio >> 16;
                        double val = Double.MAX_VALUE;
                        for (int k = 0; k < yLimit; ++k) {
                            int srcRowOffset = k * srcWidth;
                            for (int l = 0; l < xLimit; ++l) {
                                val = Math.min(val, src[srcRowStart + srcRowOffset + x2 + l]);
                            }
                        }
                        target[targetRowStart + j] = val;
                    }
                }
                break;
            }
            case MAX: {
                for (int i = 0; i < targetHeight; ++i) {
                    int y2 = i * yRatio >> 16;
                    int srcRowStart = y2 * srcWidth;
                    int targetRowStart = i * targetWidth;
                    for (int j = 0; j < targetWidth; ++j) {
                        int x2 = j * xRatio >> 16;
                        double val = -1.7976931348623157E308;
                        for (int k = 0; k < yLimit; ++k) {
                            int srcRowOffset = k * srcWidth;
                            for (int l = 0; l < xLimit; ++l) {
                                val = Math.max(val, src[srcRowStart + srcRowOffset + x2 + l]);
                            }
                        }
                        target[targetRowStart + j] = val;
                    }
                }
                break;
            }
            case DOWN_SAMPLE: {
                for (int i = 0; i < targetHeight; ++i) {
                    int y2 = i * yRatio >> 16;
                    int srcRowStart = y2 * srcWidth;
                    int targetRowStart = i * targetWidth;
                    for (int j = 0; j < targetWidth; ++j) {
                        int x2 = j * xRatio >> 16;
                        target[targetRowStart + j] = src[srcRowStart + x2];
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < targetHeight; ++i) {
                    int y2 = i * yRatio >> 16;
                    int srcRowStart = y2 * srcWidth;
                    int targetRowStart = i * targetWidth;
                    for (int j = 0; j < targetWidth; ++j) {
                        int x2 = j * xRatio >> 16;
                        double val = 0.0;
                        for (int k = 0; k < yLimit; ++k) {
                            int srcRowOffset = k * srcWidth;
                            for (int l = 0; l < xLimit; ++l) {
                                val += src[srcRowStart + srcRowOffset + x2 + l];
                            }
                        }
                        target[targetRowStart + j] = val / norm;
                    }
                }
            }
        }
    }

    public static void scaleDownByFactorTwo(double[] target, int targetWidth, int targetHeight, double[] source, int srcWidth, int srcHeight, int yMinIndex, int yMaxIndex, ReductionType reductionType) {
        int scalingX = srcWidth / targetWidth;
        if (scalingX != 2 && scalingX != 1) {
            throw new IllegalArgumentException("targetWidth=" + targetWidth + " to srcWidth=" + srcWidth + " mismatch");
        }
        int scalingY = srcHeight / targetHeight;
        if (scalingY != 2 && scalingY != 1) {
            throw new IllegalArgumentException("targetHeight=" + targetHeight + " to srcHeight=" + srcHeight + " mismatch");
        }
        int yMaxIndexLimited = Math.min(yMaxIndex, targetHeight);
        ScaleAxis scaleAxis = ScaleAxis.get(scalingX >= 2, scalingY >= 2);
        switch (reductionType) {
            case MIN: {
                DefaultDataReducer3D.scaleDownByFactorTwoMin(target, targetWidth, source, srcWidth, yMinIndex, yMaxIndexLimited, scaleAxis);
                break;
            }
            case MAX: {
                DefaultDataReducer3D.scaleDownByFactorTwoMax(target, targetWidth, source, srcWidth, yMinIndex, yMaxIndexLimited, scaleAxis);
                break;
            }
            default: {
                DefaultDataReducer3D.scaleDownByFactorTwoAvg(target, targetWidth, source, srcWidth, yMinIndex, yMaxIndexLimited, scaleAxis);
            }
        }
    }

    private static void copyIdentity(double[] target, int targetWidth, int yMinIndex, double[] source, int yMaxIndex) {
        for (int y = yMinIndex; y <= yMaxIndex; ++y) {
            int rowStart = y * targetWidth;
            for (int x = 0; x < targetWidth; ++x) {
                double r;
                target[rowStart + x] = r = source[rowStart + x];
            }
        }
    }

    private static void scaleDownByFactorTwoAvg(double[] target, int targetWidth, double[] source, int srcWidth, int yMinIndex, int yMaxIndex, ScaleAxis scaleOption) {
        switch (scaleOption) {
            case BOTH: {
                for (int y = yMinIndex; y < yMaxIndex; ++y) {
                    int y2 = y << 1;
                    int rowStart1 = y2 * srcWidth;
                    int rowStart2 = rowStart1 + srcWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        int pixelIndex1 = rowStart1 + (x << 1);
                        int pixelIndex2 = rowStart2 + (x << 1);
                        double p = 0.5 * (source[pixelIndex1] + source[pixelIndex1 + 1]);
                        double q = 0.5 * (source[pixelIndex2] + source[pixelIndex2 + 1]);
                        target[y * targetWidth + x] = r = 0.5 * (p + q);
                    }
                }
                return;
            }
            case X_ONLY: {
                for (int y = yMinIndex; y <= yMaxIndex; ++y) {
                    int rowStartSrc = y * srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        int rowStartX2 = rowStartSrc + (x << 1);
                        target[rowStartDst + x] = r = 0.5 * (source[rowStartX2] + source[rowStartX2 + 1]);
                    }
                }
                return;
            }
            case Y_ONLY: {
                for (int y = yMinIndex; y < yMaxIndex; ++y) {
                    int y2 = y << 1;
                    int rowStartSrc1 = y2 * srcWidth;
                    int rowStartSrc2 = rowStartSrc1 + srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        target[rowStartDst + x] = r = 0.5 * (source[rowStartSrc1 + x] + source[rowStartSrc2 + x]);
                    }
                }
                return;
            }
        }
        DefaultDataReducer3D.copyIdentity(target, targetWidth, yMinIndex, source, yMaxIndex);
    }

    private static void scaleDownByFactorTwoMax(double[] target, int targetWidth, double[] source, int srcWidth, int yMinIndex, int yMaxIndex, ScaleAxis scaleOption) {
        switch (scaleOption) {
            case BOTH: {
                for (int y = yMinIndex; y < yMaxIndex; ++y) {
                    int y2 = y << 1;
                    int rowStartSrc1 = y2 * srcWidth;
                    int rowStartSrc2 = rowStartSrc1 + srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        int pixelIndex1 = rowStartSrc1 + (x << 1);
                        int pixelIndex2 = rowStartSrc2 + (x << 1);
                        double p = Math.max(source[pixelIndex1], source[pixelIndex1 + 1]);
                        double q = Math.max(source[pixelIndex2], source[pixelIndex2 + 1]);
                        target[rowStartDst + x] = r = Math.max(p, q);
                    }
                }
                return;
            }
            case X_ONLY: {
                for (int y = yMinIndex; y <= yMaxIndex; ++y) {
                    int rowStartSrc = y * srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        int rowStartX2 = rowStartSrc + (x << 1);
                        target[rowStartDst + x] = r = Math.max(source[rowStartX2], source[rowStartX2 + 1]);
                    }
                }
                return;
            }
            case Y_ONLY: {
                for (int y = yMinIndex; y < yMaxIndex; ++y) {
                    int y2 = y << 1;
                    int rowStartSrc1 = y2 * srcWidth;
                    int rowStartSrc2 = rowStartSrc1 + srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        target[rowStartDst + x] = r = Math.max(source[rowStartSrc1 + x], source[rowStartSrc2 + x]);
                    }
                }
                return;
            }
        }
        DefaultDataReducer3D.copyIdentity(target, targetWidth, yMinIndex, source, yMaxIndex);
    }

    private static void scaleDownByFactorTwoMin(double[] target, int targetWidth, double[] source, int srcWidth, int yMinIndex, int yMaxIndex, ScaleAxis scaleOption) {
        switch (scaleOption) {
            case BOTH: {
                for (int y = yMinIndex; y < yMaxIndex; ++y) {
                    int y2 = y << 1;
                    int rowStartSrc1 = y2 * srcWidth;
                    int rowStartSrc2 = rowStartSrc1 + srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        int pixelIndex1 = rowStartSrc1 + (x << 1);
                        int pixelIndex2 = rowStartSrc2 + (x << 1);
                        double p = Math.min(source[pixelIndex1], source[pixelIndex1 + 1]);
                        double q = Math.min(source[pixelIndex2], source[pixelIndex2 + 1]);
                        target[rowStartDst + x] = r = Math.min(p, q);
                    }
                }
                return;
            }
            case X_ONLY: {
                for (int y = yMinIndex; y <= yMaxIndex; ++y) {
                    int rowStartDst = y * targetWidth;
                    int rowStart = y * srcWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        int rowStartX2 = rowStart + (x << 1);
                        target[rowStartDst + x] = r = Math.min(source[rowStartX2], source[rowStartX2 + 1]);
                    }
                }
                return;
            }
            case Y_ONLY: {
                for (int y = yMinIndex; y < yMaxIndex; ++y) {
                    int y2 = y << 1;
                    int rowStartSrc1 = y2 * srcWidth;
                    int rowStartSrc2 = rowStartSrc1 + srcWidth;
                    int rowStartDst = y * targetWidth;
                    for (int x = 0; x < targetWidth; ++x) {
                        double r;
                        target[rowStartDst + x] = r = Math.min(source[rowStartSrc1 + x], source[rowStartSrc2 + x]);
                    }
                }
                return;
            }
        }
        DefaultDataReducer3D.copyIdentity(target, targetWidth, yMinIndex, source, yMaxIndex);
    }

    private static enum ScaleAxis {
        BOTH,
        X_ONLY,
        Y_ONLY,
        NONE;


        static ScaleAxis get(boolean scaleX, boolean scaleY) {
            if (scaleX && scaleY) {
                return BOTH;
            }
            if (scaleX) {
                return X_ONLY;
            }
            if (scaleY) {
                return Y_ONLY;
            }
            return NONE;
        }
    }
}

