/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.chart.plugins.YValueIndicator;
import de.gsi.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.GridPane;

public class ValueIndicatorSelector
extends GridPane {
    private static final int DEFAULT_SELECTOR_HEIGHT = 100;
    private static final int ROW_HEIGHT = 24;
    private final ObservableList<AbstractSingleValueIndicator> valueIndicators = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    private final ObservableList<AbstractSingleValueIndicator> valueIndicatorsUser = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final ListView<AbstractSingleValueIndicator> indicatorListView = new ListView(this.valueIndicators);
    private final AxisMode axisMode;
    protected final CheckBox reuseIndicators = new CheckBox();
    protected ListChangeListener<? super ChartPlugin> pluginsChanged = change -> {
        while (change.next()) {
            change.getRemoved().forEach(this::removeIndicators);
            change.getAddedSubList().forEach(this::addNewIndicators);
        }
    };
    protected ChangeListener<? super Chart> chartChangeListener = (ch, o, n) -> {
        if (o != null) {
            o.getPlugins().removeListener(this.pluginsChanged);
        }
        if (n != null) {
            n.getPlugins().addListener(this.pluginsChanged);
        }
    };
    protected ListChangeListener<? super Integer> selectionChangeListener = change -> {
        while (change.next()) {
            ArrayList<AbstractSingleValueIndicator> list = new ArrayList<AbstractSingleValueIndicator>(2);
            Iterator iterator = this.indicatorListView.getSelectionModel().getSelectedIndices().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                list.add((AbstractSingleValueIndicator)this.valueIndicators.get(index));
            }
            this.valueIndicatorsUser.setAll(list);
        }
    };

    public ValueIndicatorSelector(ParameterMeasurements plugin, AxisMode axisMode, int requiredNumberOfIndicators) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin must not be null");
        }
        this.axisMode = axisMode;
        this.reuseIndicators.setSelected(true);
        plugin.chartProperty().addListener(this.chartChangeListener);
        if (plugin.getChart() != null) {
            plugin.getChart().getPlugins().addListener(this.pluginsChanged);
            plugin.getChart().getPlugins().forEach(this::addNewIndicators);
            this.reuseIndicators.setSelected(plugin.getChart().getAxes().size() <= 2);
        }
        Label label = new Label("re-use inidcators: ");
        GridPane.setConstraints((Node)label, (int)0, (int)0);
        GridPane.setConstraints((Node)this.reuseIndicators, (int)1, (int)0);
        this.reuseIndicators.selectedProperty().addListener((ch, o, n) -> this.indicatorListView.setDisable(n == false));
        this.indicatorListView.setOrientation(Orientation.VERTICAL);
        this.indicatorListView.setPrefSize(-1.0, 100.0);
        this.indicatorListView.setCellFactory(list -> new DataSelectorLabel());
        this.indicatorListView.setPrefHeight((double)(Math.max(2, this.valueIndicators.size()) * 24) + 2.0);
        GridPane.setConstraints(this.indicatorListView, (int)1, (int)1);
        MultipleSelectionModel selModel = this.indicatorListView.getSelectionModel();
        selModel.getSelectedIndices().addListener(this.selectionChangeListener);
        if (requiredNumberOfIndicators == 0) {
            this.setVisible(false);
        } else if (requiredNumberOfIndicators == 1) {
            selModel.setSelectionMode(SelectionMode.SINGLE);
        } else if (requiredNumberOfIndicators >= 2) {
            selModel.setSelectionMode(SelectionMode.MULTIPLE);
        }
        if (selModel.getSelectedIndices().isEmpty()) {
            for (int i = 0; i < Math.min(2, this.valueIndicators.size()); ++i) {
                selModel.select((Object)((AbstractSingleValueIndicator)this.valueIndicators.get(i)));
            }
        }
        if (requiredNumberOfIndicators > 0) {
            this.getChildren().addAll((Object[])new Node[]{label, this.reuseIndicators, this.indicatorListView});
        }
    }

    public CheckBox getReuseIndicators() {
        return this.reuseIndicators;
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicators() {
        return this.valueIndicators;
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicatorsUser() {
        return this.valueIndicatorsUser;
    }

    public boolean isReuseIndicators() {
        return this.reuseIndicators.isSelected();
    }

    protected void addNewIndicators(ChartPlugin newPlugin) {
        if (this.axisMode == AxisMode.X && newPlugin instanceof XValueIndicator || this.axisMode == AxisMode.Y && newPlugin instanceof YValueIndicator) {
            if (!this.valueIndicators.contains((Object)newPlugin)) {
                this.valueIndicators.add((Object)((AbstractSingleValueIndicator)newPlugin));
            }
            if (this.reuseIndicators.isSelected() && this.valueIndicatorsUser.size() < 2 && !this.valueIndicatorsUser.contains((Object)newPlugin)) {
                this.valueIndicatorsUser.add((Object)((AbstractSingleValueIndicator)newPlugin));
                this.indicatorListView.getSelectionModel().select((Object)((AbstractSingleValueIndicator)newPlugin));
            }
        }
    }

    protected void removeIndicators(ChartPlugin oldPlugin) {
        this.valueIndicators.remove((Object)oldPlugin);
        this.valueIndicatorsUser.remove((Object)oldPlugin);
    }

    protected static class DataSelectorLabel
    extends ListCell<AbstractSingleValueIndicator> {
        protected DataSelectorLabel() {
        }

        public void updateItem(AbstractSingleValueIndicator item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getText());
            }
        }
    }
}

