/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import de.gsi.chart.plugins.measurements.utils.CheckedNumberTextField;
import de.gsi.chart.utils.FXUtils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class CheckedValueField
extends VBox {
    private static final String DEFAULT_FONT_DATASET = "Verdana Bold";
    private static final String DEFAULT_FONT = "Verdana Bold";
    private static final String DEFAULT_UNIT_FONT = "Verdana Bold";
    private static final int DEFAULT_FONT_SIZE = 550;
    private static final int DEFAULT_UNIT_FONT_SIZE = 300;
    private static final double FONT_SCALE = 3000.0;
    private static final int DEFAULT_MIN_FONT_SIZE = 18;
    private static final int DEFAULT_MIN_UNIT_FONT_SIZE = 14;
    private final DoubleProperty value = new SimpleDoubleProperty((Object)this, "value", Double.NaN);
    private final DoubleProperty minRange = new SimpleDoubleProperty((Object)this, "minRange", Double.NEGATIVE_INFINITY);
    private final DoubleProperty maxRange = new SimpleDoubleProperty((Object)this, "maxRange", Double.POSITIVE_INFINITY);
    private final Label valueLabel = new Label();
    private final Label unitLabel = new Label();
    protected final Label dataSetName = new Label();
    protected CheckedNumberTextField dataRangeMin = new CheckedNumberTextField(this.minRange.get());
    protected CheckedNumberTextField dataRangeMax = new CheckedNumberTextField(this.maxRange.get());
    protected final ChangeListener<Boolean> minRangeFocusLost = (ch, o, n) -> this.evaluateMinRangeText(true);
    protected final ChangeListener<Boolean> maxRangeFocusLost = (ch, o, n) -> this.evaluateMaxRangeText(true);
    protected final EventHandler<? super KeyEvent> minRangeTyped = ke -> {
        if (ke.getCode().equals((Object)KeyCode.ENTER)) {
            this.evaluateMinRangeText(false);
        }
    };
    protected final EventHandler<? super KeyEvent> maxRangeTyped = ke -> {
        if (ke.getCode().equals((Object)KeyCode.ENTER)) {
            this.evaluateMaxRangeText(false);
        }
    };
    protected final ChangeListener<Number> widthChangeListener = (obs, o, n) -> {
        double fontSizeLarge = Math.max(18.0, Math.min(550.0, n.doubleValue() / 3000.0 * 550.0));
        double fontSizeSmall = Math.max(14.0, Math.min(300.0, n.doubleValue() / 3000.0 * 300.0));
        if (this.dataSetName.getFont().getSize() != fontSizeSmall) {
            this.dataSetName.setFont(Font.font((String)"Verdana Bold", (double)fontSizeSmall));
        }
        if (this.valueLabel.getFont().getSize() != fontSizeLarge) {
            this.valueLabel.setFont(Font.font((String)"Verdana Bold", (double)fontSizeLarge));
        }
        if (this.unitLabel.getFont().getSize() != fontSizeSmall) {
            this.unitLabel.setFont(Font.font((String)"Verdana Bold", (double)fontSizeSmall));
        }
    };

    public void evaluateMinRangeText(boolean applySafeDefaults) {
        block2: {
            try {
                this.setMinRange(Double.parseDouble(this.dataRangeMin.getText()));
            }
            catch (NumberFormatException e) {
                if (!applySafeDefaults) break block2;
                this.setMinRange(Double.NEGATIVE_INFINITY);
            }
        }
    }

    public void evaluateMaxRangeText(boolean applySafeDefaults) {
        block2: {
            try {
                this.setMaxRange(Double.parseDouble(this.dataRangeMax.getText()));
            }
            catch (NumberFormatException e) {
                if (!applySafeDefaults) break block2;
                this.setMaxRange(Double.POSITIVE_INFINITY);
            }
        }
    }

    public CheckedValueField() {
        this.setMouseTransparent(true);
        this.dataSetName.setText("");
        this.dataSetName.setPrefWidth(-1.0);
        this.dataSetName.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.dataSetName, Pos.TOP_LEFT));
        this.valueLabel.setText("");
        this.valueLabel.setFont(Font.font((String)"Verdana Bold", (double)18.0));
        this.valueLabel.setPrefWidth(-1.0);
        this.valueLabel.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.valueLabel, Pos.CENTER));
        this.unitLabel.setText("");
        this.unitLabel.setFont(Font.font((String)"Verdana Bold", (double)18.0));
        this.unitLabel.setPrefWidth(-1.0);
        this.unitLabel.setMouseTransparent(true);
        this.getChildren().add((Object)new MyHBox((Node)this.unitLabel, Pos.TOP_RIGHT));
        this.dataRangeMax.focusedProperty().addListener(this.minRangeFocusLost);
        this.dataRangeMin.setOnKeyTyped(this.minRangeTyped);
        this.minRange.addListener((ch, o, n) -> this.dataRangeMin.setText(n.toString()));
        this.dataRangeMax.focusedProperty().addListener(this.maxRangeFocusLost);
        this.dataRangeMax.setOnKeyTyped(this.maxRangeTyped);
        this.maxRange.addListener((ch, o, n) -> this.dataRangeMax.setText(n.toString()));
        this.widthProperty().addListener(this.widthChangeListener);
        VBox.setVgrow((Node)this, (Priority)Priority.SOMETIMES);
    }

    public Label getDataSetName() {
        return this.dataSetName;
    }

    public double getMaxRange() {
        return this.maxRange.get();
    }

    public CheckedNumberTextField getMaxRangeTextField() {
        return this.dataRangeMax;
    }

    public double getMinRange() {
        return this.minRange.get();
    }

    public CheckedNumberTextField getMinRangeTextField() {
        return this.dataRangeMin;
    }

    public Label getUnitLabel() {
        return this.unitLabel;
    }

    public double getValue() {
        return this.value.get();
    }

    public Label getValueLabel() {
        return this.valueLabel;
    }

    public DoubleProperty maxRangeProperty() {
        return this.maxRange;
    }

    public DoubleProperty minRangeProperty() {
        return this.minRange;
    }

    public CheckedValueField resetRanges() {
        this.setMinRange(Double.NEGATIVE_INFINITY);
        this.setMaxRange(Double.POSITIVE_INFINITY);
        this.dataRangeMin.setText(Double.toString(this.getMinRange()));
        this.dataRangeMax.setText(Double.toString(this.getMaxRange()));
        return this;
    }

    public void setDataSetName(String name) {
        FXUtils.runFX(() -> this.dataSetName.setText(name));
    }

    public CheckedValueField setMaxRange(double value) {
        this.maxRange.set(Double.isNaN(value) ? Double.POSITIVE_INFINITY : value);
        this.dataRangeMax.setText(Double.toString(this.getMaxRange()));
        return this;
    }

    public CheckedValueField setMinRange(double value) {
        this.minRange.set(Double.isNaN(value) ? Double.NEGATIVE_INFINITY : value);
        this.dataRangeMin.setText(Double.toString(this.getMinRange()));
        return this;
    }

    public void setUnit(String val) {
        if (this.unitLabel.getText() == null || this.unitLabel.getText().equals(val)) {
            return;
        }
        this.unitLabel.setText(val);
    }

    public void setValue(double val) {
        this.value.set(val);
        this.valueLabel.setText(Double.toString(this.getValue()));
        this.setValueWarning(val < this.getMinRange() || val > this.getMaxRange());
    }

    public void setValue(double val, String valString) {
        if (val == this.getValue()) {
            return;
        }
        this.setValue(val);
        this.getValueLabel().setText(valString);
    }

    public void setValueToolTip(String toolTip) {
        this.valueLabel.setTooltip(new Tooltip(toolTip));
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    protected void setValueWarning(boolean state) {
        if (state) {
            this.valueLabel.setTextFill((Paint)Color.RED);
            this.unitLabel.setTextFill((Paint)Color.RED);
        } else {
            this.valueLabel.setTextFill((Paint)Color.BLACK);
            this.unitLabel.setTextFill((Paint)Color.BLACK);
        }
    }

    private class MyHBox
    extends HBox {
        public MyHBox(Node child, Pos position) {
            super(new Node[]{child});
            this.setAlignment(position);
            VBox.setVgrow((Node)this, (Priority)Priority.SOMETIMES);
        }
    }
}

