/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.DataPointTooltip;
import de.gsi.chart.plugins.EditAxis;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.Screenshot;
import de.gsi.chart.plugins.TableViewer;
import de.gsi.chart.plugins.Zoomer;
import de.gsi.chart.plugins.measurements.AbstractChartMeasurement;
import de.gsi.chart.plugins.measurements.utils.ChartMeasurementSelector;
import de.gsi.chart.plugins.measurements.utils.CheckedNumberTextField;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.MetaDataRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.DragResizerUtil;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventRateLimiter;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.spi.LimitedIndexedTreeDataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.math.DataSetMath;
import de.gsi.math.MathDataSet;
import de.gsi.math.MultiDimDataSetMath;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetMeasurements
extends AbstractChartMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetMeasurements.class);
    private static final long MIN_FFT_BINS = 4L;
    private static final long DEFAULT_UPDATE_RATE_LIMIT = 40L;
    private static final int DEFAULT_BUFFER_CAPACITY = 10000;
    private static final double DEFAULT_BUFFER_LENGTH = 3600000.0;
    private static final String FILTER_CONSTANT_VARIABLE = "filter constant";
    private static final String FREQUENCY = "frequency";
    private static final String MAG = "magnitude(";
    private static final String VALUE = "value";
    private final CheckBox graphBelowOtherDataSets = new CheckBox();
    private final ChartMeasurementSelector measurementSelector;
    private final List<CheckedNumberTextField> parameterFields = new ArrayList<CheckedNumberTextField>();
    private final BooleanProperty graphDetached = new SimpleBooleanProperty((Object)this, "graphDetached", false);
    protected final ButtonType buttonDetached = new ButtonType("Detached", ButtonBar.ButtonData.OK_DONE);
    protected final ObjectProperty<Chart> localChart = new SimpleObjectProperty((Object)this, "localChart", null);
    private final MeasurementType measType;
    private final DefaultNumericAxis xAxis = new DefaultNumericAxis("xAxis");
    private final DefaultNumericAxis yAxis = new DefaultNumericAxis("yAxis");
    private final ErrorDataSetRenderer renderer = new ErrorDataSetRenderer();
    private final MathDataSet.DataSetsFunction dataSetFunction = this::transform;
    private ExternalStage externalStage;
    protected final boolean isTrending;
    protected final LimitedIndexedTreeDataSet trendingDataSet;
    private final MathDataSet mathDataSet;
    protected final ChangeListener<? super Number> delayedUpdateListener = (obs, o, n) -> this.delayedUpdate();
    protected final ChangeListener<Chart> localChartChangeListener = (obs, o, n) -> {
        if (o != null) {
            o.getRenderers().remove((Object)this.renderer);
        }
        if (n != null) {
            if (this.isGraphBelowOtherDataSets()) {
                n.getRenderers().add(0, (Object)this.renderer);
            } else {
                n.getRenderers().add((Object)this.renderer);
            }
        }
    };
    protected final ChangeListener<Chart> globalChartChangeListener = (chartObs, oldChart, newChart) -> {
        if (oldChart != null) {
            oldChart.getRenderers().remove((Object)this.renderer);
        }
        if (newChart != null) {
            this.localChart.set((Object)newChart);
            this.xAxis.forceRedraw();
            this.yAxis.forceRedraw();
        }
    };
    protected final ListChangeListener<? super AbstractChartMeasurement> trendingListener = change -> {
        while (change.next()) {
            change.getRemoved().forEach(meas -> meas.valueProperty().removeListener(this.delayedUpdateListener));
            change.getAddedSubList().forEach(meas -> meas.valueProperty().addListener(this.delayedUpdateListener));
        }
    };

    public DataSetMeasurements(ParameterMeasurements plugin, MeasurementType measType) {
        super(plugin, measType.toString(), measType.isVertical ? AxisMode.X : AxisMode.Y, measType.getRequiredSelectors(), MeasurementCategory.TRENDING.equals((Object)measType.getCategory()) ? 0 : measType.getRequiredDataSets());
        this.measType = measType;
        this.isTrending = MeasurementCategory.TRENDING.equals((Object)measType.getCategory());
        this.measurementSelector = new ChartMeasurementSelector(plugin, this, this.isTrending ? measType.getRequiredDataSets() : 0);
        if (this.isTrending) {
            this.trendingDataSet = new LimitedIndexedTreeDataSet("uninitialised", 10000, 3600000.0);
            this.lastLayoutRow = DataSetMeasurements.shiftGridPaneRowOffset((List<Node>)this.measurementSelector.getChildren(), this.lastLayoutRow);
            this.gridPane.getChildren().addAll((Collection)this.measurementSelector.getChildren());
            switch (measType) {
                case TRENDING_SECONDS: {
                    this.trendingDataSet.setSubtractOffset(true);
                    break;
                }
                case TRENDING_TIMEOFDAY_UTC: {
                    this.xAxis.setTimeAxis(true);
                    break;
                }
                case TRENDING_TIMEOFDAY_LOCAL: {
                    this.xAxis.setTimeAxis(true);
                    DefaultTimeFormatter axisFormatter = (DefaultTimeFormatter)this.xAxis.getAxisLabelFormatter();
                    axisFormatter.setTimeZoneOffset(OffsetDateTime.now().getOffset());
                    break;
                }
            }
        } else {
            this.trendingDataSet = null;
        }
        this.mathDataSet = new MathDataSet(measType.getName(), this.dataSetFunction, 40L, EventRateLimiter.UpdateStrategy.INSTANTANEOUS_RATE, new DataSet[0]);
        this.xAxis.setAutoRanging(true);
        this.xAxis.setAutoUnitScaling(!this.isTrending);
        this.yAxis.setAutoRanging(true);
        this.yAxis.setAutoUnitScaling(true);
        this.renderer.getAxes().addAll((Object[])new Axis[]{this.xAxis, this.yAxis});
        this.renderer.setDrawChartDataSets(false);
        this.renderer.getDatasets().add(this.isTrending ? this.trendingDataSet : this.mathDataSet);
        this.localChart.addListener(this.localChartChangeListener);
        this.getMeasurementPlugin().chartProperty().addListener(this.globalChartChangeListener);
        this.alert.getButtonTypes().add(1, (Object)this.buttonDetached);
        this.addGraphBelowItems();
        this.addParameterValueEditorItems();
        this.graphDetached.addListener((obs, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                this.externalStage = new ExternalStage();
            } else {
                if (this.externalStage == null) {
                    return;
                }
                this.externalStage.close();
                this.localChart.set((Object)this.getMeasurementPlugin().getChart());
            }
        });
        this.setTitle(measType.getName());
        this.getValueField().setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
        this.addMinMaxRangeFields();
    }

    public MeasurementType getMeasType() {
        return this.measType;
    }

    public BooleanProperty graphDetachedProperty() {
        return this.graphDetached;
    }

    public void handle(UpdateEvent event) {
        if (this.getValueIndicatorsUser().size() < this.measType.requiredSelectors) {
            return;
        }
        List dataSets = this.mathDataSet.getSourceDataSets();
        String dataSetsNames = dataSets.isEmpty() ? "(null)" : dataSets.stream().map(DataSet::getName).collect(Collectors.joining(", ", "(", ")"));
        long start = System.nanoTime();
        if (this.isTrending) {
            ObservableList<AbstractChartMeasurement> measurements = this.measurementSelector.getSelectedChartMeasurements();
            if (!measurements.isEmpty()) {
                AbstractChartMeasurement firstMeasurement = (AbstractChartMeasurement)measurements.get(0);
                ArrayList<DataSet> list = new ArrayList<DataSet>();
                list.add(firstMeasurement.getDataSet());
                this.transform(list, this.mathDataSet);
            }
        } else {
            this.transform(this.mathDataSet.getSourceDataSets(), this.mathDataSet);
        }
        long now = System.nanoTime();
        double val = TimeUnit.NANOSECONDS.toMillis(now - start);
        ProcessingProfiler.getTimeDiff((long)start, (String)("computation duration of " + this.measType + " for dataSet" + dataSetsNames));
        FXUtils.runFX(() -> this.getValueField().setUnit("ms"));
        FXUtils.runFX(() -> this.getValueField().setValue(val));
        if (event != null) {
            this.invokeListener(event);
        }
    }

    @Override
    public void initialize() {
        this.getDataViewWindow().setContent((Node)this.getValueField());
        DragResizerUtil.makeResizable((Node)this.getValueField());
        Optional<ButtonType> result = super.showConfigDialogue();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(result).log("config dialogue finished with result {}");
            LOGGER.atTrace().addArgument(this.getValueIndicators()).log("detected getValueIndicators() = {}");
            LOGGER.atTrace().addArgument(this.getValueIndicatorsUser()).log("detected getValueIndicatorsUser() = {}");
        }
        this.dataSetSelector.setDisable(true);
        this.measurementSelector.setDisable(true);
        if (this.isTrending) {
            int sourceSize = this.measurementSelector.getSelectedChartMeasurements().size();
            if (sourceSize < this.measType.getRequiredDataSets()) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.atWarn().addArgument((Object)this.measType).addArgument((Object)sourceSize).addArgument((Object)this.measType.getRequiredDataSets()).log("insuffcient number ChartMeasurements for {} selected {} vs. needed {}");
                }
                this.removeAction();
            }
        } else {
            int sourceSize = this.mathDataSet.getSourceDataSets().size();
            if (this.mathDataSet.getSourceDataSets().size() < this.measType.getRequiredDataSets()) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.atWarn().addArgument((Object)this.measType).addArgument((Object)sourceSize).addArgument((Object)this.measType.getRequiredDataSets()).log("insuffcient number DataSets for {} selected {} vs. needed {}");
                }
                this.removeAction();
            }
        }
    }

    public boolean isGraphBelowOtherDataSets() {
        return this.graphBelowOtherDataSetsProperty().get();
    }

    public boolean isGraphDetached() {
        return this.graphDetachedProperty().get();
    }

    public void setGraphBelowOtherDataSets(boolean state) {
        this.graphBelowOtherDataSetsProperty().set(state);
    }

    public void setGraphDetached(boolean newState) {
        this.graphDetachedProperty().set(newState);
    }

    private void removeRendererFromOldChart() {
        Chart chart = (Chart)((Object)this.localChart.get());
        if (chart != null) {
            chart.getRenderers().remove((Object)this.renderer);
            chart.getAxes().removeAll(this.renderer.getAxes());
            chart.requestLayout();
        }
    }

    protected void addGraphBelowItems() {
        String toolTip = "whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets";
        Label label = new Label("draw below: ");
        label.setTooltip(new Tooltip("whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets"));
        GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
        this.graphBelowOtherDataSets.setSelected(false);
        this.graphBelowOtherDataSets.setTooltip(new Tooltip("whether to draw the new DataSet below (checked) or above (un-checked) the existing DataSets"));
        GridPane.setConstraints((Node)this.graphBelowOtherDataSets, (int)1, (int)this.lastLayoutRow++);
        this.graphBelowOtherDataSets.selectedProperty().addListener((obs, o, n) -> {
            Chart chart = (Chart)((Object)((Object)this.localChart.get()));
            if (chart == null) {
                return;
            }
            chart.getRenderers().remove((Object)this.renderer);
            if (Boolean.TRUE.equals(n)) {
                chart.getRenderers().add(0, (Object)this.renderer);
            } else {
                chart.getRenderers().add((Object)this.renderer);
            }
        });
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, this.graphBelowOtherDataSets});
    }

    protected void addParameterValueEditorItems() {
        if (this.measType.getControlParameterNames().isEmpty()) {
            return;
        }
        String toolTip = "math function parameter - usually in units of the x-axis";
        for (String controlParameter : this.measType.getControlParameterNames()) {
            Label label = new Label(controlParameter + ": ");
            CheckedNumberTextField parameterField = new CheckedNumberTextField(1.0);
            label.setTooltip(new Tooltip("math function parameter - usually in units of the x-axis"));
            GridPane.setConstraints((Node)label, (int)0, (int)this.lastLayoutRow);
            parameterField.setTooltip(new Tooltip("math function parameter - usually in units of the x-axis"));
            GridPane.setConstraints((Node)parameterField, (int)1, (int)this.lastLayoutRow++);
            this.parameterFields.add(parameterField);
            this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{label, parameterField});
        }
        switch (this.measType) {
            case TRENDING_SECONDS: 
            case TRENDING_TIMEOFDAY_UTC: 
            case TRENDING_TIMEOFDAY_LOCAL: {
                this.parameterFields.get(0).setText("600.0");
                this.parameterFields.get(1).setText("10000");
                Button resetButton = new Button("reset history");
                resetButton.setTooltip(new Tooltip("press to reset trending history"));
                resetButton.setOnAction(evt -> this.trendingDataSet.reset());
                GridPane.setConstraints((Node)resetButton, (int)1, (int)this.lastLayoutRow++);
                this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{resetButton});
                break;
            }
        }
    }

    @Override
    protected void defaultAction(Optional<ButtonType> result) {
        boolean openDetached;
        super.defaultAction(result);
        boolean bl = openDetached = result.isPresent() && result.get().equals(this.buttonDetached);
        if (openDetached && !this.graphDetached.get()) {
            this.nominalAction();
            this.xAxis.setSide(Side.BOTTOM);
            this.yAxis.setSide(Side.LEFT);
            this.graphDetached.set(true);
        }
        this.initDataSets();
        if (!openDetached && this.getMeasurementPlugin().getChart() != null) {
            this.xAxis.setSide(Side.TOP);
            this.yAxis.setSide(Side.RIGHT);
            this.localChart.set((Object)this.getMeasurementPlugin().getChart());
        }
        this.delayedUpdate();
    }

    protected void delayedUpdate() {
        new Timer(DataSetMeasurements.class.toString(), true).schedule(new TimerTask(){

            @Override
            public void run() {
                DataSetMeasurements.this.handle(null);
            }
        }, 0L);
    }

    protected String getDataSetsAsStringList(List<DataSet> list) {
        return list.stream().map(DataSet::getName).collect(Collectors.joining(", ", "(", ")"));
    }

    protected BooleanProperty graphBelowOtherDataSetsProperty() {
        return this.graphBelowOtherDataSets.selectedProperty();
    }

    protected void initDataSets() {
        if (this.isTrending) {
            ObservableList<AbstractChartMeasurement> measurements = this.measurementSelector.getSelectedChartMeasurements();
            String measurementName = "measurement";
            this.trendingDataSet.setName(this.measType.getName() + "measurement");
            measurements.removeListener(this.trendingListener);
            measurements.addListener(this.trendingListener);
            if (!measurements.isEmpty()) {
                ((AbstractChartMeasurement)measurements.get(0)).valueProperty().removeListener(this.delayedUpdateListener);
                ((AbstractChartMeasurement)measurements.get(0)).valueProperty().addListener(this.delayedUpdateListener);
            }
        } else {
            ObservableList<DataSet> dataSets = this.dataSetSelector.getSelectedDataSets();
            String dataSetsNames = dataSets.isEmpty() ? "(null)" : this.getDataSetsAsStringList((List<DataSet>)dataSets);
            this.mathDataSet.setName(this.measType.getName() + dataSetsNames);
            this.mathDataSet.deregisterListener();
            this.mathDataSet.getSourceDataSets().clear();
            this.mathDataSet.getSourceDataSets().addAll(dataSets);
            this.mathDataSet.registerListener();
        }
    }

    @Override
    protected void nominalAction() {
        super.nominalAction();
        this.initDataSets();
        this.xAxis.setSide(Side.TOP);
        this.yAxis.setSide(Side.RIGHT);
        this.xAxis.invalidateCaches();
        this.yAxis.invalidateCaches();
        if (this.graphDetached.get() && this.externalStage != null && this.externalStage.getOnCloseRequest() != null) {
            this.externalStage.getOnCloseRequest().handle((Event)new WindowEvent((Window)this.externalStage, WindowEvent.WINDOW_CLOSE_REQUEST));
        }
        if (this.getMeasurementPlugin().getChart() != null) {
            this.localChart.set((Object)this.getMeasurementPlugin().getChart());
        }
        this.graphDetached.set(false);
        this.delayedUpdate();
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.removeRendererFromOldChart();
    }

    protected void transform(List<DataSet> inputDataSets, MathDataSet outputDataSet) {
        if (inputDataSets.isEmpty() || inputDataSets.get(0) == null || inputDataSets.get(0).getDataCount() < 4) {
            outputDataSet.clearMetaInfo();
            outputDataSet.clearData();
            outputDataSet.getWarningList().add(outputDataSet.getName() + " - insufficient/no source data sets");
            return;
        }
        outputDataSet.clearMetaInfo();
        DataSet firstDataSet = inputDataSets.get(0);
        firstDataSet.lock().readLockGuard(() -> {
            double newValueMarker1 = this.requiredNumberOfIndicators >= 1 && !this.getValueIndicatorsUser().isEmpty() ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(0)).getValue() : Double.NEGATIVE_INFINITY;
            double newValueMarker2 = this.requiredNumberOfIndicators >= 2 && this.getValueIndicatorsUser().size() >= 2 ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(1)).getValue() : Double.POSITIVE_INFINITY;
            double functionValue = this.parameterFields.isEmpty() ? 1.0 : this.parameterFields.get(0).getValue();
            String name1 = firstDataSet.getName();
            String xAxisName = firstDataSet.getAxisDescription(0).getName();
            String xAxisUnit = firstDataSet.getAxisDescription(0).getUnit();
            String yAxisName = firstDataSet.getAxisDescription(1).getName();
            String yAxisUnit = firstDataSet.getAxisDescription(1).getUnit();
            boolean moreThanOne = inputDataSets.size() > 1;
            DataSet secondDataSet = moreThanOne ? (DataSet)inputDataSets.get(1) : null;
            String name2 = moreThanOne ? secondDataSet.getName() : "";
            FXUtils.runFX(() -> this.xAxis.set(xAxisName, xAxisUnit));
            FXUtils.runFX(() -> this.yAxis.set(yAxisName, yAxisUnit));
            switch (this.measType) {
                case ADD_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2211(" + name1 + " + " + name2 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (DataSet)secondDataSet, (DataSetMath.MathOp)DataSetMath.MathOp.ADD));
                    break;
                }
                case ADD_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2211(" + name1 + " + " + functionValue + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.MathOp)DataSetMath.MathOp.ADD));
                    break;
                }
                case SUBTRACT_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2206(" + name1 + " - " + name2 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (DataSet)secondDataSet, (DataSetMath.MathOp)DataSetMath.MathOp.SUBTRACT));
                    break;
                }
                case SUBTRACT_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2206(" + name1 + " - " + functionValue + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.MathOp)DataSetMath.MathOp.SUBTRACT));
                    break;
                }
                case MULTIPLY_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("\u220f(" + name1 + " * " + name2 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (DataSet)secondDataSet, (DataSetMath.MathOp)DataSetMath.MathOp.MULTIPLY));
                    break;
                }
                case MULTIPLY_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u220f(" + name1 + " * " + functionValue + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.MathOp)DataSetMath.MathOp.MULTIPLY));
                    break;
                }
                case DIVIDE_FUNCTIONS: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + name1 + " / " + name2 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (DataSet)secondDataSet, (DataSetMath.MathOp)DataSetMath.MathOp.DIVIDE));
                    break;
                }
                case DIVIDE_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + name1 + " / " + functionValue + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.MathOp)DataSetMath.MathOp.DIVIDE));
                    break;
                }
                case SUB_RANGE: {
                    FXUtils.runFX(() -> this.yAxis.set("sub-range(" + name1 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.getSubRange((DataSet)firstDataSet, (double)newValueMarker1, (double)newValueMarker2));
                    break;
                }
                case ADD_GAUSS_NOISE: {
                    FXUtils.runFX(() -> this.yAxis.set(name1 + " + " + functionValue + " r.m.s. noise", yAxisUnit));
                    outputDataSet.set(DataSetMath.addGaussianNoise((DataSet)firstDataSet, (double)functionValue));
                    break;
                }
                case AVG_DATASET_FIR: {
                    FXUtils.runFX(() -> this.yAxis.set("<" + name1 + ", " + inputDataSets.size() + " DataSets>", yAxisUnit));
                    outputDataSet.set(DataSetMath.averageDataSetsFIR((List)inputDataSets, (int)((int)Math.floor(functionValue))));
                    break;
                }
                case SQUARE: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + name1 + ")\u00b2", yAxisUnit));
                    outputDataSet.set(DataSetMath.sqrFunction((DataSet)firstDataSet));
                    break;
                }
                case SQUARE_FULL: {
                    FXUtils.runFX(() -> this.yAxis.set("(" + name1 + ", " + name2 + ")\u00b2", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (DataSet)secondDataSet, (DataSetMath.MathOp)DataSetMath.MathOp.SQR));
                    break;
                }
                case SQUARE_ROOT: {
                    FXUtils.runFX(() -> this.yAxis.set("\u221a(" + name1 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.sqrtFunction((DataSet)firstDataSet));
                    break;
                }
                case SQUARE_ROOT_FULL: {
                    FXUtils.runFX(() -> this.yAxis.set("\u221a(" + name1 + ", " + name2 + ")", yAxisUnit));
                    outputDataSet.set(DataSetMath.mathFunction((DataSet)firstDataSet, (DataSet)secondDataSet, (DataSetMath.MathOp)DataSetMath.MathOp.SQRT));
                    break;
                }
                case INTEGRAL: {
                    FXUtils.runFX(() -> this.yAxis.set("\u222b(" + name1 + ")d" + xAxisName, xAxisUnit + "*" + yAxisUnit));
                    outputDataSet.set(DataSetMath.integrateFunction((DataSet)firstDataSet, (double)newValueMarker1, (double)newValueMarker2));
                    break;
                }
                case INTEGRAL_FULL: {
                    FXUtils.runFX(() -> this.yAxis.set("\u222b(" + name1 + ")d" + xAxisName, xAxisUnit + "*" + yAxisUnit));
                    outputDataSet.set(DataSetMath.integrateFunction((DataSet)firstDataSet));
                    break;
                }
                case DIFFERENTIATE: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2202(" + name1 + ")/\u2202" + xAxisName, xAxisUnit + "*" + yAxisUnit));
                    outputDataSet.set(DataSetMath.derivativeFunction((DataSet)firstDataSet));
                    break;
                }
                case DIFFERENTIATE_WITH_SCALLING: {
                    FXUtils.runFX(() -> this.yAxis.set("\u2202(" + name1 + ")/\u2202" + xAxisName, xAxisUnit + "*" + yAxisUnit));
                    outputDataSet.set(DataSetMath.derivativeFunction((DataSet)firstDataSet, (double)functionValue));
                    break;
                }
                case NORMALISE_TO_INTEGRAL: {
                    FXUtils.runFX(() -> this.yAxis.set("normalised(" + name1 + ")", "1"));
                    outputDataSet.set(DataSetMath.normalisedFunction((DataSet)firstDataSet));
                    break;
                }
                case NORMALISE_TO_INTEGRAL_VALUE: {
                    FXUtils.runFX(() -> this.yAxis.set("normalised(" + name1 + ")", Double.toString(functionValue)));
                    outputDataSet.set(DataSetMath.normalisedFunction((DataSet)firstDataSet, (double)functionValue));
                    break;
                }
                case FILTER_MEAN: {
                    FXUtils.runFX(() -> this.yAxis.set("<" + name1 + ", " + functionValue + ">", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.Filter)DataSetMath.Filter.MEAN));
                    break;
                }
                case FILTER_MEDIAN: {
                    FXUtils.runFX(() -> this.yAxis.set("median(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)Math.max(3.0, functionValue), (DataSetMath.Filter)DataSetMath.Filter.MEDIAN));
                    break;
                }
                case FILTER_MIN: {
                    FXUtils.runFX(() -> this.yAxis.set("min(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.Filter)DataSetMath.Filter.MIN));
                    break;
                }
                case FILTER_MAX: {
                    FXUtils.runFX(() -> this.yAxis.set("max(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.Filter)DataSetMath.Filter.MAX));
                    break;
                }
                case FILTER_P2P: {
                    FXUtils.runFX(() -> this.yAxis.set("peak-to-peak(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.Filter)DataSetMath.Filter.P2P));
                    break;
                }
                case FILTER_RMS: {
                    FXUtils.runFX(() -> this.yAxis.set("rms(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.Filter)DataSetMath.Filter.RMS));
                    break;
                }
                case FILTER_GEOMMEAN: {
                    FXUtils.runFX(() -> this.yAxis.set("geo.-mean(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.filterFunction((DataSet)firstDataSet, (double)functionValue, (DataSetMath.Filter)DataSetMath.Filter.GEOMMEAN));
                    break;
                }
                case FILTER_LOWPASS_IIR: {
                    FXUtils.runFX(() -> this.yAxis.set("IIR-low-pass(" + name1 + ", " + functionValue + ")", xAxisUnit));
                    outputDataSet.set(DataSetMath.iirLowPassFilterFunction((DataSet)firstDataSet, (double)functionValue));
                    break;
                }
                case DATASET_SLICE_X: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(0)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeSlice((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)0, (double)newValueMarker1);
                    break;
                }
                case DATASET_SLICE_Y: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeSlice((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)1, (double)newValueMarker1);
                    break;
                }
                case DATASET_MEAN_X: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMean((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)0, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_MEAN_Y: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMean((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)1, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_MIN_X: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMin((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)0, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_MIN_Y: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMin((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)1, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_MAX_X: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMax((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)0, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_MAX_Y: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeMax((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)1, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_INTEGRAL_X: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeIntegral((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)0, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case DATASET_INTEGRAL_Y: {
                    if (firstDataSet.getDimension() <= 2) break;
                    FXUtils.runFX(() -> this.xAxis.set(firstDataSet.getAxisDescription(1)));
                    FXUtils.runFX(() -> this.yAxis.set(firstDataSet.getAxisDescription(2)));
                    MultiDimDataSetMath.computeIntegral((DataSet)firstDataSet, (DoubleErrorDataSet)outputDataSet, (int)1, (double)newValueMarker1, (double)newValueMarker2);
                    break;
                }
                case FFT_DB: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "dB"));
                    outputDataSet.set(DataSetMath.magnitudeSpectrumDecibel((DataSet)firstDataSet));
                    break;
                }
                case FFT_DB_RANGED: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "dB"));
                    DataSet subRange = DataSetMath.getSubRange((DataSet)firstDataSet, (double)newValueMarker1, (double)newValueMarker2);
                    if ((long)subRange.getDataCount() < 4L) break;
                    outputDataSet.set(DataSetMath.magnitudeSpectrumDecibel((DataSet)subRange));
                    break;
                }
                case FFT_NORM_DB: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "dB"));
                    outputDataSet.set(DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)firstDataSet));
                    break;
                }
                case FFT_NORM_DB_RANGED: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "dB"));
                    DataSet subRange = DataSetMath.getSubRange((DataSet)firstDataSet, (double)newValueMarker1, (double)newValueMarker2);
                    if ((long)subRange.getDataCount() < 4L) break;
                    outputDataSet.set(DataSetMath.normalisedMagnitudeSpectrumDecibel((DataSet)subRange));
                    break;
                }
                case FFT_LIN: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", yAxisUnit + "/rtHz"));
                    outputDataSet.set(DataSetMath.magnitudeSpectrum((DataSet)firstDataSet));
                    break;
                }
                case FFT_LIN_RANGED: {
                    FXUtils.runFX(() -> this.xAxis.set(FREQUENCY, "Hz"));
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "/rtHz"));
                    outputDataSet.set(DataSetMath.magnitudeSpectrum((DataSet)DataSetMath.getSubRange((DataSet)firstDataSet, (double)newValueMarker1, (double)newValueMarker2)));
                    break;
                }
                case CONVERT_TO_DB: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "dB(" + yAxisUnit + ")"));
                    outputDataSet.set(DataSetMath.dbFunction((DataSet)firstDataSet));
                    break;
                }
                case CONVERT2_TO_DB: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "dB(" + yAxisUnit + ")"));
                    outputDataSet.set(DataSetMath.dbFunction((DataSet)firstDataSet, (DataSet)secondDataSet));
                    break;
                }
                case CONVERT_FROM_DB: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "a.u."));
                    outputDataSet.set(DataSetMath.inversedbFunction((DataSet)firstDataSet));
                    break;
                }
                case CONVERT_TO_LOG10: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + ")", "log10"));
                    outputDataSet.set(DataSetMath.log10Function((DataSet)firstDataSet));
                    break;
                }
                case CONVERT2_TO_LOG10: {
                    FXUtils.runFX(() -> this.yAxis.set(MAG + name1 + " + " + name2 + ")", "log10"));
                    outputDataSet.set(DataSetMath.log10Function((DataSet)firstDataSet, (DataSet)secondDataSet));
                    break;
                }
                case TRENDING_SECONDS: 
                case TRENDING_TIMEOFDAY_UTC: 
                case TRENDING_TIMEOFDAY_LOCAL: {
                    int lengthSamples;
                    double now = (double)System.currentTimeMillis() / 1000.0;
                    double lengthTime = this.parameterFields.isEmpty() ? 1.0 : Math.max(1.0, this.parameterFields.get(0).getValue());
                    int n = lengthSamples = this.parameterFields.isEmpty() ? 1 : (int)Math.max(1.0, this.parameterFields.get(1).getValue());
                    if (this.trendingDataSet.getMaxQueueSize() != lengthSamples) {
                        this.trendingDataSet.setMaxQueueSize(lengthSamples);
                    }
                    if (this.trendingDataSet.getMaxLength() != lengthTime) {
                        this.trendingDataSet.setMaxLength(lengthTime);
                    }
                    FXUtils.runFX(() -> this.xAxis.set("time-of-day", new String[]{null}));
                    FXUtils.runFX(() -> this.yAxis.set(yAxisName, yAxisUnit));
                    AbstractChartMeasurement measurement = this.measurementSelector.getSelectedChartMeasurement();
                    if (measurement == null) break;
                    this.trendingDataSet.setName(measurement.getTitle());
                    this.trendingDataSet.add(now, measurement.valueProperty().get());
                    break;
                }
            }
        });
    }

    protected class ExternalStage
    extends Stage {
        private final EventListener titleListener = evt -> FXUtils.runFX(() -> this.setTitle(DataSetMeasurements.this.mathDataSet.getName()));

        public ExternalStage() {
            XYChart chart = new XYChart(DataSetMeasurements.this.xAxis, DataSetMeasurements.this.yAxis);
            chart.getRenderers().setAll((Object[])new Renderer[]{new MetaDataRenderer(chart)});
            chart.applyCss();
            chart.getPlugins().add((Object)new ParameterMeasurements());
            chart.getPlugins().add((Object)new Screenshot());
            chart.getPlugins().add((Object)new EditAxis());
            Zoomer zoomer = new Zoomer();
            zoomer.setUpdateTickUnit(true);
            zoomer.setAutoZoomEnabled(true);
            zoomer.setAddButtonsToToolBar(false);
            chart.getPlugins().add((Object)zoomer);
            chart.getPlugins().add((Object)new DataPointTooltip());
            chart.getPlugins().add((Object)new TableViewer());
            Scene scene = new Scene((Parent)chart, 640.0, 480.0);
            ((DataSet)DataSetMeasurements.this.renderer.getDatasets().get(0)).addListener(this.titleListener);
            this.setScene(scene);
            FXUtils.runFX(() -> ((ExternalStage)this).show());
            FXUtils.runFX(() -> {
                DataSetMeasurements.this.localChart.set((Object)chart);
                DataSetMeasurements.this.xAxis.invalidateCaches();
                DataSetMeasurements.this.yAxis.invalidateCaches();
                DataSetMeasurements.this.xAxis.applyCss();
                DataSetMeasurements.this.yAxis.applyCss();
                DataSetMeasurements.this.xAxis.setSide(Side.BOTTOM);
                DataSetMeasurements.this.yAxis.setSide(Side.LEFT);
            });
            this.setOnCloseRequest(evt -> {
                chart.getRenderers().remove((Object)DataSetMeasurements.this.renderer);
                chart.getAxes().clear();
                ((DataSet)DataSetMeasurements.this.renderer.getDatasets().get(0)).removeListener(this.titleListener);
                DataSetMeasurements.this.xAxis.invalidateCaches();
                DataSetMeasurements.this.yAxis.invalidateCaches();
                DataSetMeasurements.this.xAxis.setSide(Side.TOP);
                DataSetMeasurements.this.yAxis.setSide(Side.RIGHT);
                DataSetMeasurements.this.graphDetached.set(false);
            });
        }
    }

    public static enum MeasurementType {
        ADD_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1+DataSet2", 0, 2, new String[0]),
        ADD_VALUE(true, MeasurementCategory.MATH, "DataSet1 + value", 0, 1, "value"),
        SUBTRACT_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1-DataSet2", 0, 2, new String[0]),
        SUBTRACT_VALUE(true, MeasurementCategory.MATH, "DataSet1 - value", 0, 1, "value"),
        MULTIPLY_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1*DataSet2", 0, 2, new String[0]),
        MULTIPLY_VALUE(true, MeasurementCategory.MATH, "DataSet1 * value", 0, 1, "value"),
        DIVIDE_FUNCTIONS(true, MeasurementCategory.MATH, "DataSet1/DataSet2", 0, 2, new String[0]),
        DIVIDE_VALUE(true, MeasurementCategory.MATH, "DataSet1 / value", 0, 1, "value"),
        SUB_RANGE(true, MeasurementCategory.MATH, "DataSet sub-range", 2, 1, new String[0]),
        ADD_GAUSS_NOISE(true, MeasurementCategory.MATH, "add gaussian noise", 0, 1, "r.m.s. noise"),
        AVG_DATASET_FIR(true, MeasurementCategory.MATH, "average data sets FIR"),
        SQUARE(true, MeasurementCategory.MATH_FUNCTION, "DataSet\u00b2", 0, 1, new String[0]),
        SQUARE_FULL(true, MeasurementCategory.MATH_FUNCTION, "(DataSet1+DataSet2)\u00b2", 0, 2, new String[0]),
        SQUARE_ROOT(true, MeasurementCategory.MATH_FUNCTION, "\u221aDataSet", 0, 1, new String[0]),
        SQUARE_ROOT_FULL(true, MeasurementCategory.MATH_FUNCTION, "\u221a(DataSet1+DataSet2)", 0, 2, new String[0]),
        INTEGRAL(true, MeasurementCategory.MATH_FUNCTION, "\u222bDataSet", 2, 1, new String[0]),
        INTEGRAL_FULL(true, MeasurementCategory.MATH_FUNCTION, "\u222bDataSet full range", 0, 1, new String[0]),
        DIFFERENTIATE(true, MeasurementCategory.MATH_FUNCTION, "\u2202DataSet"),
        DIFFERENTIATE_WITH_SCALLING(true, MeasurementCategory.MATH_FUNCTION, "\u2202DataSet with scalling"),
        NORMALISE_TO_INTEGRAL(true, MeasurementCategory.MATH_FUNCTION, "norm. to integral=1.0", 0, 1, new String[0]),
        NORMALISE_TO_INTEGRAL_VALUE(true, MeasurementCategory.MATH_FUNCTION, "integral value", 0, 1, "norm. to integral=value"),
        FILTER_MEAN(true, MeasurementCategory.FILTER, "LowPass", 0, 1, "filter constant"),
        FILTER_MEDIAN(true, MeasurementCategory.FILTER, "Median", 0, 1, "filter constant"),
        FILTER_MIN(true, MeasurementCategory.FILTER, "Min", 0, 1, "filter constant"),
        FILTER_MAX(true, MeasurementCategory.FILTER, "Max", 0, 1, "filter constant"),
        FILTER_P2P(true, MeasurementCategory.FILTER, "PeakToPeak", 0, 1, "filter constant"),
        FILTER_RMS(true, MeasurementCategory.FILTER, "RMS", 0, 1, "filter constant"),
        FILTER_GEOMMEAN(true, MeasurementCategory.FILTER, "GeometricMean", 0, 1, "filter constant"),
        FILTER_LOWPASS_IIR(true, MeasurementCategory.FILTER, "low-pass (IIR)", 0, 1, "filter constant"),
        DATASET_SLICE_X(false, MeasurementCategory.PROJECTION, "hor. Slice", 1, 1, new String[0]),
        DATASET_SLICE_Y(true, MeasurementCategory.PROJECTION, "ver. Slice", 1, 1, new String[0]),
        DATASET_MEAN_X(false, MeasurementCategory.PROJECTION, "hor. Mean-Projection", 2, 1, new String[0]),
        DATASET_MEAN_Y(true, MeasurementCategory.PROJECTION, "ver. Mean-Projection", 2, 1, new String[0]),
        DATASET_MIN_X(false, MeasurementCategory.PROJECTION, "hor. Min-Projection", 2, 1, new String[0]),
        DATASET_MIN_Y(true, MeasurementCategory.PROJECTION, "ver. Min-Projection", 2, 1, new String[0]),
        DATASET_MAX_X(false, MeasurementCategory.PROJECTION, "hor. Max-Projection", 2, 1, new String[0]),
        DATASET_MAX_Y(true, MeasurementCategory.PROJECTION, "ver. Max-Projection", 2, 1, new String[0]),
        DATASET_INTEGRAL_X(false, MeasurementCategory.PROJECTION, "hor. Integral-Projection", 2, 1, new String[0]),
        DATASET_INTEGRAL_Y(true, MeasurementCategory.PROJECTION, "ver. Integral-Projection", 2, 1, new String[0]),
        FFT_DB(true, MeasurementCategory.FOURIER, "FFT [dB]", 0, 1, new String[0]),
        FFT_DB_RANGED(true, MeasurementCategory.FOURIER, "FFT within range [dB]", 2, 1, new String[0]),
        FFT_NORM_DB(true, MeasurementCategory.FOURIER, "FFT - normalised frequency [dB]", 0, 1, new String[0]),
        FFT_NORM_DB_RANGED(true, MeasurementCategory.FOURIER, "FFT - norm. & ranged [dB]", 2, 1, new String[0]),
        FFT_LIN(true, MeasurementCategory.FOURIER, "FFT [lin]", 0, 1, new String[0]),
        FFT_LIN_RANGED(true, MeasurementCategory.FOURIER, "FFT within range [lin]", 2, 1, new String[0]),
        CONVERT_TO_DB(true, MeasurementCategory.FOURIER, "convert DataSet to dB", 0, 1, new String[0]),
        CONVERT2_TO_DB(true, MeasurementCategory.FOURIER, "convert sum of DataSets to dB", 0, 2, new String[0]),
        CONVERT_FROM_DB(true, MeasurementCategory.FOURIER, "convert DataSet from dB", 0, 1, new String[0]),
        CONVERT_TO_LOG10(true, MeasurementCategory.FOURIER, "convert DataSet to log10", 0, 1, new String[0]),
        CONVERT2_TO_LOG10(true, MeasurementCategory.FOURIER, "convert sum of DataSets to log10", 0, 2, new String[0]),
        TRENDING_SECONDS(true, MeasurementCategory.TRENDING, "trend in seconds", 0, 1, "length history [s]", "n data points []"),
        TRENDING_TIMEOFDAY_UTC(true, MeasurementCategory.TRENDING, "time-of-day trending [UTC]", 0, 1, "length history [s]", "n data points []"),
        TRENDING_TIMEOFDAY_LOCAL(true, MeasurementCategory.TRENDING, "time-of-day trending [local]", 0, 1, "length history [s]", "n data points []");

        private final String name;
        private final MeasurementCategory category;
        private final List<String> controlParameterNames = new ArrayList<String>();
        private final int requiredSelectors;
        private final int requiredDataSets;
        private final boolean isVertical;

        private MeasurementType(boolean isVerticalMeasurement, MeasurementCategory measurementCategory, String description) {
            this(isVerticalMeasurement, measurementCategory, description, 2, 1, new String[0]);
        }

        private MeasurementType(boolean isVerticalMeasurement, MeasurementCategory measurementCategory, String description, int requiredSelectors, int requiredDataSets, String ... controlParameterNames) {
            this.isVertical = isVerticalMeasurement;
            this.category = measurementCategory;
            this.name = description;
            if (controlParameterNames != null) {
                this.controlParameterNames.addAll(Arrays.asList(controlParameterNames));
            }
            this.requiredSelectors = requiredSelectors;
            this.requiredDataSets = requiredDataSets;
        }

        public MeasurementCategory getCategory() {
            return this.category;
        }

        public List<String> getControlParameterNames() {
            return this.controlParameterNames;
        }

        public String getName() {
            return this.name;
        }

        public int getRequiredDataSets() {
            return this.requiredDataSets;
        }

        public int getRequiredSelectors() {
            return this.requiredSelectors;
        }

        public boolean isVerticalMeasurement() {
            return this.isVertical;
        }
    }

    public static enum MeasurementCategory {
        MATH("Math - Basic"),
        MATH_FUNCTION("Math - Functions"),
        FILTER("DataSet Filtering"),
        PROJECTION("DataSet Projections"),
        FOURIER("Spectral Transforms"),
        TRENDING("Trending");

        private String name;

        private MeasurementCategory(String description) {
            this.name = description;
        }

        public String getName() {
            return this.name;
        }
    }
}

