/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.chart.plugins.YValueIndicator;
import de.gsi.chart.plugins.measurements.utils.CheckedValueField;
import de.gsi.chart.plugins.measurements.utils.DataSetSelector;
import de.gsi.chart.plugins.measurements.utils.ValueIndicatorSelector;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.utils.MouseUtils;
import de.gsi.chart.viewer.DataViewWindow;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventRateLimiter;
import de.gsi.dataset.event.EventSource;
import impl.org.controlsfx.skin.DecorationPane;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChartMeasurement
implements EventListener,
EventSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractChartMeasurement.class);
    private static final int MIN_DRAG_BORDER_WIDTH = 30;
    protected static final double DEFAULT_MIN = Double.NEGATIVE_INFINITY;
    protected static final double DEFAULT_MAX = Double.POSITIVE_INFINITY;
    protected static final long DEFAULT_UPDATE_RATE_LIMIT = 40L;
    protected static final int SMALL_FORMAT_THRESHOLD = 3;
    private static final String FORMAT_SMALL_SCALE = "0.###";
    private static final String FORMAT_LARGE_SCALE = "0.##E0";
    public static final int DEFAULT_SMALL_AXIS = 6;
    protected final DecimalFormat formatterSmall = new DecimalFormat("0.###");
    protected final DecimalFormat formatterLarge = new DecimalFormat("0.##E0");
    private final AtomicBoolean autoNotify = new AtomicBoolean(true);
    private final List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final CheckedValueField valueField = new CheckedValueField();
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", null);
    private final ObjectProperty<DataSet> dataSet = new SimpleObjectProperty((Object)this, "dataSet", null);
    private final DataViewWindow dataViewWindow = new DataViewWindow("not initialised", (Node)new Label("content to be filled"), DataViewWindow.WindowDecoration.FRAME);
    protected final Alert alert;
    protected final ButtonType buttonOK = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
    protected final ButtonType buttonDefault = new ButtonType("Defaults", ButtonBar.ButtonData.OK_DONE);
    protected final ButtonType buttonRemove = new ButtonType("Remove", ButtonBar.ButtonData.RIGHT);
    protected final DataSetSelector dataSetSelector;
    protected final ValueIndicatorSelector valueIndicatorSelector;
    protected int lastLayoutRow;
    protected final int requiredNumberOfIndicators;
    protected final int requiredNumberOfDataSets;
    private final EventListener sliderChanged = new EventRateLimiter(arg_0 -> ((AbstractChartMeasurement)this).handle(arg_0), 40L);
    protected final GridPane gridPane = new GridPane();
    private final ParameterMeasurements plugin;
    private final String measurementName;
    protected final AxisMode axisMode;
    private final EventHandler<? super MouseEvent> mouseHandler = mevt -> {
        Bounds screenBounds = this.dataViewWindow.localToScreen(this.dataViewWindow.getBoundsInLocal());
        Point2D mouseLoc = new Point2D(mevt.getScreenX(), mevt.getScreenY());
        double distance = MouseUtils.mouseInsideBoundaryBoxDistance(screenBounds, mouseLoc);
        if (MouseButton.SECONDARY == mevt.getButton() && distance > 30.0 && mevt.getClickCount() < 2) {
            this.showConfigDialogue();
            return;
        }
        if (MouseButton.SECONDARY == mevt.getButton() && mevt.getClickCount() >= 2) {
            this.dataViewWindow.setMinWidth(-1.0);
            this.dataViewWindow.setMinHeight(-1.0);
            this.dataViewWindow.setPrefWidth(-1.0);
            this.dataViewWindow.setPrefHeight(-1.0);
        }
    };
    private final ChangeListener<? super DataSet> dataSetChangeListener = (obs, o, n) -> {
        if (o != null) {
            o.removeListener((EventListener)this);
        }
        if (n == null) {
            this.getValueField().setDataSetName("<unknown data set>");
        } else {
            n.addListener((EventListener)this);
            this.getValueField().setDataSetName('<' + n.getName() + '>');
        }
    };
    private final ListChangeListener<? super AbstractSingleValueIndicator> valueIndicatorsUserChangeListener = change -> {
        while (change.next()) {
            change.getRemoved().forEach(oldIndicator -> oldIndicator.removeListener(this.sliderChanged));
            change.getAddedSubList().stream().filter(newIndicator -> !newIndicator.updateEventListener().contains(this.sliderChanged)).forEach(newIndicator -> newIndicator.addListener(this.sliderChanged));
        }
    };

    public AbstractChartMeasurement(ParameterMeasurements plugin, String measurementName, AxisMode axisMode, int requiredNumberOfIndicators, int requiredNumberOfDataSets) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin is null");
        }
        this.plugin = plugin;
        this.measurementName = measurementName;
        this.axisMode = axisMode;
        this.requiredNumberOfIndicators = requiredNumberOfIndicators;
        this.requiredNumberOfDataSets = requiredNumberOfDataSets;
        plugin.getChartMeasurements().add((Object)this);
        this.alert = new Alert(Alert.AlertType.CONFIRMATION);
        this.alert.setTitle("Measurement Config Dialog");
        this.alert.setHeaderText("Please, select data set and/or other parameters:");
        this.alert.initModality(Modality.APPLICATION_MODAL);
        DecorationPane decorationPane = new DecorationPane();
        decorationPane.getChildren().add((Object)this.gridPane);
        this.alert.getDialogPane().setContent((Node)decorationPane);
        this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{this.buttonOK, this.buttonDefault, this.buttonRemove});
        this.alert.setOnCloseRequest(evt -> this.alert.close());
        this.dataSetSelector = new DataSetSelector(plugin, requiredNumberOfDataSets);
        if (this.dataSetSelector.getNumberDataSets() >= 1) {
            this.lastLayoutRow = AbstractChartMeasurement.shiftGridPaneRowOffset((List<Node>)this.dataSetSelector.getChildren(), this.lastLayoutRow);
            this.gridPane.getChildren().addAll((Collection)this.dataSetSelector.getChildren());
        }
        this.valueIndicatorSelector = new ValueIndicatorSelector(plugin, axisMode, requiredNumberOfIndicators);
        this.lastLayoutRow = AbstractChartMeasurement.shiftGridPaneRowOffset((List<Node>)this.valueIndicatorSelector.getChildren(), this.lastLayoutRow);
        this.gridPane.getChildren().addAll((Collection)this.valueIndicatorSelector.getChildren());
        this.valueField.setMouseTransparent(true);
        GridPane.setVgrow((Node)this.dataViewWindow, (Priority)Priority.NEVER);
        this.dataViewWindow.setOnMouseClicked(this.mouseHandler);
        this.getValueIndicatorsUser().addListener(this.valueIndicatorsUserChangeListener);
        this.dataViewWindow.nameProperty().bindBidirectional((Property)this.title);
        this.setTitle(this.getClass().getSimpleName());
        this.dataSet.addListener(this.dataSetChangeListener);
        this.dataSetChangeListener.changed(this.dataSet, null, null);
        this.getMeasurementPlugin().getDataView().getVisibleChildren().add((Object)this.dataViewWindow);
    }

    public AtomicBoolean autoNotification() {
        return this.autoNotify;
    }

    public ObjectProperty<DataSet> dataSetProperty() {
        return this.dataSet;
    }

    public DataSet getDataSet() {
        return (DataSet)this.dataSetProperty().get();
    }

    public DataViewWindow getDataViewWindow() {
        return this.dataViewWindow;
    }

    @Deprecated
    public Pane getDisplayPane() {
        return this.getMeasurementPlugin().getDataView();
    }

    public ParameterMeasurements getMeasurementPlugin() {
        return this.plugin;
    }

    public String getTitle() {
        return (String)this.titleProperty().get();
    }

    public CheckedValueField getValueField() {
        return this.valueField;
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicators() {
        return this.valueIndicatorSelector.getValueIndicators();
    }

    public ObservableList<AbstractSingleValueIndicator> getValueIndicatorsUser() {
        return this.valueIndicatorSelector.getValueIndicatorsUser();
    }

    public abstract void initialize();

    public void setDataSet(DataSet value) {
        this.dataSetProperty().set((Object)value);
    }

    public void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public Optional<ButtonType> showConfigDialogue() {
        Optional result;
        if (this.alert.isShowing()) {
            return Optional.empty();
        }
        if (this.getMeasurementPlugin() != null && this.getMeasurementPlugin().getChart() != null && this.getMeasurementPlugin().getChart().getScene() != null) {
            Stage stage = (Stage)this.getMeasurementPlugin().getChart().getScene().getWindow();
            this.alert.setX(stage.getX() + stage.getWidth() / 5.0);
            this.alert.setY(stage.getY() + stage.getHeight() / 5.0);
        }
        if (!(result = this.alert.showAndWait()).isPresent() || ((ButtonType)result.get()).getButtonData() == null) {
            this.defaultAction(result);
            this.alert.close();
            return Optional.empty();
        }
        if (((ButtonType)result.get()).equals(this.buttonOK)) {
            this.nominalAction();
        } else if (((ButtonType)result.get()).equals(this.buttonRemove)) {
            this.removeAction();
        } else {
            this.defaultAction(result);
        }
        this.alert.close();
        return result;
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    public DoubleProperty valueProperty() {
        return this.valueField.valueProperty();
    }

    protected void addMinMaxRangeFields() {
        Label minRangeTitleLabel = new Label("Min. Range: ");
        GridPane.setConstraints((Node)minRangeTitleLabel, (int)0, (int)this.lastLayoutRow);
        GridPane.setConstraints((Node)this.getValueField().getMinRangeTextField(), (int)1, (int)this.lastLayoutRow);
        Label minValueLabel = new Label(" " + this.getValueField().getMinRange());
        this.getValueField().minRangeProperty().addListener((ch, o, n) -> minValueLabel.setText(" " + n.toString()));
        GridPane.setConstraints((Node)minValueLabel, (int)2, (int)this.lastLayoutRow);
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{minRangeTitleLabel, this.getValueField().getMinRangeTextField(), minValueLabel});
        ++this.lastLayoutRow;
        Label maxRangeTitleLabel = new Label("Max. Range: ");
        GridPane.setConstraints((Node)maxRangeTitleLabel, (int)0, (int)this.lastLayoutRow);
        GridPane.setConstraints((Node)this.getValueField().getMaxRangeTextField(), (int)1, (int)this.lastLayoutRow);
        Label maxValueLabel = new Label(" " + this.getValueField().getMaxRange());
        this.getValueField().maxRangeProperty().addListener((ch, o, n) -> maxValueLabel.setText(" " + n.toString()));
        GridPane.setConstraints((Node)maxValueLabel, (int)2, (int)this.lastLayoutRow);
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{maxRangeTitleLabel, this.getValueField().getMaxRangeTextField(), maxValueLabel});
    }

    protected void defaultAction(Optional<ButtonType> result) {
        this.setDataSet(null);
        this.getValueField().resetRanges();
        this.updateSlider();
    }

    protected GridPane getDialogContentBox() {
        return this.gridPane;
    }

    protected void nominalAction() {
        this.valueField.evaluateMinRangeText(true);
        this.valueField.evaluateMaxRangeText(true);
        this.setDataSet(this.dataSetSelector.getSelectedDataSet());
        this.updateSlider();
    }

    protected void removeAction() {
        this.getMeasurementPlugin().getChartMeasurements().remove((Object)this);
        this.getMeasurementPlugin().getDataView().getChildren().remove((Object)this.dataViewWindow);
        this.getMeasurementPlugin().getDataView().getVisibleChildren().remove((Object)this.dataViewWindow);
        this.getMeasurementPlugin().getDataView().getUndockedChildren().remove((Object)this.dataViewWindow);
        this.getValueIndicatorsUser().removeListener(this.valueIndicatorsUserChangeListener);
        this.removeSliderChangeListener();
        this.cleanUpSuperfluousIndicators();
    }

    protected void removeSliderChangeListener() {
        Chart chart = this.getMeasurementPlugin().getChart();
        if (chart == null) {
            return;
        }
        List<AbstractSingleValueIndicator> allIndicators = chart.getPlugins().stream().filter(p -> p instanceof AbstractSingleValueIndicator).map(p -> (AbstractSingleValueIndicator)p).collect(Collectors.toList());
        allIndicators.forEach(indicator -> {
            indicator.removeListener(this.sliderChanged);
            this.getValueIndicatorsUser().remove(indicator);
        });
    }

    protected void cleanUpSuperfluousIndicators() {
        Chart chart = this.getMeasurementPlugin().getChart();
        if (chart == null) {
            return;
        }
        List allIndicators = chart.getPlugins().stream().filter(p -> p instanceof AbstractSingleValueIndicator).map(p -> (AbstractSingleValueIndicator)p).collect(Collectors.toList());
        allIndicators.stream().filter(indicator -> indicator.isAutoRemove() && indicator.updateEventListener().isEmpty()).forEach(indicator -> this.getMeasurementPlugin().getChart().getPlugins().remove(indicator));
    }

    protected void updateSlider() {
        if (!this.valueIndicatorSelector.isReuseIndicators()) {
            this.getValueIndicatorsUser().clear();
        }
        for (int i = 0; i < this.requiredNumberOfIndicators; ++i) {
            this.updateSlider(i);
        }
        this.cleanUpSuperfluousIndicators();
    }

    protected AbstractSingleValueIndicator updateSlider(int requestedIndex) {
        AbstractSingleValueIndicator sliderIndicator;
        ObservableList<AbstractSingleValueIndicator> selectedIndicators = this.getValueIndicatorsUser();
        boolean reuse = this.valueIndicatorSelector.isReuseIndicators();
        int nSelected = selectedIndicators.size();
        AbstractSingleValueIndicator abstractSingleValueIndicator = sliderIndicator = reuse && nSelected >= requestedIndex + 1 ? (AbstractSingleValueIndicator)selectedIndicators.get(requestedIndex) : null;
        if (sliderIndicator == null) {
            Chart chart = this.getMeasurementPlugin().getChart();
            Axis axis = AbstractChartMeasurement.getFirstAxisForDataSet(chart, this.getDataSet(), this.axisMode == AxisMode.X);
            double lower = axis.getMin();
            double upper = axis.getMax();
            double middle = 0.5 * Math.abs(upper - lower);
            double min = Math.min(lower, upper);
            sliderIndicator = this.axisMode == AxisMode.X ? new XValueIndicator(axis, min) : new YValueIndicator(axis, min);
            sliderIndicator.setText(this.measurementName + '#' + requestedIndex);
            sliderIndicator.setValue(min + ((double)requestedIndex + 0.5) * middle);
            sliderIndicator.setAutoRemove(true);
            this.getValueIndicatorsUser().add((Object)sliderIndicator);
            this.getMeasurementPlugin().getChart().getPlugins().add((Object)sliderIndicator);
        }
        if (!sliderIndicator.updateEventListener().contains(this.sliderChanged)) {
            sliderIndicator.addListener(this.sliderChanged);
        }
        return sliderIndicator;
    }

    protected static Axis getFirstAxisForDataSet(Chart chart, DataSet dataSet, boolean isHorizontal) {
        if (dataSet == null) {
            return chart.getFirstAxis(isHorizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }
        for (Renderer renderer : chart.getRenderers()) {
            if (!renderer.getDatasets().contains((Object)dataSet)) continue;
            for (Axis axis : renderer.getAxes()) {
                if ((!axis.getSide().isHorizontal() || !isHorizontal) && (!axis.getSide().isVertical() || isHorizontal)) continue;
                return axis;
            }
        }
        return chart.getFirstAxis(isHorizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
    }

    protected static int shiftGridPaneRowOffset(List<Node> nodes, int minRowOffset) {
        int maxRowIndex = 0;
        for (Node node : nodes) {
            Integer rowIndex = GridPane.getRowIndex((Node)node);
            if (rowIndex == null) {
                LOGGER.atWarn().addArgument((Object)node).addArgument((Object)minRowOffset).log("node {} has not a GridPane::rowIndex being set -> set to {}");
                GridPane.setRowIndex((Node)node, (Integer)minRowOffset);
                continue;
            }
            maxRowIndex = Math.max(maxRowIndex, rowIndex);
            GridPane.setRowIndex((Node)node, (Integer)(rowIndex + minRowOffset));
        }
        return minRowOffset + maxRowIndex + 1;
    }
}

