/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.MouseEventsHelper;
import de.gsi.chart.ui.ObservableDeque;
import de.gsi.chart.ui.geometry.Side;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zoomer
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Zoomer.class);
    private static final String FONT_AWESOME = "FontAwesome";
    public static final String ZOOMER_OMIT_AXIS = "OmitAxisZoom";
    public static final String STYLE_CLASS_ZOOM_RECT = "chart-zoom-rect";
    private static final int ZOOM_RECT_MIN_SIZE = 5;
    private static final Duration DEFAULT_ZOOM_DURATION = Duration.millis((double)500.0);
    private static final int DEFAULT_AUTO_ZOOM_THRESHOLD = 15;
    private static final int DEFAULT_FLICKER_THRESHOLD = 3;
    private static final int FONT_SIZE = 20;
    public static final Predicate<MouseEvent> DEFAULT_MOUSE_FILTER = MouseEventsHelper::isOnlyMiddleButtonDown;
    private double panShiftX;
    private double panShiftY;
    private Point2D previousMouseLocation;
    private final BooleanProperty enablePanner = new SimpleBooleanProperty((Object)this, "enablePanner", true);
    private final BooleanProperty autoZoomEnable = new SimpleBooleanProperty((Object)this, "enableAutoZoom", false);
    private final IntegerProperty autoZoomThreshold = new SimpleIntegerProperty((Object)this, "autoZoomThreshold", 15);
    private final EventHandler<MouseEvent> panStartHandler = event -> {
        if (this.isPannerEnabled() && DEFAULT_MOUSE_FILTER.test((MouseEvent)event)) {
            this.panStarted((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> panDragHandler = event -> {
        if (this.panOngoing()) {
            this.panDragged((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> panEndHandler = event -> {
        if (this.panOngoing()) {
            this.panEnded();
            event.consume();
        }
    };
    public final Predicate<MouseEvent> defaultZoomInMouseFilter = event -> MouseEventsHelper.isOnlyPrimaryButtonDown(event) && MouseEventsHelper.modifierKeysUp(event) && this.isMouseEventWithinCanvas((MouseEvent)event);
    public final Predicate<MouseEvent> defaultZoomOutMouseFilter = event -> MouseEventsHelper.isOnlySecondaryButtonDown(event) && MouseEventsHelper.modifierKeysUp(event) && this.isMouseEventWithinCanvas((MouseEvent)event);
    public final Predicate<MouseEvent> defaultZoomOriginFilter = event -> MouseEventsHelper.isOnlySecondaryButtonDown(event) && MouseEventsHelper.isOnlyCtrlModifierDown(event) && this.isMouseEventWithinCanvas((MouseEvent)event);
    public final Predicate<ScrollEvent> defaultScrollFilter = this::isMouseEventWithinCanvas;
    private Predicate<MouseEvent> zoomInMouseFilter = this.defaultZoomInMouseFilter;
    private Predicate<MouseEvent> zoomOutMouseFilter = this.defaultZoomOutMouseFilter;
    private Predicate<MouseEvent> zoomOriginMouseFilter = this.defaultZoomOriginFilter;
    private Predicate<ScrollEvent> zoomScrollFilter = this.defaultScrollFilter;
    private final Rectangle zoomRectangle = new Rectangle();
    private Point2D zoomStartPoint;
    private Point2D zoomEndPoint;
    private final ObservableDeque<Map<Axis, ZoomState>> zoomStacks = new ObservableDeque(new ArrayDeque());
    private final HBox zoomButtons = this.getZoomInteractorBar();
    private ZoomRangeSlider xRangeSlider;
    private boolean xRangeSliderInit;
    private final ObservableList<Axis> omitAxisZoom = FXCollections.observableArrayList();
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };
    private Cursor originalCursor;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    private final ObjectProperty<Cursor> zoomCursor = new SimpleObjectProperty((Object)this, "zoomCursor");
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    private final ObjectProperty<Duration> zoomDuration = new SimpleObjectProperty<Duration>((Object)this, "zoomDuration", DEFAULT_ZOOM_DURATION){

        protected void invalidated() {
            Objects.requireNonNull((Duration)this.get(), "The " + this.getName() + " must not be null");
        }
    };
    private final BooleanProperty updateTickUnit = new SimpleBooleanProperty((Object)this, "updateTickUnit", true);
    private final BooleanProperty sliderVisible = new SimpleBooleanProperty((Object)this, "sliderVisible", true);
    private final EventHandler<MouseEvent> zoomInStartHandler = event -> {
        if (this.getZoomInMouseFilter() == null || this.getZoomInMouseFilter().test((MouseEvent)event)) {
            this.zoomInStarted((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomInDragHandler = event -> {
        if (this.zoomOngoing()) {
            this.zoomInDragged((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomInEndHandler = event -> {
        if (this.zoomOngoing()) {
            this.zoomInEnded();
            event.consume();
        }
    };
    private final EventHandler<ScrollEvent> zoomScrollHandler = event -> {
        if (this.getZoomScrollFilter() == null || this.getZoomScrollFilter().test((ScrollEvent)event)) {
            AxisMode mode = this.getAxisMode();
            if (this.zoomStacks.isEmpty()) {
                this.makeSnapshotOfView();
            }
            for (Axis axis : this.getChart().getAxes()) {
                if (axis.getSide() == null || !(axis.getSide().isHorizontal() ? mode.allowsX() : mode.allowsY()) || this.isOmitZoomInternal(axis)) continue;
                Zoomer.zoomOnAxis(axis, event);
            }
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomOutHandler = event -> {
        boolean zoomOutPerformed;
        if ((this.getZoomOutMouseFilter() == null || this.getZoomOutMouseFilter().test((MouseEvent)event)) && (zoomOutPerformed = this.zoomOut())) {
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomOriginHandler = event -> {
        boolean zoomOutPerformed;
        if ((this.getZoomOriginMouseFilter() == null || this.getZoomOriginMouseFilter().test((MouseEvent)event)) && (zoomOutPerformed = this.zoomOrigin())) {
            event.consume();
        }
    };

    public Zoomer() {
        this(AxisMode.XY);
    }

    public Zoomer(AxisMode zoomMode) {
        this(zoomMode, false);
    }

    public Zoomer(AxisMode zoomMode, boolean animated) {
        this.setAxisMode(zoomMode);
        this.setAnimated(animated);
        this.setZoomCursor(Cursor.CROSSHAIR);
        this.setDragCursor(Cursor.CLOSED_HAND);
        this.zoomRectangle.setManaged(false);
        this.zoomRectangle.getStyleClass().add((Object)STYLE_CLASS_ZOOM_RECT);
        this.getChartChildren().add((Object)this.zoomRectangle);
        this.registerMouseHandlers();
        this.chartProperty().addListener((change, o, n) -> {
            if (o != null) {
                o.getToolBar().getChildren().remove((Object)this.zoomButtons);
                o.getPlotArea().setBottom(null);
                this.xRangeSlider.prefWidthProperty().unbind();
            }
            if (n != null) {
                if (this.isAddButtonsToToolBar()) {
                    n.getToolBar().getChildren().add((Object)this.zoomButtons);
                }
                ZoomRangeSlider slider = new ZoomRangeSlider((Chart)((Object)n));
                if (this.isSliderVisible()) {
                    n.getPlotArea().setBottom((Node)slider);
                    this.xRangeSlider.prefWidthProperty().bind((ObservableValue)n.getCanvasForeground().widthProperty());
                }
            }
        });
    }

    public Zoomer(boolean animated) {
        this(AxisMode.XY, animated);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final BooleanProperty autoZoomEnabledProperty() {
        return this.autoZoomEnable;
    }

    public IntegerProperty autoZoomThresholdProperty() {
        return this.autoZoomThreshold;
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public void clear() {
        this.zoomStacks.clear();
    }

    public void clear(Axis axis) {
        for (Map map : this.zoomStacks) {
            map.remove(axis);
        }
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public int getAutoZoomThreshold() {
        return this.autoZoomThresholdProperty().get();
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    public RangeSlider getRangeSlider() {
        return this.xRangeSlider;
    }

    public final Cursor getZoomCursor() {
        return (Cursor)this.zoomCursorProperty().get();
    }

    public final Duration getZoomDuration() {
        return (Duration)this.zoomDurationProperty().get();
    }

    public Predicate<MouseEvent> getZoomInMouseFilter() {
        return this.zoomInMouseFilter;
    }

    public HBox getZoomInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox buttonBar = new HBox();
        buttonBar.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button zoomOut = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf0b2").size(20.0));
        zoomOut.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomOut.setTooltip(new Tooltip("zooms to origin and enables auto-ranging"));
        Button zoomModeXY = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf047").size(20.0));
        zoomModeXY.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomModeXY.setTooltip(new Tooltip("set zoom-mode to X & Y range (N.B. disables auto-ranging)"));
        Button zoomModeX = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf07e").size(20.0));
        zoomModeX.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomModeX.setTooltip(new Tooltip("set zoom-mode to X range (N.B. disables auto-ranging)"));
        Button zoomModeY = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf07d").size(20.0));
        zoomModeY.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomModeY.setTooltip(new Tooltip("set zoom-mode to Y range (N.B. disables auto-ranging)"));
        zoomOut.setOnAction(evt -> {
            this.zoomOrigin();
            for (Axis axis : this.getChart().getAxes()) {
                axis.setAutoRanging(true);
            }
        });
        zoomModeXY.setOnAction(evt -> this.setAxisMode(AxisMode.XY));
        zoomModeX.setOnAction(evt -> this.setAxisMode(AxisMode.X));
        zoomModeY.setOnAction(evt -> this.setAxisMode(AxisMode.Y));
        buttonBar.getChildren().addAll((Object[])new Node[]{separator, zoomOut, zoomModeXY, zoomModeX, zoomModeY});
        return buttonBar;
    }

    public Predicate<MouseEvent> getZoomOriginMouseFilter() {
        return this.zoomOriginMouseFilter;
    }

    public Predicate<MouseEvent> getZoomOutMouseFilter() {
        return this.zoomOutMouseFilter;
    }

    public Predicate<ScrollEvent> getZoomScrollFilter() {
        return this.zoomScrollFilter;
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final boolean isAutoZoomEnabled() {
        return this.autoZoomEnabledProperty().get();
    }

    public final boolean isPannerEnabled() {
        return this.pannerEnabledProperty().get();
    }

    public final boolean isSliderVisible() {
        return this.sliderVisibleProperty().get();
    }

    public final boolean isUpdateTickUnit() {
        return this.updateTickUnitProperty().get();
    }

    public final ObservableList<Axis> omitAxisZoomList() {
        return this.omitAxisZoom;
    }

    public final BooleanProperty pannerEnabledProperty() {
        return this.enablePanner;
    }

    public final void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public final void setAutoZoomEnabled(boolean state) {
        this.autoZoomEnabledProperty().set(state);
    }

    public void setAutoZoomThreshold(int value) {
        this.autoZoomThresholdProperty().set(value);
    }

    public final void setAxisMode(AxisMode mode) {
        this.axisModeProperty().set((Object)mode);
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final void setPannerEnabled(boolean state) {
        this.pannerEnabledProperty().set(state);
    }

    public final void setSliderVisible(boolean state) {
        this.sliderVisibleProperty().set(state);
    }

    public final void setUpdateTickUnit(boolean value) {
        this.updateTickUnitProperty().set(value);
    }

    public final void setZoomCursor(Cursor cursor) {
        this.zoomCursorProperty().set((Object)cursor);
    }

    public final void setZoomDuration(Duration duration) {
        this.zoomDurationProperty().set((Object)duration);
    }

    public void setZoomInMouseFilter(Predicate<MouseEvent> zoomInMouseFilter) {
        this.zoomInMouseFilter = zoomInMouseFilter;
    }

    public void setZoomOriginMouseFilter(Predicate<MouseEvent> zoomOriginMouseFilter) {
        this.zoomOriginMouseFilter = zoomOriginMouseFilter;
    }

    public void setZoomOutMouseFilter(Predicate<MouseEvent> zoomOutMouseFilter) {
        this.zoomOutMouseFilter = zoomOutMouseFilter;
    }

    public void setZoomScrollFilter(Predicate<ScrollEvent> zoomScrollFilter) {
        this.zoomScrollFilter = zoomScrollFilter;
    }

    public final BooleanProperty sliderVisibleProperty() {
        return this.sliderVisible;
    }

    public final BooleanProperty updateTickUnitProperty() {
        return this.updateTickUnit;
    }

    public final ObjectProperty<Cursor> zoomCursorProperty() {
        return this.zoomCursor;
    }

    public final ObjectProperty<Duration> zoomDurationProperty() {
        return this.zoomDuration;
    }

    public boolean zoomOrigin() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        Map<Axis, ZoomState> zoomWindows = this.zoomStacks.peekLast();
        if (zoomWindows == null || zoomWindows.isEmpty()) {
            return false;
        }
        this.clear();
        this.performZoom(zoomWindows, false);
        if (this.xRangeSlider != null) {
            this.xRangeSlider.reset();
        }
        for (Axis axis : this.getChart().getAxes()) {
            axis.forceRedraw();
        }
        return true;
    }

    public ObservableDeque<Map<Axis, ZoomState>> zoomStackDeque() {
        return this.zoomStacks;
    }

    private void clearZoomStackIfAxisAutoRangingIsEnabled() {
        Chart chart = this.getChart();
        if (chart == null) {
            return;
        }
        for (Axis axis : this.getChart().getAxes()) {
            if (axis.getSide().isHorizontal()) {
                if (!this.getAxisMode().allowsX() || !axis.isAutoRanging() && !axis.isAutoGrowRanging()) continue;
                this.clear(axis);
                continue;
            }
            if (!this.getAxisMode().allowsY() || !axis.isAutoRanging() && !axis.isAutoGrowRanging()) continue;
            this.clear(axis);
        }
    }

    private Map<Axis, ZoomState> getZoomDataWindows() {
        ConcurrentHashMap<Axis, ZoomState> axisStateMap = new ConcurrentHashMap<Axis, ZoomState>();
        if (this.getChart() == null) {
            return axisStateMap;
        }
        double minX = this.zoomRectangle.getX();
        double minY = this.zoomRectangle.getY() + this.zoomRectangle.getHeight();
        double maxX = this.zoomRectangle.getX() + this.zoomRectangle.getWidth();
        double maxY = this.zoomRectangle.getY();
        Point2D minPlotCoordinate = this.getChart().toPlotArea(minX, minY);
        Point2D maxPlotCoordinate = this.getChart().toPlotArea(maxX, maxY);
        block4: for (Axis axis : this.getChart().getAxes()) {
            double dataMax;
            double dataMin;
            if (axis.getSide().isVertical()) {
                dataMin = axis.getValueForDisplay(minPlotCoordinate.getY());
                dataMax = axis.getValueForDisplay(maxPlotCoordinate.getY());
            } else {
                dataMin = axis.getValueForDisplay(minPlotCoordinate.getX());
                dataMax = axis.getValueForDisplay(maxPlotCoordinate.getX());
            }
            switch (this.getAxisMode()) {
                case X: {
                    if (!axis.getSide().isHorizontal()) continue block4;
                    axisStateMap.put(axis, new ZoomState(dataMin, dataMax, axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
                case Y: {
                    if (!axis.getSide().isVertical()) continue block4;
                    axisStateMap.put(axis, new ZoomState(dataMin, dataMax, axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
            }
            axisStateMap.put(axis, new ZoomState(dataMin, dataMax, axis.isAutoRanging(), axis.isAutoGrowRanging()));
        }
        return axisStateMap;
    }

    private void installDragCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getDragCursor());
        }
    }

    private void installZoomCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getZoomCursor());
        }
    }

    private boolean isMouseEventWithinCanvas(MouseEvent mouseEvent) {
        Canvas canvas = this.getChart().getCanvas();
        Point2D mouseLoc = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        Bounds screenBounds = canvas.localToScreen(canvas.getBoundsInLocal());
        return screenBounds.contains(mouseLoc);
    }

    private boolean isMouseEventWithinCanvas(ScrollEvent mouseEvent) {
        Canvas canvas = this.getChart().getCanvas();
        Point2D mouseLoc = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        Bounds screenBounds = canvas.localToScreen(canvas.getBoundsInLocal());
        return screenBounds.contains(mouseLoc);
    }

    private boolean isOmitZoomInternal(Axis axis) {
        boolean propertyState = Zoomer.isOmitZoom(axis);
        return propertyState || this.omitAxisZoomList().contains((Object)axis);
    }

    private void makeSnapshotOfView() {
        Bounds bounds = this.getChart().getBoundsInLocal();
        double minX = bounds.getMinX();
        double minY = bounds.getMinY();
        double maxX = bounds.getMaxX();
        double maxY = bounds.getMaxY();
        this.zoomRectangle.setX(bounds.getMinX());
        this.zoomRectangle.setY(bounds.getMinY());
        this.zoomRectangle.setWidth(maxX - minX);
        this.zoomRectangle.setHeight(maxY - minY);
        this.pushCurrentZoomWindows();
        this.performZoom(this.getZoomDataWindows(), true);
        this.zoomRectangle.setVisible(false);
    }

    private void panChart(Chart chart, Point2D mouseLocation) {
        if (!(chart instanceof XYChart)) {
            return;
        }
        double oldMouseX = this.previousMouseLocation.getX();
        double oldMouseY = this.previousMouseLocation.getY();
        double newMouseX = mouseLocation.getX();
        double newMouseY = mouseLocation.getY();
        this.panShiftX += oldMouseX - newMouseX;
        this.panShiftY += oldMouseY - newMouseY;
        for (Axis axis : chart.getAxes()) {
            boolean allowsShift;
            if (axis.getSide() == null || this.isOmitZoomInternal(axis)) continue;
            Side side = axis.getSide();
            double prevData = axis.getValueForDisplay(side.isHorizontal() ? oldMouseX : oldMouseY);
            double newData = axis.getValueForDisplay(side.isHorizontal() ? newMouseX : newMouseY);
            double offset = prevData - newData;
            boolean bl = allowsShift = side.isHorizontal() ? this.getAxisMode().allowsX() : this.getAxisMode().allowsY();
            if (Zoomer.hasBoundedRange(axis) || !allowsShift) continue;
            axis.setAutoRanging(false);
            axis.set(axis.getMin() + offset, axis.getMax() + offset);
        }
        this.previousMouseLocation = mouseLocation;
    }

    private void panDragged(MouseEvent event) {
        Point2D mouseLocation = this.getLocationInPlotArea(event);
        this.panChart(this.getChart(), mouseLocation);
        this.previousMouseLocation = mouseLocation;
    }

    private void panEnded() {
        Chart chart = this.getChart();
        if (chart == null || this.panShiftX == 0.0 || this.panShiftY == 0.0 || this.previousMouseLocation == null) {
            return;
        }
        for (Axis axis : chart.getAxes()) {
            boolean allowsShift;
            if (axis.getSide() == null || this.isOmitZoomInternal(axis)) continue;
            Side side = axis.getSide();
            boolean bl = allowsShift = side.isHorizontal() ? this.getAxisMode().allowsX() : this.getAxisMode().allowsY();
            if (Zoomer.hasBoundedRange(axis) || !allowsShift) continue;
            axis.setAutoRanging(false);
        }
        this.panShiftX = 0.0;
        this.panShiftY = 0.0;
        this.previousMouseLocation = null;
        this.uninstallCursor();
    }

    protected static boolean hasBoundedRange(Axis axis) {
        return axis.minProperty().isBound() || axis.maxProperty().isBound();
    }

    private boolean panOngoing() {
        return this.previousMouseLocation != null;
    }

    private void panStarted(MouseEvent event) {
        this.previousMouseLocation = this.getLocationInPlotArea(event);
        this.panShiftX = 0.0;
        this.panShiftY = 0.0;
        this.installDragCursor();
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        this.pushCurrentZoomWindows();
    }

    private void performZoom(Map.Entry<Axis, ZoomState> zoomStateEntry, boolean isZoomIn) {
        ZoomState zoomState = zoomStateEntry.getValue();
        if (zoomState.zoomRangeMax - zoomState.zoomRangeMin == 0.0) {
            LOGGER.atDebug().log("Cannot zoom in deeper than numerical precision");
            return;
        }
        Axis axis = zoomStateEntry.getKey();
        if (isZoomIn && (axis.getSide().isHorizontal() && this.getAxisMode().allowsX() || axis.getSide().isVertical() && this.getAxisMode().allowsY())) {
            axis.setAutoRanging(false);
        }
        if (this.isAnimated()) {
            if (!Zoomer.hasBoundedRange(axis)) {
                Timeline xZoomAnimation = new Timeline();
                xZoomAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)axis.minProperty(), (Object)axis.getMin()), new KeyValue((WritableValue)axis.maxProperty(), (Object)axis.getMax())}), new KeyFrame(this.getZoomDuration(), new KeyValue[]{new KeyValue((WritableValue)axis.minProperty(), (Object)zoomState.zoomRangeMin), new KeyValue((WritableValue)axis.maxProperty(), (Object)zoomState.zoomRangeMax)})});
                xZoomAnimation.play();
            }
        } else if (!Zoomer.hasBoundedRange(axis)) {
            axis.set(zoomState.zoomRangeMin, zoomState.zoomRangeMax);
        }
        if (!isZoomIn) {
            axis.setAutoRanging(zoomState.wasAutoRanging);
            axis.setAutoGrowRanging(zoomState.wasAutoGrowRanging);
        }
    }

    private void performZoom(Map<Axis, ZoomState> zoomWindows, boolean isZoomIn) {
        for (Map.Entry<Axis, ZoomState> entry : zoomWindows.entrySet()) {
            if (this.isOmitZoomInternal(entry.getKey())) continue;
            this.performZoom(entry, isZoomIn);
        }
        for (Axis a : this.getChart().getAxes()) {
            a.forceRedraw();
        }
    }

    private void performZoomIn() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        this.pushCurrentZoomWindows();
        this.performZoom(this.getZoomDataWindows(), true);
    }

    private void pushCurrentZoomWindows() {
        if (this.getChart() == null) {
            return;
        }
        ConcurrentHashMap<Axis, ZoomState> axisStateMap = new ConcurrentHashMap<Axis, ZoomState>();
        block4: for (Axis axis : this.getChart().getAxes()) {
            switch (this.getAxisMode()) {
                case X: {
                    if (!axis.getSide().isHorizontal()) continue block4;
                    axisStateMap.put(axis, new ZoomState(axis.getMin(), axis.getMax(), axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
                case Y: {
                    if (!axis.getSide().isVertical()) continue block4;
                    axisStateMap.put(axis, new ZoomState(axis.getMin(), axis.getMax(), axis.isAutoRanging(), axis.isAutoGrowRanging()));
                    continue block4;
                }
            }
            axisStateMap.put(axis, new ZoomState(axis.getMin(), axis.getMax(), axis.isAutoRanging(), axis.isAutoGrowRanging()));
        }
        if (!((ConcurrentHashMap.CollectionView)((Object)axisStateMap.keySet())).isEmpty()) {
            this.zoomStacks.addFirst(axisStateMap);
        }
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_PRESSED, this.zoomInStartHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_DRAGGED, this.zoomInDragHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_RELEASED, this.zoomInEndHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_CLICKED, this.zoomOutHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_CLICKED, this.zoomOriginHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)ScrollEvent.SCROLL, this.zoomScrollHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_PRESSED, this.panStartHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_DRAGGED, this.panDragHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_RELEASED, this.panEndHandler);
    }

    private void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }

    private void zoomInDragged(MouseEvent event) {
        Bounds plotAreaBounds = this.getChart().getPlotArea().getBoundsInLocal();
        this.zoomEndPoint = Zoomer.limitToPlotArea(event, plotAreaBounds);
        double zoomRectX = plotAreaBounds.getMinX();
        double zoomRectY = plotAreaBounds.getMinY();
        double zoomRectWidth = plotAreaBounds.getWidth();
        double zoomRectHeight = plotAreaBounds.getHeight();
        if (this.isAutoZoomEnabled()) {
            boolean isZoomY;
            double diffX = this.zoomEndPoint.getX() - this.zoomStartPoint.getX();
            double diffY = this.zoomEndPoint.getY() - this.zoomStartPoint.getY();
            int limit = Math.abs(this.getAutoZoomThreshold());
            boolean isZoomX = Math.abs(diffY) <= (double)limit && Math.abs(diffX) >= (double)limit && Math.abs(diffX / diffY) > 3.0;
            boolean bl = isZoomY = Math.abs(diffX) <= (double)limit && Math.abs(diffY) >= (double)limit && Math.abs(diffY / diffX) > 3.0;
            if (isZoomX) {
                this.setAxisMode(AxisMode.X);
            } else if (isZoomY) {
                this.setAxisMode(AxisMode.Y);
            } else {
                this.setAxisMode(AxisMode.XY);
            }
        }
        if (this.getAxisMode().allowsX()) {
            zoomRectX = Math.min(this.zoomStartPoint.getX(), this.zoomEndPoint.getX());
            zoomRectWidth = Math.abs(this.zoomEndPoint.getX() - this.zoomStartPoint.getX());
        }
        if (this.getAxisMode().allowsY()) {
            zoomRectY = Math.min(this.zoomStartPoint.getY(), this.zoomEndPoint.getY());
            zoomRectHeight = Math.abs(this.zoomEndPoint.getY() - this.zoomStartPoint.getY());
        }
        this.zoomRectangle.setX(zoomRectX);
        this.zoomRectangle.setY(zoomRectY);
        this.zoomRectangle.setWidth(zoomRectWidth);
        this.zoomRectangle.setHeight(zoomRectHeight);
    }

    private void zoomInEnded() {
        this.zoomRectangle.setVisible(false);
        if (this.zoomRectangle.getWidth() > 5.0 && this.zoomRectangle.getHeight() > 5.0) {
            this.performZoomIn();
        }
        this.zoomEndPoint = null;
        this.zoomStartPoint = null;
        this.uninstallCursor();
    }

    private void zoomInStarted(MouseEvent event) {
        this.zoomStartPoint = new Point2D(event.getX(), event.getY());
        this.zoomRectangle.setX(this.zoomStartPoint.getX());
        this.zoomRectangle.setY(this.zoomStartPoint.getY());
        this.zoomRectangle.setWidth(0.0);
        this.zoomRectangle.setHeight(0.0);
        this.zoomRectangle.setVisible(true);
        this.installZoomCursor();
    }

    private boolean zoomOngoing() {
        return this.zoomStartPoint != null;
    }

    private boolean zoomOut() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        Map<Axis, ZoomState> zoomWindows = this.zoomStacks.pollFirst();
        if (zoomWindows == null || zoomWindows.isEmpty()) {
            return this.zoomOrigin();
        }
        this.performZoom(zoomWindows, false);
        return true;
    }

    public static boolean isOmitZoom(Axis axis) {
        return axis instanceof Node && ((Node)axis).getProperties().get((Object)ZOOMER_OMIT_AXIS) == Boolean.TRUE;
    }

    public static void setOmitZoom(Axis axis, boolean state) {
        if (!(axis instanceof Node)) {
            return;
        }
        if (state) {
            ((Node)axis).getProperties().put((Object)ZOOMER_OMIT_AXIS, (Object)true);
        } else {
            ((Node)axis).getProperties().remove((Object)ZOOMER_OMIT_AXIS);
        }
    }

    private static Point2D limitToPlotArea(MouseEvent event, Bounds plotBounds) {
        double limitedX = Math.max(Math.min(event.getX() - plotBounds.getMinX(), plotBounds.getMaxX()), plotBounds.getMinX());
        double limitedY = Math.max(Math.min(event.getY() - plotBounds.getMinY(), plotBounds.getMaxY()), plotBounds.getMinY());
        return new Point2D(limitedX, limitedY);
    }

    private static void zoomOnAxis(Axis axis, ScrollEvent event) {
        if (Zoomer.hasBoundedRange(axis)) {
            return;
        }
        boolean isZoomIn = event.getDeltaY() > 0.0;
        boolean isHorizontal = axis.getSide().isHorizontal();
        double mousePos = isHorizontal ? event.getX() : event.getY();
        double posOnAxis = axis.getValueForDisplay(mousePos);
        double max = axis.getMax();
        double min = axis.getMin();
        double scaling = isZoomIn ? 0.9 : 1.1111111111111112;
        double diffHalf1 = scaling * Math.abs(posOnAxis - min);
        double diffHalf2 = scaling * Math.abs(max - posOnAxis);
        axis.set(posOnAxis - diffHalf1, posOnAxis + diffHalf2);
        axis.forceRedraw();
    }

    private class ZoomRangeSlider
    extends RangeSlider {
        private final BooleanProperty invertedSlide = new SimpleBooleanProperty((Object)this, "invertedSlide", false);
        private boolean isUpdating;
        private final ChangeListener<Boolean> sliderResetHandler = (ch, o, n) -> this.resetSlider((Boolean)n);
        private final ChangeListener<Number> rangeChangeListener = (ch, o, n) -> {
            if (this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            Axis xAxis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            xAxis.getMax();
            xAxis.getMin();
            double minBound = Math.min(xAxis.getMin(), this.getMin());
            double maxBound = Math.max(xAxis.getMax(), this.getMax());
            if (Zoomer.this.xRangeSliderInit) {
                this.setMin(minBound);
                this.setMax(maxBound);
            }
            this.isUpdating = false;
        };
        private final ChangeListener<Number> sliderValueChanged = (ch, o, n) -> {
            if (!Zoomer.this.isSliderVisible() || n == null || this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            Axis xAxis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            if (xAxis.isAutoRanging() || xAxis.isAutoGrowRanging()) {
                this.setMin(xAxis.getMin());
                this.setMax(xAxis.getMax());
                this.isUpdating = false;
                return;
            }
            this.isUpdating = false;
        };
        private final EventHandler<? super MouseEvent> mouseEventHandler = event -> {
            if (Zoomer.this.zoomStacks.isEmpty()) {
                Zoomer.this.makeSnapshotOfView();
            }
            Axis xAxis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            xAxis.setAutoRanging(false);
            xAxis.setAutoGrowRanging(false);
            xAxis.set(this.getLowValue(), this.getHighValue());
        };

        protected void resetSlider(Boolean n) {
            if (Zoomer.this.getChart() == null) {
                return;
            }
            Axis axis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            if (Boolean.TRUE.equals(n)) {
                this.setMin(axis.getMin());
                this.setMax(axis.getMax());
            }
        }

        public ZoomRangeSlider(Chart chart) {
            Axis xAxis = chart.getFirstAxis(Orientation.HORIZONTAL);
            Zoomer.this.xRangeSlider = this;
            this.setPrefWidth(-1.0);
            this.setMaxWidth(Double.MAX_VALUE);
            xAxis.invertAxisProperty().bindBidirectional((Property)this.invertedSlide);
            this.invertedSlide.addListener((ch, o, n) -> this.setRotate(Boolean.TRUE.equals(n) ? 180.0 : 0.0));
            xAxis.autoRangingProperty().addListener(this.sliderResetHandler);
            xAxis.autoGrowRangingProperty().addListener(this.sliderResetHandler);
            xAxis.minProperty().addListener(this.rangeChangeListener);
            xAxis.maxProperty().addListener(this.rangeChangeListener);
            this.lowValueProperty().addListener(this.sliderValueChanged);
            this.highValueProperty().addListener(this.sliderValueChanged);
            this.setOnMouseReleased(this.mouseEventHandler);
            this.lowValueProperty().bindBidirectional((Property)xAxis.minProperty());
            this.highValueProperty().bindBidirectional((Property)xAxis.maxProperty());
            Zoomer.this.sliderVisibleProperty().addListener((ch, o, n) -> {
                if (Zoomer.this.getChart() == null || n.equals(o) || this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                if (Boolean.TRUE.equals(n)) {
                    Zoomer.this.getChart().getPlotArea().setBottom((Node)Zoomer.this.xRangeSlider);
                    this.prefWidthProperty().bind((ObservableValue)Zoomer.this.getChart().getCanvasForeground().widthProperty());
                } else {
                    Zoomer.this.getChart().getPlotArea().setBottom(null);
                    this.prefWidthProperty().unbind();
                }
                this.isUpdating = false;
            });
            Zoomer.this.addButtonsToToolBarProperty().addListener((ch, o, n) -> {
                Chart chartLocal = Zoomer.this.getChart();
                if (chartLocal == null || n.equals(o)) {
                    return;
                }
                if (Boolean.TRUE.equals(n)) {
                    chartLocal.getToolBar().getChildren().add((Object)Zoomer.this.zoomButtons);
                } else {
                    chartLocal.getToolBar().getChildren().remove((Object)Zoomer.this.zoomButtons);
                }
            });
            Zoomer.this.xRangeSliderInit = true;
        }

        public void reset() {
            this.resetSlider(true);
        }
    }

    public class ZoomState {
        protected double zoomRangeMin;
        protected double zoomRangeMax;
        protected boolean wasAutoRanging;
        protected boolean wasAutoGrowRanging;

        private ZoomState(double zoomRangeMin, double zoomRangeMax, boolean isAutoRanging, boolean isAutoGrowRanging) {
            this.zoomRangeMin = zoomRangeMin;
            this.zoomRangeMax = zoomRangeMax;
            this.wasAutoRanging = isAutoRanging;
            this.wasAutoGrowRanging = isAutoGrowRanging;
        }

        public double getZoomRangeMax() {
            return this.zoomRangeMax;
        }

        public double getZoomRangeMin() {
            return this.zoomRangeMin;
        }

        public String toString() {
            return "ZoomState[zoomRangeMin= " + this.zoomRangeMin + ", zoomRangeMax= " + this.zoomRangeMax + ", wasAutoRanging= " + this.wasAutoRanging + ", wasAutoGrowRanging= " + this.wasAutoGrowRanging + "]";
        }

        public boolean wasAutoGrowRanging() {
            return this.wasAutoGrowRanging;
        }

        public boolean wasAutoRanging() {
            return this.wasAutoRanging;
        }
    }
}

