/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractRangeValueIndicator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class YRangeIndicator
extends AbstractRangeValueIndicator {
    public YRangeIndicator(Axis axis, double lowerBound, double upperBound) {
        this(axis, lowerBound, upperBound, null);
    }

    public YRangeIndicator(Axis axis, double lowerBound, double upperBound, String text) {
        super(axis, lowerBound, upperBound, text);
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        Axis yAxis = this.getNumericAxis();
        double value1 = yAxis.getDisplayPosition(this.getLowerBound());
        double value2 = yAxis.getDisplayPosition(this.getUpperBound());
        double startY = Math.max(minY, minY + Math.min(value1, value2));
        double endY = Math.min(maxY, minY + Math.max(value1, value2));
        this.layout((Bounds)new BoundingBox(minX, startY, maxX - minX, endY - startY));
    }

    @Override
    public void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "y-", "range-indicator-label");
        this.setStyleClasses((Node)this.rectangle, "y-", "range-indicator-rect");
    }
}

