/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.EventListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableViewer
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableViewer.class);
    protected static final String FONT_AWESOME = "FontAwesome";
    private static final int MAX_DATASETS_IN_TABLE = 100;
    protected static final int FONT_SIZE = 20;
    protected static final int MIN_REFRESH_RATE_WARN = 20;
    private final Glyph tableView = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.TABLE).size(20.0);
    private final Glyph graphView = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.LINE_CHART).size(20.0);
    private final Glyph saveIcon = new Glyph("FontAwesome", (Object)"\uf0c7").size(20.0);
    private final Glyph clipBoardIcon = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.CLIPBOARD).size(20.0);
    private final HBox interactorButtons = this.getInteractorBar();
    private final TableView<DataSetsRow> table = new TableView();
    private final DataSetsModel dsModel = new DataSetsModel();
    protected boolean editable;
    private Timer timer = new Timer("TableViewer-update-task", true);
    private final IntegerProperty refreshRate = new SimpleIntegerProperty(this, "refreshRate", 1000){

        public void set(int newValue) {
            if (newValue < 0) {
                throw new IllegalArgumentException("refresh rate must be positive");
            }
            if (newValue < 20) {
                LOGGER.atWarn().addArgument((Object)newValue).addArgument((Object)20).log("New refresh rate ({}ms) lower than recommended minimun ({}ms)");
            }
            super.set(newValue);
        }
    };

    public TableViewer() {
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.getSelectionModel().setCellSelectionEnabled(true);
        this.table.setEditable(true);
        this.table.setItems((ObservableList)this.dsModel);
        Bindings.bindContent((List)this.table.getColumns(), this.dsModel.getColumns());
        this.chartProperty().addListener((change, oldChart, newChart) -> {
            if (oldChart != null) {
                oldChart.getToolBar().getChildren().remove((Object)this.interactorButtons);
                oldChart.getPlotForeground().getChildren().remove(this.table);
                oldChart.getPlotArea().setBottom(null);
                this.table.prefWidthProperty().unbind();
                this.table.prefHeightProperty().unbind();
            }
            if (newChart != null) {
                if (this.isAddButtonsToToolBar()) {
                    newChart.getToolBar().getChildren().add((Object)this.interactorButtons);
                }
                newChart.getPlotForeground().getChildren().add(this.table);
                this.table.toFront();
                this.table.setVisible(false);
                this.table.prefWidthProperty().bind((ObservableValue)newChart.getPlotForeground().widthProperty());
                this.table.prefHeightProperty().bind((ObservableValue)newChart.getPlotForeground().heightProperty());
            }
            this.dsModel.chartChanged((Chart)((Object)oldChart), (Chart)((Object)newChart));
        });
        this.addButtonsToToolBarProperty().addListener((ch, o, n) -> {
            Chart chartLocal = this.getChart();
            if (chartLocal == null || o.equals(n)) {
                return;
            }
            if (Boolean.TRUE.equals(n)) {
                chartLocal.getToolBar().getChildren().add((Object)this.interactorButtons);
            } else {
                chartLocal.getToolBar().getChildren().remove((Object)this.interactorButtons);
            }
        });
    }

    public IntegerProperty refreshRateProperty() {
        return this.refreshRate;
    }

    public int getRefreshRate() {
        return this.refreshRate.get();
    }

    public void setRefreshRate(int newVal) {
        this.refreshRate.set(newVal);
    }

    public void copySelectedToClipboard() {
        ClipboardContent content = new ClipboardContent();
        content.putString(this.dsModel.getSelectedData((TableView.TableViewSelectionModel<DataSetsRow>)this.table.getSelectionModel()));
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void exportGridToCSV() {
        FileChooser chooser = new FileChooser();
        File save = chooser.showSaveDialog(this.getChart().getScene().getWindow());
        if (save == null) {
            return;
        }
        String data = this.dsModel.getSelectedData((TableView.TableViewSelectionModel<DataSetsRow>)this.table.getSelectionModel());
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(save.getPath() + ".csv", new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(data);
        }
        catch (IOException ex) {
            LOGGER.atError().setCause((Throwable)ex).log("error while exporting data to csv");
        }
    }

    protected HBox getInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox buttonBar = new HBox();
        buttonBar.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button switchTableView = new Button(null, (Node)this.tableView);
        switchTableView.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        switchTableView.setTooltip(new Tooltip("switches between graph and table view"));
        Button copyToClipBoard = new Button(null, (Node)this.clipBoardIcon);
        copyToClipBoard.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        copyToClipBoard.setTooltip(new Tooltip("copy selected content top system clipboard"));
        copyToClipBoard.setOnAction(e -> this.copySelectedToClipboard());
        Button saveTableView = new Button(null, (Node)this.saveIcon);
        saveTableView.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        saveTableView.setTooltip(new Tooltip("store actively shown content as .csv file"));
        saveTableView.setOnAction(e -> this.exportGridToCSV());
        switchTableView.setOnAction(evt -> {
            switchTableView.setGraphic((Node)(this.table.isVisible() ? this.tableView : this.graphView));
            this.table.setVisible(!this.table.isVisible());
            this.getChart().getPlotForeground().setMouseTransparent(!this.table.isVisible());
            this.table.setMouseTransparent(!this.table.isVisible());
            this.dsModel.datasetsChanged(null);
        });
        buttonBar.getChildren().addAll((Object[])new Node[]{separator, switchTableView, copyToClipBoard, saveTableView});
        return buttonBar;
    }

    public TableView<?> getTable() {
        return this.table;
    }

    protected class DataSetsRow {
        private final int row;
        private final DataSetsModel model;

        private DataSetsRow(int row, DataSetsModel model) {
            this.row = row;
            this.model = model;
        }

        public boolean equals(Object o) {
            if (o instanceof DataSetsRow) {
                DataSetsRow dsr = (DataSetsRow)o;
                return dsr.getRow() == this.row && this.model.equals((Object)dsr.getModel());
            }
            return false;
        }

        protected DataSetsModel getModel() {
            return this.model;
        }

        public int getRow() {
            return this.row;
        }

        public double getValue(DataSet ds, ColumnType type) {
            return this.model.getValue(this.row, ds, type);
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.model.hashCode();
            hash = 31 * hash + this.row;
            return hash;
        }
    }

    protected class DataSetsModel
    extends ObservableListBase<DataSetsRow> {
        protected static final double DEFAULT_COL_WIDTH = 150.0;
        private int nRows;
        private final ObservableList<TableColumn<DataSetsRow, ?>> columns = FXCollections.observableArrayList();
        private long lastColumnUpdate = 0L;
        private AtomicBoolean columnUpdateScheduled = new AtomicBoolean(false);
        private final ListChangeListener<Renderer> rendererChangeListener = this::rendererChanged;
        private final InvalidationListener datasetChangeListener = this::datasetsChanged;
        private final EventListener dataSetDataUpdateListener = evt -> FXUtils.runFX(() -> this.datasetsChanged(null));
        private TimerTask timerTask;

        public DataSetsModel() {
            this.columns.add((Object)new RowIndexHeaderTableColumn());
            TableViewer.this.table.visibleProperty().addListener((prop, oldVal, newVal) -> {
                if (Boolean.TRUE.equals(newVal)) {
                    this.datasetsChanged(null);
                }
            });
        }

        public String toString() {
            return "TableModel";
        }

        public void datasetsChanged(Observable obs) {
            if (TableViewer.this.getChart() == null) {
                return;
            }
            if (!TableViewer.this.table.isVisible()) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastColumnUpdate > (long)TableViewer.this.refreshRate.get()) {
                List columnsUpdated = TableViewer.this.getChart().getAllDatasets().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList());
                int nRowsNew = 0;
                for (int i = 0; i < this.columns.size() - 1 || i < columnsUpdated.size(); ++i) {
                    if (i > 100) {
                        LOGGER.atWarn().addArgument((Object)columnsUpdated.size()).log("Limiting number of DataSets shown in Table, chart has {} DataSets.");
                        break;
                    }
                    if (i < columnsUpdated.size()) {
                        if (i >= this.columns.size() - 1) {
                            this.columns.add((Object)new DataSetTableColumns());
                        }
                        DataSet ds = (DataSet)columnsUpdated.get(i);
                        ds.removeListener(this.dataSetDataUpdateListener);
                        ds.addListener(this.dataSetDataUpdateListener);
                        ((DataSetTableColumns)((Object)this.columns.get(i + 1))).update(ds);
                        nRowsNew = Math.max(nRowsNew, ds.getDataCount());
                        continue;
                    }
                    ((DataSetTableColumns)((Object)this.columns.get(i + 1))).update(null);
                }
                this.lastColumnUpdate = now;
                if (this.nRows != nRowsNew) {
                    this.nRows = nRowsNew;
                    TableViewer.this.table.setItems(null);
                    TableViewer.this.table.setItems((ObservableList)TableViewer.this.dsModel);
                } else {
                    TableViewer.this.table.refresh();
                }
            } else if (this.columnUpdateScheduled.compareAndExchange(false, true)) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        DataSetsModel.this.columnUpdateScheduled.set(false);
                        FXUtils.runFX(() -> DataSetsModel.this.datasetsChanged(null));
                    }
                };
                TableViewer.this.timer.schedule(this.timerTask, TableViewer.this.refreshRate.get());
            }
        }

        public void chartChanged(Chart oldChart, Chart newChart) {
            if (oldChart != null) {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                oldChart.getDatasets().removeListener(this.datasetChangeListener);
                oldChart.getDatasets().forEach(dataSet -> dataSet.removeListener(this.dataSetDataUpdateListener));
                oldChart.getRenderers().removeListener(this.rendererChangeListener);
                if (newChart != null) {
                    newChart.getRenderers().forEach(renderer -> renderer.getDatasets().removeListener(this.datasetChangeListener));
                }
            }
            if (newChart != null) {
                newChart.getDatasets().addListener(this.datasetChangeListener);
                newChart.getDatasets().forEach(dataSet -> dataSet.addListener(this.dataSetDataUpdateListener));
                newChart.getRenderers().addListener(this.rendererChangeListener);
                newChart.getRenderers().forEach(renderer -> renderer.getDatasets().addListener(this.datasetChangeListener));
                this.datasetsChanged(null);
            }
        }

        public boolean contains(Object o) {
            if (o instanceof DataSetsRow) {
                return this.nRows > ((DataSetsRow)o).getRow();
            }
            return false;
        }

        public DataSetsRow get(int row) {
            return new DataSetsRow(row, this);
        }

        protected String getAllData() {
            StringBuilder sb = new StringBuilder();
            sb.append('#');
            int dataSetNo = 0;
            for (TableColumn col : this.columns) {
                if (!(col instanceof DataSetTableColumns) || !col.isVisible()) continue;
                ++dataSetNo;
                for (TableColumn subcol : col.getColumns()) {
                    if (!(subcol instanceof DataSetTableColumn) || !((DataSetTableColumn)subcol).active) continue;
                    sb.append(((DataSetTableColumn)subcol).getText()).append(dataSetNo).append(", ");
                }
            }
            sb.setCharAt(sb.length() - 2, '\n');
            sb.deleteCharAt(sb.length() - 1);
            for (int r = 0; r < this.nRows; ++r) {
                for (TableColumn col : this.columns) {
                    if (col instanceof DataSetTableColumns && col.isVisible()) {
                        for (TableColumn subcol : col.getColumns()) {
                            if (!(subcol instanceof DataSetTableColumn) || !((DataSetTableColumn)subcol).active) continue;
                            sb.append(((DataSetTableColumn)subcol).getValue(r)).append(", ");
                        }
                        continue;
                    }
                    if (!(col instanceof RowIndexHeaderTableColumn)) continue;
                    sb.append(col.getCellData(r)).append(", ");
                }
                sb.setCharAt(sb.length() - 2, '\n');
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        public ObservableList<TableColumn<DataSetsRow, ?>> getColumns() {
            return this.columns;
        }

        protected String getSelectedData(TableView.TableViewSelectionModel<DataSetsRow> selModel) {
            ObservableList selected = selModel.getSelectedCells();
            if (selected.isEmpty()) {
                return this.getAllData();
            }
            TreeSet<Integer> rows = new TreeSet<Integer>();
            TreeMap<Integer, TableColumn> cols = new TreeMap<Integer, TableColumn>();
            for (TablePosition cell : selected) {
                cols.put(cell.getColumn(), cell.getTableColumn());
                rows.add(cell.getRow());
            }
            StringBuilder sb = new StringBuilder();
            sb.append('#');
            for (Map.Entry col : cols.entrySet()) {
                sb.append(((TableColumn)col.getValue()).getText()).append(", ");
            }
            sb.setCharAt(sb.length() - 2, '\n');
            sb.deleteCharAt(sb.length() - 1);
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                int r = (Integer)((Object)iterator.next());
                for (Map.Entry col : cols.entrySet()) {
                    if (col.getValue() instanceof DataSetTableColumn) {
                        sb.append(((DataSetTableColumn)((Object)col.getValue())).getValue(r)).append(", ");
                        continue;
                    }
                    sb.append(((TableColumn)col.getValue()).getCellData(r)).append(", ");
                }
                sb.setCharAt(sb.length() - 2, '\n');
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        public double getValue(int row, DataSet ds, ColumnType type) {
            if (ds == null || row >= ds.getDataCount(0)) {
                return 0.0;
            }
            if (!type.errorCol) {
                return ds.get(type.dimIdx, row);
            }
            if (!(ds instanceof DataSetError)) {
                return 0.0;
            }
            DataSetError eds = (DataSetError)ds;
            if (type.positive) {
                return eds.getErrorPositive(type.dimIdx, row);
            }
            return eds.getErrorNegative(type.dimIdx, row);
        }

        public int indexOf(Object o) {
            if (o instanceof DataSetsRow) {
                int row = ((DataSetsRow)o).row;
                return row < this.nRows ? row : -1;
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.nRows >= 0;
        }

        protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
            boolean dataSetChanges = false;
            while (change.next()) {
                change.getAddedSubList().forEach(renderer -> renderer.getDatasets().addListener(this.datasetChangeListener));
                if (!change.getAddedSubList().isEmpty()) {
                    dataSetChanges = true;
                }
                change.getRemoved().forEach(renderer -> renderer.getDatasets().removeListener(this.datasetChangeListener));
                if (change.getRemoved().isEmpty()) continue;
                dataSetChanges = true;
            }
            if (dataSetChanges) {
                this.datasetsChanged(null);
            }
        }

        public int size() {
            return this.nRows;
        }

        protected class RowIndexHeaderTableColumn
        extends TableColumn<DataSetsRow, Integer> {
            public RowIndexHeaderTableColumn() {
                this.setSortable(false);
                this.setReorderable(false);
                this.setCellValueFactory(dataSetsRow -> new ReadOnlyObjectWrapper((Object)((DataSetsRow)dataSetsRow.getValue()).getRow()));
                this.getStyleClass().add((Object)"column-header");
                this.setEditable(false);
            }
        }

        protected class DataSetTableColumns
        extends TableColumn<DataSetsRow, Double> {
            private DataSet dataSet;

            public DataSetTableColumns() {
                super("");
                this.setSortable(false);
                this.setReorderable(false);
                this.dataSet = null;
                for (ColumnType type : ColumnType.values()) {
                    this.getColumns().add((Object)new DataSetTableColumn(type));
                }
            }

            public void update(DataSet newDataSet) {
                this.dataSet = newDataSet;
                if (newDataSet != null) {
                    this.setText(newDataSet.getName());
                    this.setPrefWidth(150.0);
                } else {
                    this.setText("");
                    this.setPrefWidth(0.0);
                }
                this.getColumns().forEach(col -> {
                    if (col instanceof DataSetTableColumn) {
                        ((DataSetTableColumn)((Object)col)).update(this.dataSet);
                    }
                });
            }
        }

        protected class DataSetTableColumn
        extends TableColumn<DataSetsRow, Double> {
            private DataSet ds;
            private final ColumnType type;
            protected boolean active;

            public DataSetTableColumn(ColumnType type) {
                super("");
                this.active = false;
                this.setSortable(false);
                this.setReorderable(false);
                this.ds = null;
                this.type = type;
                this.setCellValueFactory(dataSetsRowFeature -> new ReadOnlyObjectWrapper((Object)((DataSetsRow)dataSetsRowFeature.getValue()).getValue(this.ds, type)));
                this.setPrefWidth(0.0);
            }

            public double getValue(int row) {
                return TableViewer.this.dsModel.getValue(row, this.ds, this.type);
            }

            public void update(DataSet newDataSet) {
                this.ds = newDataSet;
                if (this.ds == null) {
                    this.setText("");
                    this.setPrefWidth(0.0);
                    this.active = false;
                    return;
                }
                if (TableViewer.this.editable) {
                    this.updateEditableState();
                }
                if (!this.type.errorCol) {
                    this.setText(this.type.label);
                    this.setPrefWidth(150.0);
                    this.active = true;
                    return;
                }
                if (!(newDataSet instanceof DataSetError)) {
                    this.setText("");
                    this.setPrefWidth(0.0);
                    this.active = false;
                    return;
                }
                DataSetError eDs = (DataSetError)newDataSet;
                switch (eDs.getErrorType(this.type.dimIdx)) {
                    case SYMMETRIC: {
                        this.setText(this.type.positive ? "" : this.type.label);
                        this.setPrefWidth(this.type.positive ? 0.0 : 150.0);
                        this.active = !this.type.positive;
                        return;
                    }
                    case ASYMMETRIC: {
                        this.setText((this.type.positive ? (char)'+' : '-') + this.type.label);
                        this.setPrefWidth(150.0);
                        this.active = true;
                        return;
                    }
                }
                this.setText("");
                this.setPrefWidth(0.0);
                this.active = false;
            }

            private void updateEditableState() {
                this.setEditable(false);
                this.setOnEditCommit(null);
                if (!(this.ds instanceof EditableDataSet) || this.type != ColumnType.X && this.type != ColumnType.Y) {
                    return;
                }
                EditableDataSet editableDataSet = (EditableDataSet)this.ds;
                EditConstraints editConstraints = editableDataSet.getEditConstraints();
                if (this.type == ColumnType.X && editConstraints != null && !editConstraints.isEditable(0)) {
                    return;
                }
                if (this.type == ColumnType.Y && editConstraints != null && !editConstraints.isEditable(1)) {
                    return;
                }
                this.setEditable(true);
                this.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
                this.setOnEditCommit(e -> {
                    DataSetsRow rowValue = (DataSetsRow)e.getRowValue();
                    if (rowValue == null) {
                        LOGGER.atError().log("DataSet row should not be null");
                        return;
                    }
                    int row = rowValue.getRow();
                    double oldX = editableDataSet.get(0, row);
                    double oldY = editableDataSet.get(1, row);
                    if (editConstraints != null && !editConstraints.canChange(row)) {
                        editableDataSet.set(row, new double[]{oldX, oldY});
                        return;
                    }
                    double newVal = (Double)e.getNewValue();
                    switch (this.type) {
                        case X: {
                            if (editConstraints != null && !editConstraints.isAcceptable(row, new double[]{newVal, oldY})) {
                                editableDataSet.set(row, new double[]{oldX, oldY});
                                break;
                            }
                            editableDataSet.set(row, new double[]{newVal, oldY});
                            break;
                        }
                        case Y: {
                            if (editConstraints != null && !editConstraints.isAcceptable(row, new double[]{oldX, newVal})) {
                                editableDataSet.set(row, new double[]{oldX, oldY});
                                break;
                            }
                            editableDataSet.set(row, new double[]{oldX, newVal});
                            break;
                        }
                        default: {
                            editableDataSet.set(row, new double[]{oldX, oldY});
                        }
                    }
                });
            }
        }
    }

    protected static enum ColumnType {
        X(0, "x", false, true),
        Y(1, "y", false, true),
        EXN(0, "e_x", true, false),
        EXP(0, "e_x", true, true),
        EYN(1, "e_y", true, false),
        EYP(1, "e_y", true, true);

        int dimIdx;
        String label;
        boolean errorCol;
        boolean positive;

        private ColumnType(int dimIdx, String label, boolean errorCol, boolean positive) {
            this.dimIdx = dimIdx;
            this.label = label;
            this.errorCol = errorCol;
            this.positive = positive;
        }
    }
}

