/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.plugins.ChartPlugin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Bounds;
import javafx.scene.Node;

public class ChartOverlay
extends ChartPlugin {
    private final ObjectProperty<Node> node = new SimpleObjectProperty((Object)this, "node");
    private final ObjectProperty<OverlayArea> overlayArea = new SimpleObjectProperty<OverlayArea>((Object)this, "overlayArea"){

        protected void invalidated() {
            ChartOverlay.this.layoutChildren();
        }
    };

    public ChartOverlay(OverlayArea area) {
        this(area, null);
    }

    public ChartOverlay(OverlayArea area, Node node) {
        this.setOverlayArea(area);
        this.nodeProperty().addListener((obs, oldNode, newNode) -> {
            this.getChartChildren().remove(oldNode);
            if (newNode != null) {
                this.getChartChildren().add(newNode);
            }
            this.layoutChildren();
        });
        this.setNode(node);
    }

    public final Node getNode() {
        return (Node)this.nodeProperty().get();
    }

    public final OverlayArea getOverlayArea() {
        return (OverlayArea)((Object)this.overlayAreaProperty().get());
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null || this.getNode() == null) {
            return;
        }
        if (this.getOverlayArea() == OverlayArea.CHART_PANE) {
            this.getNode().resizeRelocate(0.0, 0.0, this.getChart().getWidth(), this.getChart().getHeight());
        } else {
            Bounds plotArea = this.getChart().getBoundsInLocal();
            this.getNode().resizeRelocate(plotArea.getMinX(), plotArea.getMinY(), plotArea.getWidth(), plotArea.getHeight());
        }
    }

    public final ObjectProperty<Node> nodeProperty() {
        return this.node;
    }

    public final ObjectProperty<OverlayArea> overlayAreaProperty() {
        return this.overlayArea;
    }

    public final void setNode(Node newNode) {
        this.nodeProperty().set((Object)newNode);
    }

    public final void setOverlayArea(OverlayArea area) {
        this.overlayAreaProperty().set((Object)area);
    }

    public static enum OverlayArea {
        CHART_PANE,
        PLOT_AREA;

    }
}

