/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.marker;

import de.gsi.chart.marker.Marker;
import javafx.scene.canvas.GraphicsContext;

public enum DefaultMarker implements Marker
{
    RECTANGLE,
    RECTANGLE1,
    RECTANGLE2,
    CIRCLE,
    CIRCLE1,
    CIRCLE2,
    PLUS,
    CROSS,
    DIAMOND,
    DIAMOND1,
    DIAMOND2;


    @Override
    public void draw(GraphicsContext gc, double x, double y, double size) {
        switch (this) {
            case DIAMOND: 
            case DIAMOND1: {
                DefaultMarker.drawDiamond(gc, x, y, size);
                break;
            }
            case DIAMOND2: {
                DefaultMarker.drawEmptyDiamond(gc, x, y, size);
                break;
            }
            case CIRCLE: 
            case CIRCLE1: {
                DefaultMarker.drawCircle(gc, x, y, size);
                break;
            }
            case CIRCLE2: {
                DefaultMarker.drawEmptyCircle(gc, x, y, size);
                break;
            }
            case CROSS: {
                DefaultMarker.drawCross(gc, x, y, size);
                break;
            }
            case PLUS: {
                DefaultMarker.drawPlus(gc, x, y, size);
                break;
            }
            case RECTANGLE2: {
                DefaultMarker.drawEmptyRectangle(gc, x, y, size);
                break;
            }
            default: {
                DefaultMarker.drawRectangle(gc, x, y, size);
            }
        }
    }

    public static void drawCircle(GraphicsContext gc, double x, double y, double size) {
        gc.fillOval(x - size, y - size, 2.0 * size, 2.0 * size);
    }

    public static void drawCross(GraphicsContext gc, double x, double y, double size) {
        gc.strokeLine(x - size, y - size, x + size, y + size);
        gc.strokeLine(x - size, y + size, x + size, y - size);
    }

    public static void drawDiamond(GraphicsContext gc, double x, double y, double size) {
        double[] xPoints = new double[]{x + size, x, x - size, x, x + size};
        double[] yPoints = new double[]{y, y + size, y, y - size, y};
        gc.fillPolygon(xPoints, yPoints, xPoints.length);
    }

    public static void drawEmptyCircle(GraphicsContext gc, double x, double y, double size) {
        gc.strokeOval(x - size, y - size, 2.0 * size, 2.0 * size);
    }

    public static void drawEmptyDiamond(GraphicsContext gc, double x, double y, double size) {
        double[] xPoints = new double[]{x + size, x, x - size, x, x + size};
        double[] yPoints = new double[]{y, y + size, y, y - size, y};
        gc.strokePolygon(xPoints, yPoints, xPoints.length);
    }

    public static void drawEmptyRectangle(GraphicsContext gc, double x, double y, double size) {
        gc.strokeRect(x - size, y - size, 2.0 * size, 2.0 * size);
    }

    public static void drawPlus(GraphicsContext gc, double x, double y, double size) {
        gc.strokeLine(x, y - size, x, y + size);
        gc.strokeLine(x - size, y, x + size, y);
    }

    public static void drawRectangle(GraphicsContext gc, double x, double y, double size) {
        gc.fillRect(x - size, y - size, 2.0 * size, 2.0 * size);
    }

    public static Marker get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("marker type name must not be 'null'");
        }
        String nameCheck = name.toUpperCase();
        for (DefaultMarker marker : DefaultMarker.values()) {
            if (!marker.name().equals(nameCheck)) continue;
            return marker;
        }
        throw new IllegalArgumentException("unknown marker type name '" + name + "'");
    }
}

