/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.LogAxisType;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.chart.ValueAxis;

public class LogarithmicAxis
extends AbstractAxis {
    public static final double DEFAULT_LOGARITHM_BASE = 10.0;
    public static final double DEFAULT_LOG_MIN_VALUE = 1.0E-6;
    public static final double DB20_LOGARITHM_BASE = Math.exp(Math.log10(10.0) / 20.0);
    public static final double DB10_LOGARITHM_BASE = Math.exp(Math.log10(10.0) / 10.0);
    public static final int DEFAULT_SMALL_LOG_AXIS = 4;
    private static final int DEFAULT_TICK_COUNT = 9;
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final Cache cache = new Cache();
    private boolean isUpdating = true;
    private final SimpleStyleableDoubleProperty tickUnit = new SimpleStyleableDoubleProperty(StyleableProperties.TICK_UNIT, this, "tickUnit", 5.0){

        protected void invalidated() {
            if (!LogarithmicAxis.this.isAutoRanging() && !LogarithmicAxis.this.isAutoGrowRanging()) {
                LogarithmicAxis.this.invalidate();
                LogarithmicAxis.this.requestAxisLayout();
            }
        }
    };
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);
    private final DoubleProperty logarithmBase = new SimpleDoubleProperty(this, "logarithmBase", 10.0){

        protected void invalidated() {
            if (this.get() <= 1.0) {
                throw new IllegalArgumentException("logarithmBase must be grater than 1");
            }
            LogarithmicAxis.this.invalidate();
            LogarithmicAxis.this.requestAxisLayout();
        }
    };

    public LogarithmicAxis() {
        this("axis label", 0.0, 0.0, 5.0);
    }

    public LogarithmicAxis(double lowerBound, double upperBound, double tickUnit) {
        this(null, lowerBound, upperBound, tickUnit);
    }

    public LogarithmicAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setName(axisLabel);
        if (lowerBound >= upperBound || lowerBound == 0.0 && upperBound == 0.0) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(tickUnit);
        this.setMinorTickCount(9);
        this.currentLowerBound.addListener((evt, o, n) -> this.cache.updateCachedAxisVariables());
        super.maxProperty().addListener((evt, o, n) -> this.cache.updateCachedAxisVariables());
        super.scaleProperty().addListener((evt, o, n) -> this.cache.updateCachedAxisVariables());
        this.widthProperty().addListener((ch, o, n) -> {
            this.cache.axisWidth = this.getWidth();
        });
        this.heightProperty().addListener((ch, o, n) -> {
            this.cache.axisHeight = this.getHeight();
        });
        this.isUpdating = false;
    }

    @Override
    public double computePreferredTickUnit(double axisLength) {
        return this.tickUnit.get();
    }

    @Override
    public AxisTransform getAxisTransform() {
        return null;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LogarithmicAxis.getClassCssMetaData();
    }

    @Override
    public double getDisplayPosition(double value) {
        double valueLogOffset = this.log(value) - this.cache.lowerBoundLog;
        if (this.cache.isVerticalAxis) {
            return this.cache.axisHeight - valueLogOffset * this.cache.logScaleLengthInv;
        }
        return valueLogOffset * this.cache.logScaleLengthInv;
    }

    public double getLogarithmBase() {
        return this.logarithmBaseProperty().get();
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    @Override
    public double getValueForDisplay(double displayPosition) {
        if (this.cache.isVerticalAxis) {
            double height = this.cache.axisHeight;
            return this.pow(this.cache.lowerBoundLog + (height - displayPosition) / height * this.cache.logScaleLength);
        }
        return this.pow(this.cache.lowerBoundLog + displayPosition / this.cache.axisWidth * this.cache.logScaleLength);
    }

    @Override
    public double getZeroPosition() {
        return this.getDisplayPosition(this.cache.localCurrentLowerBound);
    }

    @Override
    public boolean isLogAxis() {
        return true;
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    public DoubleProperty logarithmBaseProperty() {
        return this.logarithmBase;
    }

    @Override
    public void requestAxisLayout() {
        if (this.isUpdating) {
            return;
        }
        super.requestAxisLayout();
    }

    public void setLogarithmBase(double value) {
        this.logarithmBaseProperty().set(value);
    }

    @Override
    public void setTickUnit(double unit) {
        this.tickUnitProperty().set(unit);
    }

    public void setTickUnitSupplier(TickUnitSupplier supplier) {
        this.tickUnitSupplierProperty().set((Object)supplier);
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    private double log(double value) {
        if (value <= 0.0) {
            return Double.NaN;
        }
        return Math.log10(value) / this.cache.logBase;
    }

    private double pow(double value) {
        return Math.pow(this.getLogarithmBase(), value);
    }

    @Override
    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        double min = minValue;
        double max = maxValue;
        if (min <= 0.0) {
            min = 1.0E-6;
            this.isUpdating = true;
            this.setMin(1.0E-6);
            this.isUpdating = false;
        }
        double paddingScale = 1.0 + this.getAutoRangePadding();
        double paddedMin = min / paddingScale;
        double paddedMax = max * paddingScale;
        return this.computeRange(paddedMin, paddedMax, length, labelSize);
    }

    @Override
    protected List<Double> calculateMajorTickValues(double axisLength, AxisRange range) {
        if (!(range instanceof AxisRange)) {
            throw new InvalidParameterException("unknown range class:" + ((Object)((Object)range)).getClass().getCanonicalName());
        }
        AxisRange rangeImpl = range;
        ArrayList<Double> tickValues = new ArrayList<Double>();
        if (rangeImpl.getLowerBound() >= rangeImpl.getUpperBound()) {
            return Arrays.asList(rangeImpl.getLowerBound());
        }
        double exp = Math.ceil(this.log(rangeImpl.getLowerBound()));
        double tickValue = this.pow(exp);
        while (tickValue <= rangeImpl.getUpperBound()) {
            tickValues.add(tickValue);
            tickValue = this.pow(exp += 1.0);
        }
        return tickValues;
    }

    @Override
    protected List<Double> calculateMinorTickValues() {
        if (this.getMinorTickCount() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Double> minorTickMarks = new ArrayList<Double>();
        double lowerBound = this.getMin();
        double upperBound = this.getMax();
        double exp = Math.floor(this.log(lowerBound));
        double majorTick = this.pow(exp);
        while (majorTick < upperBound) {
            double nextMajorTick = this.pow(exp + 1.0);
            double minorUnit = (nextMajorTick - majorTick) / (double)this.getMinorTickCount();
            for (double minorTick = majorTick + minorUnit; minorTick < nextMajorTick; minorTick += minorUnit) {
                if (!(minorTick >= lowerBound) || !(minorTick <= upperBound)) continue;
                minorTickMarks.add(minorTick);
            }
            majorTick = this.pow(exp += 1.0);
        }
        return minorTickMarks;
    }

    @Override
    protected AxisRange computeRange(double min, double max, double axisLength, double labelSize) {
        double minValue = min;
        double maxValue = max;
        if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
            minValue = minValue <= 0.0 ? 1.0E-6 : this.pow(Math.floor(this.log(minValue)));
            maxValue = this.pow(Math.ceil(this.log(maxValue)));
        }
        double newScale = this.calculateNewScale(axisLength, minValue, maxValue);
        return new AxisRange(minValue, maxValue, axisLength, newScale, this.tickUnit.get());
    }

    @Override
    protected void setRange(AxisRange range, boolean animate) {
        super.setRange(range, animate);
        this.setTickUnit(range.getTickUnit());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    protected class Cache {
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double upperBoundLog;
        protected double lowerBoundLog;
        protected double logScaleLength;
        protected double logScaleLengthInv;
        protected boolean isVerticalAxis;
        protected double axisWidth;
        protected double axisHeight;
        protected double logBase;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.localCurrentLowerBound = LogarithmicAxis.this.currentLowerBound.get();
            this.localCurrentUpperBound = LogarithmicAxis.super.getMax();
            this.upperBoundLog = LogarithmicAxis.this.log(LogarithmicAxis.this.getMax());
            this.lowerBoundLog = LogarithmicAxis.this.log(LogarithmicAxis.this.getMin());
            this.logScaleLength = this.upperBoundLog - this.lowerBoundLog;
            this.logScaleLengthInv = 1.0 / this.logScaleLength;
            if (LogarithmicAxis.this.getSide() != null) {
                this.isVerticalAxis = LogarithmicAxis.this.getSide().isVertical();
            }
            this.logScaleLengthInv = this.isVerticalAxis ? this.axisHeight / this.logScaleLength : this.axisWidth / this.logScaleLength;
            this.logBase = Math.log10(LogarithmicAxis.this.getLogarithmBase());
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<LogarithmicAxis, Number> TICK_UNIT = new CssMetaData<LogarithmicAxis, Number>("-fx-tick-unit", SizeConverter.getInstance(), (Number)5.0){

            public StyleableProperty<Number> getStyleableProperty(LogarithmicAxis axis) {
                return (StyleableProperty)axis.tickUnitProperty();
            }

            public boolean isSettable(LogarithmicAxis axis) {
                return axis != null && !axis.tickUnit.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<LogarithmicAxis, Number>> styleables = new ArrayList<CssMetaData<LogarithmicAxis, Number>>(ValueAxis.getClassCssMetaData());
            styleables.add(TICK_UNIT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

