/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.LogAxisType;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.chart.ValueAxis;

public class LinearAxis
extends AbstractAxis {
    private static final int DEFAULT_TICK_COUNT = 9;
    private static final int TICK_MARK_GAP = 6;
    private static final double NEXT_TICK_UNIT_FACTOR = 1.01;
    private static final int MAX_TICK_COUNT = 20;
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private static final int DEFAULT_RANGE_LENGTH = 2;
    private final Cache cache = new Cache();
    private boolean isUpdating = true;
    private final BooleanProperty forceZeroInRange = new SimpleBooleanProperty(this, "forceZeroInRange", false){

        protected void invalidated() {
            if (LinearAxis.this.isAutoRanging() || LinearAxis.this.isAutoGrowRanging()) {
                LinearAxis.this.invalidate();
                LinearAxis.this.requestAxisLayout();
            }
        }
    };
    private final SimpleStyleableDoubleProperty tickUnit = new SimpleStyleableDoubleProperty(StyleableProperties.TICK_UNIT, this, "tickUnit", 5.0){

        protected void invalidated() {
            if (!LinearAxis.this.isAutoRanging() && !LinearAxis.this.isAutoGrowRanging()) {
                LinearAxis.this.invalidate();
                LinearAxis.this.requestAxisLayout();
            }
        }
    };
    private final ObjectProperty<TickUnitSupplier> tickUnitSupplier = new SimpleObjectProperty((Object)this, "tickUnitSupplier", (Object)DEFAULT_TICK_UNIT_SUPPLIER);

    public LinearAxis() {
        this("axis label", 0.0, 0.0, 5.0);
    }

    public LinearAxis(double lowerBound, double upperBound, double tickUnit) {
        this(null, lowerBound, upperBound, tickUnit);
    }

    public LinearAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setName(axisLabel);
        if (lowerBound >= upperBound || lowerBound == 0.0 && upperBound == 0.0) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(tickUnit);
        this.setMinorTickCount(9);
        this.currentLowerBound.addListener((evt, o, n) -> this.cache.updateCachedAxisVariables());
        super.maxProperty().addListener((evt, o, n) -> this.cache.updateCachedAxisVariables());
        super.scaleProperty().addListener((evt, o, n) -> this.cache.updateCachedAxisVariables());
        this.widthProperty().addListener((ch, o, n) -> {
            this.cache.axisWidth = this.getWidth();
        });
        this.heightProperty().addListener((ch, o, n) -> {
            this.cache.axisHeight = this.getHeight();
        });
        this.isUpdating = false;
    }

    @Override
    public double computePreferredTickUnit(double axisLength) {
        int ticksCount;
        double reqLength;
        double labelSize = this.getTickLabelFont().getSize() * 2.0;
        int numOfFittingLabels = (int)Math.floor(axisLength / labelSize);
        int numOfTickMarks = Math.max(Math.min(numOfFittingLabels, 20), 2);
        double max = this.maxProperty().get();
        double min = this.minProperty().get();
        double rawTickUnit = (max - min) / (double)numOfTickMarks;
        double tickUnitRounded = Double.MIN_VALUE;
        double minRounded = min;
        double maxRounded = max;
        do {
            double firstMajorTick;
            if (Double.isNaN(rawTickUnit)) {
                throw new IllegalArgumentException("Can't calculate axis range: data contains NaN value");
            }
            double prevTickUnitRounded = tickUnitRounded;
            tickUnitRounded = this.computeTickUnit(rawTickUnit);
            if (tickUnitRounded <= prevTickUnitRounded) break;
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                minRounded = Math.floor(min / tickUnitRounded) * tickUnitRounded;
                maxRounded = Math.ceil(max / tickUnitRounded) * tickUnitRounded;
                firstMajorTick = minRounded;
            } else {
                firstMajorTick = Math.ceil(min / tickUnitRounded) * tickUnitRounded;
            }
            ticksCount = 0;
            double maxReqTickGap = 0.0;
            double halfOfLastTickSize = 0.0;
            double major = firstMajorTick;
            while (major <= maxRounded) {
                double tickMarkSize = this.measureTickMarkLength(major);
                if (major == firstMajorTick) {
                    halfOfLastTickSize = tickMarkSize / 2.0;
                } else {
                    maxReqTickGap = Math.max(maxReqTickGap, halfOfLastTickSize + 6.0 + tickMarkSize / 2.0);
                }
                major += tickUnitRounded;
                ++ticksCount;
            }
            reqLength = (double)(ticksCount - 1) * maxReqTickGap;
            rawTickUnit = tickUnitRounded * 1.01;
        } while (numOfTickMarks > 2 && (reqLength > axisLength || ticksCount > 20));
        return tickUnitRounded;
    }

    public BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    @Override
    public AxisTransform getAxisTransform() {
        return null;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LinearAxis.getClassCssMetaData();
    }

    @Override
    public double getDisplayPosition(double value) {
        return this.cache.localOffset + (value - this.cache.localCurrentLowerBound) * this.cache.localScale;
    }

    @Override
    public LogAxisType getLogAxisType() {
        return LogAxisType.LINEAR_SCALE;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    public TickUnitSupplier getTickUnitSupplier() {
        return (TickUnitSupplier)this.tickUnitSupplierProperty().get();
    }

    @Override
    public double getValueForDisplay(double displayPosition) {
        return (displayPosition - this.cache.localOffset) / this.cache.localScale + this.cache.localCurrentLowerBound;
    }

    @Override
    public double getZeroPosition() {
        return this.getDisplayPosition(0.0);
    }

    public boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    @Override
    public boolean isLogAxis() {
        return false;
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    @Override
    public void requestAxisLayout() {
        if (this.isUpdating) {
            return;
        }
        super.requestAxisLayout();
    }

    public void setForceZeroInRange(boolean value) {
        this.forceZeroInRange.setValue(Boolean.valueOf(value));
    }

    @Override
    public void setTickUnit(double unit) {
        this.tickUnitProperty().set(unit);
    }

    public void setTickUnitSupplier(TickUnitSupplier supplier) {
        this.tickUnitSupplierProperty().set((Object)supplier);
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public ObjectProperty<TickUnitSupplier> tickUnitSupplierProperty() {
        return this.tickUnitSupplier;
    }

    private AxisRange computeRangeImpl(double min, double max, double axisLength, double labelSize) {
        int ticksCount;
        double reqLength;
        int numOfFittingLabels = (int)Math.floor(axisLength / labelSize);
        int numOfTickMarks = Math.max(Math.min(numOfFittingLabels, 20), 2);
        double rawTickUnit = (max - min) / (double)numOfTickMarks;
        double tickUnitRounded = Double.MIN_VALUE;
        double minRounded = min;
        double maxRounded = max;
        do {
            double firstMajorTick;
            if (Double.isNaN(rawTickUnit)) {
                throw new IllegalArgumentException("Can't calculate axis range: data contains NaN value");
            }
            double prevTickUnitRounded = tickUnitRounded;
            tickUnitRounded = this.computeTickUnit(rawTickUnit);
            if (tickUnitRounded <= prevTickUnitRounded) break;
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                minRounded = Math.floor(min / tickUnitRounded) * tickUnitRounded;
                maxRounded = Math.ceil(max / tickUnitRounded) * tickUnitRounded;
                firstMajorTick = minRounded;
            } else {
                firstMajorTick = Math.ceil(min / tickUnitRounded) * tickUnitRounded;
            }
            ticksCount = 0;
            double maxReqTickGap = 0.0;
            double halfOfLastTickSize = 0.0;
            double major = firstMajorTick;
            while (major <= maxRounded) {
                double tickMarkSize = this.measureTickMarkLength(major);
                if (major == firstMajorTick) {
                    halfOfLastTickSize = tickMarkSize / 2.0;
                } else {
                    maxReqTickGap = Math.max(maxReqTickGap, halfOfLastTickSize + 6.0 + tickMarkSize / 2.0);
                }
                major += tickUnitRounded;
                ++ticksCount;
            }
            reqLength = (double)(ticksCount - 1) * maxReqTickGap;
            rawTickUnit = tickUnitRounded * 1.01;
        } while (numOfTickMarks > 2 && (reqLength > axisLength || ticksCount > 20));
        double newScale = this.calculateNewScale(axisLength, minRounded, maxRounded);
        return new AxisRange(minRounded, maxRounded, axisLength, newScale, tickUnitRounded);
    }

    private double computeTickUnit(double rawTickUnit) {
        double majorUnit;
        TickUnitSupplier unitSupplier = this.getTickUnitSupplier();
        if (unitSupplier == null) {
            unitSupplier = DEFAULT_TICK_UNIT_SUPPLIER;
        }
        if ((majorUnit = unitSupplier.computeTickUnit(rawTickUnit)) <= 0.0) {
            throw new IllegalArgumentException("The " + unitSupplier.getClass().getName() + " computed illegal unit value [" + majorUnit + "] for argument " + rawTickUnit);
        }
        return majorUnit;
    }

    @Override
    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        double min = minValue > 0.0 && this.isForceZeroInRange() ? 0.0 : minValue;
        double max = maxValue < 0.0 && this.isForceZeroInRange() ? 0.0 : maxValue;
        double padding = LinearAxis.getEffectiveRange(min, max) * this.getAutoRangePadding();
        double paddedMin = LinearAxis.clampBoundToZero(min - padding, min);
        double paddedMax = LinearAxis.clampBoundToZero(max + padding, max);
        return this.computeRange(paddedMin, paddedMax, length, labelSize);
    }

    @Override
    protected List<Double> calculateMajorTickValues(double axisLength, AxisRange range) {
        double firstTick;
        if (!(range instanceof AxisRange)) {
            throw new InvalidParameterException("unknown range class:" + ((Object)((Object)range)).getClass().getCanonicalName());
        }
        AxisRange rangeImpl = range;
        ArrayList<Double> tickValues = new ArrayList<Double>();
        if (rangeImpl.getLowerBound() == rangeImpl.getUpperBound() || rangeImpl.getTickUnit() <= 0.0) {
            return Arrays.asList(rangeImpl.getLowerBound());
        }
        for (double major = firstTick = LinearAxis.computeFistMajorTick(rangeImpl.getLowerBound(), rangeImpl.getTickUnit()); major <= rangeImpl.getUpperBound(); major += rangeImpl.getTickUnit()) {
            tickValues.add(major);
        }
        return tickValues;
    }

    @Override
    protected List<Double> calculateMinorTickValues() {
        ArrayList<Double> minorTickMarks = new ArrayList<Double>();
        double lowerBound = this.getMin();
        double upperBound = this.getMax();
        double majorUnit = this.getTickUnit();
        double firstMajorTick = LinearAxis.computeFistMajorTick(lowerBound, majorUnit);
        double minorUnit = majorUnit / (double)this.getMinorTickCount();
        for (double majorTick = firstMajorTick - majorUnit; majorTick < upperBound; majorTick += majorUnit) {
            double nextMajorTick = majorTick + majorUnit;
            for (double minorTick = majorTick + minorUnit; minorTick < nextMajorTick; minorTick += minorUnit) {
                if (!(minorTick >= lowerBound) || !(minorTick <= upperBound)) continue;
                minorTickMarks.add(minorTick);
            }
        }
        return minorTickMarks;
    }

    @Override
    protected AxisRange computeRange(double min, double max, double axisLength, double labelSize) {
        double maxValue = max;
        double minValue = min;
        if (maxValue - minValue == 0.0) {
            double padding = this.getAutoRangePadding() < 0.0 ? 0.0 : this.getAutoRangePadding();
            double paddedRange = LinearAxis.getEffectiveRange(minValue, maxValue) * padding;
            minValue -= paddedRange / 2.0;
            maxValue += paddedRange / 2.0;
        }
        return this.computeRangeImpl(minValue, maxValue, axisLength, labelSize);
    }

    @Override
    protected AxisRange getAxisRange() {
        AxisRange localRange = super.getAxisRange();
        double lower = localRange.getLowerBound();
        double upper = localRange.getUpperBound();
        double axisLength = localRange.getAxisLength();
        double scale = localRange.getScale();
        return new AxisRange(lower, upper, axisLength, scale, this.getTickUnit());
    }

    @Override
    protected void setRange(AxisRange range, boolean animate) {
        super.setRange(range, animate);
        this.setTickUnit(range.getTickUnit());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static double clampBoundToZero(double paddedBound, double bound) {
        if (paddedBound < 0.0 && bound >= 0.0 || paddedBound > 0.0 && bound <= 0.0) {
            return 0.0;
        }
        return paddedBound;
    }

    private static double computeFistMajorTick(double lowerBound, double tickUnit) {
        return Math.ceil(lowerBound / tickUnit) * tickUnit;
    }

    private static double getEffectiveRange(double min, double max) {
        double effectiveRange = max - min;
        if (effectiveRange == 0.0) {
            effectiveRange = min == 0.0 ? 2.0 : Math.abs(min);
        }
        return effectiveRange;
    }

    protected class Cache {
        protected double localScale;
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double localOffset;
        protected boolean isVerticalAxis;
        protected double axisWidth;
        protected double axisHeight;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.localCurrentLowerBound = LinearAxis.this.currentLowerBound.get();
            this.localCurrentUpperBound = LinearAxis.super.getMax();
            this.localScale = LinearAxis.this.scaleProperty().get();
            double zero = LinearAxis.super.getDisplayPosition(0.0);
            this.localOffset = zero + this.localCurrentLowerBound * LinearAxis.this.scaleProperty().get();
            if (LinearAxis.this.getSide() != null) {
                this.isVerticalAxis = LinearAxis.this.getSide().isVertical();
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<LinearAxis, Number> TICK_UNIT = new CssMetaData<LinearAxis, Number>("-fx-tick-unit", SizeConverter.getInstance(), (Number)5.0){

            public StyleableProperty<Number> getStyleableProperty(LinearAxis axis) {
                return (StyleableProperty)axis.tickUnitProperty();
            }

            public boolean isSettable(LinearAxis axis) {
                return axis != null && !axis.tickUnit.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<LinearAxis, Number>> styleables = new ArrayList<CssMetaData<LinearAxis, Number>>(ValueAxis.getClassCssMetaData());
            styleables.add(TICK_UNIT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

