/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import de.gsi.chart.viewer.DataView;
import de.gsi.chart.viewer.DataViewTilingPane;
import de.gsi.chart.viewer.DataViewWindow;
import de.gsi.chart.viewer.SquareButton;
import de.gsi.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="views")
public class DataViewer
extends BorderPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewer.class);
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private final BooleanProperty decorationVisible = new SimpleBooleanProperty((Object)this, "windowDecorationVisible", true);
    private final BooleanProperty closeWindowButtonVisible = new SimpleBooleanProperty((Object)this, "closeButtonVisible", true);
    private final Glyph rootGlyph = new Glyph("FontAwesome", (Object)"\uf698").size(20.0);
    private final DataView dataViewRoot = new DataView("root", (Node)this.rootGlyph, null);
    private final HBox viewList = new HBox();
    private final Separator separator1 = new Separator(Orientation.HORIZONTAL);
    private final Separator separator2 = new Separator(Orientation.HORIZONTAL);
    private final ToolBar toolBar;
    private final ObservableList<Node> userToolBarItems = FXCollections.observableList((List)new NoDuplicatesList());
    private final BooleanProperty showListStyleDataViews = new SimpleBooleanProperty((Object)this, "listStyleViews", false);
    private final BooleanProperty explorerVisible = new SimpleBooleanProperty(false){

        protected void invalidated() {
            DataViewer.this.requestLayout();
        }
    };

    public DataViewer() {
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("DataViewer.css").toExternalForm());
        this.dataViewRoot.getSubDataViews().addListener(change -> {
            while (change.next()) {
                DataView activeView = this.dataViewRoot.getActiveView();
                if (change.getAddedSize() <= 0 || activeView != null && activeView != this.dataViewRoot) continue;
                this.dataViewRoot.setActiveSubView((DataView)((Object)((Object)change.getAddedSubList().get(0))));
            }
        });
        this.dataViewRoot.activeSubViewProperty().addListener((ch, o, n) -> {
            if (n == null) {
                this.dataViewRoot.getChildren().clear();
                this.updateToolBar();
                return;
            }
            this.dataViewRoot.getChildren().setAll((Object[])new Node[]{n});
            if (!this.dataViewRoot.getSubDataViews().contains((Object)n)) {
                this.dataViewRoot.getSubDataViews().add((Object)n);
            }
            this.updateToolBar();
        });
        this.userToolBarItems.addListener(change -> this.updateToolBar());
        this.showListStyleDataViews.addListener((ch, o, n) -> this.updateToolBar());
        this.selectedViewProperty().addListener((ch, o, n) -> this.updateToolBar());
        this.windowDecorationVisible().addListener((ch, o, n) -> this.updateWindowDecorations(this.dataViewRoot));
        this.closeWindowButtonVisibleProperty().addListener((ch, o, n) -> this.updateCloseWindowButton(this.dataViewRoot, (boolean)n));
        Label spacer = new Label();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.toolBar = new ToolBar(new Node[]{this.separator1, this.viewList, this.separator2, spacer});
        this.setCenter((Node)this.dataViewRoot);
        this.requestLayout();
    }

    public BooleanProperty closeWindowButtonVisibleProperty() {
        return this.closeWindowButtonVisible;
    }

    public BooleanProperty explorerVisibleProperty() {
        return this.explorerVisible;
    }

    public final DataView getSelectedView() {
        return (DataView)((Object)this.selectedViewProperty().get());
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public ObservableList<Node> getUserToolBarItems() {
        return this.userToolBarItems;
    }

    public final ObservableList<DataView> getViews() {
        return this.dataViewRoot.getSubDataViews();
    }

    public boolean isCloseWindowButtonVisible() {
        return this.closeWindowButtonVisibleProperty().get();
    }

    public final boolean isExplorerVisible() {
        return this.explorerVisibleProperty().get();
    }

    public boolean isWindowDecorationVisible() {
        return this.windowDecorationVisible().get();
    }

    public final ObjectProperty<DataView> selectedViewProperty() {
        return this.dataViewRoot.activeSubViewProperty();
    }

    public void setCloseWindowButtonVisible(boolean state) {
        this.closeWindowButtonVisibleProperty().set(state);
    }

    public final void setExplorerVisible(boolean value) {
        this.explorerVisibleProperty().set(value);
    }

    public final void setSelectedView(DataView selectedView) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)selectedView).log("setSelectedView('{}')");
        }
        this.selectedViewProperty().set((Object)selectedView);
    }

    public final void setSelectedView(String viewName) {
        this.setSelectedView(viewName);
    }

    public void setWindowDecorationVisible(boolean state) {
        this.windowDecorationVisible().set(state);
    }

    public BooleanProperty showListStyleDataViewProperty() {
        return this.showListStyleDataViews;
    }

    protected void updateCloseWindowButton(DataView root, boolean state) {
        for (DataView view : root.getSubDataViews()) {
            this.updateCloseWindowButton(view, state);
        }
        ArrayList<Pane> nodeList = new ArrayList<Pane>();
        if (root.getContentPane() != null) {
            nodeList.add(root.getContentPane());
        }
        nodeList.addAll((Collection<Pane>)root.getChildren());
        nodeList.addAll((Collection<Pane>)root.getContentPane().getChildren());
        for (Node child : nodeList) {
            if (!(child instanceof DataViewWindow)) continue;
            DataViewWindow window = (DataViewWindow)child;
            if (state) {
                window.addCloseWindowButton();
                continue;
            }
            window.removeCloseWindowButton();
        }
    }

    public void updateMenuButton(Menu menuButton, DataView dataView) {
        for (DataView view : dataView.getSubDataViews()) {
            String name = view.getName();
            Node icon = view.getIcon();
            if (view.getSubDataViews().isEmpty()) {
                MenuItem menuItem = new MenuItem(name, icon);
                menuItem.setOnAction(evt -> dataView.setView(view));
                menuButton.getItems().add((Object)menuItem);
                continue;
            }
            Menu subMenuButton = new Menu(name, icon);
            subMenuButton.setOnAction(evt -> dataView.setView(view));
            menuButton.getItems().add((Object)subMenuButton);
            this.updateMenuButton(subMenuButton, view);
        }
    }

    protected void updateToolBar() {
        this.toolBar.getItems().clear();
        this.toolBar.getItems().addAll(this.userToolBarItems);
        if (this.getSelectedView() == null) {
            return;
        }
        this.toolBar.getItems().add((Object)this.separator1);
        for (DataView view : this.dataViewRoot.getSubDataViews()) {
            String name = view.getName();
            Node icon = view.getIcon();
            Button viewButton = icon == null && name == null ? new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.QUESTION)) : (icon == null ? new Button(name, null) : new Button(null, icon));
            viewButton.setTooltip(new Tooltip("activates view '" + name + "'"));
            if (this.showListStyleDataViewProperty().get()) continue;
            viewButton.setOnAction(evt -> this.setSelectedView(view));
            this.toolBar.getItems().add((Object)viewButton);
        }
        if (this.showListStyleDataViewProperty().get()) {
            Menu rootMenu = new Menu(null, (Node)new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.LIST_UL));
            MenuBar menuButton = new MenuBar(new Menu[]{rootMenu});
            this.updateMenuButton(rootMenu, this.dataViewRoot);
            if (!rootMenu.getItems().isEmpty()) {
                this.toolBar.getItems().add((Object)menuButton);
            }
        }
        if (this.getSelectedView().isStandalone()) {
            this.toolBar.requestLayout();
            return;
        }
        this.toolBar.getItems().add((Object)this.separator2);
        SquareButton sortButton = new SquareButton(null, (Node)new Glyph(FONT_AWESOME, (Object)FontAwesome.Glyph.SORT_ALPHA_ASC));
        sortButton.setTooltip(new Tooltip("sort children"));
        sortButton.setOnAction(evt -> this.getSelectedView().getActiveView().sort());
        this.toolBar.getItems().add((Object)sortButton);
        for (DataView view : this.getSelectedView().getSubDataViews()) {
            if (!(view.getContentPane() instanceof DataViewTilingPane)) continue;
            DataViewTilingPane tilingPane = (DataViewTilingPane)view.getContentPane();
            DataViewTilingPane.Layout layout = tilingPane.getLayout();
            SquareButton selectionButton = new SquareButton(null, layout.getIcon());
            selectionButton.setTooltip(new Tooltip("configure pane for " + layout.getName() + "-style layout"));
            selectionButton.setOnAction(evt -> this.getSelectedView().setView(view));
            if (layout.equals((Object)DataViewTilingPane.Layout.MAXIMISE)) continue;
            this.toolBar.getItems().add((Object)selectionButton);
        }
        this.toolBar.requestLayout();
    }

    protected void updateWindowDecorations(DataView root) {
        for (DataView view : root.getSubDataViews()) {
            this.updateWindowDecorations(view);
        }
        if (root.getContentPane() == null) {
            return;
        }
        ArrayList<Pane> nodeList = new ArrayList<Pane>();
        nodeList.add(root.getContentPane());
        nodeList.addAll((Collection<Pane>)root.getChildren());
        nodeList.addAll((Collection<Pane>)root.getContentPane().getChildren());
        for (Node child : nodeList) {
            if (!(child instanceof DataViewWindow)) continue;
            DataViewWindow window = (DataViewWindow)child;
            window.setWindowDecorationVisible(this.isWindowDecorationVisible());
        }
    }

    public BooleanProperty windowDecorationVisible() {
        return this.decorationVisible;
    }
}

