/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataViewTilingPane
extends GridPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataViewTilingPane.class);
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    public final Layout layout;

    public DataViewTilingPane(Layout layout) {
        this.layout = layout;
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.getChildren().addListener(change -> {
            while (change.next()) {
                this.layoutNormal();
            }
        });
    }

    protected int getColumnsCount() {
        int childCount = this.getChildren().size();
        if (childCount == 0) {
            return 1;
        }
        switch (this.layout) {
            case HBOX: {
                return childCount;
            }
            case MAXIMISE: 
            case VBOX: {
                return 1;
            }
        }
        if (childCount < 4) {
            return 2;
        }
        int ncols = (int)Math.ceil(Math.sqrt(childCount));
        if (ncols == 0) {
            ncols = 1;
        }
        return ncols;
    }

    public Layout getLayout() {
        return this.layout;
    }

    protected void layoutNormal() {
        if (this.getChildren().isEmpty()) {
            return;
        }
        int colsCount = this.getColumnsCount();
        if (this.getColumnConstraints().size() != colsCount) {
            ArrayList<ColumnConstraints> colConstraintList = new ArrayList<ColumnConstraints>();
            for (int i = 0; i < colsCount; ++i) {
                ColumnConstraints colConstraints = new ColumnConstraints();
                colConstraints.setPercentWidth(100.0 / (double)colsCount);
                colConstraints.setHgrow(Priority.ALWAYS);
                colConstraints.setFillWidth(true);
                colConstraintList.add(colConstraints);
            }
            this.getColumnConstraints().setAll(colConstraintList);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update column constraints");
            }
        }
        int rowIndex = 0;
        int colIndex = 0;
        int childCount = 0;
        int nChildren = this.getChildren().size();
        int nColSpan = Math.max(1, colsCount / (nChildren - childCount));
        for (Node child : this.getChildren()) {
            GridPane.setFillWidth((Node)child, (Boolean)true);
            GridPane.setFillHeight((Node)child, (Boolean)true);
            GridPane.setHgrow((Node)child, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)child, (Priority)Priority.ALWAYS);
            GridPane.setColumnIndex((Node)child, (Integer)colIndex);
            GridPane.setRowIndex((Node)child, (Integer)rowIndex);
            if (colIndex == 0 && nChildren - childCount < colsCount) {
                nColSpan = Math.max(1, colsCount / (nChildren - childCount));
            }
            if (nChildren - childCount == 1 && colIndex < colsCount) {
                nColSpan = colsCount - colIndex;
            }
            GridPane.setColumnSpan((Node)child, (Integer)nColSpan);
            if ((colIndex += nColSpan) >= colsCount) {
                colIndex = 0;
                ++rowIndex;
            }
            ++childCount;
        }
    }

    public String toString() {
        return DataViewTilingPane.class.getSimpleName() + "('" + this.layout + "0')";
    }

    public static enum Layout {
        HBOX("HBox", new Glyph("FontAwesome", (Object)"\uf07e").size(20.0)),
        VBOX("VBox", new Glyph("FontAwesome", (Object)"\uf07d").size(20.0)),
        GRID("Grid", new Glyph("FontAwesome", (Object)"\uf009").size(20.0)),
        MAXIMISE("Maximise", new Glyph("FontAwesome", (Object)"\uf2d0").size(20.0));

        private final String name;
        private final Glyph glyph;

        private Layout(String name, Glyph glyph) {
            this.name = name;
            this.glyph = glyph;
        }

        public Node getIcon() {
            return this.glyph.duplicate();
        }

        public String getName() {
            return this.name;
        }
    }
}

