/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;

public final class FXUtils {
    private FXUtils() {
        throw new UnsupportedOperationException("don't use this in a non-static context");
    }

    public static void assertJavaFxThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("access JavaFX from non-JavaFX thread - please fix");
        }
    }

    public static void keepJavaFxAlive() {
        Platform.setImplicitExit((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAndWait(Runnable run) throws InterruptedException, ExecutionException {
        FXUtils.keepJavaFxAlive();
        if (Platform.isFxApplicationThread()) {
            try {
                run.run();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        ThrowableWrapper throwableWrapper = new ThrowableWrapper();
        lock.lock();
        try {
            Platform.runLater(() -> {
                lock.lock();
                try {
                    run.run();
                }
                catch (Throwable e) {
                    throwableWrapper.t = e;
                }
                finally {
                    try {
                        condition.signal();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
            condition.await();
            if (throwableWrapper.t != null) {
                throw new ExecutionException(throwableWrapper.t);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void runFX(Runnable run) {
        FXUtils.keepJavaFxAlive();
        if (Platform.isFxApplicationThread()) {
            try {
                run.run();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            Platform.runLater((Runnable)run);
        }
    }

    public static void runLater(Runnable run) throws ExecutionException {
        FXUtils.keepJavaFxAlive();
        if (Platform.isFxApplicationThread()) {
            try {
                run.run();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        } else {
            Platform.runLater((Runnable)run);
        }
    }

    private static class ThrowableWrapper {
        Throwable t;

        private ThrowableWrapper() {
        }
    }
}

