/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import de.gsi.chart.Chart;
import de.gsi.chart.ui.ToolBarShapeHelper;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ToolBarFlowPane
extends FlowPane {
    private static final double CORNER_SPACE_PADDING_FACTOR = 1.8;
    private Color defaultColour = Color.web((String)"#f4f4f4", (double)0.85).deriveColor(0.0, 1.0, 0.94, 1.0);
    private Color selectedColour = Color.web((String)"#f4f4f4", (double)0.85).deriveColor(0.0, 1.0, 0.92, 1.0);
    private Insets toolBarPadding = new Insets(1.0, 12.5, 5.0, 12.5);
    private final DoubleProperty cornerRadius = new SimpleDoubleProperty((Object)this, "cornerRadius", 25.0);
    private final Chart chart;

    public ToolBarFlowPane(Chart chart) {
        this.chart = chart;
        this.setPrefHeight(-1.0);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.defaultColour, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.setMinHeight(0.0);
        this.setShape(ToolBarShapeHelper.getToolBarShape(this.getWidth(), this.getHeight(), this.cornerRadius.get()));
        this.setPrefWidth(-1.0);
        this.setAlignment(Pos.TOP_CENTER);
        this.setMinWidth(0.0);
        this.setPadding(this.calculateInsets());
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.NEVER);
        ChangeListener toolBarSizeListener = (ch, o, n) -> {
            if (n.equals(o)) {
                return;
            }
            this.adjustToolBarWidth();
        };
        this.widthProperty().addListener(toolBarSizeListener);
        this.heightProperty().addListener(toolBarSizeListener);
        chart.getCanvas().widthProperty().addListener(toolBarSizeListener);
        this.cornerRadius.addListener(toolBarSizeListener);
    }

    private void adjustToolBarWidth() {
        double maxLength = 0.9 * this.chart.getCanvas().getWidth();
        double length = 0.0;
        for (Node node : this.getChildren()) {
            length += node.prefWidth(-2.0);
        }
        double wrapLength = Math.min(maxLength, Math.max(length += 4.0 * this.cornerRadius.get(), 50.0));
        this.prefWrapLengthProperty().set(wrapLength);
        this.setMaxWidth(maxLength);
        this.setShape(ToolBarShapeHelper.getToolBarShape(wrapLength, this.getHeight(), this.cornerRadius.get()));
    }

    protected Insets calculateInsets() {
        double roundCornerSpace = 1.8 * this.cornerRadius.get();
        double sidePaddingRight = Math.max(roundCornerSpace, this.toolBarPadding.getRight());
        double sidePaddingLeft = Math.max(roundCornerSpace, this.toolBarPadding.getLeft());
        return new Insets(this.toolBarPadding.getTop(), sidePaddingRight, this.toolBarPadding.getBottom(), sidePaddingLeft);
    }

    public DoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public Color getToolBarDefaultColor() {
        return this.defaultColour;
    }

    public Insets getToolBarInsets() {
        return this.toolBarPadding;
    }

    public Color getToolBarSelectedColor() {
        return this.selectedColour;
    }

    public void registerListener() {
        this.getChildren().addListener(c -> this.adjustToolBarWidth());
        this.setOnMouseClicked(mevt -> {
            if (this.chart.toolBarPinnedProperty().isBound()) {
                return;
            }
            this.chart.setToolBarPinned(!this.chart.isToolBarPinned());
        });
        this.chart.toolBarPinnedProperty().addListener((obj, valOld, valNew) -> {
            if (valNew.booleanValue()) {
                this.chart.setPinnedSide(Side.TOP);
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.selectedColour, CornerRadii.EMPTY, Insets.EMPTY)}));
            } else {
                this.chart.setPinnedSide(null);
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.defaultColour, CornerRadii.EMPTY, Insets.EMPTY)}));
            }
            this.chart.requestLayout();
        });
    }

    public void setToolBarDefaultColor(Color color) {
        this.defaultColour = color;
    }

    public void setToolBarInsets(Insets padding) {
        this.toolBarPadding = padding;
        this.setPadding(this.toolBarPadding);
    }

    public void setToolBarSelectedColor(Color color) {
        this.selectedColour = color;
    }
}

