/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.chart.renderer.spi.utils.DefaultRenderColorScheme;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;

public class ReducingLineRenderer
extends AbstractDataSetManagement<ReducingLineRenderer>
implements Renderer {
    private int maxPoints;

    public ReducingLineRenderer() {
        this.maxPoints = 300;
    }

    public ReducingLineRenderer(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    @Override
    protected ReducingLineRenderer getThis() {
        return this;
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)super.getDatasets());
        long start = ProcessingProfiler.getTimeStamp();
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xAxis.getWidth();
        double xmin = xAxis.getValueForDisplay(0.0);
        double xmax = xAxis.getValueForDisplay(xAxisWidth);
        int index = 0;
        for (DataSet ds : localDataSetList) {
            if (!(ds instanceof DataSet2D)) continue;
            DataSet2D dataset = (DataSet2D)ds;
            int lindex = index++;
            dataset.lock().readLockGuardOptimistic(() -> {
                if (lindex == 0) {
                    CategoryAxis axis;
                    if (xyChart.getXAxis() instanceof CategoryAxis) {
                        axis = (CategoryAxis)xyChart.getXAxis();
                        axis.updateCategories((DataSet)dataset);
                    }
                    if (xyChart.getYAxis() instanceof CategoryAxis) {
                        axis = (CategoryAxis)xyChart.getYAxis();
                        axis.updateCategories((DataSet)dataset);
                    }
                }
                gc.save();
                DefaultRenderColorScheme.setLineScheme(gc, dataset.getStyle(), lindex);
                DefaultRenderColorScheme.setGraphicsContextAttributes(gc, dataset.getStyle());
                if (dataset.getDataCount() > 0) {
                    int indexMin = Math.max(0, dataset.getXIndex(xmin));
                    int indexMax = Math.min(dataset.getXIndex(xmax) + 1, dataset.getDataCount());
                    int n = Math.abs(indexMax - indexMin);
                    int d = n / this.maxPoints;
                    if (d <= 1) {
                        int i = dataset.getXIndex(xmin);
                        if (i < 0) {
                            i = 0;
                        }
                        double x0 = xAxis.getDisplayPosition(dataset.get(0, i));
                        double y0 = yAxis.getDisplayPosition(dataset.get(1, i));
                        ++i;
                        while (i < Math.min(dataset.getXIndex(xmax) + 1, dataset.getDataCount())) {
                            double x1 = xAxis.getDisplayPosition(dataset.getX(i));
                            double y1 = yAxis.getDisplayPosition(dataset.getY(i));
                            gc.strokeLine(x0, y0, x1, y1);
                            x0 = x1;
                            y0 = y1;
                            ++i;
                        }
                    } else {
                        int i = dataset.getXIndex(xmin);
                        if (i < 0) {
                            i = 0;
                        }
                        double x0 = xAxis.getDisplayPosition(dataset.get(0, i));
                        double y0 = yAxis.getDisplayPosition(dataset.get(1, i));
                        double x1 = xAxis.getDisplayPosition(dataset.get(0, ++i));
                        double y1 = yAxis.getDisplayPosition(dataset.get(1, i));
                        double delta = Math.abs(y1 - y0);
                        ++i;
                        int j = d - 2;
                        while (i < Math.min(dataset.getXIndex(xmax) + 1, dataset.getDataCount())) {
                            if (j > 0) {
                                double x2 = xAxis.getDisplayPosition(dataset.get(0, i));
                                double y2 = yAxis.getDisplayPosition(dataset.get(1, i));
                                if (Math.abs(y2 - y0) > delta) {
                                    x1 = x2;
                                    y1 = y2;
                                    delta = Math.abs(y2 - y0);
                                }
                                --j;
                            } else {
                                gc.strokeLine(x0, y0, x1, y1);
                                x0 = x1;
                                y0 = y1;
                                x1 = xAxis.getDisplayPosition(dataset.get(0, i));
                                y1 = yAxis.getDisplayPosition(dataset.get(1, i));
                                delta = Math.abs(y1 - y0);
                                j = d - 1;
                            }
                            ++i;
                        }
                    }
                }
                gc.restore();
            });
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    public void setMaxPoints(int maxPoints) {
        this.maxPoints = maxPoints;
    }
}

