/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AxisRangeChangeEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.locks.DefaultDataSetLock;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;

public class MountainRangeRenderer
extends ErrorDataSetRenderer
implements Renderer {
    protected DoubleProperty mountainRangeOffset = new SimpleDoubleProperty((Object)this, "mountainRangeOffset", 0.5);
    private final ObservableList<ErrorDataSetRenderer> renderers = FXCollections.observableArrayList();
    private final ObservableList<DataSet> empty = FXCollections.observableArrayList();
    private final WeakHashMap<Double, Integer> xWeakIndexMap = new WeakHashMap();
    private final WeakHashMap<Double, Integer> yWeakIndexMap = new WeakHashMap();
    private double zRangeMin = Double.MAX_VALUE;
    private double zRangeMax = -1.7976931348623157E308;
    private double mountainRaingeExtra = 0.0;

    public MountainRangeRenderer() {
        this.setDrawMarker(false);
        this.setDrawBars(false);
        this.setErrorType(ErrorStyle.NONE);
        this.xWeakIndexMap.clear();
        this.yWeakIndexMap.clear();
    }

    public MountainRangeRenderer(double mountainRangeOffset) {
        this();
        this.setMountainRangeOffset(mountainRangeOffset);
    }

    private void checkAndRecreateRenderer(int nRenderer) {
        if (this.renderers.size() == nRenderer) {
            return;
        }
        if (nRenderer > this.renderers.size()) {
            for (int i = this.renderers.size(); i < nRenderer; ++i) {
                ErrorDataSetRenderer newRenderer = new ErrorDataSetRenderer();
                newRenderer.bind(this);
                newRenderer.showInLegendProperty().unbind();
                newRenderer.setShowInLegend(false);
                this.renderers.add((Object)newRenderer);
            }
            return;
        }
        while (nRenderer < this.renderers.size()) {
            this.renderers.remove(0);
        }
    }

    public final double getMountainRangeOffset() {
        return this.mountainRangeOffset.get();
    }

    public final DoubleProperty mountainRangeOffsetProperty() {
        return this.mountainRangeOffset;
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        if (!(xyChart.getYAxis() instanceof Axis)) {
            throw new InvalidParameterException("y Axis not a Axis derivative, yAxis = " + xyChart.getYAxis());
        }
        Axis yAxis = xyChart.getYAxis();
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        this.zRangeMin = Double.MAX_VALUE;
        this.zRangeMax = -1.7976931348623157E308;
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (!(dataSet instanceof DataSet3D)) continue;
            dataSet.lock().readLockGuardOptimistic(() -> {
                DataSet3D mData = (DataSet3D)dataSet;
                this.xWeakIndexMap.clear();
                this.yWeakIndexMap.clear();
                this.zRangeMin = Math.min(this.zRangeMin, mData.getAxisDescription(2).getMin());
                this.zRangeMax = Math.max(this.zRangeMin, mData.getAxisDescription(2).getMax());
                this.mountainRaingeExtra = this.getMountainRangeOffset();
                double min = this.zRangeMin;
                double max = this.zRangeMax * (1.0 + this.mountainRaingeExtra);
                boolean autoRange = yAxis.isAutoRanging();
                if (autoRange && (min != yAxis.getMin() || max != yAxis.getMax())) {
                    yAxis.setAutoRanging(false);
                    yAxis.setMin(min);
                    yAxis.setMax(max);
                    yAxis.setTickUnit(Math.abs(max - min) / 10.0);
                    yAxis.forceRedraw();
                }
                yAxis.setAutoRanging(autoRange);
                int yCountMax = mData.getDataCount(1);
                this.checkAndRecreateRenderer(yCountMax);
                for (int index = yCountMax - 1; index >= 0; --index) {
                    ((ErrorDataSetRenderer)this.renderers.get(index)).getDatasets().setAll((Object[])new DataSet[]{new Demux3dTo2dDataSet(mData, index)});
                    ((ErrorDataSetRenderer)this.renderers.get(index)).render(gc, chart, 0, this.empty);
                }
            });
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    public final MountainRangeRenderer setMountainRangeOffset(double mountainRangeOffset) {
        AssertUtils.gtEqThanZero((String)"mountainRangeOffset", (double)mountainRangeOffset);
        this.mountainRangeOffset.setValue((Number)mountainRangeOffset);
        return this;
    }

    private class Demux3dTo2dDataSet
    implements DataSet2D,
    DataSetError {
        private static final long serialVersionUID = 3914728138839091421L;
        private final transient DataSetLock<DataSet> lock = new DefaultDataSetLock((DataSet)this);
        private final AtomicBoolean autoNotification = new AtomicBoolean(true);
        private final DataSet3D dataSet;
        private final int yIndex;
        private final int yMax;
        private double yShift;
        private final transient List<EventListener> updateListener = new ArrayList<EventListener>();
        private final transient List<AxisDescription> axesDescriptions = new ArrayList<DefaultAxisDescription>(Arrays.asList(new DefaultAxisDescription("x-Axis", new String[]{"a.u."}), new DefaultAxisDescription("y-Axis", new String[]{"a.u."})));

        public Demux3dTo2dDataSet(DataSet3D sourceDataSet, int selectedYIndex) {
            this.dataSet = sourceDataSet;
            this.yIndex = selectedYIndex;
            this.yMax = this.dataSet.getDataCount(1);
            this.yShift = 0.0;
            AxisDescription xAxis = this.dataSet.getAxisDescription(0);
            this.dataSet.addListener(evt -> {
                this.getAxisDescription(0).set(xAxis.getName(), xAxis.getUnit(), xAxis.getMin(), xAxis.getMax());
                this.setYMax(this.dataSet.getAxisDescription(2));
            });
            this.setYMax(this.dataSet.getAxisDescription(2));
        }

        public AtomicBoolean autoNotification() {
            return this.autoNotification;
        }

        public double get(int dimIndex, int i) {
            return dimIndex == 1 ? this.getY(i) : this.dataSet.get(dimIndex, i);
        }

        public List<AxisDescription> getAxisDescriptions() {
            return this.axesDescriptions;
        }

        public int getDataCount() {
            return this.dataSet.getDataCount(0);
        }

        public int getDataCount(int dimIndex) {
            return this.getDataCount();
        }

        public String getDataLabel(int index) {
            return this.dataSet.getDataLabel(index);
        }

        public double getErrorNegative(int dimIndex, int index) {
            return 0.0;
        }

        public double getErrorPositive(int dimIndex, int index) {
            return 0.0;
        }

        public DataSetError.ErrorType getErrorType(int dimIndex) {
            switch (dimIndex) {
                case 0: {
                    return DataSetError.ErrorType.NO_ERROR;
                }
                case 1: {
                    return DataSetError.ErrorType.SYMMETRIC;
                }
            }
            throw new IndexOutOfBoundsException("DataSet only 2-dimensional");
        }

        public String getName() {
            return this.dataSet.getName() + ":slice#" + this.yIndex;
        }

        public String getStyle() {
            return this.dataSet.getStyle();
        }

        public String getStyle(int index) {
            return null;
        }

        public double getX(int i) {
            return this.dataSet.get(0, i);
        }

        public double getY(int i) {
            return this.dataSet.getZ(i, this.yIndex) + this.yShift;
        }

        public boolean isAutoNotification() {
            return this.autoNotification.get();
        }

        public DataSetLock<DataSet> lock() {
            return this.lock;
        }

        public DataSet recomputeLimits(int dimension) {
            this.setYMax(this.dataSet.getAxisDescription(2));
            this.notifyRangeChange();
            return this;
        }

        public DataSet setStyle(String style) {
            return this.dataSet.setStyle(style);
        }

        private final void setYMax(AxisDescription zAxis) {
            this.yShift = MountainRangeRenderer.this.mountainRaingeExtra * zAxis.getMax() * (double)this.yIndex / (double)this.yMax;
            this.getAxisDescription(1).set(zAxis.getName(), zAxis.getUnit(), zAxis.getMin(), MountainRangeRenderer.this.zRangeMax * (1.0 + MountainRangeRenderer.this.mountainRaingeExtra));
        }

        private final void notifyRangeChange() {
            if (this.dataSet == null || !this.dataSet.autoNotification().get()) {
                return;
            }
            String name = this.getAxisDescription(1).getName();
            String unit = this.getAxisDescription(1).getUnit();
            this.dataSet.invokeListener((UpdateEvent)new AxisRangeChangeEvent((EventSource)this.dataSet, "updated axis range for '" + name + "' '[" + unit + "]'", -1));
        }

        public List<EventListener> updateEventListener() {
            return this.updateListener;
        }

        public int getIndex(int dimIndex, double value) {
            switch (dimIndex) {
                case 0: {
                    return MountainRangeRenderer.this.xWeakIndexMap.computeIfAbsent(value, key -> {
                        Integer ret = this.dataSet.getXIndex(value);
                        MountainRangeRenderer.this.xWeakIndexMap.put(value, ret);
                        return ret;
                    });
                }
                case 1: {
                    return MountainRangeRenderer.this.yWeakIndexMap.computeIfAbsent(value, key -> {
                        Integer ret = this.dataSet.getYIndex(value);
                        MountainRangeRenderer.this.yWeakIndexMap.put(value, ret);
                        return ret;
                    });
                }
            }
            throw new IndexOutOfBoundsException("dimIndex=" + dimIndex + " out of range");
        }
    }
}

