/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.utils.ArrayCache;
import de.gsi.dataset.utils.CachedDaemonThreadFactory;
import de.gsi.dataset.utils.ProcessingProfiler;
import de.gsi.math.ArrayUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class CachedDataPoints {
    private static final String STYLES2 = "styles";
    private static final String SELECTED2 = "selected";
    private static final String ERROR_X_POS = "errorXPos";
    private static final String ERROR_X_NEG = "errorXNeg";
    private static final String ERROR_Y_POS = "errorYPos";
    private static final String ERROR_Y_NEG = "errorYNeg";
    private static final String Y_VALUES = "yValues";
    private static final String X_VALUES = "xValues";
    private static final double DEG_TO_RAD = Math.PI / 180;
    protected double[] xValues;
    protected double[] yValues;
    protected double[] errorXNeg;
    protected double[] errorXPos;
    protected double[] errorYNeg;
    protected double[] errorYPos;
    protected boolean[] selected;
    protected String[] styles;
    protected boolean xAxisInverted;
    protected boolean yAxisInverted;
    protected String defaultStyle;
    protected int dataSetIndex;
    protected int dataSetStyleIndex;
    protected boolean allowForNaNs;
    protected DataSetError.ErrorType[] errorType;
    protected int indexMin;
    protected int indexMax;
    protected int minDistanceX = Integer.MAX_VALUE;
    protected double xZero;
    protected double yZero;
    protected double yMin;
    protected double yMax;
    protected double xMin;
    protected double xMax;
    protected boolean polarPlot;
    protected ErrorStyle rendererErrorStyle;
    protected double xRange;
    protected double yRange;
    protected double maxRadius;
    protected int maxDataCount;
    protected int actualDataCount;

    public CachedDataPoints(int indexMin, int indexMax, int dataLength, boolean full) {
        this.maxDataCount = dataLength;
        this.xValues = ArrayCache.getCachedDoubleArray((String)X_VALUES, (int)this.maxDataCount);
        this.yValues = ArrayCache.getCachedDoubleArray((String)Y_VALUES, (int)this.maxDataCount);
        this.styles = ArrayCache.getCachedStringArray((String)STYLES2, (int)dataLength);
        this.indexMin = indexMin;
        this.indexMax = indexMax;
        this.errorYNeg = ArrayCache.getCachedDoubleArray((String)ERROR_Y_NEG, (int)this.maxDataCount);
        this.errorYPos = ArrayCache.getCachedDoubleArray((String)ERROR_Y_POS, (int)this.maxDataCount);
        if (full) {
            this.errorXNeg = ArrayCache.getCachedDoubleArray((String)ERROR_X_NEG, (int)this.maxDataCount);
            this.errorXPos = ArrayCache.getCachedDoubleArray((String)ERROR_X_POS, (int)this.maxDataCount);
        }
        this.selected = ArrayCache.getCachedBooleanArray((String)SELECTED2, (int)dataLength);
        ArrayUtils.fillArray((Object[])this.styles, null);
    }

    protected void computeBoundaryVariables(Axis xAxis, Axis yAxis) {
        this.xAxisInverted = xAxis.isInvertedAxis();
        this.yAxisInverted = yAxis.isInvertedAxis();
        this.xZero = xAxis.isLogAxis() ? xAxis.getDisplayPosition(xAxis.getMin()) : xAxis.getDisplayPosition(0.0);
        this.yZero = yAxis.isLogAxis() ? yAxis.getDisplayPosition(yAxis.getMin()) : yAxis.getDisplayPosition(0.0);
        this.yMin = yAxis.getDisplayPosition(yAxis.getMin());
        this.yMax = yAxis.getDisplayPosition(yAxis.getMax());
        this.xMin = xAxis.getDisplayPosition(xAxis.getMin());
        this.xMax = xAxis.getDisplayPosition(xAxis.getMax());
        this.xRange = Math.abs(this.xMax - this.xMin);
        this.yRange = Math.abs(this.yMax - this.yMin);
        this.maxRadius = 0.5 * Math.max(Math.min(this.xRange, this.yRange), 20.0) * 0.9;
        if (this.polarPlot) {
            this.xZero = 0.5 * this.xRange;
            this.yZero = 0.5 * this.yRange;
        }
    }

    private void computeErrorStyles(DataSet dataSet, int min, int max) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            for (int index = min; index < max; ++index) {
                this.styles[index] = dataSet.getStyle(index);
            }
        });
    }

    private void computeFullPolar(Axis yAxis, DataSetError dataSet, int min, int max) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            for (int index = min; index < max; ++index) {
                double x = dataSet.get(0, index);
                double y = dataSet.get(1, index);
                double phi = x * (Math.PI / 180);
                double r = this.maxRadius * Math.abs(1.0 - yAxis.getDisplayPosition(y) / this.yRange);
                this.xValues[index] = this.xZero + r * Math.cos(phi);
                this.yValues[index] = this.yZero + r * Math.sin(phi);
                this.errorXNeg[index] = 0.0;
                this.errorXPos[index] = 0.0;
                this.errorYNeg[index] = 0.0;
                this.errorYPos[index] = 0.0;
                if (!Double.isFinite(this.yValues[index])) {
                    this.yValues[index] = this.yZero;
                }
                this.styles[index] = dataSet.getStyle(index);
            }
        });
    }

    private void computeNoErrorPolar(Axis yAxis, DataSet2D dataSet, int min, int max) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            for (int index = min; index < max; ++index) {
                double x = dataSet.get(0, index);
                double y = dataSet.get(1, index);
                double phi = x * (Math.PI / 180);
                double r = this.maxRadius * Math.abs(1.0 - yAxis.getDisplayPosition(y) / this.yRange);
                this.xValues[index] = this.xZero + r * Math.cos(phi);
                this.yValues[index] = this.yZero + r * Math.sin(phi);
                if (!Double.isFinite(this.yValues[index])) {
                    this.yValues[index] = this.yZero;
                }
                this.styles[index] = dataSet.getStyle(index);
            }
        });
    }

    protected void computeScreenCoordinates(Axis xAxis, Axis yAxis, DataSet dataSet, int dsIndex, int min, int max, ErrorStyle localRendErrorStyle, boolean isPolarPlot, boolean doAllowForNaNs) {
        this.setBoundaryConditions(xAxis, yAxis, dataSet, dsIndex, min, max, localRendErrorStyle, isPolarPlot, doAllowForNaNs);
        this.computeScreenCoordinatesNonThreaded(xAxis, yAxis, dataSet, min, max);
    }

    private void computeScreenCoordinatesEuclidean(Axis xAxis, Axis yAxis, DataSet dataSet, int min, int max) {
        block3: for (int dimIndex = 0; dimIndex < 2; ++dimIndex) {
            switch (this.errorType[dimIndex]) {
                case NO_ERROR: {
                    if (this.allowForNaNs) {
                        this.computeWithNoErrorAllowingNaNs(dimIndex == 0 ? xAxis : yAxis, dataSet, dimIndex, min, max);
                        continue block3;
                    }
                    this.computeWithNoError(dimIndex == 0 ? xAxis : yAxis, dataSet, dimIndex, min, max);
                    continue block3;
                }
                default: {
                    if (this.allowForNaNs) {
                        this.computeWithErrorAllowingNaNs(dimIndex == 0 ? xAxis : yAxis, dataSet, dimIndex, min, max);
                        continue block3;
                    }
                    this.computeWithError(dimIndex == 0 ? xAxis : yAxis, dataSet, dimIndex, min, max);
                }
            }
        }
        this.computeErrorStyles(dataSet, min, max);
    }

    protected void computeScreenCoordinatesInParallel(Axis xAxis, Axis yAxis, DataSet dataSet, int dsIndex, int min, int max, ErrorStyle localRendErrorStyle, boolean isPolarPlot, boolean doAllowForNaNs) {
        this.setBoundaryConditions(xAxis, yAxis, dataSet, dsIndex, min, max, localRendErrorStyle, isPolarPlot, doAllowForNaNs);
        this.computeScreenCoordinatesParallel(xAxis, yAxis, dataSet, min, max);
    }

    protected void computeScreenCoordinatesNonThreaded(Axis xAxis, Axis yAxis, DataSet dataSet, int min, int max) {
        if (this.polarPlot) {
            this.computeScreenCoordinatesPolar(yAxis, dataSet, min, max);
        } else {
            this.computeScreenCoordinatesEuclidean(xAxis, yAxis, dataSet, min, max);
        }
    }

    protected void computeScreenCoordinatesParallel(Axis xAxis, Axis yAxis, DataSet dataSet, int min, int max) {
        int minthreshold = 1000;
        int divThread = (int)Math.ceil((double)Math.abs(max - min) / (double)CachedDaemonThreadFactory.getNumbersOfThreads());
        int stepSize = Math.max(divThread, 1000);
        ArrayList<Callable<Boolean>> workers = new ArrayList<Callable<Boolean>>();
        for (int i = min; i < max; i += stepSize) {
            int start = i;
            workers.add(() -> {
                if (this.polarPlot) {
                    this.computeScreenCoordinatesPolar(yAxis, dataSet, start, Math.min(max, start + stepSize));
                } else {
                    this.computeScreenCoordinatesEuclidean(xAxis, yAxis, dataSet, start, Math.min(max, start + stepSize));
                }
                return Boolean.TRUE;
            });
        }
        try {
            List jobs = CachedDaemonThreadFactory.getCommonPool().invokeAll(workers);
            for (Future future : jobs) {
                Boolean r = (Boolean)future.get();
                if (r.booleanValue()) continue;
                throw new IllegalStateException("one parallel worker thread finished execution with error");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("one parallel worker thread finished execution with error", e);
        }
    }

    private void computeScreenCoordinatesPolar(Axis yAxis, DataSet dataSet, int min, int max) {
        if (!(dataSet instanceof DataSet2D)) {
            throw new IllegalStateException("non-DataSet2D implementation not yet propagated");
        }
        if (this.errorType[0] == DataSetError.ErrorType.NO_ERROR && this.errorType[1] == DataSetError.ErrorType.NO_ERROR) {
            this.computeNoErrorPolar(yAxis, (DataSet2D)dataSet, min, max);
        } else if (this.errorType[0] == DataSetError.ErrorType.NO_ERROR) {
            this.computeYonlyPolar(yAxis, (DataSet2D)dataSet, min, max);
        } else {
            DataSetError ds = (DataSetError)dataSet;
            this.computeFullPolar(yAxis, ds, min, max);
        }
    }

    private void computeWithError(Axis yAxis, DataSet dataSet, int dimIndex, int min, int max) {
        if (dataSet instanceof DataSetError) {
            dataSet.lock().readLockGuardOptimistic(() -> {
                double[] values = dimIndex == 0 ? this.xValues : this.yValues;
                double[] valuesEN = dimIndex == 0 ? this.errorXNeg : this.errorYNeg;
                double[] valuesEP = dimIndex == 0 ? this.errorXPos : this.errorYPos;
                double minValue = dimIndex == 0 ? this.xMin : this.yMin;
                DataSetError ds = (DataSetError)dataSet;
                for (int index = min; index < max; ++index) {
                    double value = dataSet.get(dimIndex, index);
                    values[index] = yAxis.getDisplayPosition(value);
                    if (!Double.isNaN(values[index])) {
                        valuesEN[index] = yAxis.getDisplayPosition(value - ds.getErrorNegative(dimIndex, index));
                        valuesEP[index] = yAxis.getDisplayPosition(value + ds.getErrorPositive(dimIndex, index));
                        continue;
                    }
                    values[index] = minValue;
                    valuesEN[index] = minValue;
                    valuesEP[index] = minValue;
                }
            });
            return;
        }
        dataSet.lock().readLockGuardOptimistic(() -> {
            double[] values = dimIndex == 0 ? this.xValues : this.yValues;
            double[] valuesEN = dimIndex == 0 ? this.errorXNeg : this.errorYNeg;
            double[] valuesEP = dimIndex == 0 ? this.errorXPos : this.errorYPos;
            double minValue = dimIndex == 0 ? this.xMin : this.yMin;
            for (int index = min; index < max; ++index) {
                values[index] = yAxis.getDisplayPosition(dataSet.get(dimIndex, index));
                if (Double.isFinite(values[index])) {
                    valuesEN[index] = values[index];
                    valuesEP[index] = values[index];
                    continue;
                }
                values[index] = minValue;
                valuesEN[index] = minValue;
                valuesEP[index] = minValue;
            }
        });
    }

    private void computeWithErrorAllowingNaNs(Axis yAxis, DataSet dataSet, int dimIndex, int min, int max) {
        if (dataSet instanceof DataSetError) {
            dataSet.lock().readLockGuardOptimistic(() -> {
                double[] values = dimIndex == 0 ? this.xValues : this.yValues;
                double[] valuesEN = dimIndex == 0 ? this.errorXNeg : this.errorYNeg;
                double[] valuesEP = dimIndex == 0 ? this.errorXPos : this.errorYPos;
                DataSetError ds = (DataSetError)dataSet;
                for (int index = min; index < max; ++index) {
                    double value = dataSet.get(dimIndex, index);
                    if (!Double.isFinite(value)) {
                        values[index] = Double.NaN;
                        valuesEN[index] = Double.NaN;
                        valuesEP[index] = Double.NaN;
                        continue;
                    }
                    values[index] = yAxis.getDisplayPosition(value);
                    valuesEN[index] = yAxis.getDisplayPosition(value - ds.getErrorNegative(dimIndex, index));
                    valuesEP[index] = yAxis.getDisplayPosition(value + ds.getErrorPositive(dimIndex, index));
                }
            });
            return;
        }
        dataSet.lock().readLockGuardOptimistic(() -> {
            double[] values = dimIndex == 0 ? this.xValues : this.yValues;
            double[] valuesEN = dimIndex == 0 ? this.errorXNeg : this.errorYNeg;
            double[] valuesEP = dimIndex == 0 ? this.errorXPos : this.errorYPos;
            for (int index = min; index < max; ++index) {
                values[index] = yAxis.getDisplayPosition(dataSet.get(dimIndex, index));
                if (Double.isFinite(values[index])) {
                    valuesEN[index] = values[index];
                    valuesEP[index] = values[index];
                    continue;
                }
                values[index] = Double.NaN;
                valuesEN[index] = Double.NaN;
                valuesEP[index] = Double.NaN;
            }
        });
    }

    private void computeWithNoError(Axis axis, DataSet dataSet, int dimIndex, int min, int max) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            double[] values = dimIndex == 0 ? this.xValues : this.yValues;
            double minValue = dimIndex == 0 ? this.xMin : this.yMin;
            for (int index = min; index < max; ++index) {
                double value = dataSet.get(dimIndex, index);
                values[index] = axis.getDisplayPosition(value);
                if (!Double.isNaN(values[index])) continue;
                this.yValues[index] = minValue;
            }
            if (dimIndex == 1 && this.rendererErrorStyle != ErrorStyle.NONE) {
                System.arraycopy(values, min, this.errorYNeg, min, max - min);
                System.arraycopy(values, min, this.errorYPos, min, max - min);
            }
        });
    }

    private void computeWithNoErrorAllowingNaNs(Axis axis, DataSet dataSet, int dimIndex, int min, int max) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            double[] values = dimIndex == 0 ? this.xValues : this.yValues;
            for (int index = min; index < max; ++index) {
                double value = dataSet.get(dimIndex, index);
                values[index] = Double.isFinite(value) ? axis.getDisplayPosition(value) : Double.NaN;
            }
            if (dimIndex == 1 && this.rendererErrorStyle != ErrorStyle.NONE) {
                System.arraycopy(values, min, this.errorYNeg, min, max - min);
                System.arraycopy(values, min, this.errorYPos, min, max - min);
            }
        });
    }

    private void computeYonlyPolar(Axis yAxis, DataSet2D dataSet, int min, int max) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            for (int index = min; index < max; ++index) {
                double x = dataSet.get(0, index);
                double y = dataSet.get(1, index);
                double phi = x * (Math.PI / 180);
                double r = this.maxRadius * Math.abs(1.0 - yAxis.getDisplayPosition(y) / this.yRange);
                this.xValues[index] = this.xZero + r * Math.cos(phi);
                this.yValues[index] = this.yZero + r * Math.sin(phi);
                this.errorXNeg[index] = 0.0;
                this.errorXPos[index] = 0.0;
                this.errorYNeg[index] = 0.0;
                this.errorYPos[index] = 0.0;
                if (!Double.isFinite(this.yValues[index])) {
                    this.yValues[index] = this.yZero;
                }
                this.styles[index] = dataSet.getStyle(index);
            }
        });
    }

    protected int getMinXDistance() {
        if (this.minDistanceX < Integer.MAX_VALUE) {
            return this.minDistanceX;
        }
        if (this.indexMin >= this.indexMax) {
            this.minDistanceX = 1;
            return this.minDistanceX;
        }
        this.minDistanceX = Integer.MAX_VALUE;
        for (int i = 1; i < this.actualDataCount; ++i) {
            double x0 = this.xValues[i - 1];
            double x1 = this.xValues[i];
            this.minDistanceX = Math.min(this.minDistanceX, (int)Math.abs(x1 - x0));
        }
        return this.minDistanceX;
    }

    private int minDataPointDistanceX() {
        if (this.actualDataCount <= 1) {
            this.minDistanceX = 1;
            return this.minDistanceX;
        }
        this.minDistanceX = Integer.MAX_VALUE;
        for (int i = 1; i < this.actualDataCount; ++i) {
            double x0 = this.xValues[i - 1];
            double x1 = this.xValues[i];
            this.minDistanceX = Math.min(this.minDistanceX, (int)Math.abs(x1 - x0));
        }
        return this.minDistanceX;
    }

    protected void reduce(RendererDataReducer cruncher, boolean isReducePoints, int minRequiredReductionSize) {
        long startTimeStamp = ProcessingProfiler.getTimeStamp();
        this.actualDataCount = 1;
        if (!isReducePoints || Math.abs(this.indexMax - this.indexMin) < minRequiredReductionSize) {
            this.actualDataCount = this.indexMax - this.indexMin;
            System.arraycopy(this.xValues, this.indexMin, this.xValues, 0, this.actualDataCount);
            System.arraycopy(this.yValues, this.indexMin, this.yValues, 0, this.actualDataCount);
            System.arraycopy(this.selected, this.indexMin, this.selected, 0, this.actualDataCount);
            if (this.errorType[0] != DataSetError.ErrorType.NO_ERROR) {
                System.arraycopy(this.errorXNeg, this.indexMin, this.errorXNeg, 0, this.actualDataCount);
                System.arraycopy(this.errorXPos, this.indexMin, this.errorXPos, 0, this.actualDataCount);
                System.arraycopy(this.errorYNeg, this.indexMin, this.errorYNeg, 0, this.actualDataCount);
                System.arraycopy(this.errorYPos, this.indexMin, this.errorYPos, 0, this.actualDataCount);
            } else if (this.errorType[1] != DataSetError.ErrorType.NO_ERROR) {
                System.arraycopy(this.errorYNeg, this.indexMin, this.errorYNeg, 0, this.actualDataCount);
                System.arraycopy(this.errorYPos, this.indexMin, this.errorYPos, 0, this.actualDataCount);
            }
            ProcessingProfiler.getTimeDiff((long)startTimeStamp, (String)String.format("no data reduction (%d)", this.actualDataCount));
            return;
        }
        this.actualDataCount = this.errorType[0] == DataSetError.ErrorType.NO_ERROR ? cruncher.reducePoints(this.xValues, this.yValues, null, null, this.errorYPos, this.errorYNeg, this.styles, this.selected, this.indexMin, this.indexMax) : cruncher.reducePoints(this.xValues, this.yValues, this.errorXPos, this.errorXNeg, this.errorYPos, this.errorYNeg, this.styles, this.selected, this.indexMin, this.indexMax);
        this.minDataPointDistanceX();
    }

    public void release() {
        ArrayCache.release((String)X_VALUES, (double[])this.xValues);
        ArrayCache.release((String)Y_VALUES, (double[])this.yValues);
        ArrayCache.release((String)ERROR_Y_NEG, (double[])this.errorYNeg);
        ArrayCache.release((String)ERROR_Y_POS, (double[])this.errorYPos);
        ArrayCache.release((String)ERROR_X_NEG, (double[])this.errorXNeg);
        ArrayCache.release((String)ERROR_X_POS, (double[])this.errorXPos);
        ArrayCache.release((String)SELECTED2, (boolean[])this.selected);
        ArrayCache.release((String)STYLES2, (String[])this.styles);
    }

    private void setBoundaryConditions(Axis xAxis, Axis yAxis, DataSet dataSet, int dsIndex, int min, int max, ErrorStyle rendererErrorStyle, boolean isPolarPlot, boolean doAllowForNaNs) {
        this.indexMin = min;
        this.indexMax = max;
        this.polarPlot = isPolarPlot;
        this.allowForNaNs = doAllowForNaNs;
        this.rendererErrorStyle = rendererErrorStyle;
        this.computeBoundaryVariables(xAxis, yAxis);
        this.setStyleVariable(dataSet, dsIndex);
        this.setErrorType(dataSet, rendererErrorStyle);
    }

    protected void setErrorType(DataSet dataSet, ErrorStyle errorStyle) {
        this.errorType = new DataSetError.ErrorType[dataSet.getDimension()];
        if (dataSet instanceof DataSetError) {
            DataSetError ds = (DataSetError)dataSet;
            for (int dimIndex = 0; dimIndex < ds.getDimension(); ++dimIndex) {
                int tmpIndex = dimIndex;
                this.errorType[dimIndex] = (DataSetError.ErrorType)dataSet.lock().readLockGuardOptimistic(() -> ds.getErrorType(tmpIndex));
            }
        } else if (errorStyle == ErrorStyle.NONE) {
            for (int dimIndex = 0; dimIndex < dataSet.getDimension(); ++dimIndex) {
                this.errorType[dimIndex] = DataSetError.ErrorType.NO_ERROR;
            }
        } else {
            for (int dimIndex = 0; dimIndex < dataSet.getDimension(); ++dimIndex) {
                this.errorType[dimIndex] = dimIndex == 1 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.NO_ERROR;
            }
        }
    }

    protected void setStyleVariable(DataSet dataSet, int dsIndex) {
        dataSet.lock().readLockGuardOptimistic(() -> {
            this.defaultStyle = dataSet.getStyle();
            return this.defaultStyle;
        });
        Integer layoutOffset = StyleParser.getIntegerPropertyValue(this.defaultStyle, "dsLayoutOffset");
        Integer dsIndexLocal = StyleParser.getIntegerPropertyValue(this.defaultStyle, "dsIndex");
        this.dataSetStyleIndex = layoutOffset == null ? 0 : layoutOffset;
        this.dataSetIndex = dsIndexLocal == null ? dsIndex : dsIndexLocal;
    }
}

