/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.LineStyle;
import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.chart.renderer.datareduction.DefaultDataReducer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.chart.renderer.spi.AbstractPointReductionManagment;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public abstract class AbstractErrorDataSetRendererParameter<R extends AbstractErrorDataSetRendererParameter<R>>
extends AbstractPointReductionManagment<R> {
    protected static final double DEFAULT_HISTORY_INTENSITY_FADING = 0.65;
    private final ObjectProperty<ErrorStyle> errorStyle = new SimpleObjectProperty((Object)this, "errorStyle", (Object)ErrorStyle.ERRORCOMBO);
    private final ObjectProperty<RendererDataReducer> rendererDataReducer = new SimpleObjectProperty((Object)this, "rendererDataReducer", (Object)new DefaultDataReducer());
    private final IntegerProperty dashSize = new SimpleIntegerProperty((Object)this, "dashSize", 3);
    private final DoubleProperty markerSize = new SimpleDoubleProperty((Object)this, "markerSize", 1.5);
    private final BooleanProperty drawMarker = new SimpleBooleanProperty((Object)this, "drawMarker", true);
    private final ObjectProperty<LineStyle> polyLineStyle = new SimpleObjectProperty((Object)this, "polyLineStyle", (Object)LineStyle.NORMAL);
    private final BooleanProperty drawBars = new SimpleBooleanProperty((Object)this, "drawBars", false);
    private final BooleanProperty shiftBar = new SimpleBooleanProperty((Object)this, "shiftBar", true);
    private final IntegerProperty shiftBarOffset = new SimpleIntegerProperty((Object)this, "shiftBarOffset", 3);
    private final BooleanProperty dynamicBarWidth = new SimpleBooleanProperty((Object)this, "dynamicBarWidth", true);
    private final DoubleProperty barWidthPercentage = new SimpleDoubleProperty((Object)this, "barWidthPercentage", 70.0);
    private final IntegerProperty barWidth = new SimpleIntegerProperty((Object)this, "barWidth", 5);
    private final DoubleProperty intensityFading = new SimpleDoubleProperty((Object)this, "intensityFading", 0.65);
    private final BooleanProperty drawBubbles = new SimpleBooleanProperty((Object)this, "drawBubbles", false);
    private final BooleanProperty allowNaNs = new SimpleBooleanProperty((Object)this, "allowNans", false);

    public BooleanProperty allowNaNsProperty() {
        return this.allowNaNs;
    }

    public DoubleProperty barWidthPercentageProperty() {
        return this.barWidthPercentage;
    }

    public IntegerProperty barWidthProperty() {
        return this.barWidth;
    }

    protected R bind(R other) {
        this.errorStyleProperty().bind(((AbstractErrorDataSetRendererParameter)other).errorStyleProperty());
        this.pointReductionProperty().bind((ObservableValue)((AbstractPointReductionManagment)other).pointReductionProperty());
        this.assumeSortedDataProperty().bind((ObservableValue)((AbstractPointReductionManagment)other).assumeSortedDataProperty());
        this.dashSizeProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).dashSizeProperty());
        this.minRequiredReductionSizeProperty().bind((ObservableValue)((AbstractPointReductionManagment)other).minRequiredReductionSizeProperty());
        this.markerSizeProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).markerSizeProperty());
        this.drawMarkerProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).drawMarkerProperty());
        this.polyLineStyleProperty().bind(((AbstractErrorDataSetRendererParameter)other).polyLineStyleProperty());
        this.drawBarsProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).drawBarsProperty());
        this.drawBubblesProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).drawBubblesProperty());
        this.allowNaNsProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).allowNaNsProperty());
        this.shiftBarProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).shiftBarProperty());
        this.shiftBarOffsetProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).shiftBarOffsetProperty());
        this.dynamicBarWidthProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).dynamicBarWidthProperty());
        this.barWidthPercentageProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).barWidthPercentageProperty());
        this.barWidthProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).barWidthProperty());
        this.getAxes().setAll(((AbstractDataSetManagement)other).getAxes());
        this.intensityFadingProperty().bind((ObservableValue)((AbstractErrorDataSetRendererParameter)other).intensityFadingProperty());
        ((AbstractDataSetManagement)other).getAxes().addListener(change -> {
            while (change.next()) {
                this.getAxes().addAll((Collection)change.getAddedSubList());
                this.getAxes().removeAll((Collection)change.getRemoved());
            }
        });
        return (R)this.getThis();
    }

    public IntegerProperty dashSizeProperty() {
        return this.dashSize;
    }

    public BooleanProperty drawBarsProperty() {
        return this.drawBars;
    }

    public BooleanProperty drawBubblesProperty() {
        return this.drawBubbles;
    }

    public BooleanProperty drawMarkerProperty() {
        return this.drawMarker;
    }

    public BooleanProperty dynamicBarWidthProperty() {
        return this.dynamicBarWidth;
    }

    public ObjectProperty<ErrorStyle> errorStyleProperty() {
        return this.errorStyle;
    }

    public int getBarWidth() {
        return this.barWidth.get();
    }

    public double getBarWidthPercentage() {
        return this.barWidthPercentage.get();
    }

    public int getDashSize() {
        return this.dashSize.get();
    }

    public ErrorStyle getErrorType() {
        return (ErrorStyle)((Object)this.errorStyle.get());
    }

    public double getIntensityFading() {
        return this.intensityFading.get();
    }

    public double getMarkerSize() {
        return this.markerSize.get();
    }

    public LineStyle getPolyLineStyle() {
        return (LineStyle)((Object)this.polyLineStyleProperty().get());
    }

    public RendererDataReducer getRendererDataReducer() {
        return (RendererDataReducer)this.rendererDataReducer.get();
    }

    public int getShiftBarOffset() {
        return this.shiftBarOffset.get();
    }

    @Override
    protected abstract R getThis();

    public DoubleProperty intensityFadingProperty() {
        return this.intensityFading;
    }

    public boolean isallowNaNs() {
        return this.allowNaNs.get();
    }

    public boolean isDrawBars() {
        return this.drawBars.get();
    }

    public boolean isDrawBubbles() {
        return this.drawBubbles.get();
    }

    public boolean isDrawMarker() {
        return this.drawMarker.get();
    }

    public boolean isDynamicBarWidth() {
        return this.dynamicBarWidth.get();
    }

    public boolean isShiftBar() {
        return this.shiftBar.get();
    }

    public DoubleProperty markerSizeProperty() {
        return this.markerSize;
    }

    public ObjectProperty<LineStyle> polyLineStyleProperty() {
        return this.polyLineStyle;
    }

    public ObjectProperty<RendererDataReducer> rendererDataReducerProperty() {
        return this.rendererDataReducer;
    }

    public R setAllowNaNs(boolean state) {
        this.allowNaNs.set(state);
        return (R)this.getThis();
    }

    public R setBarWidth(int barWidth) {
        AssertUtils.gtEqThanZero((String)"barWidth", (int)barWidth);
        this.barWidth.setValue((Number)barWidth);
        return (R)this.getThis();
    }

    public R setBarWidthPercentage(double size) {
        AssertUtils.gtEqThanZero((String)"barWidthPercentage", (double)size);
        this.barWidthPercentage.setValue((Number)size);
        return (R)this.getThis();
    }

    public R setDashSize(int dashSize) {
        AssertUtils.gtEqThanZero((String)"dash size", (int)dashSize);
        this.dashSize.setValue((Number)dashSize);
        return (R)this.getThis();
    }

    public R setDrawBars(boolean state) {
        this.drawBars.set(state);
        return (R)this.getThis();
    }

    public R setDrawBubbles(boolean state) {
        this.drawBubbles.set(state);
        return (R)this.getThis();
    }

    public R setDrawMarker(boolean state) {
        this.drawMarker.set(state);
        return (R)this.getThis();
    }

    public R setDynamicBarWidth(boolean state) {
        this.dynamicBarWidth.set(state);
        return (R)this.getThis();
    }

    public R setErrorType(ErrorStyle style) {
        this.errorStyle.set((Object)style);
        return (R)this.getThis();
    }

    public R setIntensityFading(double size) {
        this.intensityFading.setValue((Number)size);
        return (R)this.getThis();
    }

    public R setMarkerSize(double size) {
        AssertUtils.gtEqThanZero((String)"marker size ", (double)size);
        this.markerSize.setValue((Number)size);
        return (R)this.getThis();
    }

    public R setPolyLineStyle(LineStyle style) {
        this.polyLineStyleProperty().set((Object)style);
        return (R)this.getThis();
    }

    public R setRendererDataReducer(RendererDataReducer algorithm) {
        if (algorithm == null) {
            this.rendererDataReducer.set((Object)new DefaultDataReducer());
        } else {
            this.rendererDataReducer.set((Object)algorithm);
        }
        return (R)this.getThis();
    }

    public R setShiftBar(boolean state) {
        this.shiftBar.set(state);
        return (R)this.getThis();
    }

    public R setshiftBarOffset(int shiftBarOffset) {
        AssertUtils.gtEqThanZero((String)"shiftBarOffset", (int)shiftBarOffset);
        this.shiftBarOffset.setValue((Number)shiftBarOffset);
        return (R)this.getThis();
    }

    public IntegerProperty shiftBarOffsetProperty() {
        return this.shiftBarOffset;
    }

    public BooleanProperty shiftBarProperty() {
        return this.shiftBar;
    }

    protected R unbind() {
        this.errorStyleProperty().unbind();
        this.pointReductionProperty().unbind();
        this.dashSizeProperty().unbind();
        this.minRequiredReductionSizeProperty().unbind();
        this.markerSizeProperty().unbind();
        this.drawMarkerProperty().unbind();
        this.polyLineStyleProperty().unbind();
        this.drawBarsProperty().unbind();
        this.drawBubblesProperty().unbind();
        this.allowNaNsProperty().unbind();
        this.shiftBarProperty().unbind();
        this.shiftBarOffsetProperty().unbind();
        this.dynamicBarWidthProperty().unbind();
        this.barWidthPercentageProperty().unbind();
        this.barWidthProperty().unbind();
        this.intensityFadingProperty().unbind();
        return (R)this.getThis();
    }
}

