/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.datareduction;

import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class DefaultDataReducer
implements RendererDataReducer {
    protected IntegerProperty minPointPixelDistance = new SimpleIntegerProperty(this, "minPixelDistance", 6){

        public void set(int value) {
            if (value < 0) {
                throw new InvalidParameterException("minPointPixelDistance " + value + " must be greater than zero");
            }
            super.set(value);
        }
    };

    public final int getMinPointPixelDistance() {
        return this.minPointPixelDistanceProperty().get();
    }

    public final IntegerProperty minPointPixelDistanceProperty() {
        return this.minPointPixelDistance;
    }

    @Override
    public int reducePoints(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        boolean yErrorNeg;
        AssertUtils.nonEmptyArray((String)"xValues", (double[])xValues);
        int defaultDataLength = xValues.length;
        AssertUtils.checkArrayDimension((String)"yValues", (double[])yValues, (int)defaultDataLength);
        AssertUtils.checkArrayDimension((String)"pointSelected", (boolean[])pointSelected, (int)defaultDataLength);
        AssertUtils.gtEqThanZero((String)"indexMax", (int)indexMin);
        AssertUtils.gtThanZero((String)"indexMax", (int)indexMax);
        boolean xErrorPos = xPointErrorsPos != null;
        boolean xErrorNeg = xPointErrorsNeg != null;
        boolean yErrorPos = yPointErrorsPos != null;
        boolean bl = yErrorNeg = yPointErrorsNeg != null;
        if (xErrorPos && xErrorNeg && yErrorPos && yErrorNeg) {
            AssertUtils.checkArrayDimension((String)"xPointErrorsPos", (double[])xPointErrorsPos, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"xPointErrorsNeg", (double[])xPointErrorsNeg, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"yPointErrorsPos", (double[])yPointErrorsPos, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"yPointErrorsNeg", (double[])yPointErrorsNeg, (int)defaultDataLength);
            return this.reducePointsInternal(xValues, yValues, xPointErrorsPos, xPointErrorsNeg, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, indexMin, indexMax);
        }
        if (yErrorPos && yErrorNeg) {
            AssertUtils.checkArrayDimension((String)"yPointErrorsPos", (double[])yPointErrorsPos, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"yPointErrorsNeg", (double[])yPointErrorsNeg, (int)defaultDataLength);
            return this.reducePointsInternal(xValues, yValues, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, indexMin, indexMax);
        }
        return this.reducePointsInternal(xValues, yValues, styles, pointSelected, indexMin, indexMax);
    }

    private int reducePointsInternal(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long start = ProcessingProfiler.getTimeStamp();
        int count = 0;
        int ncount = 0;
        double meanX = 0.0;
        double meanY = 0.0;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        String style = null;
        boolean sel = false;
        double xold = xValues[indexMin];
        double yold = yValues[indexMin];
        int minPixelDistance = this.getMinPointPixelDistance();
        xValues[count] = xValues[indexMin];
        yValues[count] = yValues[indexMin];
        xPointErrorsNeg[count] = xPointErrorsNeg[indexMin];
        xPointErrorsPos[count] = xPointErrorsPos[indexMin];
        yPointErrorsNeg[count] = yPointErrorsNeg[indexMin];
        yPointErrorsPos[count] = yPointErrorsPos[indexMin];
        pointSelected[count] = pointSelected[indexMin];
        styles[count] = styles[indexMin];
        ++count;
        for (int i = indexMin + 1; i < indexMax - 1; ++i) {
            double newXValue = xValues[i];
            double newYValue = yValues[i];
            boolean isNaN = Double.isNaN(newYValue);
            if (isNaN) {
                xValues[count] = newXValue;
                yValues[count] = Double.NaN;
                xPointErrorsNeg[count] = 0.0;
                xPointErrorsPos[count] = 0.0;
                yPointErrorsNeg[count] = Double.NaN;
                yPointErrorsPos[count] = Double.NaN;
                pointSelected[count] = sel;
                styles[count] = style;
                ++count;
                ncount = 0;
                continue;
            }
            int differenceInX = (int)Math.abs(xold - newXValue);
            int differenceInY = (int)Math.abs(yold - newYValue);
            if (differenceInX > minPixelDistance || differenceInY > minPixelDistance) {
                if (ncount > 0) {
                    if (ncount == 1) {
                        xValues[count] = (int)meanX;
                        yValues[count] = (int)meanY;
                    } else {
                        xValues[count] = (int)(meanX / (double)ncount);
                        yValues[count] = (int)(meanY / (double)ncount);
                    }
                    xPointErrorsNeg[count] = minX;
                    xPointErrorsPos[count] = maxX;
                    yPointErrorsNeg[count] = maxY;
                    yPointErrorsPos[count] = minY;
                    pointSelected[count] = sel;
                    styles[count] = style;
                    ++count;
                }
                meanX = newXValue;
                meanY = newYValue;
                xold = newXValue;
                yold = newYValue;
                minX = (int)xPointErrorsPos[i];
                maxX = (int)xPointErrorsNeg[i];
                minY = (int)yPointErrorsPos[i];
                maxY = (int)yPointErrorsNeg[i];
                sel |= pointSelected[i];
                style = styles[i];
                ncount = 1;
                continue;
            }
            meanX += newXValue;
            meanY += newYValue;
            minY = Math.min(minY, (int)yPointErrorsPos[i]);
            maxY = Math.max(maxY, (int)yPointErrorsNeg[i]);
            minX = Math.min(minX, (int)xPointErrorsPos[i]);
            maxX = Math.max(maxX, (int)xPointErrorsNeg[i]);
            sel |= pointSelected[i];
            ++ncount;
        }
        if (ncount > 0) {
            if (ncount == 1) {
                xValues[count] = (int)meanX;
                yValues[count] = (int)meanY;
            } else {
                xValues[count] = (int)(meanX / (double)ncount);
                yValues[count] = (int)(meanY / (double)ncount);
            }
            xPointErrorsNeg[count] = minX;
            xPointErrorsPos[count] = maxX;
            yPointErrorsNeg[count] = maxY;
            yPointErrorsPos[count] = minY;
            pointSelected[count] = sel;
            styles[count] = style;
            ++count;
        }
        xValues[count] = xValues[indexMax - 1];
        yValues[count] = yValues[indexMax - 1];
        xPointErrorsNeg[count] = xPointErrorsPos[indexMax - 1];
        xPointErrorsPos[count] = xPointErrorsNeg[indexMax - 1];
        yPointErrorsNeg[count] = yPointErrorsPos[indexMax - 1];
        yPointErrorsPos[count] = yPointErrorsNeg[indexMax - 1];
        pointSelected[count] = pointSelected[indexMax - 1];
        styles[count] = styles[indexMax - 1];
        ++count;
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start, (String)String.format("data reduction (full-xy error definitions: from %d to %d)", indexMax - indexMin, count));
        }
        return count;
    }

    private int reducePointsInternal(double[] xValues, double[] yValues, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long start = ProcessingProfiler.getTimeStamp();
        int count = 0;
        int ncount = 0;
        double meanX = 0.0;
        double meanY = 0.0;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        String style = null;
        boolean sel = false;
        double xold = xValues[indexMin];
        double yold = yValues[indexMin];
        int minPixelDistance = this.getMinPointPixelDistance();
        xValues[count] = xValues[indexMin];
        yValues[count] = yValues[indexMin];
        yPointErrorsNeg[count] = yPointErrorsNeg[indexMin];
        yPointErrorsPos[count] = yPointErrorsPos[indexMin];
        pointSelected[count] = pointSelected[indexMin];
        styles[count] = styles[indexMin];
        ++count;
        for (int i = indexMin + 1; i < indexMax - 1; ++i) {
            double newXValue = xValues[i];
            double newYValue = yValues[i];
            boolean isNaN = Double.isNaN(newYValue);
            if (isNaN) {
                xValues[count] = newXValue;
                yValues[count] = Double.NaN;
                yPointErrorsNeg[count] = Double.NaN;
                yPointErrorsPos[count] = Double.NaN;
                pointSelected[count] = sel;
                styles[count] = style;
                ++count;
                ncount = 0;
                continue;
            }
            int differenceInX = (int)Math.abs(xold - newXValue);
            int differenceInY = (int)Math.abs(yold - newYValue);
            if (differenceInX > minPixelDistance || differenceInY > minPixelDistance) {
                if (ncount > 0) {
                    if (ncount == 1) {
                        xValues[count] = (int)meanX;
                        yValues[count] = (int)meanY;
                    } else {
                        xValues[count] = (int)(meanX / (double)ncount);
                        yValues[count] = (int)(meanY / (double)ncount);
                    }
                    yPointErrorsNeg[count] = maxY;
                    yPointErrorsPos[count] = minY;
                    pointSelected[count] = sel;
                    styles[count] = style;
                    ++count;
                }
                meanX = newXValue;
                meanY = newYValue;
                xold = newXValue;
                yold = newYValue;
                minY = (int)yPointErrorsPos[i];
                maxY = (int)yPointErrorsNeg[i];
                sel |= pointSelected[i];
                style = styles[i];
                ncount = 1;
                continue;
            }
            meanX += newXValue;
            meanY += newYValue;
            minY = Math.min(minY, (int)yPointErrorsPos[i]);
            maxY = Math.max(maxY, (int)yPointErrorsNeg[i]);
            sel |= pointSelected[i];
            ++ncount;
        }
        if (ncount > 0) {
            if (ncount == 1) {
                xValues[count] = (int)meanX;
                yValues[count] = (int)meanY;
            } else {
                xValues[count] = (int)(meanX / (double)ncount);
                yValues[count] = (int)(meanY / (double)ncount);
            }
            yPointErrorsNeg[count] = maxY;
            yPointErrorsPos[count] = minY;
            pointSelected[count] = sel;
            styles[count] = style;
            ++count;
        }
        xValues[count] = xValues[indexMax - 1];
        yValues[count] = yValues[indexMax - 1];
        yPointErrorsNeg[count] = yPointErrorsPos[indexMax - 1];
        yPointErrorsPos[count] = yPointErrorsNeg[indexMax - 1];
        pointSelected[count] = pointSelected[indexMax - 1];
        styles[count] = styles[indexMax - 1];
        ++count;
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start, (String)String.format("only-y error definitions: data reduction (from %d to %d)", indexMax - indexMin, count));
        }
        return count;
    }

    private int reducePointsInternal(double[] xValues, double[] yValues, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long start = ProcessingProfiler.getTimeStamp();
        int count = 0;
        int ncount = 0;
        double meanX = 0.0;
        double meanY = 0.0;
        String style = null;
        boolean sel = false;
        double xold = xValues[indexMin];
        double yold = yValues[indexMin];
        int minPixelDistance = this.getMinPointPixelDistance();
        xValues[count] = xValues[indexMin];
        yValues[count] = yValues[indexMin];
        pointSelected[count] = pointSelected[indexMin];
        styles[count] = styles[indexMin];
        ++count;
        for (int i = indexMin + 1; i < indexMax - 1; ++i) {
            double newXValue = xValues[i];
            double newYValue = yValues[i];
            boolean isNaN = Double.isNaN(newYValue);
            if (isNaN) {
                xValues[count] = newXValue;
                yValues[count] = Double.NaN;
                pointSelected[count] = sel;
                styles[count] = style;
                ++count;
                ncount = 0;
                continue;
            }
            int differenceInX = (int)Math.abs(xold - newXValue);
            int differenceInY = (int)Math.abs(yold - newYValue);
            if (differenceInX > minPixelDistance || differenceInY > minPixelDistance) {
                if (ncount > 0 || isNaN) {
                    if (ncount == 1) {
                        xValues[count] = (int)meanX;
                        yValues[count] = (int)meanY;
                    } else {
                        xValues[count] = (int)(meanX / (double)ncount);
                        yValues[count] = (int)(meanY / (double)ncount);
                    }
                    pointSelected[count] = sel;
                    styles[count] = style;
                    ++count;
                }
                meanX = newXValue;
                meanY = newYValue;
                xold = newXValue;
                yold = newYValue;
                sel |= pointSelected[i];
                style = styles[i];
                ncount = 1;
                continue;
            }
            meanX += newXValue;
            meanY += newYValue;
            sel |= pointSelected[i];
            ++ncount;
        }
        if (ncount > 0) {
            if (ncount == 1) {
                xValues[count] = (int)meanX;
                yValues[count] = (int)meanY;
            } else {
                xValues[count] = (int)(meanX / (double)ncount);
                yValues[count] = (int)(meanY / (double)ncount);
            }
            pointSelected[count] = sel;
            styles[count] = style;
            ++count;
        }
        xValues[count] = xValues[indexMax - 1];
        yValues[count] = yValues[indexMax - 1];
        pointSelected[count] = pointSelected[indexMax - 1];
        styles[count] = styles[indexMax - 1];
        ++count;
        if (ProcessingProfiler.getDebugState()) {
            ProcessingProfiler.getTimeDiff((long)start, (String)String.format("data reduction (no error definitions: from %d to %d)", indexMax - indexMin, count));
        }
        return count;
    }

    public final void setMinPointPixelDistance(int minPixelDistance) {
        this.minPointPixelDistanceProperty().setValue((Number)minPixelDistance);
    }
}

