/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import de.gsi.chart.XYChart;
import de.gsi.dataset.DataSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.layout.HBox;

public class DataSetSelector
extends HBox {
    private static final int DEFAULT_SELECTOR_HEIGHT = 50;
    protected final ListView<DataSet> dataSets;
    protected final ObservableList<DataSet> allDataSets;

    public DataSetSelector(XYChart chart) {
        Label label = new Label("Selected Dataset:");
        this.allDataSets = FXCollections.observableArrayList(chart.getAllDatasets());
        this.dataSets = new ListView(this.allDataSets);
        this.dataSets.setOrientation(Orientation.VERTICAL);
        this.dataSets.setPrefSize(-1.0, 50.0);
        MultipleSelectionModel selModel = this.dataSets.getSelectionModel();
        if (!this.allDataSets.isEmpty() && selModel != null) {
            selModel.select(0);
        }
        this.dataSets.setCellFactory(list -> new DataSetLabel());
        this.getChildren().addAll((Object[])new Node[]{label, this.dataSets});
    }

    public int getNumberDataSets() {
        return this.allDataSets.size();
    }

    public DataSet getSelectedDataSet() {
        MultipleSelectionModel selModel = this.dataSets.getSelectionModel();
        if (selModel == null) {
            return null;
        }
        return (DataSet)selModel.getSelectedItem();
    }

    protected static class DataSetLabel
    extends ListCell<DataSet> {
        protected DataSetLabel() {
        }

        public void updateItem(DataSet item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.getName());
            }
        }
    }
}

