/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements.utils;

import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CheckedNumberTextField
extends TextField {
    private static final String NUMBER_REGEX = "[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";

    public CheckedNumberTextField(double initialValue) {
        super(Double.toString(initialValue));
        ValidationSupport support = new ValidationSupport();
        Validator validator = (control, value) -> {
            boolean condition = value == null || !value.matches(NUMBER_REGEX) && !CheckedNumberTextField.isNumberInfinity(value);
            this.setStyle(condition ? "-fx-text-inner-color: red;" : "-fx-text-inner-color: black;");
            return ValidationResult.fromMessageIf((Control)control, (String)"not a number", (Severity)Severity.ERROR, (boolean)condition);
        };
        support.registerValidator((Control)this, true, validator);
        this.snappedTopInset();
        this.snappedBottomInset();
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
    }

    public double getValue() {
        try {
            return Double.parseDouble(this.getText());
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    private static boolean isNumberInfinity(String value) {
        return value.toUpperCase().contains("INFINITY");
    }
}

