/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.XValueIndicator;
import de.gsi.chart.plugins.YValueIndicator;
import de.gsi.chart.plugins.measurements.AbstractChartMeasurement;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.UpdateEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import org.controlsfx.tools.Borders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueIndicator
extends AbstractChartMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueIndicator.class);
    protected static final int SMALL_FORMAT_THRESHOLD = 3;
    private static final String FORMAT_SMALL_SCALE = "0.###";
    private static final String FORMAT_LARGE_SCALE = "0.##E0";
    public static final int DEFAULT_SMALL_AXIS = 6;
    protected final DecimalFormat formatterSmall = new DecimalFormat("0.###");
    protected final DecimalFormat formatterLarge = new DecimalFormat("0.##E0");
    protected AbstractSingleValueIndicator sliderIndicator1;
    protected AbstractSingleValueIndicator sliderIndicator2;
    protected AxisMode axisMode;
    protected NumberFormat formatter;

    public ValueIndicator(XYChart chart, AxisMode axisMode) {
        super(chart);
        Axis axis;
        this.axisMode = axisMode;
        Axis axis2 = axis = axisMode == AxisMode.X ? chart.getXAxis() : chart.getYAxis();
        if (!(axis instanceof Axis)) {
            LOGGER.warn("axis type " + axis.getClass().getSimpleName() + "not compatible with indicator (needs to derivce from Axis)");
            return;
        }
        Axis numAxis = axis;
        this.formatter = this.formatterSmall;
        this.getDialogContentBox().getChildren().addAll((Object[])new Node[]{new HBox(new Node[]{new Label("Min. Range: "), this.valueField.getMinRangeTextField()}), new HBox(new Node[]{new Label("Max. Range: "), this.valueField.getMaxRangeTextField()})});
        double lower = numAxis.getMin();
        double upper = numAxis.getMax();
        double middle = 0.5 * Math.abs(upper - lower) + Math.min(lower, upper);
        if (axisMode == AxisMode.X) {
            this.sliderIndicator1 = new XValueIndicator(numAxis, middle);
            this.sliderIndicator2 = new XValueIndicator(numAxis, middle);
        } else {
            this.sliderIndicator1 = new YValueIndicator(numAxis, middle);
            this.sliderIndicator2 = new YValueIndicator(numAxis, middle);
        }
        this.sliderIndicator1.setText("Marker#" + AbstractChartMeasurement.markerCount);
        chart.getPlugins().add((Object)this.sliderIndicator1);
        this.title = "Value@Marker#" + (++AbstractChartMeasurement.markerCount - 1);
        chart.requestLayout();
    }

    @Override
    protected void defaultAction() {
        super.defaultAction();
        this.valueField.resetRanges();
    }

    public void handle(UpdateEvent observable) {
        String valueLabel;
        if (!Platform.isFxApplicationThread()) {
            FXUtils.runFX(() -> this.handle(observable));
            return;
        }
        DataSet selectedDataSet = this.getDataSet();
        double newValue = this.sliderIndicator1.getValue();
        int index = selectedDataSet.getIndex(this.axisMode == AxisMode.X ? 0 : 1, newValue);
        double val = selectedDataSet.get(this.axisMode == AxisMode.X ? 1 : 0, index);
        Axis axis = this.axisMode == AxisMode.X ? this.chart.getYAxis() : this.chart.getXAxis();
        this.valueField.setUnit(axis.getUnit() == null ? "" : axis.getUnit());
        if (axis instanceof DefaultNumericAxis) {
            AxisLabelFormatter axisFormatter = ((DefaultNumericAxis)axis).getAxisLabelFormatter();
            valueLabel = axisFormatter.toString(val);
        } else {
            this.formatter = Math.abs(Math.log10(Math.abs(val))) < 3.0 ? this.formatterSmall : this.formatterLarge;
            valueLabel = this.formatter.format(val);
        }
        this.valueField.setValue(val, valueLabel);
    }

    @Override
    public void initialize() {
        Node node = Borders.wrap((Node)this.valueField).lineBorder().title(this.title).color(Color.BLACK).build().build();
        node.setMouseTransparent(true);
        this.displayPane.getChildren().add((Object)node);
        this.sliderIndicator1.valueProperty().addListener((ch, oldValue, newValue) -> {
            if (oldValue != newValue) {
                FXUtils.runFX(() -> this.handle(null));
            }
        });
        super.showConfigDialogue();
        FXUtils.runFX(() -> {
            this.handle(null);
            this.chart.requestLayout();
        });
    }

    @Override
    protected void nominalAction() {
        super.nominalAction();
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.chart.getPlugins().remove((Object)this.sliderIndicator1);
        this.chart.requestLayout();
    }
}

