/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.plugins.measurements.utils.CheckedValueField;
import de.gsi.chart.plugins.measurements.utils.DataSetSelector;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import impl.org.controlsfx.skin.DecorationPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;

public abstract class AbstractChartMeasurement
implements EventListener {
    protected static final int PREFERRED_WIDTH = 300;
    protected static int markerCount;
    protected XYChart chart;
    protected final CheckedValueField valueField = new CheckedValueField();
    protected String title;
    private DataSet dataSet;
    protected VBox displayPane = new VBox();
    protected final Alert alert;
    protected final ButtonType buttonOK = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
    protected final ButtonType buttonDefault = new ButtonType("Defaults", ButtonBar.ButtonData.OK_DONE);
    protected final ButtonType buttonRemove = new ButtonType("Remove");
    protected final DataSetSelector dataSetSelector;
    protected final VBox vBox = new VBox();

    public AbstractChartMeasurement(Chart chart) {
        if (chart == null) {
            throw new IllegalArgumentException("chart is null");
        }
        if (!(chart instanceof XYChart)) {
            throw new IllegalArgumentException("not (yet) designed for non XYCharts - type is " + ((Object)((Object)chart)).getClass().getSimpleName());
        }
        this.chart = (XYChart)chart;
        this.title = this.getClass().getSimpleName();
        this.dataSet = null;
        VBox.setMargin((Node)this.displayPane, (Insets)Insets.EMPTY);
        chart.getMeasurementBar(chart.getMeasurementBarSide()).getChildren().addAll((Object[])new Node[]{this.displayPane, new Pane()});
        this.alert = new Alert(Alert.AlertType.CONFIRMATION);
        this.alert.setTitle("Measurement Config Dialog");
        this.alert.setHeaderText("Please, select data set and/or other parameters:");
        this.alert.initModality(Modality.APPLICATION_MODAL);
        DecorationPane decorationPane = new DecorationPane();
        decorationPane.getChildren().add((Object)this.vBox);
        this.alert.getDialogPane().setContent((Node)decorationPane);
        this.alert.getButtonTypes().setAll((Object[])new ButtonType[]{this.buttonOK, this.buttonDefault, this.buttonRemove});
        this.alert.setOnCloseRequest(evt -> this.alert.close());
        this.dataSetSelector = new DataSetSelector(this.chart);
        if (this.dataSetSelector.getNumberDataSets() > 1) {
            this.vBox.getChildren().add((Object)this.dataSetSelector);
        }
        this.displayPane.setOnMouseClicked(mevt -> {
            if (mevt.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.showConfigDialogue();
            }
        });
    }

    protected void defaultAction() {
        this.setDataSet(null);
    }

    public DataSet getDataSet() {
        if (this.dataSet == null) {
            ArrayList<DataSet> allDataSets = new ArrayList<DataSet>((Collection<DataSet>)this.chart.getAllDatasets());
            return (DataSet)allDataSets.get(0);
        }
        return this.dataSet;
    }

    protected VBox getDialogContentBox() {
        return this.vBox;
    }

    public Pane getDisplayPane() {
        return this.displayPane;
    }

    public abstract void initialize();

    protected void nominalAction() {
        this.setDataSet(this.dataSetSelector.getSelectedDataSet());
    }

    protected void removeAction() {
        this.chart.getMeasurementBar(this.chart.getMeasurementBarSide()).getChildren().remove((Object)this.displayPane);
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeListener((EventListener)this);
        }
        if (dataSet == null) {
            this.valueField.setDataSetName("<unknown data set>");
            this.dataSet = dataSet;
        } else {
            this.valueField.setDataSetName("<" + dataSet.getName() + ">");
            this.dataSet = dataSet;
            this.dataSet.addListener((EventListener)this);
        }
    }

    public void showConfigDialogue() {
        if (this.alert.isShowing()) {
            return;
        }
        Optional result = this.alert.showAndWait();
        if (!result.isPresent()) {
            this.defaultAction();
            return;
        }
        if (result.get() == this.buttonOK) {
            this.nominalAction();
        } else if (result.get() == this.buttonRemove) {
            this.removeAction();
        } else {
            this.defaultAction();
        }
        this.alert.close();
    }
}

