/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.ColorGradientAxis;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAxisLabels
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateAxisLabels.class);
    private Map<Renderer, Map<DataSet, EventListener>> rendererDataSetsListeners = new HashMap<Renderer, Map<DataSet, EventListener>>();
    private Map<DataSet, EventListener> chartDataSetsListeners = new HashMap<DataSet, EventListener>();
    private Map<Renderer, ListChangeListener<DataSet>> renderersListeners = new HashMap<Renderer, ListChangeListener<DataSet>>();
    private ListChangeListener<Renderer> renderersListener = renderersChange -> {
        while (renderersChange.next()) {
            if (renderersChange.wasAdded()) {
                for (Renderer renderer : renderersChange.getAddedSubList()) {
                    ListChangeListener dataSetsListener = dataSetsChange -> {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.atDebug().log("update listener -> dataSetsChanged ");
                        }
                        this.dataSetsChanged((ListChangeListener.Change<? extends DataSet>)dataSetsChange, renderer);
                    };
                    renderer.getDatasets().addListener(dataSetsListener);
                    this.renderersListeners.put(renderer, (ListChangeListener<DataSet>)dataSetsListener);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.atDebug().addArgument((Object)renderer.getClass().getSimpleName()).addArgument((Object)this.rendererDataSetsListeners.size()).log("added listener for render {}, number of data set listeners {}");
                }
            }
            if (!renderersChange.wasRemoved()) continue;
            for (Renderer renderer : renderersChange.getRemoved()) {
                renderer.getDatasets().removeListener(this.renderersListeners.get(renderer));
                this.renderersListeners.remove(renderer);
            }
        }
    };
    private final ChangeListener<? super Chart> chartChangeListener = (change, oldChart, newChart) -> {
        this.removeRendererAndDataSetListener((Chart)((Object)oldChart));
        this.addRendererAndDataSetListener((Chart)((Object)newChart));
    };

    public UpdateAxisLabels() {
        this.chartProperty().addListener(this.chartChangeListener);
        this.addRendererAndDataSetListener(this.getChart());
    }

    private void addRendererAndDataSetListener(Chart newChart) {
        if (newChart == null) {
            return;
        }
        this.setupDataSetListeners(null, newChart.getDatasets());
        newChart.getRenderers().addListener(this.renderersListener);
        newChart.getRenderers().forEach(r -> this.setupDataSetListeners((Renderer)r, r.getDatasets()));
    }

    private void dataSetChange(UpdateEvent update, Renderer renderer) {
        if (!(update instanceof AxisChangeEvent)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("axis - dataSetChange for AxisChangeEvent");
        }
        AxisChangeEvent axisDataUpdate = (AxisChangeEvent)update;
        int dim = axisDataUpdate.getDimension();
        DataSet dataSet = (DataSet)axisDataUpdate.getSource();
        if (renderer == null) {
            if (this.getChart().getDatasets().size() == 1) {
                if (dim == -1 || dim == 0) {
                    this.getChart().getFirstAxis(Orientation.HORIZONTAL).set(dataSet.getAxisDescription(0).getName(), new String[]{dataSet.getAxisDescription(0).getUnit()});
                }
                if (dim == -1 || dim == 1) {
                    this.getChart().getFirstAxis(Orientation.VERTICAL).set(dataSet.getAxisDescription(1).getName(), new String[]{dataSet.getAxisDescription(1).getUnit()});
                }
                if ((dim == -1 || dim == 2) && dataSet.getDimension() >= 3) {
                    this.getChart().getAxes().stream().filter(axis -> axis instanceof ColorGradientAxis).findFirst().ifPresent(axis -> axis.set(dataSet.getAxisDescription(2).getName(), new String[]{dataSet.getAxisDescription(2).getUnit()}));
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.atWarn().log("Applying axis information not possible for more than one DataSet added to chart. Please add datasets to separate Renderers");
            }
        } else if (renderer.getDatasets().size() == 1) {
            Optional<Axis> oldAxis;
            if (dim == -1 || dim == 0) {
                oldAxis = renderer.getAxes().stream().filter(axis -> axis.getSide().isHorizontal()).findFirst();
                oldAxis.ifPresent(a -> a.set(dataSet.getAxisDescription(0).getName(), new String[]{dataSet.getAxisDescription(0).getUnit()}));
            }
            if (dim == -1 || dim == 1) {
                oldAxis = renderer.getAxes().stream().filter(axis -> axis.getSide().isVertical()).findFirst();
                oldAxis.ifPresent(a -> a.set(dataSet.getAxisDescription(1).getName(), new String[]{dataSet.getAxisDescription(1).getUnit()}));
            }
            if ((dim == -1 || dim == 2) && dataSet.getDimension() >= 3) {
                renderer.getAxes().stream().filter(axis -> axis instanceof ColorGradientAxis).findFirst().ifPresent(axis -> axis.set(dataSet.getAxisDescription(2).getName(), new String[]{dataSet.getAxisDescription(2).getUnit()}));
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().log("Applying axis information not possible for more than one DataSet added to renderer. Please add datasets to separate Renderers");
        }
    }

    private void dataSetsChanged(ListChangeListener.Change<? extends DataSet> change, Renderer renderer) {
        Map<DataSet, EventListener> dataSetListeners;
        if (renderer == null) {
            dataSetListeners = this.chartDataSetsListeners;
        } else if (this.rendererDataSetsListeners.containsKey(renderer)) {
            dataSetListeners = this.rendererDataSetsListeners.get(renderer);
        } else {
            dataSetListeners = new HashMap<DataSet, EventListener>();
            this.rendererDataSetsListeners.put(renderer, dataSetListeners);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("dataSetsChanged added/removed - invoked");
        }
        while (change.next()) {
            if (change.wasAdded()) {
                for (DataSet dataSet : change.getAddedSubList()) {
                    EventListener dataSetListener = update -> FXUtils.runFX(() -> this.dataSetChange(update, renderer));
                    dataSet.addListener(dataSetListener);
                    dataSetListeners.put(dataSet, dataSetListener);
                    this.dataSetChange((UpdateEvent)new AxisChangeEvent((EventSource)dataSet, -1), renderer);
                }
            }
            if (!change.wasRemoved()) continue;
            for (DataSet dataSet : change.getRemoved()) {
                EventListener listener = dataSetListeners.get(dataSet);
                if (listener == null) continue;
                dataSet.removeListener(listener);
                dataSetListeners.remove(dataSet);
            }
        }
    }

    private void removeRendererAndDataSetListener(Chart oldChart) {
        if (oldChart == null) {
            return;
        }
        this.teardownDataSetListeners(null, oldChart.getDatasets());
        oldChart.getRenderers().removeListener(this.renderersListener);
        oldChart.getRenderers().forEach(r -> this.teardownDataSetListeners((Renderer)r, r.getDatasets()));
    }

    private void setupDataSetListeners(Renderer renderer, ObservableList<DataSet> dataSets) {
        Map<DataSet, EventListener> dataSetListeners;
        if (renderer == null) {
            dataSetListeners = this.chartDataSetsListeners;
        } else if (this.rendererDataSetsListeners.containsKey(renderer)) {
            dataSetListeners = this.rendererDataSetsListeners.get(renderer);
        } else {
            dataSetListeners = new HashMap<DataSet, EventListener>();
            this.rendererDataSetsListeners.put(renderer, dataSetListeners);
        }
        ListChangeListener rendererListener = change -> this.dataSetsChanged((ListChangeListener.Change<? extends DataSet>)change, renderer);
        dataSets.addListener(rendererListener);
        this.renderersListeners.put(renderer, (ListChangeListener<DataSet>)rendererListener);
        dataSets.forEach(dataSet -> {
            EventListener dataSetListener = update -> FXUtils.runFX(() -> this.dataSetChange(update, renderer));
            dataSet.addListener(dataSetListener);
            dataSetListeners.put((DataSet)dataSet, dataSetListener);
            this.dataSetChange((UpdateEvent)new AxisChangeEvent((EventSource)dataSet, -1), renderer);
        });
    }

    private void teardownDataSetListeners(Renderer renderer, ObservableList<DataSet> dataSets) {
        Map<DataSet, EventListener> dataSetListeners;
        if (renderer == null) {
            dataSetListeners = this.chartDataSetsListeners;
        } else if (this.rendererDataSetsListeners.containsKey(renderer)) {
            dataSetListeners = this.rendererDataSetsListeners.get(renderer);
        } else {
            dataSetListeners = new HashMap<DataSet, EventListener>();
            this.rendererDataSetsListeners.put(renderer, dataSetListeners);
        }
        dataSets.removeListener(this.renderersListeners.get(renderer));
        this.renderersListeners.remove(renderer);
        dataSets.forEach(dataSet -> {
            dataSet.removeListener((EventListener)dataSetListeners.get(dataSet));
            dataSetListeners.remove(dataSet);
        });
    }
}

