/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.XYChart;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.measurements.SimpleMeasurements;
import de.gsi.chart.plugins.measurements.ValueIndicator;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterMeasurements
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterMeasurements.class);
    private static final String FONT_AWESOME = "FontAwesome";
    private static final int FONT_SIZE = 20;
    private static final char TOOLBUTTON_ALT = '\uf0ad';
    private static final char TOOLBUTTON = '\uf0ad';
    protected final Pane measurmentDisplayPane = new Pane();
    private HBox parameterMenu;

    public ParameterMeasurements() {
        this.chartProperty().addListener((change, oldChart, newChart) -> {
            if (oldChart != null) {
                oldChart.getToolBar().getChildren().remove((Object)this.parameterMenu);
            }
            if (newChart != null) {
                this.parameterMenu = this.getMenuBar();
                newChart.getToolBar().getChildren().add((Object)this.parameterMenu);
            }
        });
    }

    private HBox getMenuBar() {
        HBox fileMenuBar = new HBox();
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu(null, (Node)new Glyph(FONT_AWESOME, '\uf0ad').size(20.0));
        for (SimpleMeasurements.MeasurementCategory category : SimpleMeasurements.MeasurementCategory.values()) {
            Menu newCategory = new Menu(category.toString());
            fileMenu.getItems().addAll((Object[])new MenuItem[]{newCategory});
            for (SimpleMeasurements.MeasurementType measType : SimpleMeasurements.MeasurementType.values()) {
                if (measType.getCategory() != category) continue;
                MenuItem newMeasurement = new MenuItem(measType.toString());
                XYChart xyChart = (XYChart)this.getChart();
                newMeasurement.setOnAction(evt -> new SimpleMeasurements(xyChart, measType).initialize());
                newCategory.getItems().addAll((Object[])new MenuItem[]{newMeasurement});
            }
        }
        Menu newCategory = new Menu("Misc");
        fileMenu.getItems().addAll((Object[])new MenuItem[]{newCategory});
        MenuItem newMeasurement1 = new MenuItem("Hor. Indicator");
        XYChart xyChart = (XYChart)this.getChart();
        newMeasurement1.setOnAction(evt -> new ValueIndicator(xyChart, AxisMode.X).initialize());
        newCategory.getItems().addAll((Object[])new MenuItem[]{newMeasurement1});
        MenuItem newMeasurement2 = new MenuItem("Ver. Indicator");
        newMeasurement2.setOnAction(evt -> new ValueIndicator(xyChart, AxisMode.Y).initialize());
        newCategory.getItems().addAll((Object[])new MenuItem[]{newMeasurement2});
        menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu});
        fileMenuBar.getChildren().addAll((Object[])new Node[]{separator, menuBar});
        return fileMenuBar;
    }
}

