/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractDataFormattingPlugin;
import de.gsi.dataset.DataSet;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Pair;

public class DataPointTooltip
extends AbstractDataFormattingPlugin {
    public static final String STYLE_CLASS_LABEL = "chart-datapoint-tooltip-label";
    public static final int DEFAULT_PICKING_DISTANCE = 5;
    private static final int LABEL_X_OFFSET = 15;
    private static final int LABEL_Y_OFFSET = 5;
    private final Label label = new Label();
    private final DoubleProperty pickingDistance = new SimpleDoubleProperty(this, "pickingDistance", 5.0){

        protected void invalidated() {
            if (this.get() <= 0.0) {
                throw new IllegalArgumentException("The " + this.getName() + " must be a positive value");
            }
        }
    };
    private final EventHandler<MouseEvent> mouseMoveHandler = this::updateToolTip;

    public DataPointTooltip() {
        this.label.getStyleClass().add((Object)STYLE_CLASS_LABEL);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
    }

    public DataPointTooltip(double pickingDistance) {
        this();
        this.setPickingDistance(pickingDistance);
    }

    private DataPoint findDataPoint(MouseEvent event, Bounds plotAreaBounds) {
        if (!plotAreaBounds.contains(event.getX(), event.getY())) {
            return null;
        }
        Point2D mouseLocation = this.getLocationInPlotArea(event);
        Object nearestDataPoint = null;
        Chart chart = this.getChart();
        return this.findNearestDataPointWithinPickingDistance(chart, mouseLocation);
    }

    private DataPoint findNearestDataPointWithinPickingDistance(Chart chart, Point2D mouseLocation) {
        DataPoint nearestDataPoint = null;
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xyChart = (XYChart)chart;
        double xValue = xyChart.getXAxis().getValueForDisplay(mouseLocation.getX());
        for (DataPoint dataPoint : this.findNeighborPoints(xyChart, xValue)) {
            if (!(this.getChart().getFirstAxis(Orientation.HORIZONTAL) instanceof Axis)) continue;
            double x = xyChart.getXAxis().getDisplayPosition(dataPoint.x);
            double y = xyChart.getYAxis().getDisplayPosition(dataPoint.y);
            Point2D displayPoint = new Point2D(x, y);
            dataPoint.distanceFromMouse = displayPoint.distance(mouseLocation);
            if (!(displayPoint.distance(mouseLocation) <= this.getPickingDistance()) || nearestDataPoint != null && !(dataPoint.distanceFromMouse < nearestDataPoint.distanceFromMouse)) continue;
            nearestDataPoint = dataPoint;
        }
        return nearestDataPoint;
    }

    private Pair<DataPoint, DataPoint> findNeighborPoints(DataSet dataSet, double searchedX) {
        int prevIndex = -1;
        int nextIndex = -1;
        double prevX = Double.MIN_VALUE;
        double nextX = Double.MAX_VALUE;
        int nDataCount = dataSet.getDataCount(0);
        int size = nDataCount;
        for (int i = 0; i < size; ++i) {
            double currentX = dataSet.get(0, i);
            if (currentX < searchedX) {
                if (!(prevX < currentX)) continue;
                prevIndex = i;
                prevX = currentX;
                continue;
            }
            if (!(nextX > currentX)) continue;
            nextIndex = i;
            nextX = currentX;
        }
        DataPoint prevPoint = prevIndex == -1 ? null : new DataPoint(this.getChart(), dataSet.get(0, prevIndex), dataSet.get(1, prevIndex), this.getDataLabelSafe(dataSet, prevIndex));
        DataPoint nextPoint = nextIndex == -1 || nextIndex == prevIndex ? null : new DataPoint(this.getChart(), dataSet.get(0, nextIndex), dataSet.get(1, nextIndex), this.getDataLabelSafe(dataSet, nextIndex));
        return new Pair((Object)prevPoint, (Object)nextPoint);
    }

    private List<DataPoint> findNeighborPoints(XYChart chart, double searchedX) {
        LinkedList<DataPoint> points = new LinkedList<DataPoint>();
        for (DataSet dataSet : chart.getAllDatasets()) {
            Pair<DataPoint, DataPoint> neighborPoints = this.findNeighborPoints(dataSet, searchedX);
            if (neighborPoints.getKey() != null) {
                points.add((DataPoint)neighborPoints.getKey());
            }
            if (neighborPoints.getValue() == null) continue;
            points.add((DataPoint)neighborPoints.getValue());
        }
        return points;
    }

    private String formatDataPoint(DataPoint dataPoint) {
        return String.format("DataPoint@(%.3f,%.3f)", dataPoint.x, dataPoint.y);
    }

    protected String formatLabel(DataPoint dataPoint) {
        return String.format("'%s'\n%s", dataPoint.label, this.formatDataPoint(dataPoint));
    }

    protected String getDataLabelSafe(DataSet dataSet, int index) {
        String lable = dataSet.getDataLabel(index);
        if (lable == null) {
            return this.getDefaultDataLabel(dataSet, index);
        }
        return lable;
    }

    protected String getDefaultDataLabel(DataSet dataSet, int index) {
        return String.format("%s (%d, %s, %s)", dataSet.getName(), index, Double.toString(dataSet.get(0, index)), Double.toString(dataSet.get(1, index)));
    }

    public final double getPickingDistance() {
        return this.pickingDistanceProperty().get();
    }

    public final DoubleProperty pickingDistanceProperty() {
        return this.pickingDistance;
    }

    public final void setPickingDistance(double distance) {
        this.pickingDistanceProperty().set(distance);
    }

    private void updateLabel(MouseEvent event, Bounds plotAreaBounds, DataPoint dataPoint) {
        this.label.setText(this.formatLabel(dataPoint));
        double mouseX = event.getX();
        double mouseY = event.getY();
        double width = this.label.prefWidth(-1.0);
        double height = this.label.prefHeight(width);
        double xLocation = mouseX + 15.0;
        double yLocation = mouseY - 5.0 - height;
        if (xLocation + width > plotAreaBounds.getMaxX()) {
            xLocation = mouseX - 15.0 - width;
        }
        if (yLocation < plotAreaBounds.getMinY()) {
            yLocation = mouseY + 5.0;
        }
        this.label.resizeRelocate(xLocation, yLocation, width, height);
    }

    private void updateToolTip(MouseEvent event) {
        Bounds plotAreaBounds = this.getChart().getPlotArea().getBoundsInLocal();
        DataPoint dataPoint = this.findDataPoint(event, plotAreaBounds);
        if (dataPoint == null) {
            this.getChartChildren().remove((Object)this.label);
            return;
        }
        this.updateLabel(event, plotAreaBounds, dataPoint);
        if (!this.getChartChildren().contains((Object)this.label)) {
            this.getChartChildren().add((Object)this.label);
            this.label.requestLayout();
        }
    }

    protected class DataPoint {
        protected final Chart chart;
        protected final double x;
        protected final double y;
        protected final String label;
        protected double distanceFromMouse;

        protected DataPoint(Chart chart, double x, double y, String label) {
            this.chart = chart;
            this.x = x;
            this.y = y;
            this.label = label;
        }

        public Chart getChart() {
            return this.chart;
        }

        public double getDistanceFromMouse() {
            return this.distanceFromMouse;
        }

        public String getLabel() {
            return this.label;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

