/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColormapSelector
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColormapSelector.class);
    private BooleanProperty showInToolbar = new SimpleBooleanProperty((Object)this, "show in toolbar", true);
    private ComboBox<ColorGradient> dropdown = new ColormapComboBox();

    public ColormapSelector() {
        this.chartProperty().addListener((change, o, n) -> {
            if (o != null) {
                o.getToolBar().getChildren().remove(this.dropdown);
            }
            if (n != null && this.isShowInToolbar()) {
                n.getToolBar().getChildren().add(this.dropdown);
            }
        });
        this.showInToolbar.addListener((prop, o, n) -> {
            if (n.booleanValue()) {
                this.getChart().getToolBar().getChildren().add(this.dropdown);
            } else {
                this.getChart().getToolBar().getChildren().remove(this.dropdown);
            }
        });
    }

    public ObjectProperty<ColorGradient> colormapProperty() {
        return this.dropdown.valueProperty();
    }

    public ColorGradient getColormap() {
        return (ColorGradient)this.dropdown.getValue();
    }

    public ObservableList<ColorGradient> getGradientsList() {
        return this.dropdown.getItems();
    }

    public boolean isShowInToolbar() {
        return this.showInToolbar.get();
    }

    public void setColormap(ColorGradient newGradient) {
        if (!this.getGradientsList().contains((Object)newGradient)) {
            this.getGradientsList().add((Object)newGradient);
        }
        this.dropdown.setValue((Object)newGradient);
    }

    public void setShowInToolbar(boolean show) {
        this.showInToolbar.set(show);
    }

    public BooleanProperty showInToolbarProperty() {
        return this.showInToolbar;
    }

    public static class ColormapListCell
    extends ListCell<ColorGradient> {
        private static final double COLORMAP_WIDTH = 30.0;
        private static final double COLORMAP_HEIGHT = 10.0;
        private final Rectangle rect = new Rectangle(30.0, 10.0);

        public ColormapListCell() {
            this.setContentDisplay(ContentDisplay.LEFT);
        }

        protected void updateItem(ColorGradient gradient, boolean empty) {
            super.updateItem((Object)gradient, empty);
            if (gradient == null || empty) {
                this.setGraphic(null);
                this.setText("-");
            } else {
                this.rect.setFill((Paint)new LinearGradient(0.0, 0.0, 30.0, 0.0, false, CycleMethod.NO_CYCLE, gradient.getStops()));
                this.setGraphic((Node)this.rect);
                this.setText(gradient.toString());
            }
        }
    }

    public static class ColormapComboBox
    extends ComboBox<ColorGradient> {
        public ColormapComboBox() {
            this.setCellFactory(listView -> new ColormapListCell());
            this.setButtonCell(new ColormapListCell());
            this.getItems().addAll(ColorGradient.colorGradients());
            this.setValue(ColorGradient.DEFAULT);
        }
    }
}

