/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.legend.spi;

import de.gsi.chart.legend.Legend;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.utils.StyleParser;
import de.gsi.dataset.DataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.FlowPane;

public class DefaultLegend
extends FlowPane
implements Legend {
    private static final int GAP = 5;
    private static final int SYMBOL_WIDTH = 20;
    private static final int SYMBOL_HEIGHT = 20;
    private final ListChangeListener<LegendItem> itemsListener = c -> {
        this.getChildren().setAll(this.getItems());
        if (this.isVisible()) {
            this.requestLayout();
        }
    };
    private final BooleanProperty vertical = new SimpleBooleanProperty(this, "vertical", false){

        protected void invalidated() {
            DefaultLegend.this.setOrientation(this.get() ? Orientation.VERTICAL : Orientation.HORIZONTAL);
        }
    };
    private final ObjectProperty<ObservableList<LegendItem>> items = new SimpleObjectProperty<ObservableList<LegendItem>>((Object)this, "items"){
        private ObservableList<LegendItem> oldItems;
        {
            this.oldItems = null;
        }

        protected void invalidated() {
            ObservableList newItems;
            if (this.oldItems != null) {
                this.oldItems.removeListener(DefaultLegend.this.itemsListener);
            }
            if ((newItems = (ObservableList)this.get()) == null) {
                DefaultLegend.this.getChildren().clear();
            } else {
                newItems.addListener(DefaultLegend.this.itemsListener);
                DefaultLegend.this.getChildren().setAll((Collection)newItems);
            }
            this.oldItems = (ObservableList)this.get();
            if (DefaultLegend.this.isVisible()) {
                DefaultLegend.this.requestLayout();
            }
        }
    };

    public DefaultLegend() {
        super(5.0, 5.0);
        this.setItems((ObservableList<LegendItem>)FXCollections.observableArrayList());
        this.getStyleClass().setAll((Object[])new String[]{"chart-legend"});
        this.setAlignment(Pos.CENTER);
    }

    protected double computePrefHeight(double forWidth) {
        return this.getItems().isEmpty() ? 0.0 : super.computePrefHeight(forWidth);
    }

    protected double computePrefWidth(double forHeight) {
        return this.getItems().isEmpty() ? 0.0 : super.computePrefWidth(forHeight);
    }

    public final ObservableList<LegendItem> getItems() {
        return (ObservableList)this.items.get();
    }

    public LegendItem getNewLegendItem(Renderer renderer, DataSet series, int seriesIndex) {
        Canvas symbol = renderer.drawLegendSymbol(series, seriesIndex, 20, 20);
        return new LegendItem(series.getName(), (Node)symbol);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public final boolean isVertical() {
        return this.vertical.get();
    }

    public final ObjectProperty<ObservableList<LegendItem>> itemsProperty() {
        return this.items;
    }

    public final void setItems(ObservableList<LegendItem> value) {
        this.itemsProperty().set(value);
    }

    @Override
    public final void setVertical(boolean value) {
        this.vertical.set(value);
    }

    @Override
    public void updateLegend(List<DataSet> dataSets, List<Renderer> renderers, boolean forceUpdate) {
        ArrayList<DataSet> alreadyDrawnDataSets = new ArrayList<DataSet>();
        ArrayList<LegendItem> legendItems = new ArrayList<LegendItem>();
        if (forceUpdate) {
            this.getItems().clear();
        }
        int legendItemCount = 0;
        for (int seriesIndex = 0; seriesIndex < dataSets.size(); ++seriesIndex) {
            DataSet series = dataSets.get(seriesIndex);
            String style = series.getStyle();
            Boolean show = StyleParser.getBooleanPropertyValue(style, "showInLegend");
            if (show != null && !show.booleanValue() || alreadyDrawnDataSets.contains(series) || renderers.isEmpty()) continue;
            legendItems.add(this.getNewLegendItem(renderers.get(0), series, seriesIndex));
            alreadyDrawnDataSets.add(series);
            ++legendItemCount;
        }
        for (Renderer renderer : renderers) {
            if (!renderer.showInLegend()) continue;
            for (DataSet series : renderer.getDatasets()) {
                String style = series.getStyle();
                Boolean show = StyleParser.getBooleanPropertyValue(style, "showInLegend");
                if (show != null && !show.booleanValue() || alreadyDrawnDataSets.contains(series)) continue;
                legendItems.add(this.getNewLegendItem(renderer, series, legendItemCount));
                alreadyDrawnDataSets.add(series);
                ++legendItemCount;
            }
        }
        boolean diffLegend = false;
        if (this.getItems().size() != legendItems.size()) {
            diffLegend = true;
        } else {
            List newItems = legendItems.stream().map(Labeled::getText).collect(Collectors.toList());
            List oldItems = this.getItems().stream().map(Labeled::getText).collect(Collectors.toList());
            for (String item : newItems) {
                if (oldItems.contains(item)) continue;
                diffLegend = true;
            }
        }
        if (diffLegend) {
            this.getItems().setAll(legendItems);
        }
    }

    public final BooleanProperty verticalProperty() {
        return this.vertical;
    }

    public static class LegendItem
    extends Label {
        public LegendItem(String text, Node symbol) {
            this.setText(text);
            this.getStyleClass().add((Object)"chart-legend-item");
            this.setAlignment(Pos.CENTER_LEFT);
            this.setContentDisplay(ContentDisplay.LEFT);
            this.setSymbol(symbol);
        }

        public final Node getSymbol() {
            return this.getGraphic();
        }

        public final void setSymbol(Node value) {
            this.setGraphic(value);
        }
    }
}

