/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.chart.ui.geometry.Side;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorGradientAxis
extends DefaultNumericAxis {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorGradientAxis.class);
    protected final Rectangle gradientRect = new Rectangle();
    private final ObjectProperty<ColorGradient> colorGradient = new SimpleObjectProperty((Object)this, "colorGradient", (Object)ColorGradient.DEFAULT);
    private final DoubleProperty gradientWidth = new SimpleDoubleProperty((Object)this, "gradientWidth", 20.0);

    public ColorGradientAxis(double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound, tickUnit);
        this.colorGradient.addListener((p, o, n) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(double lowerBound, double upperBound, double tickUnit, ColorGradient colorGradient) {
        this(lowerBound, upperBound, tickUnit);
        this.colorGradient.set((Object)colorGradient);
    }

    public ColorGradientAxis(String axisLabel) {
        super(axisLabel);
        this.colorGradient.addListener((p, o, n) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(String axisLabel, ColorGradient colorGradient) {
        this(axisLabel);
        this.colorGradient.set((Object)colorGradient);
    }

    public ColorGradientAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(axisLabel, lowerBound, upperBound, tickUnit);
        this.colorGradient.addListener((p, o, n) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit, ColorGradient colorGradient) {
        this(axisLabel, lowerBound, upperBound, tickUnit);
        this.colorGradient.set((Object)colorGradient);
    }

    public ColorGradientAxis(String axisLabel, String unit) {
        super(axisLabel, unit);
        this.colorGradient.addListener((p, o, n) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(String axisLabel, String unit, ColorGradient colorGradient) {
        this(axisLabel, unit);
        this.colorGradient.set((Object)colorGradient);
    }

    public ObjectProperty<ColorGradient> colorGradientProperty() {
        return this.colorGradient;
    }

    @Override
    protected double computePrefHeight(double width) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_HOR || side.isVertical()) {
            return super.computePrefHeight(width);
        }
        return super.computePrefHeight(width) + this.getGradientWidth();
    }

    @Override
    protected double computePrefWidth(double height) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_VER || side.isHorizontal()) {
            return super.computePrefWidth(height);
        }
        return super.computePrefWidth(height) + this.getGradientWidth();
    }

    @Override
    public void drawAxis(GraphicsContext gc, double axisWidth, double axisHeight) {
        if (gc == null || this.getSide() == null) {
            return;
        }
        this.clearAxisCanvas(gc, axisWidth, axisHeight);
        this.drawAxisPre();
        this.updateCSS();
        double axisLength = this.getSide().isHorizontal() ? axisWidth : axisHeight;
        this.drawAxisLine(gc, axisLength, axisWidth, axisHeight);
        double gradientWidth = this.getGradientWidth();
        gc.save();
        switch (this.getSide()) {
            case LEFT: {
                gc.translate(-gradientWidth, 0.0);
                break;
            }
            case RIGHT: {
                gc.translate(gradientWidth, 0.0);
                break;
            }
            case TOP: {
                gc.translate(0.0, -gradientWidth);
                break;
            }
            case BOTTOM: {
                gc.translate(0.0, gradientWidth);
                break;
            }
            case CENTER_HOR: {
                gc.translate(gradientWidth, 0.0);
                break;
            }
            case CENTER_VER: {
                gc.translate(-gradientWidth, 0.0);
                break;
            }
        }
        if (!this.isTickMarkVisible()) {
            this.drawAxisLabel(gc, axisWidth, axisHeight, this.getAxisLabel(), null, this.getTickLength());
            this.drawAxisPost();
            return;
        }
        ObservableList<TickMark> majorTicks = this.getTickMarks();
        ObservableList<TickMark> minorTicks = this.getMinorTickMarks();
        double neededLength = (double)(this.getTickMarks().size() + minorTicks.size()) * 2.0;
        if (this.isMinorTickVisible() && axisLength > neededLength) {
            this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, minorTicks, this.getMinorTickLength(), this.getMinorTickStyle());
            this.drawTickLabels(gc, axisWidth, axisHeight, minorTicks, this.getMinorTickLength());
        }
        this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, majorTicks, this.getTickLength(), this.getMajorTickStyle());
        this.drawTickLabels(gc, axisWidth, axisHeight, majorTicks, this.getTickLength());
        this.drawAxisLabel(gc, axisWidth, axisHeight, this.getAxisLabel(), majorTicks, this.getTickLength());
        this.drawAxisPost();
        gc.restore();
    }

    @Override
    protected void drawAxisLine(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight) {
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        double gradientWidth = this.getGradientWidth();
        Path tickStyle = this.getMajorTickStyle();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        if (this.getSide().isHorizontal()) {
            gc.setFill((Paint)new LinearGradient(0.0, 0.0, axisLength, 0.0, false, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
        } else {
            gc.setFill((Paint)new LinearGradient(0.0, axisLength, 0.0, 0.0, false, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
        }
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.fillRect(ColorGradientAxis.snap(axisWidth - gradientWidth), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisWidth), ColorGradientAxis.snap(axisLength));
                gc.strokeRect(ColorGradientAxis.snap(axisWidth - gradientWidth), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisWidth), ColorGradientAxis.snap(axisLength));
                break;
            }
            case RIGHT: {
                gc.fillRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(gradientWidth), ColorGradientAxis.snap(axisLength));
                gc.strokeRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(gradientWidth), ColorGradientAxis.snap(axisLength));
                break;
            }
            case TOP: {
                gc.fillRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisHeight - gradientWidth), ColorGradientAxis.snap(axisLength), ColorGradientAxis.snap(axisHeight));
                gc.strokeRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisHeight - gradientWidth), ColorGradientAxis.snap(axisLength), ColorGradientAxis.snap(axisHeight));
                break;
            }
            case BOTTOM: {
                gc.rect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisLength), ColorGradientAxis.snap(gradientWidth));
                break;
            }
            case CENTER_HOR: {
                gc.fillRect(ColorGradientAxis.snap(0.0), axisCentre * axisHeight - 0.5 * gradientWidth, ColorGradientAxis.snap(axisLength), ColorGradientAxis.snap(axisCentre * axisHeight + 0.5 * gradientWidth));
                gc.strokeRect(ColorGradientAxis.snap(0.0), axisCentre * axisHeight - 0.5 * gradientWidth, ColorGradientAxis.snap(axisLength), ColorGradientAxis.snap(axisCentre * axisHeight + 0.5 * gradientWidth));
                break;
            }
            case CENTER_VER: {
                gc.fillRect(ColorGradientAxis.snap(axisCentre * axisWidth - 0.5 * gradientWidth), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisCentre * axisWidth + 0.5 * gradientWidth), ColorGradientAxis.snap(axisLength));
                gc.strokeRect(ColorGradientAxis.snap(axisCentre * axisWidth - 0.5 * gradientWidth), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(axisCentre * axisWidth + 0.5 * gradientWidth), ColorGradientAxis.snap(axisLength));
                break;
            }
        }
        gc.restore();
    }

    public Color getColor(double value) {
        double offset = (value - this.getRange().getLowerBound()) / (this.getRange().getUpperBound() - this.getRange().getLowerBound());
        double lowerOffset = 0.0;
        double upperOffset = 1.0;
        Color lowerColor = Color.TRANSPARENT;
        Color upperColor = Color.TRANSPARENT;
        for (Stop stop : this.getColorGradient().getStops()) {
            double currentOffset = stop.getOffset();
            if (currentOffset == offset) {
                return stop.getColor();
            }
            if (currentOffset < offset) {
                lowerOffset = currentOffset;
                lowerColor = stop.getColor();
                continue;
            }
            upperOffset = currentOffset;
            upperColor = stop.getColor();
            break;
        }
        double interpolationOffset = (offset - lowerOffset) / (upperOffset - lowerOffset);
        return lowerColor.interpolate(upperColor, interpolationOffset);
    }

    public ColorGradient getColorGradient() {
        return (ColorGradient)this.colorGradientProperty().get();
    }

    public double getGradientWidth() {
        return this.gradientWidth.get();
    }

    public int getIntColor(double value) {
        Color color = this.getColor(value);
        return ((byte)(color.getOpacity() * 255.0) << 24) + ((byte)(color.getRed() * 255.0) << 16) + ((byte)(color.getGreen() * 255.0) << 8) + (byte)(color.getBlue() * 255.0);
    }

    public DoubleProperty gradientWidthProperty() {
        return this.gradientWidth;
    }

    public void setColorGradient(ColorGradient value) {
        this.colorGradientProperty().set((Object)value);
    }

    public void setGradientWidth(double newGradientWidth) {
        this.gradientWidth.set(newGradientWidth);
    }
}

