/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AxisLabel;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.MetricPrefix;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.ui.css.StylishBooleanProperty;
import de.gsi.chart.ui.css.StylishDoubleProperty;
import de.gsi.chart.ui.css.StylishIntegerProperty;
import de.gsi.chart.ui.css.StylishObjectProperty;
import de.gsi.chart.ui.css.StylishStringProperty;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.StringConverter;

public abstract class AbstractAxisParameter
extends Pane
implements Axis {
    private static final String CHART_CSS = Chart.class.getResource("chart.css").toExternalForm();
    private static final int MAX_TICK_COUNT = 20;
    private static final double DEFAULT_MIN_RANGE = -1.0;
    private static final double DEFAULT_MAX_RANGE = 1.0;
    private static final double DEFAULT_TICK_UNIT = 5.0;
    protected static final int DEFAULT_MINOR_TICK_COUNT = 10;
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass CENTRE_HOR_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"horCentre");
    private static final PseudoClass CENTRE_VER_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"verCentre");
    private final transient AtomicBoolean autoNotification = new AtomicBoolean(true);
    private final List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    protected final Path majorTickStyle = new Path();
    protected final Path minorTickStyle = new Path();
    protected final AxisLabel axisLabel = new AxisLabel();
    protected double oldAxisLength = -1.0;
    protected double oldAxisMin = -1.7976931348623157E308;
    protected double oldAxisMax = -1.7976931348623157E308;
    protected double oldTickUnit = -1.7976931348623157E308;
    protected BooleanProperty valid = new SimpleBooleanProperty((Object)this, "valid", false);
    protected final ObservableList<Double> majorTickMarkValues = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final ObservableList<Double> minorTickMarkValues = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final ObservableList<TickMark> majorTickMarks = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    protected final ObservableList<TickMark> minorTickMarks = FXCollections.observableArrayList((Collection)new NoDuplicatesList());
    private final AxisRange autoRange = new AxisRange();
    private final AxisRange userRange = new AxisRange();
    private final ObjectProperty<Side> side = new StyleableObjectProperty<Side>(Side.BOTTOM){

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public CssMetaData<AbstractAxisParameter, Side> getCssMetaData() {
            return StyleableProperties.SIDE;
        }

        public String getName() {
            return "side";
        }

        protected void invalidated() {
            Side edge = (Side)((Object)this.get());
            AbstractAxisParameter.this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, edge == Side.TOP);
            AbstractAxisParameter.this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, edge == Side.RIGHT);
            AbstractAxisParameter.this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, edge == Side.BOTTOM);
            AbstractAxisParameter.this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, edge == Side.LEFT);
            AbstractAxisParameter.this.pseudoClassStateChanged(CENTRE_HOR_PSEUDOCLASS_STATE, edge == Side.CENTER_HOR);
            AbstractAxisParameter.this.pseudoClassStateChanged(CENTRE_VER_PSEUDOCLASS_STATE, edge == Side.CENTER_VER);
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final ObjectProperty<AxisLabelOverlapPolicy> overlapPolicy = new StyleableObjectProperty<AxisLabelOverlapPolicy>(AxisLabelOverlapPolicy.SKIP_ALT){

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public CssMetaData<AbstractAxisParameter, AxisLabelOverlapPolicy> getCssMetaData() {
            return StyleableProperties.OVERLAP_POLICY;
        }

        public String getName() {
            return "overlapPolcy";
        }

        protected void invalidated() {
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final DoubleProperty centerAxisPosition = new StylishDoubleProperty(StyleableProperties.CENTER_AXIS_POSITION, this, "centerAxisPosition", 0.5, this::requestAxisLayout){

        public void set(double value) {
            super.set(Math.max(0.0, Math.min(value, 1.0)));
        }
    };
    private final ObjectProperty<TextAlignment> axisLabelTextAlignment = new StylishObjectProperty<TextAlignment>(StyleableProperties.AXIS_LABEL_ALIGNMENT, this, "axisLabelTextAlignment", TextAlignment.CENTER, this::requestAxisLayout);
    private final StringProperty axisName = new StylishStringProperty(StyleableProperties.AXIS_LABEL, this, "label", null, this::requestAxisLayout);
    private final BooleanProperty tickMarkVisible = new StylishBooleanProperty(StyleableProperties.TICK_MARK_VISIBLE, this, "tickMarkVisible", true, this::requestAxisLayout);
    private final BooleanProperty tickLabelsVisible = new StylishBooleanProperty(StyleableProperties.TICK_LABELS_VISIBLE, this, "tickLabelsVisible", true, () -> {
        for (TickMark tick : this.getTickMarks()) {
            tick.setVisible(this.tickLabelsVisible.get());
        }
        this.invalidate();
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    });
    private final DoubleProperty axisPadding = new StylishDoubleProperty(StyleableProperties.AXIS_PADDING, this, "axisPadding", 15.0, this::requestAxisLayout);
    private final DoubleProperty tickLength = new StylishDoubleProperty(StyleableProperties.TICK_LENGTH, this, "tickLength", 8.0, this::requestAxisLayout);
    private final BooleanProperty autoRanging = new StylishBooleanProperty(StyleableProperties.AUTO_RANGING, this, "autoRanging", true, this::requestAxisLayout);
    private final ObjectProperty<Font> tickLabelFont = new StylishObjectProperty<Font>(StyleableProperties.TICK_LABEL_FONT, this, "tickLabelFont", Font.font((String)"System", (double)8.0), () -> {
        Font f = (Font)this.tickLabelFontProperty().get();
        for (TickMark tm : this.getTickMarks()) {
            tm.setFont(f);
        }
        this.invalidate();
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    });
    private final ObjectProperty<Paint> tickLabelFill = new StylishObjectProperty<Color>(StyleableProperties.TICK_LABEL_FILL, this, "tickLabelFill", Color.BLACK, this::requestAxisLayout);
    private final DoubleProperty tickLabelGap = new StylishDoubleProperty(StyleableProperties.TICK_LABEL_TICK_GAP, this, "tickLabelGap", 3.0, this::requestAxisLayout);
    private final DoubleProperty axisLabelGap = new StylishDoubleProperty(StyleableProperties.AXIS_LABEL_TICK_GAP, this, "axisLabelGap", 3.0, this::requestAxisLayout);
    private final IntegerProperty animationDuration = new StylishIntegerProperty(StyleableProperties.ANIMATION_DURATION, this, "animationDuration", 250, this::requestAxisLayout);
    private final IntegerProperty maxMajorTickLabelCount = new StylishIntegerProperty(StyleableProperties.MAX_TICK_LABEL_COUNT, this, "maxMaxjorTickLabelCount", 20, this::requestAxisLayout);
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    protected final DoubleProperty tickLabelRotation = new StylishDoubleProperty(StyleableProperties.TICK_LABEL_ROTATION, this, "tickLabelRotation", 0.0, this::requestAxisLayout);
    private final BooleanProperty minorTickVisible = new StylishBooleanProperty(StyleableProperties.MINOR_TICK_VISIBLE, this, "minorTickVisible", true, this::requestAxisLayout);
    private final ReadOnlyDoubleWrapper scale = new ReadOnlyDoubleWrapper(this, "scale", 1.0){

        protected void invalidated() {
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    protected final DoubleProperty maxProp = new SimpleDoubleProperty(this, "upperBound", 1.0){

        public void set(double newValue) {
            double oldValue = this.get();
            if (oldValue != newValue) {
                super.set(newValue);
                AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
            }
        }
    };
    protected final DoubleProperty minProp = new SimpleDoubleProperty(this, "lowerBound", -1.0){

        public void set(double newValue) {
            double oldValue = this.get();
            if (oldValue != newValue) {
                super.set(newValue);
                AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
            }
        }
    };
    private final ObjectProperty<StringConverter<Number>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<Number>>(null){

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "tickLabelFormatter";
        }

        protected void invalidated() {
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final DoubleProperty minorTickLength = new StylishDoubleProperty(StyleableProperties.MINOR_TICK_LENGTH, this, "minorTickLength", 5.0, this::requestAxisLayout);
    private final IntegerProperty minorTickCount = new StylishIntegerProperty(StyleableProperties.MINOR_TICK_COUNT, this, "minorTickCount", 10, this::requestAxisLayout);
    protected final DoubleProperty scaleBinding = new SimpleDoubleProperty(this, "scaleBinding", this.getScale()){

        protected void invalidated() {
            AbstractAxisParameter.this.setScale(this.get());
        }
    };
    private final BooleanProperty autoGrowRanging = new StylishBooleanProperty(StyleableProperties.AUTO_GROW_RANGING, this, "autoGrowRanging", false, this::requestAxisLayout);
    protected boolean isInvertedAxis = false;
    private final BooleanProperty invertAxis = new SimpleBooleanProperty(this, "invertAxis", false){

        protected void invalidated() {
            AbstractAxisParameter.this.isInvertedAxis = this.get();
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    protected boolean isTimeAxis = false;
    private final BooleanProperty timeAxis = new SimpleBooleanProperty(this, "timeAxis", false){

        protected void invalidated() {
            AbstractAxisParameter.this.isTimeAxis = this.get();
            if (AbstractAxisParameter.this.isTimeAxis) {
                AbstractAxisParameter.this.setMinorTickCount(0);
            } else {
                AbstractAxisParameter.this.setMinorTickCount(10);
            }
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final BooleanProperty autoRangeRounding = new StylishBooleanProperty(StyleableProperties.AUTO_RANGE_ROUNDING, this, "autoRangeRounding", false, this::requestAxisLayout);
    private final DoubleProperty autoRangePadding = new SimpleDoubleProperty(0.0);
    private final ObjectProperty<String> axisUnit = new ObjectPropertyBase<String>(){

        public Object getBean() {
            return AbstractAxisParameter.this;
        }

        public String getName() {
            return "unitLabel";
        }

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final BooleanProperty autoUnitScaling = new SimpleBooleanProperty(this, "autoUnitScaling", false){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    private final DoubleProperty unitScaling = new SimpleDoubleProperty(this, "unitScaling", 1.0){

        protected void invalidated() {
            AbstractAxisParameter.this.updateAxisLabelAndUnit();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };
    protected final SimpleStyleableDoubleProperty tickUnit = new SimpleStyleableDoubleProperty(StyleableProperties.TICK_UNIT, this, "tickUnit", 5.0){

        protected void invalidated() {
            if (AbstractAxisParameter.this.isAutoRanging() || AbstractAxisParameter.this.isAutoGrowRanging()) {
                return;
            }
            AbstractAxisParameter.this.invalidate();
            AbstractAxisParameter.this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)AbstractAxisParameter.this));
        }
    };

    public AbstractAxisParameter() {
        this.getStylesheets().add((Object)CHART_CSS);
        this.getStyleClass().setAll((Object[])new String[]{"axis"});
        this.majorTickStyle.getStyleClass().add((Object)"axis-tick-mark");
        this.minorTickStyle.getStyleClass().add((Object)"axis-minor-tick-mark");
        this.getChildren().addAll((Object[])new Node[]{this.axisLabel, this.majorTickStyle, this.minorTickStyle});
        this.autoRangingProperty().addListener(ch -> {
            if (this.isAutoRanging()) {
                this.setAutoGrowRanging(false);
            }
        });
        this.autoGrowRangingProperty().addListener(ch -> {
            if (this.isAutoGrowRanging()) {
                this.setAutoRanging(false);
            }
        });
        this.nameProperty().addListener(e -> {
            this.updateAxisLabelAndUnit();
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        });
        ChangeListener autoRangeChangeListener = (ch, oldValue, newValue) -> {
            if (oldValue.equals(newValue)) {
                return;
            }
            if (this.isAutoUnitScaling()) {
                this.updateAxisLabelAndUnit();
            }
        };
        this.maxProperty().addListener(autoRangeChangeListener);
        this.minProperty().addListener(autoRangeChangeListener);
        this.axisLabel.textAlignmentProperty().bindBidirectional(this.axisLabelTextAlignmentProperty());
        ChangeListener userLimitChangeListener = (ch, o, n) -> {
            this.getUserRange().set(this.getMin(), this.getMax());
            if (!this.isAutoRanging() && !this.isAutoGrowRanging()) {
                this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
            }
            this.invalidate();
        };
        this.minProperty().addListener(userLimitChangeListener);
        this.maxProperty().addListener(userLimitChangeListener);
        this.majorTickStyle.applyCss();
        this.minorTickStyle.applyCss();
        this.axisLabel.applyCss();
        this.widthProperty().addListener((ch, o, n) -> this.invalidate());
        this.heightProperty().addListener((ch, o, n) -> this.invalidate());
    }

    public boolean add(double value) {
        if (this.contains(value)) {
            return false;
        }
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        if (value > this.getMax()) {
            this.setMax(value);
            changed = true;
        }
        if (value < this.getMin()) {
            this.setMin(value);
            changed = true;
        }
        this.autoNotification().set(oldState);
        if (changed) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    public boolean add(double[] values, int nlength) {
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        for (int i = 0; i < nlength; ++i) {
            changed |= this.add(values[i]);
        }
        this.autoNotification().set(oldState);
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        return changed;
    }

    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    public boolean clear() {
        boolean oldState = this.autoNotification().getAndSet(false);
        this.minProp.set(-1.0);
        this.maxProp.set(1.0);
        this.autoNotification().set(oldState);
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        return false;
    }

    public boolean contains(double value) {
        return Double.isFinite(value) && value >= this.getMin() && value <= this.getMax();
    }

    public abstract void fireInvalidated();

    @Override
    public AxisRange getAutoRange() {
        return this.autoRange;
    }

    public Text getAxisLabel() {
        return this.axisLabel;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AbstractAxisParameter.getClassCssMetaData();
    }

    @Override
    public double getLength() {
        if (this.getSide() == null) {
            return Double.NaN;
        }
        return this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
    }

    public Path getMajorTickStyle() {
        return this.majorTickStyle;
    }

    @Override
    public ObservableList<TickMark> getMinorTickMarks() {
        return this.minorTickMarks;
    }

    public ObservableList<Double> getMinorTickMarkValues() {
        return this.minorTickMarkValues;
    }

    public Path getMinorTickStyle() {
        return this.minorTickStyle;
    }

    @Override
    public AxisRange getRange() {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            return this.getAutoRange();
        }
        return this.getUserRange();
    }

    @Override
    public ObservableList<TickMark> getTickMarks() {
        return this.majorTickMarks;
    }

    public ObservableList<Double> getTickMarkValues() {
        return this.majorTickMarkValues;
    }

    @Override
    public AxisRange getUserRange() {
        return this.userRange;
    }

    public void invalidate() {
        this.validProperty().set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeListener(UpdateEvent updateEvent, boolean executeParallel) {
        AtomicBoolean atomicBoolean = this.autoNotification();
        synchronized (atomicBoolean) {
            if (!this.autoNotification().get()) {
                return;
            }
        }
        this.requestAxisLayout();
        Axis.super.invokeListener(updateEvent, executeParallel);
    }

    public boolean isDefined() {
        return Double.isFinite(this.getMin()) && Double.isFinite(this.getMax());
    }

    public boolean set(double min, double max) {
        boolean changed;
        double oldMin = this.minProp.get();
        double oldMax = this.maxProp.get();
        boolean oldState = this.autoNotification().getAndSet(false);
        this.minProp.set(min);
        this.maxProp.set(max);
        this.autoNotification().set(oldState);
        boolean bl = changed = oldMin != min || oldMax != max;
        if (changed) {
            this.invalidate();
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    public boolean set(String axisName, String ... axisUnit) {
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        if (!AbstractAxisParameter.equalString(axisName, this.getName())) {
            this.setName(axisName);
            changed = true;
        }
        if (axisUnit != null && axisUnit.length > 0 && !AbstractAxisParameter.equalString(axisUnit[0], this.getUnit())) {
            this.setUnit(axisUnit[0]);
            changed = true;
        }
        this.autoNotification().set(oldState);
        if (changed) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    public boolean set(String axisName, String axisUnit, double rangeMin, double rangeMax) {
        boolean changed = false;
        boolean oldState = this.autoNotification().getAndSet(false);
        changed |= this.set(axisName, axisUnit);
        this.autoNotification().set(oldState);
        if (changed |= this.set(rangeMin, rangeMax)) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
        }
        return changed;
    }

    protected void updateAxisLabelAndUnit() {
        String axisPrimaryLabel = this.getName();
        String axisUnit = this.getUnit();
        boolean isAutoScaling = this.isAutoUnitScaling();
        if (isAutoScaling) {
            this.updateScaleAndUnitPrefix();
        }
        String axisPrefix = MetricPrefix.getShortPrefix(this.getUnitScaling());
        if (axisUnit == null && axisPrefix != null) {
            axisUnit = "a.u.";
        }
        if (axisUnit == null) {
            this.axisLabel.setText(axisPrimaryLabel);
        } else {
            this.axisLabel.setText(axisPrimaryLabel + " [" + axisPrefix + axisUnit + "]");
        }
        this.invalidate();
    }

    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    protected void updateScaleAndUnitPrefix() {
        double oldPower;
        double power3Lower;
        double range = Math.abs(this.getMax() - this.getMin());
        double logRange = Math.log10(range);
        double power3Upper = 3.0 * Math.ceil(logRange / 3.0);
        double a = power3Upper > (power3Lower = 3.0 * Math.floor(logRange / 3.0)) ? power3Lower : power3Upper;
        double power = Math.pow(10.0, a);
        if (power != (oldPower = this.getUnitScaling()) && power != 0.0 && Double.isFinite(power)) {
            this.setUnitScaling(power);
        }
        this.setTickUnit(range / (double)this.getMinorTickCount());
    }

    private static boolean equalString(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public BooleanProperty animatedProperty() {
        return this.animated;
    }

    public boolean isAnimated() {
        return this.animatedProperty().get();
    }

    @Override
    public void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public IntegerProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public int getAnimationDuration() {
        return this.animationDurationProperty().get();
    }

    public void setAnimationDuration(int value) {
        this.animationDurationProperty().set(value);
    }

    @Override
    public BooleanProperty autoGrowRangingProperty() {
        return this.autoGrowRanging;
    }

    @Override
    public boolean isAutoGrowRanging() {
        return this.autoGrowRangingProperty().get();
    }

    @Override
    public void setAutoGrowRanging(boolean state) {
        if (state) {
            this.setAutoRanging(false);
            this.invalidate();
            this.requestAxisLayout();
        }
        this.autoGrowRangingProperty().set(state);
    }

    public DoubleProperty autoRangePaddingProperty() {
        return this.autoRangePadding;
    }

    public double getAutoRangePadding() {
        return this.autoRangePaddingProperty().get();
    }

    public void setAutoRangePadding(double padding) {
        this.autoRangePaddingProperty().set(padding);
    }

    public BooleanProperty autoRangeRoundingProperty() {
        return this.autoRangeRounding;
    }

    public boolean isAutoRangeRounding() {
        return this.autoRangeRoundingProperty().get();
    }

    public void setAutoRangeRounding(boolean round) {
        this.autoRangeRoundingProperty().set(round);
    }

    @Override
    public BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    @Override
    public boolean isAutoRanging() {
        return this.autoRangingProperty().get();
    }

    @Override
    public void setAutoRanging(boolean value) {
        this.autoRangingProperty().set(value);
    }

    @Override
    public BooleanProperty autoUnitScalingProperty() {
        return this.autoUnitScaling;
    }

    @Override
    public boolean isAutoUnitScaling() {
        return this.autoUnitScalingProperty().get();
    }

    @Override
    public void setAutoUnitScaling(boolean value) {
        this.autoUnitScalingProperty().set(value);
    }

    public DoubleProperty axisLabelGapProperty() {
        return this.axisLabelGap;
    }

    public double getAxisLabelGap() {
        return this.axisLabelGapProperty().get();
    }

    public void setAxisLabelGap(double value) {
        this.axisLabelGapProperty().set(value);
    }

    public ObjectProperty<TextAlignment> axisLabelTextAlignmentProperty() {
        return this.axisLabelTextAlignment;
    }

    @Deprecated
    public TextAlignment getaAxisLabelTextAlignment() {
        return (TextAlignment)this.axisLabelTextAlignmentProperty().get();
    }

    public TextAlignment getAxisLabelTextAlignment() {
        return (TextAlignment)this.axisLabelTextAlignmentProperty().get();
    }

    public void setAxisLabelTextAlignment(TextAlignment value) {
        this.axisLabelTextAlignmentProperty().set((Object)value);
    }

    public DoubleProperty axisPaddingProperty() {
        return this.axisPadding;
    }

    public double getAxisPadding() {
        return this.axisPaddingProperty().get();
    }

    public void setAxisPadding(double value) {
        this.axisPaddingProperty().set(value);
    }

    public DoubleProperty centerAxisPositionProperty() {
        return this.centerAxisPosition;
    }

    public double getAxisCenterPosition() {
        return this.centerAxisPositionProperty().get();
    }

    @Deprecated
    public double getCenterAxisPosition() {
        return this.centerAxisPositionProperty().get();
    }

    public void setAxisCenterPosition(double value) {
        this.centerAxisPositionProperty().set(value);
    }

    @Override
    public BooleanProperty invertAxisProperty() {
        return this.invertAxis;
    }

    @Override
    public boolean isInvertedAxis() {
        return this.invertAxisProperty().get();
    }

    @Override
    public void invertAxis(boolean value) {
        this.invertAxisProperty().set(value);
    }

    public IntegerProperty maxMajorTickLabelCountProperty() {
        return this.maxMajorTickLabelCount;
    }

    @Deprecated
    public int getMaxMaxjorTickLabelCount() {
        return this.maxMajorTickLabelCountProperty().get();
    }

    public int getMaxMajorTickLabelCount() {
        return this.maxMajorTickLabelCountProperty().get();
    }

    public void setMaxMajorTickLabelCount(int value) {
        this.maxMajorTickLabelCountProperty().set(value);
    }

    @Override
    public DoubleProperty maxProperty() {
        return this.maxProp;
    }

    public double getMax() {
        return this.maxProperty().get();
    }

    public boolean setMax(double value) {
        double oldvalue = this.maxProperty().get();
        this.maxProperty().set(value);
        return oldvalue != value;
    }

    public IntegerProperty minorTickCountProperty() {
        return this.minorTickCount;
    }

    @Override
    public int getMinorTickCount() {
        return this.minorTickCountProperty().get();
    }

    public void setMinorTickCount(int value) {
        this.minorTickCountProperty().set(value);
    }

    public DoubleProperty minorTickLengthProperty() {
        return this.minorTickLength;
    }

    public double getMinorTickLength() {
        return this.minorTickLengthProperty().get();
    }

    public void setMinorTickLength(double value) {
        this.minorTickLengthProperty().set(value);
    }

    public BooleanProperty minorTickVisibleProperty() {
        return this.minorTickVisible;
    }

    public boolean isMinorTickVisible() {
        return this.minorTickVisibleProperty().get();
    }

    public void setMinorTickVisible(boolean value) {
        this.minorTickVisibleProperty().set(value);
    }

    @Override
    public DoubleProperty minProperty() {
        return this.minProp;
    }

    public double getMin() {
        return this.minProperty().get();
    }

    public boolean setMin(double value) {
        double oldvalue = this.minProperty().get();
        this.minProperty().set(value);
        return oldvalue != value;
    }

    @Override
    public StringProperty nameProperty() {
        return this.axisName;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    @Override
    public void setName(String value) {
        this.nameProperty().set((Object)value);
    }

    public ObjectProperty<AxisLabelOverlapPolicy> overlapPolicyProperty() {
        return this.overlapPolicy;
    }

    public AxisLabelOverlapPolicy getOverlapPolicy() {
        return (AxisLabelOverlapPolicy)((Object)this.overlapPolicyProperty().get());
    }

    public void setOverlapPolicy(AxisLabelOverlapPolicy value) {
        this.overlapPolicyProperty().set((Object)value);
    }

    public ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    ReadOnlyDoubleWrapper scalePropertyImpl() {
        return this.scale;
    }

    public double getScale() {
        return this.scaleProperty().get();
    }

    protected void setScale(double scale) {
        this.scalePropertyImpl().set(scale);
    }

    @Override
    public ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    @Override
    public Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    @Override
    public void setSide(Side value) {
        this.sideProperty().set((Object)value);
    }

    public ObjectProperty<Paint> tickLabelFillProperty() {
        return this.tickLabelFill;
    }

    @Override
    public Paint getTickLabelFill() {
        return (Paint)this.tickLabelFillProperty().get();
    }

    public void setTickLabelFill(Paint value) {
        this.tickLabelFillProperty().set((Object)value);
    }

    public ObjectProperty<Font> tickLabelFontProperty() {
        return this.tickLabelFont;
    }

    @Override
    public Font getTickLabelFont() {
        return (Font)this.tickLabelFontProperty().get();
    }

    public void setTickLabelFont(Font value) {
        this.tickLabelFontProperty().set((Object)value);
    }

    public ObjectProperty<StringConverter<Number>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    @Override
    public StringConverter<Number> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatterProperty().getValue();
    }

    public void setTickLabelFormatter(StringConverter<Number> value) {
        this.tickLabelFormatterProperty().setValue(value);
    }

    public DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    @Override
    public double getTickLabelGap() {
        return this.tickLabelGapProperty().get();
    }

    public void setTickLabelGap(double value) {
        this.tickLabelGapProperty().set(value);
    }

    public DoubleProperty tickLabelRotationProperty() {
        return this.tickLabelRotation;
    }

    public double getTickLabelRotation() {
        return this.tickLabelRotationProperty().getValue();
    }

    public void setTickLabelRotation(double value) {
        this.tickLabelRotationProperty().setValue((Number)value);
    }

    public BooleanProperty tickLabelsVisibleProperty() {
        return this.tickLabelsVisible;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisibleProperty().get();
    }

    public void setTickLabelsVisible(boolean value) {
        this.tickLabelsVisibleProperty().set(value);
    }

    public DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    public double getTickLength() {
        return this.tickLengthProperty().get();
    }

    public void setTickLength(double value) {
        this.tickLengthProperty().set(value);
    }

    public BooleanProperty tickMarkVisibleProperty() {
        return this.tickMarkVisible;
    }

    public boolean isTickMarkVisible() {
        return this.tickMarkVisibleProperty().get();
    }

    public void setTickMarkVisible(boolean value) {
        this.tickMarkVisibleProperty().set(value);
    }

    @Override
    public DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    @Override
    public double getTickUnit() {
        return this.tickUnitProperty().get();
    }

    @Override
    public void setTickUnit(double unit) {
        this.tickUnitProperty().set(unit);
    }

    @Override
    public BooleanProperty timeAxisProperty() {
        return this.timeAxis;
    }

    @Override
    public boolean isTimeAxis() {
        return this.timeAxisProperty().get();
    }

    @Override
    public void setTimeAxis(boolean value) {
        this.timeAxisProperty().set(value);
    }

    @Override
    public ObjectProperty<String> unitProperty() {
        return this.axisUnit;
    }

    public String getUnit() {
        return (String)this.unitProperty().get();
    }

    @Override
    public void setUnit(String value) {
        this.unitProperty().set((Object)value);
    }

    @Override
    public DoubleProperty unitScalingProperty() {
        return this.unitScaling;
    }

    @Override
    public double getUnitScaling() {
        return this.unitScalingProperty().get();
    }

    @Override
    public void setUnitScaling(double value) {
        if (!Double.isFinite(value) || value == 0.0) {
            throw new IllegalArgumentException("provided number is not finite and/or zero: " + value);
        }
        this.setTickUnit(value);
        this.unitScalingProperty().set(value);
    }

    @Override
    public void setUnitScaling(MetricPrefix prefix) {
        this.unitScalingProperty().set(prefix.getPower());
    }

    protected BooleanProperty validProperty() {
        return this.valid;
    }

    public boolean isValid() {
        return this.validProperty().get();
    }

    private static class StyleableProperties {
        private static final CssMetaData<AbstractAxisParameter, Side> SIDE = new CssMetaData<AbstractAxisParameter, Side>("-fx-side", (StyleConverter)new EnumConverter(Side.class)){

            public StyleableProperty<Side> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.sideProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.sideProperty().isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, AxisLabelOverlapPolicy> OVERLAP_POLICY = new CssMetaData<AbstractAxisParameter, AxisLabelOverlapPolicy>("-fx-overlap-policy", (StyleConverter)new EnumConverter(AxisLabelOverlapPolicy.class)){

            public StyleableProperty<AxisLabelOverlapPolicy> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.overlapPolicyProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.overlapPolicy.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, TextAlignment> AXIS_LABEL_ALIGNMENT = new CssMetaData<AbstractAxisParameter, TextAlignment>("-fx-axis-label-alignment", (StyleConverter)new EnumConverter(TextAlignment.class)){

            public StyleableProperty<TextAlignment> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.axisLabelTextAlignmentProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.axisLabelTextAlignment.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, String> AXIS_LABEL = new CssMetaData<AbstractAxisParameter, String>("-fx-axis-label", javafx.css.converter.StringConverter.getInstance()){

            public StyleableProperty<String> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.nameProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.axisName.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> CENTER_AXIS_POSITION = new CssMetaData<AbstractAxisParameter, Number>("-fx-centre-axis-position", SizeConverter.getInstance(), (Number)0.5){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.centerAxisPositionProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.centerAxisPosition.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> AXIS_PADDING = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-padding", SizeConverter.getInstance(), (Number)15.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.axisPaddingProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.axisPadding.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> TICK_LENGTH = new CssMetaData<AbstractAxisParameter, Number>("-fx-tick-length", SizeConverter.getInstance(), (Number)8.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLengthProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickLength.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Font> TICK_LABEL_FONT = new FontCssMetaData<AbstractAxisParameter>("-fx-tick-label-font", Font.font((String)"system", (double)8.0)){

            public StyleableProperty<Font> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelFontProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickLabelFont.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Paint> TICK_LABEL_FILL = new CssMetaData<AbstractAxisParameter, Paint>("-fx-tick-label-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

            public StyleableProperty<Paint> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelFillProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickLabelFill.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> TICK_LABEL_TICK_GAP = new CssMetaData<AbstractAxisParameter, Number>("-fx-tick-label-gap", SizeConverter.getInstance(), (Number)3.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelGapProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickLabelGap.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> AXIS_LABEL_TICK_GAP = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-label-gap", SizeConverter.getInstance(), (Number)3.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelGapProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickLabelGap.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> MAX_TICK_LABEL_COUNT = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-max-major-tick-label-count", SizeConverter.getInstance(), (Number)20){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.maxMajorTickLabelCountProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.maxMajorTickLabelCount.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> ANIMATION_DURATION = new CssMetaData<AbstractAxisParameter, Number>("-fx-axis-animation-duration", SizeConverter.getInstance(), (Number)250){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.animationDurationProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.animationDuration.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> TICK_MARK_VISIBLE = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-tick-mark-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickMarkVisibleProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickMarkVisible.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> TICK_LABELS_VISIBLE = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-tick-labels-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.tickLabelsVisibleProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.tickLabelsVisible.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> TICK_UNIT = new CssMetaData<AbstractAxisParameter, Number>("-fx-tick-unit", SizeConverter.getInstance(), (Number)5.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter axis) {
                return (StyleableProperty)axis.tickUnitProperty();
            }

            public boolean isSettable(AbstractAxisParameter axis) {
                return axis != null && !axis.tickUnit.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> TICK_LABEL_ROTATION = new CssMetaData<AbstractAxisParameter, Number>("-fx-tick-rotation", SizeConverter.getInstance(), (Number)0.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter axis) {
                return (StyleableProperty)axis.tickLabelRotationProperty();
            }

            public boolean isSettable(AbstractAxisParameter axis) {
                return axis != null && !axis.tickLabelRotationProperty().isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> MINOR_TICK_LENGTH = new CssMetaData<AbstractAxisParameter, Number>("-fx-minor-tick-length", SizeConverter.getInstance(), (Number)5.0){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.minorTickLengthProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.minorTickLength.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Number> MINOR_TICK_COUNT = new CssMetaData<AbstractAxisParameter, Number>("-fx-minor-tick-count", SizeConverter.getInstance(), (Number)5){

            public StyleableProperty<Number> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.minorTickCountProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.minorTickCount.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> MINOR_TICK_VISIBLE = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-minor-tick-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.minorTickVisibleProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.minorTickVisible.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> AUTO_RANGING = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-auto-ranging", BooleanConverter.getInstance(), Boolean.TRUE){

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.autoRangingProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.autoRangingProperty().isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> AUTO_GROW_RANGING = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-auto-grow-ranging", BooleanConverter.getInstance(), Boolean.FALSE){

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.autoGrowRangingProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.autoGrowRanging.isBound();
            }
        };
        private static final CssMetaData<AbstractAxisParameter, Boolean> AUTO_RANGE_ROUNDING = new CssMetaData<AbstractAxisParameter, Boolean>("-fx-auto-range-rounding", BooleanConverter.getInstance(), Boolean.FALSE){

            public StyleableProperty<Boolean> getStyleableProperty(AbstractAxisParameter n) {
                return (StyleableProperty)n.autoRangeRoundingProperty();
            }

            public boolean isSettable(AbstractAxisParameter n) {
                return n != null && !n.autoRangeRounding.isBound();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
            styleables.add(SIDE);
            styleables.add(CENTER_AXIS_POSITION);
            styleables.add(AXIS_PADDING);
            styleables.add(AXIS_LABEL_TICK_GAP);
            styleables.add(AXIS_LABEL_ALIGNMENT);
            styleables.add(AXIS_LABEL);
            styleables.add(ANIMATION_DURATION);
            styleables.add(TICK_LENGTH);
            styleables.add(TICK_LABEL_FONT);
            styleables.add(TICK_LABEL_FILL);
            styleables.add(TICK_LABEL_TICK_GAP);
            styleables.add(TICK_MARK_VISIBLE);
            styleables.add(TICK_LABELS_VISIBLE);
            styleables.add(TICK_LABEL_ROTATION);
            styleables.add(TICK_UNIT);
            styleables.add(MINOR_TICK_COUNT);
            styleables.add(MINOR_TICK_LENGTH);
            styleables.add(MINOR_TICK_VISIBLE);
            styleables.add(AUTO_RANGING);
            styleables.add(AUTO_GROW_RANGING);
            styleables.add(AUTO_RANGE_ROUNDING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

