/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.axes.spi.format.DefaultFormatter;
import de.gsi.chart.axes.spi.format.DefaultLogFormatter;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.ui.ResizableCanvas;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import javafx.util.StringConverter;

public abstract class AbstractAxis
extends AbstractAxisParameter
implements Axis {
    protected static final double MIN_NARROW_FONT_SCALE = 0.7;
    protected static final double MAX_NARROW_FONT_SCALE = 1.0;
    protected static final int RANGE_ANIMATION_DURATION_MS = 700;
    protected static final int BURST_LIMIT_CSS_MS = 3000;
    private long lastCssUpdate;
    private boolean callCssUpdater;
    protected final Timeline animator = new Timeline();
    private final Canvas canvas = new ResizableCanvas();
    protected boolean labelOverlap;
    protected double scaleFont = 1.0;
    protected double cachedOffset;
    protected final transient ReentrantLock lock = new ReentrantLock();
    protected double maxLabelHeight;
    protected double maxLabelWidth;
    protected final DoubleProperty currentLowerBound = new SimpleDoubleProperty((Object)this, "currentLowerBound");
    private final ObjectProperty<AxisLabelFormatter> axisFormatter = new SimpleObjectProperty<AxisLabelFormatter>((Object)this, "axisLabelFormatter", null){
        private final AxisLabelFormatter defaultFormatter;
        private final AxisLabelFormatter defaultLogFormatter;
        private final AxisLabelFormatter defaultTimeFormatter;
        private final AxisLabelFormatter defaultLogTimeFormatter;
        {
            this.defaultFormatter = new DefaultFormatter(AbstractAxis.this);
            this.defaultLogFormatter = new DefaultLogFormatter(AbstractAxis.this);
            this.defaultTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
            this.defaultLogTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
        }

        public AxisLabelFormatter get() {
            AxisLabelFormatter superImpl = (AxisLabelFormatter)super.get();
            if (superImpl != null) {
                return superImpl;
            }
            if (AbstractAxis.this.isTimeAxis()) {
                if (AbstractAxis.this.isLogAxis()) {
                    return this.defaultLogTimeFormatter;
                }
                return this.defaultTimeFormatter;
            }
            if (AbstractAxis.this.isLogAxis()) {
                return this.defaultLogFormatter;
            }
            return this.defaultFormatter;
        }

        protected void invalidated() {
            AbstractAxis.this.invalidateCaches();
            AbstractAxis.this.invalidate();
            AbstractAxis.this.requestAxisLayout();
        }
    };
    protected WeakHashMap<String, TickMark> tickMarkStringCache = new WeakHashMap();
    protected WeakHashMap<Double, TickMark> tickMarkDoubleCache = new WeakHashMap();

    public AbstractAxis() {
        this.setMouseTransparent(false);
        this.setPickOnBounds(true);
        this.canvas.setMouseTransparent(false);
        this.canvas.toFront();
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.getChildren().add((Object)this.canvas);
        ChangeListener axisSizeChangeListener = (c, o, n) -> {
            if (o == n) {
                return;
            }
            double padding = this.getAxisPadding();
            if (this.getSide().isHorizontal()) {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight());
                this.canvas.setLayoutX(-padding);
            } else {
                this.canvas.resize(this.getWidth(), this.getHeight() + 2.0 * padding);
                this.canvas.setLayoutY(-padding);
            }
            this.invalidate();
            this.requestLayout();
        };
        this.axisPaddingProperty().addListener((ch, o, n) -> {
            if (o == n) {
                return;
            }
            double padding = this.getAxisPadding();
            if (this.getSide().isHorizontal()) {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight());
                this.canvas.setLayoutX(-padding);
            } else {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight() + 2.0 * padding);
                this.canvas.setLayoutY(-padding);
            }
        });
        this.widthProperty().addListener(axisSizeChangeListener);
        this.heightProperty().addListener(axisSizeChangeListener);
        this.sideProperty().addListener((ch, o, n) -> {
            switch (n) {
                case CENTER_VER: 
                case CENTER_HOR: {
                    this.getAxisLabel().setTextAlignment(TextAlignment.RIGHT);
                    break;
                }
                default: {
                    this.getAxisLabel().setTextAlignment(TextAlignment.CENTER);
                }
            }
        });
        this.invertAxisProperty().addListener((ch, o, n) -> Platform.runLater(() -> {
            this.clear();
            this.invalidateCaches();
            this.forceRedraw();
        }));
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
    }

    public AbstractAxis(double lowerBound, double upperBound) {
        this();
        this.set(lowerBound, upperBound);
        this.setAutoRanging(false);
    }

    public ObjectProperty<AxisLabelFormatter> axisLabelFormatterProperty() {
        return this.axisFormatter;
    }

    public abstract double computePreferredTickUnit(double var1);

    @Override
    public void drawAxis(GraphicsContext gc, double axisWidth, double axisHeight) {
        if (gc == null || this.getSide() == null) {
            return;
        }
        this.drawAxisPre();
        this.updateCSS();
        double axisLength = this.getSide().isHorizontal() ? axisWidth : axisHeight;
        this.drawAxisLine(gc, axisLength, axisWidth, axisHeight);
        if (!this.isTickMarkVisible()) {
            this.drawAxisLabel(gc, axisWidth, axisHeight, this.getAxisLabel(), null, this.getTickLength());
            this.drawAxisPost();
            return;
        }
        ObservableList<TickMark> majorTicks = this.getTickMarks();
        ObservableList<TickMark> minorTicks = this.getMinorTickMarks();
        double neededLength = (double)(this.getTickMarks().size() + minorTicks.size()) * 2.0;
        if (this.isMinorTickVisible() && axisLength > neededLength) {
            this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, minorTicks, this.getMinorTickLength(), this.getMinorTickStyle());
            this.drawTickLabels(gc, axisWidth, axisHeight, minorTicks, this.getMinorTickLength());
        }
        this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, majorTicks, this.getTickLength(), this.getMajorTickStyle());
        this.drawTickLabels(gc, axisWidth, axisHeight, majorTicks, this.getTickLength());
        this.drawAxisLabel(gc, axisWidth, axisHeight, this.getAxisLabel(), majorTicks, this.getTickLength());
        this.drawAxisPost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireInvalidated() {
        AtomicBoolean atomicBoolean = this.autoNotification();
        synchronized (atomicBoolean) {
            if (!this.autoNotification().get() || this.updateEventListener().isEmpty()) {
                return;
            }
        }
        if (Platform.isFxApplicationThread()) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this), false);
        } else {
            Platform.runLater(() -> this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this), false));
        }
    }

    @Override
    public void forceRedraw() {
        this.invalidate();
        this.layoutChildren();
    }

    public AxisLabelFormatter getAxisLabelFormatter() {
        return (AxisLabelFormatter)this.axisFormatter.get();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public double getDisplayPosition(double value) {
        return this.cachedOffset + (value - this.currentLowerBound.get()) * this.getScale();
    }

    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    public TickMark getNewTickMark(Double tickValue, double tickPosition, String tickMarkLabel) {
        TickMark tick;
        if (tickMarkLabel.isEmpty()) {
            tick = this.tickMarkDoubleCache.computeIfAbsent(tickValue, k -> new TickMark(this.getSide(), tickValue, tickPosition, this.getTickLabelRotation(), ""));
        } else {
            tick = this.tickMarkStringCache.computeIfAbsent(tickMarkLabel, k -> new TickMark(this.getSide(), tickValue, tickPosition, this.getTickLabelRotation(), (String)k));
            tick.setValue(tickValue);
        }
        tick.setPosition(tickPosition);
        tick.setVisible(true);
        return tick;
    }

    @Override
    public String getTickMarkLabel(double value) {
        double scaledValue = value / this.getUnitScaling();
        StringConverter<Number> formatter = this.getTickLabelFormatter();
        if (formatter != null) {
            return formatter.toString((Object)scaledValue);
        }
        return this.getAxisLabelFormatter().toString(scaledValue);
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getMin() || 0.0 > this.getMax()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    public void invalidateCaches() {
        this.getTickMarkValues().clear();
        this.getMinorTickMarkValues().clear();
        this.getTickMarks().clear();
        this.getMinorTickMarks().clear();
        this.tickMarkStringCache.clear();
        this.tickMarkDoubleCache.clear();
    }

    @Override
    public void invalidateRange(List<Number> data) {
        double dataMinValue;
        double dataMaxValue;
        if (data.isEmpty()) {
            dataMaxValue = this.getMax();
            dataMinValue = this.getMin();
            this.getAutoRange().set(this.getMin(), this.getMax());
        } else {
            dataMinValue = Double.MAX_VALUE;
            dataMaxValue = -1.7976931348623157E308;
            this.getAutoRange().clear();
        }
        for (Number dataValue : data) {
            dataMinValue = Math.min(dataMinValue, dataValue.doubleValue());
            dataMaxValue = Math.max(dataMaxValue, dataValue.doubleValue());
            this.getAutoRange().add(dataValue.doubleValue());
        }
        boolean oldState = this.autoNotification().getAndSet(false);
        boolean change = this.set(dataMinValue, dataMaxValue);
        if (change) {
            data.clear();
            this.getAutoRange().setAxisLength(this.getLength() == 0.0 ? 1.0 : this.getLength(), this.getSide());
            this.invalidate();
        }
        if (this.getAutoRange().getMax() != this.getMax() || this.getAutoRange().getMin() != this.getMin() || this.getAutoRange().getAxisLength() != this.getLength()) {
            this.invalidate();
        }
        this.autoNotification().set(oldState);
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    }

    public boolean isLabelOverlapping() {
        return this.labelOverlap;
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return Double.isFinite(value) && value >= this.getMin() && value <= this.getMax();
    }

    public void recomputeTickMarks() {
        this.recomputeTickMarks(this.getRange());
    }

    @Override
    public void requestAxisLayout() {
        super.requestLayout();
    }

    public void setAxisLabelFormatter(AxisLabelFormatter value) {
        this.axisFormatter.set((Object)value);
    }

    @Override
    public boolean setMax(double value) {
        if (this.isLogAxis() && (value <= 0.0 || !Double.isFinite(value))) {
            if (this.getMin() >= 0.0) {
                return super.setMax(this.getMin() * 1000000.0);
            }
            return false;
        }
        return super.setMax(value);
    }

    @Override
    public boolean setMin(double value) {
        if (this.isLogAxis() && (value <= 0.0 || !Double.isFinite(value))) {
            if (this.getMax() > 0.0) {
                return super.setMin(this.getMax() / 1000000.0);
            }
            return false;
        }
        return super.setMin(value);
    }

    protected AxisRange autoRange(double length) {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            double labelSize = this.getTickLabelFont().getSize() * 1.2;
            return this.autoRange(this.getAutoRange().getMin(), this.getAutoRange().getMax(), length, labelSize);
        }
        return this.getAxisRange();
    }

    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        return this.computeRange(minValue, maxValue, length, labelSize);
    }

    protected abstract List<Double> calculateMajorTickValues(double var1, AxisRange var3);

    protected abstract List<Double> calculateMinorTickValues();

    protected double calculateNewScale(double length, double lowerBound, double upperBound) {
        double newScale = 1.0;
        Side side = this.getSide();
        double diff = upperBound - lowerBound;
        if (side.isVertical()) {
            this.cachedOffset = length;
            newScale = diff == 0.0 ? -length : -(length / diff);
        } else {
            this.cachedOffset = 0.0;
            newScale = upperBound - lowerBound == 0.0 ? length : length / diff;
        }
        return newScale == 0.0 ? -1.0 : newScale;
    }

    protected void clearAxisCanvas(GraphicsContext gc, double width, double height) {
        gc.clearRect(0.0, 0.0, width, height);
    }

    protected double computePrefHeight(double width) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_HOR || side.isVertical()) {
            return 150.0;
        }
        if (this.getTickMarks().isEmpty()) {
            AxisRange range = this.autoRange(width);
            this.computeTickMarks(range, true);
            this.invalidate();
        }
        double maxLabelHeightLocal = this.isTickLabelsVisible() ? this.maxLabelHeight : 0.0;
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        double labelHeight = this.axisLabel.getText() == null || this.axisLabel.getText().isEmpty() ? 0.0 : this.axisLabel.prefHeight(-1.0) + 2.0 * this.getAxisLabelGap();
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? labelHeight : 0.0;
        return tickMarkLength + maxLabelHeightLocal + labelHeight + shiftedLabels;
    }

    protected double computePrefWidth(double height) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_VER || side.isHorizontal()) {
            return 150.0;
        }
        if (this.getTickMarks().isEmpty()) {
            AxisRange range = this.autoRange(height);
            this.computeTickMarks(range, true);
            this.invalidate();
        }
        double maxLabelWidthLocal = this.isTickLabelsVisible() ? this.maxLabelWidth : 0.0;
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        double labelHeight = this.axisLabel.getText() == null || this.axisLabel.getText().isEmpty() ? 0.0 : this.axisLabel.prefHeight(-1.0) + 2.0 * this.getAxisLabelGap();
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? labelHeight : 0.0;
        return maxLabelWidthLocal + tickMarkLength + labelHeight + shiftedLabels;
    }

    protected abstract AxisRange computeRange(double var1, double var3, double var5, double var7);

    protected List<TickMark> computeTickMarks(AxisRange range, boolean majorTickMark) {
        List<Double> newTickValues;
        ObservableList<TickMark> oldTickMarks;
        Side side = this.getSide();
        ObservableList<TickMark> observableList = oldTickMarks = majorTickMark ? this.getTickMarks() : this.getMinorTickMarks();
        if (side == null) {
            return oldTickMarks;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        double axisLength = side.isVertical() ? height : width;
        ObservableList<Double> oldTickValues = majorTickMark ? this.getTickMarkValues() : this.getMinorTickMarkValues();
        List<Double> list = newTickValues = majorTickMark ? this.calculateMajorTickValues(axisLength, range) : this.calculateMinorTickValues();
        if (!oldTickValues.isEmpty() && !oldTickMarks.isEmpty() && newTickValues.equals(oldTickValues)) {
            return oldTickMarks;
        }
        if (majorTickMark) {
            this.getAxisLabelFormatter().updateFormatter(newTickValues, this.getUnitScaling());
        }
        if (newTickValues.size() > 2) {
            if (majorTickMark) {
                this.getTickMarkValues().setAll(newTickValues);
            } else {
                this.getMinorTickMarkValues().setAll(newTickValues);
            }
        }
        if (majorTickMark) {
            this.maxLabelHeight = 0.0;
            this.maxLabelWidth = 0.0;
        }
        LinkedList<TickMark> newTickMarkList = new LinkedList<TickMark>();
        newTickValues.forEach(tickValue -> {
            double tickPosition = this.getDisplayPosition((double)tickValue);
            String tickMarkLabel = majorTickMark ? this.getTickMarkLabel((double)tickValue) : "";
            TickMark tick = this.getNewTickMark((Double)tickValue, tickPosition, tickMarkLabel);
            newTickMarkList.add(tick);
            this.maxLabelHeight = Math.max(this.maxLabelHeight, tick.getHeight());
            this.maxLabelWidth = Math.max(this.maxLabelWidth, tick.getWidth());
            if (majorTickMark && this.shouldAnimate()) {
                tick.setOpacity(0.0);
                FadeTransition ft = new FadeTransition(Duration.millis((double)750.0), (Node)tick);
                tick.opacityProperty().addListener((ch, o, n) -> {
                    this.clearAxisCanvas(this.canvas.getGraphicsContext2D(), width, height);
                    this.drawAxis(this.canvas.getGraphicsContext2D(), width, height);
                });
                ft.setFromValue(0.0);
                ft.setToValue(1.0);
                ft.play();
            }
        });
        return newTickMarkList;
    }

    protected void drawAxisLabel(GraphicsContext gc, double axisWidth, double axisHeight, Text axisName, ObservableList<TickMark> tickMarks, double tickLength) {
        double labelGap;
        double labelPosition;
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        boolean isHorizontal = this.getSide().isHorizontal();
        double tickLabelGap = this.getTickLabelGap();
        double axisLabelGap = this.getAxisLabelGap();
        double axisCentre = this.getCenterAxisPosition();
        switch (axisName.getTextAlignment()) {
            case LEFT: {
                labelPosition = 0.0;
                labelGap = tickLabelGap;
                break;
            }
            case RIGHT: {
                labelPosition = 1.0;
                labelGap = -tickLabelGap;
                break;
            }
            default: {
                labelPosition = 0.5;
                labelGap = 0.0;
            }
        }
        double tickLabelSize = isHorizontal ? this.maxLabelHeight : this.maxLabelWidth;
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? tickLabelSize + tickLabelGap : 0.0;
        gc.save();
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.setTextBaseline(VPos.BASELINE);
                double x = axisWidth - tickLength - 2.0 * tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                double y = (1.0 - labelPosition) * axisHeight - labelGap;
                axisName.setRotate(-90.0);
                AbstractAxis.drawAxisLabel(gc, x, y, axisName);
                break;
            }
            case RIGHT: {
                gc.setTextBaseline(VPos.TOP);
                axisName.setRotate(-90.0);
                double x = tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                double y = (1.0 - labelPosition) * axisHeight - labelGap;
                AbstractAxis.drawAxisLabel(gc, x, y, axisName);
                break;
            }
            case TOP: {
                gc.setTextBaseline(VPos.BOTTOM);
                double x = labelPosition * axisWidth + labelGap;
                double y = axisHeight - tickLength - tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                AbstractAxis.drawAxisLabel(gc, x, y, axisName);
                break;
            }
            case BOTTOM: {
                gc.setTextBaseline(VPos.TOP);
                double x = labelPosition * axisWidth + labelGap;
                double y = tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                AbstractAxis.drawAxisLabel(gc, x, y, axisName);
                break;
            }
            case CENTER_VER: {
                gc.setTextBaseline(VPos.TOP);
                axisName.setRotate(-90.0);
                double x = axisCentre * axisWidth - tickLength - 2.0 * tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                double y = (1.0 - labelPosition) * axisHeight - labelGap;
                AbstractAxis.drawAxisLabel(gc, x, y, axisName);
                break;
            }
            case CENTER_HOR: {
                gc.setTextBaseline(VPos.TOP);
                double x = labelPosition * axisWidth + labelGap;
                double y = axisCentre * axisHeight + tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                AbstractAxis.drawAxisLabel(gc, x, y, axisName);
                break;
            }
        }
        gc.restore();
    }

    protected void drawAxisLine(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight) {
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        Path tickStyle = this.getMajorTickStyle();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setFill(tickStyle.getFill());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.strokeLine(AbstractAxis.snap(axisWidth), AbstractAxis.snap(0.0), AbstractAxis.snap(axisWidth), AbstractAxis.snap(axisLength));
                break;
            }
            case RIGHT: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(axisLength));
                break;
            }
            case TOP: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(axisHeight), AbstractAxis.snap(axisLength), AbstractAxis.snap(axisHeight));
                break;
            }
            case BOTTOM: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(axisLength), AbstractAxis.snap(0.0));
                break;
            }
            case CENTER_HOR: {
                gc.strokeLine(AbstractAxis.snap(0.0), axisCentre * axisHeight, AbstractAxis.snap(axisLength), AbstractAxis.snap(axisCentre * axisHeight));
                break;
            }
            case CENTER_VER: {
                gc.strokeLine(AbstractAxis.snap(axisCentre * axisWidth), AbstractAxis.snap(0.0), AbstractAxis.snap(axisCentre * axisWidth), AbstractAxis.snap(axisLength));
                break;
            }
        }
        gc.restore();
    }

    protected void drawAxisPost() {
    }

    protected void drawAxisPre() {
    }

    protected void drawTickLabels(GraphicsContext gc, double axisWidth, double axisHeight, ObservableList<TickMark> tickMarks, double tickLength) {
        if (tickLength <= 0.0 || tickMarks.isEmpty()) {
            return;
        }
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        AxisLabelOverlapPolicy overlapPolicy = this.getOverlapPolicy();
        double tickLabelGap = this.getTickLabelGap();
        gc.save();
        gc.translate(paddingX, paddingY);
        TickMark firstTick = (TickMark)((Object)tickMarks.get(0));
        gc.setGlobalAlpha(firstTick.getOpacity());
        int counter = (int)firstTick.getValue() % 2;
        switch (this.getSide()) {
            case LEFT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = axisWidth - tickLength - tickLabelGap;
                    double y = position;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                x -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, x -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), y, this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case RIGHT: 
            case CENTER_VER: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = tickLength + tickLabelGap;
                    double y = position;
                    if (this.getSide().equals((Object)Side.CENTER_VER)) {
                        x += axisCentre * axisWidth;
                    }
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                x += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, x += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), y, this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case TOP: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = position;
                    double y = axisHeight - tickLength - tickLabelGap;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, x, y -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case BOTTOM: 
            case CENTER_HOR: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = position;
                    double y = tickLength + tickLabelGap;
                    if (this.getSide().equals((Object)Side.CENTER_HOR)) {
                        y += axisCentre * axisHeight;
                    }
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, x, y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, x, y, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
        }
        gc.restore();
    }

    protected void drawTickMarks(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight, ObservableList<TickMark> tickMarks, double tickLength, Path tickStyle) {
        if (tickLength <= 0.0) {
            return;
        }
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getCenterAxisPosition();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setFill(tickStyle.getFill());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(axisWidth - tickLength);
                    double x1 = AbstractAxis.snap(axisWidth);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
            case RIGHT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(0.0);
                    double x1 = AbstractAxis.snap(tickLength);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
            case TOP: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(axisHeight);
                    double y1 = AbstractAxis.snap(axisHeight - tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case BOTTOM: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(0.0);
                    double y1 = AbstractAxis.snap(tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case CENTER_HOR: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(axisCentre * axisHeight - tickLength);
                    double y1 = AbstractAxis.snap(axisCentre * axisHeight + tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case CENTER_VER: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(axisCentre * axisWidth - tickLength);
                    double x1 = AbstractAxis.snap(axisCentre * axisWidth + tickLength);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
        }
        gc.restore();
    }

    protected AxisRange getAxisRange() {
        return new AxisRange(this.getMin(), this.getMax(), this.getLength(), this.getScale(), this.getTickUnit());
    }

    protected void layoutChildren() {
        double axisLength;
        if (this.isValid() && !super.isNeedsLayout()) {
            super.layoutChildren();
            return;
        }
        Side side = this.getSide();
        if (side == null) {
            return;
        }
        double axisWidth = this.getWidth();
        double axisHeight = this.getHeight();
        double d = axisLength = side.isVertical() ? axisHeight : axisWidth;
        if (!this.isAutoRanging()) {
            this.setScale(this.calculateNewScale(axisLength, this.getMin(), this.getMax()));
            this.currentLowerBound.set(this.getMin());
        }
        boolean isFirstPass = this.oldAxisLength == -1.0;
        double preferredTickUnit = this.computePreferredTickUnit(axisLength);
        boolean tickUnitDiffers = this.getTickUnit() != preferredTickUnit;
        boolean lengthDiffers = this.oldAxisLength != axisLength;
        boolean rangeDiffers = this.oldAxisMin != this.getMin() || this.oldAxisMax != this.getMax() || this.oldTickUnit != this.getTickUnit();
        boolean recomputedTicks = false;
        if (lengthDiffers || rangeDiffers || tickUnitDiffers) {
            AxisRange newAxisRange;
            recomputedTicks = true;
            if (this.isAutoRanging()) {
                newAxisRange = this.autoRange(axisLength);
                this.setRange(newAxisRange, this.isAnimated() && !isFirstPass);
            } else {
                newAxisRange = this.getAxisRange();
            }
            this.setTickUnit(this.computePreferredTickUnit(axisLength));
            newAxisRange.tickUnit = this.getTickUnit();
            this.updateAxisLabelAndUnit();
            this.recomputeTickMarks(newAxisRange);
            this.oldAxisLength = axisLength;
            this.oldAxisMin = this.getMin();
            this.oldAxisMax = this.getMax();
            this.oldTickUnit = this.getTickUnit();
            this.updateCachedVariables();
            this.getTickMarks().forEach(mark -> {
                mark.setPosition(this.getDisplayPosition(mark.getValue()));
                mark.setVisible(true);
            });
            this.getMinorTickMarks().forEach(mark -> {
                mark.setPosition(this.getDisplayPosition(mark.getValue()));
                mark.setVisible(true);
            });
            double totalLabelsSize = 0.0;
            double maxLabelSize = 0.0;
            for (TickMark m : this.getTickMarks()) {
                double tickSize = side.isHorizontal() ? m.getWidth() : m.getHeight() + 2.0 * this.getTickLabelGap();
                totalLabelsSize += tickSize;
                maxLabelSize = Math.round(Math.max(maxLabelSize, tickSize));
            }
            this.labelOverlap = false;
            double projectedLengthFromIndividualMarks = (double)(this.majorTickMarks.size() + 1) * maxLabelSize;
            switch (this.getOverlapPolicy()) {
                case NARROW_FONT: {
                    double scale = axisLength / projectedLengthFromIndividualMarks;
                    if (scale >= 0.7 && scale <= 1.0) {
                        this.scaleFont = scale;
                        break;
                    }
                    this.scaleFont = Math.min(Math.max(scale, 0.7), 1.0);
                }
                case SKIP_ALT: {
                    int numLabelsToSkip = 0;
                    if (maxLabelSize > 0.0 && axisLength < totalLabelsSize) {
                        numLabelsToSkip = (int)(projectedLengthFromIndividualMarks / axisLength);
                        this.labelOverlap = true;
                    }
                    if (numLabelsToSkip <= 0) break;
                    int tickIndex = 0;
                    for (TickMark m : this.majorTickMarks) {
                        if (!m.isVisible()) continue;
                        m.setVisible(tickIndex++ % numLabelsToSkip == 0);
                    }
                    break;
                }
            }
            if (this.majorTickMarks.size() > 2) {
                TickMark m2;
                TickMark m1 = (TickMark)((Object)this.majorTickMarks.get(0));
                if (AbstractAxis.isTickLabelsOverlap(side, m1, m2 = (TickMark)((Object)this.majorTickMarks.get(1)), this.getTickLabelGap())) {
                    this.labelOverlap = true;
                }
                if (AbstractAxis.isTickLabelsOverlap(side, m1 = (TickMark)((Object)this.majorTickMarks.get(this.majorTickMarks.size() - 2)), m2 = (TickMark)((Object)this.majorTickMarks.get(this.majorTickMarks.size() - 1)), this.getTickLabelGap())) {
                    this.labelOverlap = true;
                }
            }
            this.tickMarksUpdated();
        }
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        this.clearAxisCanvas(gc, this.canvas.getWidth(), this.canvas.getHeight());
        this.drawAxis(gc, axisWidth, axisHeight);
        if (recomputedTicks) {
            this.fireInvalidated();
        }
        super.layoutChildren();
        this.validProperty().set(true);
    }

    protected double measureTickMarkLength(Double major) {
        TickMark tick = this.getNewTickMark(major, 0.0, this.getTickMarkLabel(major));
        return this.getSide().isHorizontal() ? tick.getWidth() : tick.getHeight();
    }

    protected void recomputeTickMarks(AxisRange range) {
        Side side = this.getSide();
        if (side == null) {
            return;
        }
        if (this.isTickMarkVisible() && this.isTickLabelsVisible()) {
            List<TickMark> majorTicks = this.computeTickMarks(range, true);
            if (!this.getTickMarks().equals(majorTicks) && !majorTicks.isEmpty()) {
                this.getTickMarks().setAll(majorTicks);
            }
        } else if (!this.getTickMarks().isEmpty()) {
            this.getTickMarks().clear();
        }
        if (this.isTickMarkVisible() && this.isMinorTickVisible()) {
            List<TickMark> minorTicks = this.computeTickMarks(range, false);
            if (!this.getMinorTickMarks().equals(minorTicks) && !minorTicks.isEmpty()) {
                this.getMinorTickMarks().setAll(minorTicks);
            }
        } else if (!this.getMinorTickMarks().isEmpty()) {
            this.getMinorTickMarks().clear();
        }
    }

    protected void setRange(AxisRange rangeObj, boolean animate) {
        AxisRange range = rangeObj;
        double oldLowerBound = this.getMin();
        this.set(range.getLowerBound(), range.getUpperBound());
        if (animate) {
            this.animator.stop();
            this.animator.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)oldLowerBound), new KeyValue((WritableValue)this.scaleBinding, (Object)this.getScale())}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)range.getLowerBound()), new KeyValue((WritableValue)this.scaleBinding, (Object)range.getScale())})});
            this.animator.play();
        } else {
            this.currentLowerBound.set(range.getLowerBound());
            this.setScale(range.getScale());
        }
    }

    protected boolean shouldAnimate() {
        return this.isAnimated() && this.getScene() != null;
    }

    protected void tickMarksUpdated() {
    }

    protected void updateCachedVariables() {
    }

    protected void updateCSS() {
        long now = System.nanoTime();
        double diffMillisSinceLastUpdate = TimeUnit.NANOSECONDS.toMillis(now - this.lastCssUpdate);
        if (diffMillisSinceLastUpdate < 3000.0) {
            if (!this.callCssUpdater) {
                this.callCssUpdater = true;
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)20.0), e -> this.requestLayout(), new KeyValue[0]);
                Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                Platform.runLater(() -> ((Timeline)timeline).play());
            }
            return;
        }
        this.lastCssUpdate = now;
        this.callCssUpdater = false;
        this.majorTickStyle.applyCss();
        this.minorTickStyle.applyCss();
        this.axisLabel.applyCss();
    }

    private static boolean isTickLabelsOverlap(Side side, TickMark m1, TickMark m2, double gap) {
        if (!m1.isVisible() || !m2.isVisible()) {
            return false;
        }
        double m1Size = side.isHorizontal() ? m1.getWidth() : m1.getHeight();
        double m2Size = side.isHorizontal() ? m2.getWidth() : m2.getHeight();
        double m1Start = m1.getPosition() - m1Size / 2.0;
        double m1End = m1.getPosition() + m1Size / 2.0;
        double m2Start = m2.getPosition() - m2Size / 2.0;
        double m2End = m2.getPosition() + m2Size / 2.0;
        return side.isVertical() ? m1Start - m2End <= gap : m2Start - m1End <= gap;
    }

    protected static void drawAxisLabel(GraphicsContext gc, double x, double y, Text label) {
        gc.save();
        gc.setTextAlign(label.getTextAlignment());
        gc.setFont(label.getFont());
        gc.setFill(label.getFill());
        gc.setStroke(label.getStroke());
        gc.setLineWidth(label.getStrokeWidth());
        gc.translate(x, y);
        gc.rotate(label.getRotate());
        gc.fillText(label.getText(), 0.0, 0.0);
        gc.restore();
    }

    protected static void drawTickMarkLabel(GraphicsContext gc, double x, double y, double scaleFont, TickMark tickMark) {
        gc.save();
        gc.setFont(tickMark.getFont());
        gc.setFill(tickMark.getFill());
        gc.setTextAlign(tickMark.getTextAlignment());
        gc.setTextBaseline(tickMark.getTextOrigin());
        gc.translate(x, y);
        if (tickMark.getRotate() != 0.0) {
            gc.rotate(tickMark.getRotate());
        }
        gc.setGlobalAlpha(tickMark.getOpacity());
        if (scaleFont != 1.0) {
            gc.scale(scaleFont, 1.0);
        }
        gc.fillText(tickMark.getText(), 0.0, 0.0);
        gc.restore();
    }

    protected static double getMaxTickLabelHeight(List<TickMark> tickMarks) {
        return tickMarks == null || tickMarks.isEmpty() ? 0.0 : tickMarks.stream().mapToDouble(TickMark::getHeight).max().getAsDouble();
    }

    protected static double getMaxTickLabelWidth(List<TickMark> tickMarks) {
        return tickMarks == null || tickMarks.isEmpty() ? 0.0 : tickMarks.stream().mapToDouble(TickMark::getWidth).max().getAsDouble();
    }

    protected static double snap(double coordinate) {
        return (double)Math.round(coordinate) + 0.5;
    }
}

