/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.PolarTickStep;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.chart.renderer.spi.GridRenderer;
import de.gsi.chart.renderer.spi.LabelledMarkerRenderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.utils.AssertUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XYChart
extends Chart {
    private static final Logger LOGGER = LoggerFactory.getLogger(XYChart.class);
    protected static final int BURST_LIMIT_MS = 15;
    protected BooleanProperty polarPlot = new SimpleBooleanProperty((Object)this, "polarPlot", false);
    private final ObjectProperty<PolarTickStep> polarStepSize = new SimpleObjectProperty((Object)PolarTickStep.THIRTY);
    private final GridRenderer gridRenderer = new GridRenderer();
    protected final ChangeListener<? super Boolean> gridLineVisibilitychange = (ob, o, n) -> this.requestLayout();
    private long lastCanvasUpdate;
    private boolean callCanvasUpdateLater;
    private final ChangeListener<Side> axisSideChangeListener = this::axisSideChanged;

    public XYChart() {
        this(null, null);
    }

    public XYChart(Axis xAxis, Axis yAxis) {
        if (xAxis != null) {
            if (xAxis.getSide() == null || !xAxis.getSide().isHorizontal()) {
                xAxis.setSide(Side.BOTTOM);
            }
            this.getAxes().add((Object)xAxis);
        }
        if (yAxis != null) {
            if (yAxis.getSide() == null || !yAxis.getSide().isVertical()) {
                yAxis.setSide(Side.LEFT);
            }
            this.getAxes().add((Object)yAxis);
        }
        this.gridRenderer.horizontalGridLinesVisibleProperty().addListener(this.gridLineVisibilitychange);
        this.gridRenderer.verticalGridLinesVisibleProperty().addListener(this.gridLineVisibilitychange);
        this.gridRenderer.drawOnTopProperty().addListener(this.gridLineVisibilitychange);
        this.setAnimated(false);
        this.getRenderers().addListener(this::rendererChanged);
        this.getRenderers().add((Object)new ErrorDataSetRenderer());
    }

    @Override
    public ObservableList<DataSet> getAllDatasets() {
        if (this.getRenderers() == null) {
            return this.allDataSets;
        }
        this.allDataSets.clear();
        this.allDataSets.addAll(this.getDatasets());
        this.getRenderers().stream().filter(renderer -> !(renderer instanceof LabelledMarkerRenderer)).forEach(renderer -> this.allDataSets.addAll(renderer.getDatasets()));
        return this.allDataSets;
    }

    public ObservableList<DataSet> getAllShownDatasets() {
        ObservableList ret = FXCollections.observableArrayList();
        ret.addAll(this.getDatasets());
        this.getRenderers().stream().filter(Renderer::showInLegend).forEach(renderer -> ret.addAll(renderer.getDatasets()));
        return ret;
    }

    public GridRenderer getGridRenderer() {
        return this.gridRenderer;
    }

    public PolarTickStep getPolarStepSize() {
        return (PolarTickStep)((Object)this.polarStepSizeProperty().get());
    }

    public Axis getXAxis() {
        return this.getFirstAxis(Orientation.HORIZONTAL);
    }

    public Axis getYAxis() {
        return this.getFirstAxis(Orientation.VERTICAL);
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.gridRenderer.horizontalGridLinesVisibleProperty();
    }

    public final boolean isHorizontalGridLinesVisible() {
        return this.horizontalGridLinesVisibleProperty().get();
    }

    public final boolean isPolarPlot() {
        return this.polarPlotProperty().get();
    }

    public final boolean isVerticalGridLinesVisible() {
        return this.verticalGridLinesVisibleProperty().get();
    }

    public final BooleanProperty polarPlotProperty() {
        return this.polarPlot;
    }

    public ObjectProperty<PolarTickStep> polarStepSizeProperty() {
        return this.polarStepSize;
    }

    public final void setHorizontalGridLinesVisible(boolean value) {
        this.horizontalGridLinesVisibleProperty().set(value);
    }

    public final XYChart setPolarPlot(boolean state) {
        this.polarPlotProperty().set(state);
        return this;
    }

    public void setPolarStepSize(PolarTickStep step) {
        this.polarStepSizeProperty().set((Object)step);
    }

    public final void setVerticalGridLinesVisible(boolean value) {
        this.verticalGridLinesVisibleProperty().set(value);
    }

    @Override
    public void updateAxisRange() {
        if (this.isDataEmpty()) {
            return;
        }
        ObservableList<DataSet> dataSets = this.getAllDatasets();
        dataSets.parallelStream().forEach(dataset -> dataset.getAxisDescriptions().parallelStream().filter(axisD -> !axisD.isDefined()).forEach(axisDescription -> dataset.lock().writeLockGuard(() -> dataset.recomputeLimits(dataset.getAxisDescriptions().indexOf(axisDescription)))));
        dataSets.forEach(ds -> ds.lock().readLock());
        try {
            this.getAxes().forEach(chartAxis -> {
                List<DataSet> dataSetForAxis = this.getDataSetForAxis((Axis)chartAxis);
                XYChart.updateNumericAxis(chartAxis, dataSetForAxis);
            });
        }
        finally {
            dataSets.forEach(ds -> ds.lock().readUnLock());
        }
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.gridRenderer.verticalGridLinesVisibleProperty();
    }

    private boolean isDataEmpty() {
        return this.getAllDatasets() == null || this.getAllDatasets().isEmpty();
    }

    @Override
    protected void axesChanged(ListChangeListener.Change<? extends Axis> change) {
        while (change.next()) {
            change.getRemoved().forEach(axis -> {
                AssertUtils.notNull((String)"to be removed axis is null", (Object)axis);
                this.removeFromAllAxesPanes((Axis)axis);
                axis.sideProperty().removeListener(this.axisSideChangeListener);
            });
            change.getAddedSubList().forEach(axis -> {
                AssertUtils.notNull((String)"to be added axis is null", (Object)axis);
                Side side = axis.getSide();
                if (side == null) {
                    throw new InvalidParameterException("axis '" + axis.getName() + "' has 'null' as side being set");
                }
                if (!this.getAxesPane(axis.getSide()).getChildren().contains((Object)((Node)axis))) {
                    this.getAxesPane(axis.getSide()).getChildren().add((Object)((Node)axis));
                }
                axis.sideProperty().addListener(this.axisSideChangeListener);
            });
        }
        this.requestLayout();
    }

    protected void axisSideChanged(ObservableValue<? extends Side> change, Side oldValue, Side newValue) {
        if (newValue != null && newValue.equals((Object)oldValue)) {
            return;
        }
        for (Axis axis : this.axesList) {
            if (axis.getSide() == null) {
                this.removeFromAllAxesPanes(axis);
            }
            if (this.getAxesPane(axis.getSide()).getChildren().contains((Object)((Node)axis))) continue;
            this.removeFromAllAxesPanes(axis);
            this.getAxesPane(axis.getSide()).getChildren().add((Object)((Node)axis));
        }
        this.requestLayout();
    }

    protected void checkRendererForRequiredAxes(Renderer renderer) {
        if (renderer.getAxes().size() < 2) {
            Optional<Axis> xAxis = renderer.getAxes().stream().filter(a -> a.getSide().isHorizontal()).findFirst();
            Optional<Axis> yAxis = renderer.getAxes().stream().filter(a -> a.getSide().isVertical()).findFirst();
            if (xAxis.isEmpty()) {
                renderer.getAxes().add((Object)this.getFirstAxis(Orientation.HORIZONTAL));
            }
            if (yAxis.isEmpty()) {
                renderer.getAxes().add((Object)this.getFirstAxis(Orientation.VERTICAL));
            }
        }
        this.getAxes().addAll((Collection)renderer.getAxes().stream().limit(2L).filter(a -> a.getSide() != null && !this.getAxes().contains(a)).collect(Collectors.toList()));
    }

    protected List<DataSet> getDataSetForAxis(Axis axis) {
        ArrayList<DataSet> retVal = new ArrayList<DataSet>();
        if (axis == null) {
            return retVal;
        }
        retVal.addAll((Collection<DataSet>)this.getDatasets());
        this.getRenderers().forEach(renderer -> renderer.getAxes().stream().filter(axis::equals).forEach(rendererAxis -> retVal.addAll((Collection<DataSet>)renderer.getDatasets())));
        return retVal;
    }

    @Override
    protected void redrawCanvas() {
        if (DEBUG && LOGGER.isDebugEnabled()) {
            LOGGER.debug("   xychart redrawCanvas() - pre");
        }
        this.setAutoNotification(false);
        FXUtils.assertJavaFxThread();
        long now = System.nanoTime();
        double diffMillisSinceLastUpdate = TimeUnit.NANOSECONDS.toMillis(now - this.lastCanvasUpdate);
        if (diffMillisSinceLastUpdate < 15.0) {
            if (!this.callCanvasUpdateLater) {
                this.callCanvasUpdateLater = true;
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)20.0), e -> this.requestLayout(), new KeyValue[0]);
                Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                Platform.runLater(() -> ((Timeline)timeline).play());
            }
            return;
        }
        if (DEBUG && LOGGER.isDebugEnabled()) {
            LOGGER.debug("   xychart redrawCanvas() - executing");
            LOGGER.debug("   xychart redrawCanvas() - canvas size = {}", (Object)String.format("%fx%f", this.canvas.getWidth(), this.canvas.getHeight()));
        }
        this.lastCanvasUpdate = now;
        this.callCanvasUpdateLater = false;
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (!this.gridRenderer.isDrawOnTop()) {
            this.gridRenderer.render(gc, this, 0, null);
        }
        int dataSetOffset = 0;
        for (Renderer renderer : this.getRenderers()) {
            this.checkRendererForRequiredAxes(renderer);
            renderer.render(gc, this, dataSetOffset, this.getDatasets());
            dataSetOffset += this.getDatasets().size() + renderer.getDatasets().size();
        }
        if (this.gridRenderer.isDrawOnTop()) {
            this.gridRenderer.render(gc, this, 0, null);
        }
        this.setAutoNotification(true);
        if (DEBUG && LOGGER.isDebugEnabled()) {
            LOGGER.debug("   xychart redrawCanvas() - done");
        }
    }

    @Override
    protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
        FXUtils.assertJavaFxThread();
        super.rendererChanged(change);
        this.requestLayout();
        this.updateLegend((List<DataSet>)this.getDatasets(), (List<Renderer>)this.getRenderers());
    }

    protected static void updateNumericAxis(Axis axis, List<DataSet> dataSets) {
        if (dataSets == null || dataSets.isEmpty()) {
            return;
        }
        boolean oldAutoState = axis.autoNotification().getAndSet(false);
        double oldMin = axis.getMin();
        double oldMax = axis.getMax();
        double oldLength = axis.getLength();
        boolean isHorizontal = axis.getSide().isHorizontal();
        Side side = axis.getSide();
        axis.getAutoRange().clear();
        dataSets.forEach(dataset -> {
            if (dataset instanceof DataSet3D && (side == Side.RIGHT || side == Side.TOP)) {
                DataSet3D mDataSet = (DataSet3D)dataset;
                axis.getAutoRange().add(mDataSet.getAxisDescription(2).getMin());
                axis.getAutoRange().add(mDataSet.getAxisDescription(2).getMax());
            } else {
                axis.getAutoRange().add(dataset.getAxisDescription(isHorizontal ? 0 : 1).getMin());
                axis.getAutoRange().add(dataset.getAxisDescription(isHorizontal ? 0 : 1).getMax());
            }
        });
        axis.getAutoRange().setAxisLength(axis.getLength() == 0.0 ? 1.0 : axis.getLength(), side);
        if (!axis.isAutoRanging() && !axis.isAutoGrowRanging()) {
            if (oldMin != axis.getMin() || oldMax != axis.getMax() || oldLength != axis.getLength()) {
                axis.requestAxisLayout();
            }
            axis.autoNotification().set(oldAutoState);
            return;
        }
        ArrayList<Number> dataMinMax = new ArrayList<Number>();
        dataSets.forEach(dataset -> dataset.lock().readLockGuardOptimistic(() -> {
            if (dataset instanceof DataSet3D && (side == Side.RIGHT || side == Side.TOP)) {
                DataSet3D mDataSet = (DataSet3D)dataset;
                dataMinMax.add(mDataSet.getAxisDescription(2).getMin());
                dataMinMax.add(mDataSet.getAxisDescription(2).getMax());
            } else {
                dataMinMax.add(dataset.getAxisDescription(isHorizontal ? 0 : 1).getMin());
                dataMinMax.add(dataset.getAxisDescription(isHorizontal ? 0 : 1).getMax());
            }
        }));
        if (axis.isAutoGrowRanging()) {
            dataMinMax.add(axis.getMin());
            dataMinMax.add(axis.getMax());
        }
        if (axis.isAutoGrowRanging()) {
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (Number val : dataMinMax) {
                min = Math.min(min, val.doubleValue());
                max = Math.max(max, val.doubleValue());
            }
            axis.set(min, max);
        } else {
            axis.invalidateRange(dataMinMax);
        }
        if (oldMin != axis.getMin() || oldMax != axis.getMax() || oldLength != axis.getLength()) {
            axis.requestAxisLayout();
        }
        axis.autoNotification().set(oldAutoState);
    }
}

