/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.viewer;

import de.gsi.chart.viewer.DataView;
import de.gsi.chart.viewer.DataViewPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class DataViewer
extends BorderPane {
    private final ObservableList<DataView> views = FXCollections.observableArrayList();
    private final VisibleViewerPane visibleViewerPane = new VisibleViewerPane();
    private final MinimizedViewerPane minimizedViewerPane = new MinimizedViewerPane();
    private final VBox viewerPane;
    private final BooleanProperty explorerVisible = new SimpleBooleanProperty(false);
    private final ObjectProperty<DataView> selectedView = new SimpleObjectProperty<DataView>((Object)this, "selectedView"){

        protected void invalidated() {
            DataViewer.this.visibleViewerPane.getChildren().setAll(((DataView)this.getValue()).getChildren());
            DataViewer.this.requestLayout();
        }
    };

    public DataViewer() {
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("DataViewer.css").toExternalForm());
        VBox.setVgrow((Node)this.visibleViewerPane, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.minimizedViewerPane, (Priority)Priority.SOMETIMES);
        this.viewerPane = new VBox(new Node[]{this.visibleViewerPane, this.minimizedViewerPane});
        this.setCenter((Node)this.viewerPane);
        ListChangeListener childChangeListener = c -> {
            System.err.println("added child -> update pane");
            this.layout();
        };
        ChangeListener maximizedViewPropertyListner = (obs, oldV, newV) -> {
            this.visibleViewerPane.requestLayout();
            this.minimizedViewerPane.requestLayout();
            this.requestLayout();
        };
        ListChangeListener minimizedViewPropertyListner = c -> {
            this.minimizedViewerPane.requestLayout();
            this.requestLayout();
        };
        ListChangeListener visibleViewPropertyListner = c -> {
            this.visibleViewerPane.requestLayout();
            this.requestLayout();
        };
        ListChangeListener viewsChangeListener = change -> {
            if (this.views.size() == 1) {
                this.setSelectedView((DataView)this.views.get(0));
            }
            this.requestLayout();
        };
        this.views.addListener(viewsChangeListener);
        this.selectedViewProperty().addListener((obs, oldView, newView) -> {
            if (oldView != null) {
                oldView.getChildren().removeListener(childChangeListener);
                oldView.maximizedViewProperty().removeListener(maximizedViewPropertyListner);
                oldView.getMinimizedChildren().removeListener(minimizedViewPropertyListner);
                oldView.getVisibleChildren().removeListener(visibleViewPropertyListner);
                System.err.println("old view");
            }
            if (newView != null) {
                newView.getChildren().addListener(childChangeListener);
                newView.maximizedViewProperty().addListener(maximizedViewPropertyListner);
                newView.getMinimizedChildren().addListener(minimizedViewPropertyListner);
                newView.getVisibleChildren().addListener(visibleViewPropertyListner);
                System.err.println("new view");
            }
            this.requestLayout();
        });
        this.requestLayout();
    }

    public final ObservableList<DataView> getViews() {
        return this.views;
    }

    public final BooleanProperty explorerVisibleProperty() {
        return this.explorerVisible;
    }

    public final boolean isExplorerVisible() {
        return this.explorerVisibleProperty().get();
    }

    public final void setExplorerVisible(boolean value) {
        this.explorerVisibleProperty().set(value);
    }

    public final ObjectProperty<DataView> selectedViewProperty() {
        return this.selectedView;
    }

    public final DataView getSelectedView() {
        return (DataView)this.selectedViewProperty().get();
    }

    public final void setSelectedView(DataView selectedView) {
        this.selectedViewProperty().set((Object)selectedView);
    }

    public void sort() {
        this.visibleViewerPane.sort();
    }

    private static <T> boolean listEqualsIgnoreOrder(ObservableList<Node> observableList, ObservableList<DataViewPane> observableList2) {
        return new HashSet<Node>((Collection<Node>)observableList).equals(new HashSet<DataViewPane>((Collection<DataViewPane>)observableList2));
    }

    private class MinimizedViewerPane
    extends GridPane {
        MinimizedViewerPane() {
            this.getStyleClass().add((Object)"minimizedviewer-pane");
        }

        protected void layoutChildren() {
            super.layoutChildren();
            DataView view = DataViewer.this.getSelectedView();
            if (view == null) {
                return;
            }
            this.removeOldChildren(view);
            int countX = 0;
            int countY = 0;
            for (DataViewPane child : view.getMinimizedChildren()) {
                child.setVisible(true);
                GridPane.setColumnIndex((Node)child, (Integer)countX);
                GridPane.setRowIndex((Node)child, (Integer)countY);
                GridPane.setFillWidth((Node)child, (Boolean)true);
                if (!this.getChildren().contains((Object)child)) {
                    System.err.println("minimized added child = " + child);
                    this.getChildren().add((Object)child);
                }
                if (++countX <= 3) continue;
                ++countY;
                countX = 0;
            }
            DataViewer.this.viewerPane.requestLayout();
        }

        private void removeOldChildren(DataView view) {
            ObservableList existingChildren = this.getChildren();
            for (Node child : existingChildren) {
                if (!(child instanceof DataViewPane)) continue;
                DataViewPane addedPane = (DataViewPane)child;
                if (view.getMinimizedChildren().contains((Object)addedPane)) continue;
                this.getChildren().remove((Object)addedPane);
            }
        }
    }

    private class VisibleViewerPane
    extends GridPane {
        private int oldColsCount = -1;

        VisibleViewerPane() {
            this.getStyleClass().add((Object)"viewer-pane");
        }

        private void sort() {
            DataView view = DataViewer.this.getSelectedView();
            ObservableList workingCollection = FXCollections.observableArrayList(view.getVisibleChildren());
            Collections.sort(workingCollection, (o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.titleProperty().getValue().compareTo(o2.titleProperty().getValue());
            });
            view.getVisibleChildren().setAll((Collection)workingCollection);
            this.layoutChildren();
        }

        protected void layoutChildren() {
            super.layoutChildren();
            DataView view = DataViewer.this.getSelectedView();
            if (view == null) {
                return;
            }
            this.removeOldChildren(view);
            if (view.getMaximizedView() == null) {
                this.layoutNormal(view);
            } else {
                this.layoutMaximized(view);
            }
        }

        private void removeOldChildren(DataView view) {
        }

        private void layoutMaximized(DataView view) {
            for (DataViewPane child : view.getVisibleChildren()) {
                if (child == view.getMaximizedView()) {
                    if (!this.getChildren().contains((Object)child)) {
                        System.err.println("maximized added child = " + child);
                        this.getChildren().add((Object)child);
                    }
                    child.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
                    child.setVisible(true);
                    continue;
                }
                child.setVisible(false);
                child.resizeRelocate(0.0, 0.0, 0.0, 0.0);
            }
        }

        private void layoutNormal(DataView view) {
            int childCount;
            DataView.Layout layout = view.getLayout() == null ? DataView.Layout.GRID : view.getLayout();
            int colsCount = this.getColumnsCount(layout, childCount = view.getVisibleChildren().size());
            if (this.oldColsCount != colsCount) {
                ArrayList<ColumnConstraints> colConstraintList = new ArrayList<ColumnConstraints>();
                for (int i = 0; i < colsCount; ++i) {
                    ColumnConstraints colConstraints = new ColumnConstraints();
                    colConstraints.setPercentWidth(100.0 / (double)colsCount);
                    colConstraints.setHgrow(Priority.ALWAYS);
                    colConstraints.setFillWidth(true);
                    colConstraintList.add(colConstraints);
                }
                this.getColumnConstraints().clear();
                this.getColumnConstraints().addAll(colConstraintList);
                System.err.println("update column constraints");
                this.oldColsCount = colsCount;
            }
            if (!DataViewer.listEqualsIgnoreOrder((ObservableList<Node>)this.getChildren(), view.getVisibleChildren())) {
                System.err.println("cleared dataset");
                this.getChildren().clear();
            }
            int rowIndex = 0;
            int colIndex = 0;
            for (DataViewPane child : view.getVisibleChildren()) {
                GridPane.setHgrow((Node)child, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)child, (Priority)Priority.ALWAYS);
                child.setVisible(true);
                child.setPrefSize(300.0, 200.0);
                GridPane.setColumnIndex((Node)child, (Integer)colIndex);
                GridPane.setRowIndex((Node)child, (Integer)rowIndex);
                if (!this.getChildren().contains((Object)child)) {
                    this.getChildren().add((Object)child);
                }
                if (++colIndex < colsCount) continue;
                colIndex = 0;
                ++rowIndex;
            }
            if (rowIndex == 0) {
                ++rowIndex;
            }
        }

        private int getColumnsCount(DataView.Layout layout, int childCount) {
            switch (layout) {
                case HBOX: {
                    return childCount;
                }
                case VBOX: {
                    return 1;
                }
            }
            if (childCount < 4) {
                return 1;
            }
            int ncols = (int)Math.ceil(Math.sqrt(childCount));
            if (ncols == 0) {
                ncols = 1;
            }
            return ncols;
        }
    }
}

