/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicScreenCapture
implements Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicScreenCapture.class);
    private static final String DEFAULT_TIME_FORMAT = "yyyyMMdd_HHmmss";
    private static final String FILE_LOGGING_SUFFIX = ".png";
    private static final String IMAGE_FORMAT = "png";
    private final Scene primaryScene;
    private final Path path;
    private final String fileName;
    private final double delay;
    private final double period;
    private Timeline periodicTask;
    private String isoDateTimeFormatString = "yyyyMMdd_HHmmss";
    private final boolean addDateTime;
    protected final List<InvalidationListener> listeners = new LinkedList<InvalidationListener>();
    private final Timer timer = new Timer();

    public PeriodicScreenCapture(Path path, String fileName, Scene scene, double delay, double period) {
        this(path, fileName, scene, delay, period, false);
    }

    public PeriodicScreenCapture(Path path, String fileName, Scene scene, double delay, double period, boolean addDateTime) {
        this.path = path;
        this.fileName = fileName.replaceAll(FILE_LOGGING_SUFFIX, "").replaceAll(".PNG", "");
        this.primaryScene = scene;
        this.delay = delay;
        this.period = period;
        this.addDateTime = addDateTime;
    }

    public void start() {
        if (this.periodicTask != null) {
            this.periodicTask.stop();
        }
        this.periodicTask = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)this.period), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PeriodicScreenCapture.this.performScreenCapture();
            }
        }, new KeyValue[0])});
        this.periodicTask.setDelay(Duration.seconds((double)this.delay));
        this.periodicTask.setCycleCount(-1);
        this.periodicTask.play();
    }

    public void stop() {
        if (this.periodicTask != null) {
            this.periodicTask.stop();
        }
    }

    public void performScreenCapture() {
        try {
            final WritableImage image = this.primaryScene.snapshot(null);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PeriodicScreenCapture.this.writeImage((Image)image);
                }
            }, 0L);
            LOGGER.debug("this is called periodic on UI thread");
        }
        catch (Exception e) {
            LOGGER.error("error while writing screen captured image to file", (Throwable)e);
        }
    }

    public void setIsoDateTimeFormatterString(String newFormat) {
        if (newFormat == null || newFormat.isEmpty()) {
            throw new IllegalArgumentException("new format must not be null or empty");
        }
        this.isoDateTimeFormatString = newFormat;
    }

    public String getIsoDateTimeFormatterString() {
        return this.isoDateTimeFormatString;
    }

    protected static String getISODate(long timeMillis, String format) {
        long time = TimeUnit.MILLISECONDS.toMillis(timeMillis);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(tz);
        return df.format(new Date(time));
    }

    private void writeImage(Image image) {
        long now = System.currentTimeMillis();
        try {
            String format = this.getIsoDateTimeFormatterString();
            String longFileName = this.addDateTime && format != null && !format.isEmpty() ? this.path.toFile() + String.format("/%s_%s%s", this.fileName, PeriodicScreenCapture.getISODate(now, format), FILE_LOGGING_SUFFIX) : this.path.toFile() + "/" + this.fileName;
            String tempFileName = longFileName + "_temp.png";
            File file = new File(tempFileName);
            if (file.getParentFile().mkdirs()) {
                LOGGER.info("needed to create directory for file: " + longFileName);
            }
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), IMAGE_FORMAT, file);
            Files.move(Paths.get(tempFileName, new String[0]), Paths.get(longFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            this.fireInvalidated();
            LOGGER.debug("write screenshot to " + tempFileName + " -> " + longFileName);
        }
        catch (Exception e) {
            LOGGER.error("could not write to file: '" + this.fileName + "'", (Throwable)e);
        }
    }

    public void addListener(InvalidationListener listener) {
        Objects.requireNonNull(listener, "InvalidationListener must not be null");
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        this.listeners.remove(listener);
    }

    public void fireInvalidated() {
        if (this.listeners.isEmpty()) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.executeFireInvalidated();
        } else {
            Platform.runLater(this::executeFireInvalidated);
        }
    }

    protected void executeFireInvalidated() {
        for (InvalidationListener listener : new ArrayList<InvalidationListener>(this.listeners)) {
            listener.invalidated((Observable)this);
        }
    }
}

