/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class PercentageStringConverter
extends StringConverter<Number> {
    private int precision = 1;
    private boolean appendPercentSign = true;
    private final DecimalFormat format = new DecimalFormat();

    public PercentageStringConverter() {
        this.buildFormat(this.precision);
    }

    public PercentageStringConverter(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
    }

    public PercentageStringConverter(int precision, boolean appendPercentSign) {
        this.precision = precision;
        this.appendPercentSign = appendPercentSign;
        this.buildFormat(precision);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
    }

    public boolean isAppendPercentSign() {
        return this.appendPercentSign;
    }

    public void setAppendPercentSign(boolean appendPercentSign) {
        this.appendPercentSign = appendPercentSign;
    }

    public String toString(Number object) {
        return this.format.format(object.doubleValue() * 100.0) + (this.appendPercentSign ? "%" : "");
    }

    public Number fromString(String input) {
        String s = input;
        int p = s.indexOf(37);
        if (p > 0) {
            s = s.substring(0, p);
        }
        return Double.parseDouble(s);
    }

    private void buildFormat(int precision) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("0");
        if (precision > 0) {
            sb.append(".");
            for (int i = 0; i < precision; ++i) {
                sb.append('0');
            }
        }
        this.format.applyPattern(sb.toString());
    }
}

