/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class MemorySizeStringConverter
extends StringConverter<Number> {
    private int precision = 1;
    private Unit unit = Unit.BEST;
    private final DecimalFormat format = new DecimalFormat();

    public MemorySizeStringConverter() {
        this.buildFormat(this.precision);
    }

    public MemorySizeStringConverter(Unit unit) {
        this.unit = unit;
        this.buildFormat(this.precision);
    }

    public MemorySizeStringConverter(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
    }

    public MemorySizeStringConverter(Unit unit, int precision) {
        this.unit = unit;
        this.precision = precision;
        this.buildFormat(precision);
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
        this.buildFormat(precision);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String toString(Number object) {
        String u;
        double v = object.doubleValue();
        switch (this.unit) {
            case BEST: {
                if (v < 1000.0) {
                    u = "B";
                    break;
                }
                if (v < 1000000.0) {
                    v /= 1000.0;
                    u = "kB";
                    break;
                }
                if (v < 1.0E9) {
                    v /= 1000000.0;
                    u = "MB";
                    break;
                }
                v /= 1.0E9;
                u = "GB";
                break;
            }
            case KILOBYTE: {
                v /= 1000.0;
                u = "kB";
                break;
            }
            case MEGABYTE: {
                v /= 1000000.0;
                u = "MB";
                break;
            }
            case GIGABYTE: {
                v /= 1.0E9;
                u = "GB";
                break;
            }
            default: {
                u = "B";
            }
        }
        return this.format.format(v) + u;
    }

    public Number fromString(String string) {
        throw new UnsupportedOperationException("Parsing memory size string not implemented yet");
    }

    private void buildFormat(int precision) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("0.");
        for (int i = 0; i < precision; ++i) {
            sb.append('0');
        }
        this.format.applyPattern(sb.toString());
    }

    public static enum Unit {
        BEST,
        BYTE,
        KILOBYTE,
        MEGABYTE,
        GIGABYTE;

    }
}

