/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.utils;

import de.gsi.chart.axes.spi.AbstractAxis;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class AxisSynchronizer {
    private boolean updating;
    private final ArrayList<AbstractAxis> charts = new ArrayList();
    private final ChangeListener<Number> upperBoundChangeListener = this::upperBoundChanged;
    private final ChangeListener<Number> lowerBoundChangeListener = this::lowerBoundChanged;

    public void add(AbstractAxis axis) {
        this.charts.add(axis);
        axis.upperBoundProperty().addListener(this.upperBoundChangeListener);
        axis.lowerBoundProperty().addListener(this.lowerBoundChangeListener);
    }

    public void remove(AbstractAxis axis) {
        this.charts.remove(axis);
        axis.upperBoundProperty().removeListener(this.upperBoundChangeListener);
        axis.lowerBoundProperty().removeListener(this.lowerBoundChangeListener);
        axis.setAutoRanging(true);
    }

    private void upperBoundChanged(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
        if (!this.updating) {
            double value = newValue.doubleValue();
            if (Double.isNaN(value)) {
                return;
            }
            if (value == oldValue.doubleValue()) {
                return;
            }
            this.updating = true;
            AbstractAxis sender = this.findAxis(property);
            double tickUnit = this.calculateTickUnit(sender);
            for (AbstractAxis axis : this.charts) {
                if (axis != sender) {
                    axis.setAutoRanging(false);
                    axis.setUpperBound(value);
                }
                axis.setTickUnit(tickUnit);
            }
            this.updating = false;
        }
    }

    private void lowerBoundChanged(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
        if (!this.updating) {
            double value = newValue.doubleValue();
            if (Double.isNaN(value)) {
                return;
            }
            if (value == oldValue.doubleValue()) {
                return;
            }
            this.updating = true;
            AbstractAxis sender = this.findAxis(property);
            double tickUnit = this.calculateTickUnit(sender);
            for (AbstractAxis axis : this.charts) {
                if (axis != sender) {
                    axis.setLowerBound(value);
                    axis.setAutoRanging(false);
                }
                axis.setTickUnit(tickUnit);
            }
            this.updating = false;
        }
    }

    private AbstractAxis findAxis(ObservableValue<? extends Number> property) {
        for (AbstractAxis chart : this.charts) {
            if (property == chart.upperBoundProperty()) {
                return chart;
            }
            if (property != chart.lowerBoundProperty()) continue;
            return chart;
        }
        return null;
    }

    private double calculateTickUnit(AbstractAxis axis) {
        return axis.computePreferredTickUnit(axis.getLength());
    }
}

