/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.ui;

import de.gsi.chart.ui.SidesPaneSkin;
import de.gsi.chart.ui.geometry.Side;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class SidesPane
extends Control {
    private final DoubleProperty prefHeightTop = new SimpleDoubleProperty((Object)this, "prefHeightTop", -1.0);
    private final DoubleProperty prefHeightBottom = new SimpleDoubleProperty((Object)this, "prefHeightBottom", -1.0);
    private final DoubleProperty prefWidthLeft = new SimpleDoubleProperty((Object)this, "prefWidthLeft", -1.0);
    private final DoubleProperty prefWidthRight = new SimpleDoubleProperty((Object)this, "prefWidthRight", -1.0);
    private final DoubleProperty triggerDistance = new SimpleDoubleProperty((Object)this, "triggerDistance", 16.0);
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final ObjectProperty<Node> top = new SimpleObjectProperty<Node>((Object)this, "top"){

        public void set(Node node) {
            if (node instanceof Region) {
                ((Region)node).setPadding(Insets.EMPTY);
                ((Region)node).setPrefHeight(-1.0);
                ((Region)node).setMinHeight(0.0);
                ((Region)node).setPrefWidth(-1.0);
                ((Region)node).setMinWidth(0.0);
            }
            super.set((Object)node);
        }
    };
    private final ObjectProperty<Node> right = new SimpleObjectProperty<Node>((Object)this, "right"){

        public void set(Node node) {
            if (node instanceof Region) {
                ((Region)node).setPadding(Insets.EMPTY);
                ((Region)node).setPrefHeight(-1.0);
                ((Region)node).setMinHeight(0.0);
                ((Region)node).setPrefWidth(-1.0);
                ((Region)node).setMinWidth(0.0);
            }
            super.set((Object)node);
        }
    };
    private final ObjectProperty<Node> bottom = new SimpleObjectProperty<Node>((Object)this, "bottom"){

        public void set(Node node) {
            if (node instanceof Region) {
                ((Region)node).setPadding(Insets.EMPTY);
                ((Region)node).setPrefHeight(-1.0);
                ((Region)node).setMinHeight(0.0);
                ((Region)node).setPrefWidth(-1.0);
                ((Region)node).setMinWidth(0.0);
            }
            super.set((Object)node);
        }
    };
    private final ObjectProperty<Node> left = new SimpleObjectProperty<Node>((Object)this, "left"){

        public void set(Node node) {
            if (node instanceof Region) {
                ((Region)node).setPadding(Insets.EMPTY);
                ((Region)node).setPrefHeight(-1.0);
                ((Region)node).setMinHeight(0.0);
                ((Region)node).setPrefWidth(-1.0);
                ((Region)node).setMinWidth(0.0);
            }
            super.set((Object)node);
        }
    };
    private final ObservableMap<Side, Boolean> pinnedSide = FXCollections.observableHashMap();
    private final ObjectProperty<Duration> animationDelay = new SimpleObjectProperty((Object)this, "animationDelay", (Object)Duration.millis((double)500.0));
    private final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)200.0));

    public SidesPane(Node content, Node top, Node right, Node bottom, Node left) {
        this.setContent(content);
        this.setTop(top);
        this.setRight(right);
        this.setBottom(bottom);
        this.setLeft(left);
        this.topProperty().addListener((obs, o, n) -> {
            if (n != null) {
                double val = n.prefHeight(-1.0);
                this.prefHeightTop.set(val > 0.0 ? val : -1.0);
            }
        });
        this.bottomProperty().addListener((obs, o, n) -> {
            if (n != null) {
                double val = n.prefHeight(-1.0);
                this.prefHeightBottom.set(val > 0.0 ? val : -1.0);
            }
        });
        this.leftProperty().addListener((obs, o, n) -> {
            if (n != null) {
                double val = n.prefWidth(-1.0);
                this.prefWidthLeft.set(val > 0.0 ? val : -1.0);
            }
        });
        this.rightProperty().addListener((obs, o, n) -> {
            if (n != null) {
                double val = n.prefWidth(-1.0);
                this.prefWidthRight.set(val > 0.0 ? val : -1.0);
            }
        });
    }

    public SidesPane() {
        this(null, null, null, null, null);
    }

    protected Skin<?> createDefaultSkin() {
        return new SidesPaneSkin(this);
    }

    public DoubleProperty prefHeightTopProperty() {
        return this.prefHeightTop;
    }

    public DoubleProperty prefHeightBottomProperty() {
        return this.prefHeightBottom;
    }

    public DoubleProperty prefWidthLeftProperty() {
        return this.prefWidthLeft;
    }

    public DoubleProperty prefWidthRightProperty() {
        return this.prefWidthRight;
    }

    public final DoubleProperty triggerDistanceProperty() {
        return this.triggerDistance;
    }

    public final double getTriggerDistance() {
        return this.triggerDistance.get();
    }

    public final void setTriggerDistance(double distance) {
        this.triggerDistance.set(distance);
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public final void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public final ObjectProperty<Node> topProperty() {
        return this.top;
    }

    public final Node getTop() {
        return (Node)this.topProperty().get();
    }

    public final void setTop(Node top) {
        this.topProperty().set((Object)top);
    }

    public final ObjectProperty<Node> rightProperty() {
        return this.right;
    }

    public final Node getRight() {
        return (Node)this.rightProperty().get();
    }

    public final void setRight(Node right) {
        this.rightProperty().set((Object)right);
    }

    public final ObjectProperty<Node> bottomProperty() {
        return this.bottom;
    }

    public final Node getBottom() {
        return (Node)this.bottomProperty().get();
    }

    public final void setBottom(Node bottom) {
        this.bottomProperty().set((Object)bottom);
    }

    public final ObjectProperty<Node> leftProperty() {
        return this.left;
    }

    public final Node getLeft() {
        return (Node)this.leftProperty().get();
    }

    public final void setLeft(Node left) {
        this.leftProperty().set((Object)left);
    }

    public final ObservableMap<Side, Boolean> pinnedSideProperty() {
        return this.pinnedSide;
    }

    public final Boolean isPinned(Side side) {
        Boolean ret = (Boolean)this.pinnedSideProperty().get((Object)side);
        if (ret == null) {
            return false;
        }
        return (boolean)ret;
    }

    public final void setPinned(Side side, Boolean stateState) {
        if (this.pinnedSideProperty().get((Object)side) == null) {
            this.pinnedSideProperty().put((Object)side, (Object)stateState);
            return;
        }
        this.pinnedSideProperty().replace((Object)side, (Object)stateState);
    }

    public final ObjectProperty<Duration> animationDelayProperty() {
        return this.animationDelay;
    }

    public final Duration getAnimationDelay() {
        return (Duration)this.animationDelay.get();
    }

    public final void setAnimationDelay(Duration duration) {
        this.animationDelay.set((Object)duration);
    }

    public final ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public final Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public final void setAnimationDuration(Duration duration) {
        this.animationDuration.set((Object)duration);
    }
}

