/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.utils;

import java.util.WeakHashMap;

public final class Cache {
    protected WeakHashMap<String, WeakHashMap<Integer, double[]>> doubleArrayCache = new WeakHashMap();
    protected WeakHashMap<String, WeakHashMap<Integer, int[]>> intArrayCache = new WeakHashMap();
    protected WeakHashMap<String, WeakHashMap<Integer, boolean[]>> booleanArrayCache = new WeakHashMap();
    protected WeakHashMap<String, WeakHashMap<Integer, String[]>> stringArrayCache = new WeakHashMap();

    public synchronized double[] getCachedDoubleArray(String arrayName, int size) {
        double[] cachedArray;
        if (this.doubleArrayCache.get(arrayName) == null) {
            this.doubleArrayCache.put(arrayName, new WeakHashMap());
        }
        if ((cachedArray = this.doubleArrayCache.get(arrayName).get(size)) == null) {
            cachedArray = new double[size];
        } else {
            this.doubleArrayCache.get(arrayName).remove(cachedArray);
        }
        return cachedArray;
    }

    public synchronized void release(String arrayName, double[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        this.doubleArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public synchronized int[] getCachedIntArray(String arrayName, int size) {
        int[] cachedArray;
        if (this.intArrayCache.get(arrayName) == null) {
            this.intArrayCache.put(arrayName, new WeakHashMap());
        }
        if ((cachedArray = this.intArrayCache.get(arrayName).get(size)) == null) {
            cachedArray = new int[size];
        } else {
            this.intArrayCache.get(arrayName).remove(cachedArray);
        }
        return cachedArray;
    }

    public synchronized void release(String arrayName, int[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        this.intArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public synchronized boolean[] getCachedBooleanArray(String arrayName, int size) {
        boolean[] cachedArray;
        if (this.booleanArrayCache.get(arrayName) == null) {
            this.booleanArrayCache.put(arrayName, new WeakHashMap());
        }
        if ((cachedArray = this.booleanArrayCache.get(arrayName).get(size)) == null) {
            cachedArray = new boolean[size];
        } else {
            this.booleanArrayCache.get(arrayName).remove(cachedArray);
        }
        return cachedArray;
    }

    public synchronized void release(String arrayName, boolean[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        this.booleanArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }

    public synchronized String[] getCachedStringArray(String arrayName, int size) {
        String[] cachedArray;
        if (this.stringArrayCache.get(arrayName) == null) {
            this.stringArrayCache.put(arrayName, new WeakHashMap());
        }
        if ((cachedArray = this.stringArrayCache.get(arrayName).get(size)) == null) {
            cachedArray = new String[size];
        } else {
            this.stringArrayCache.get(arrayName).remove(cachedArray);
        }
        return cachedArray;
    }

    public synchronized void release(String arrayName, String[] cachedArray) {
        if (cachedArray == null) {
            return;
        }
        this.stringArrayCache.get(arrayName).put(cachedArray.length, cachedArray);
    }
}

