/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.marchingsquares;

import javafx.geometry.Side;

class Cell {
    private byte cellNdx;
    private final boolean flipped;
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;

    Cell(int ndx, boolean flipped, float left, float top, float right, float bottom) {
        this.cellNdx = (byte)ndx;
        this.flipped = flipped && ndx != 5 && ndx != 10 ? false : flipped;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public void clear() {
        switch (this.cellNdx) {
            case 0: 
            case 5: 
            case 10: 
            case 15: {
                break;
            }
            default: {
                this.cellNdx = (byte)15;
            }
        }
    }

    public byte getCellNdx() {
        return this.cellNdx;
    }

    public float[] getXY(Side edge) {
        switch (edge) {
            case BOTTOM: {
                return new float[]{this.bottom, 0.0f};
            }
            case LEFT: {
                return new float[]{0.0f, this.left};
            }
            case RIGHT: {
                return new float[]{1.0f, this.right};
            }
            case TOP: {
                return new float[]{this.top, 1.0f};
            }
        }
        throw new IllegalStateException("getXY: N/A w/o a non-trivial edge");
    }

    public boolean isSaddle() {
        return this.cellNdx == 5 || this.cellNdx == 10;
    }

    public boolean isTrivial() {
        return this.cellNdx == 0 || this.cellNdx == 15;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public String toString() {
        return "Cell{index=" + this.cellNdx + ", flipped? " + this.flipped + ", left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + "}";
    }
}

