/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.hexagon;

import de.gsi.chart.renderer.spi.hexagon.GridPosition;
import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonCallback;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import java.util.Collection;
import javafx.scene.Group;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class GridDrawer {
    private final HexagonMap map;
    private Font font = new Font(13.0);

    GridDrawer(HexagonMap map) {
        this.map = map;
    }

    void draw(Group root) {
        Collection<Hexagon> hexagons = this.map.getAllHexagons();
        for (Hexagon hexagon : hexagons) {
            hexagon.addEventFilter(MouseEvent.MOUSE_CLICKED, me -> {
                GridPosition pos = ((Hexagon)((Object)((Object)me.getSource()))).position;
                for (HexagonCallback callBack : this.map.onHexClickedCallback) {
                    Hexagon hex;
                    if (callBack == null || (hex = this.map.getHexagon(pos)) == null) continue;
                    callBack.handle(hex);
                }
            });
            hexagon.addEventFilter(MouseEvent.MOUSE_ENTERED, me -> {
                GridPosition pos = ((Hexagon)((Object)((Object)me.getSource()))).position;
                for (HexagonCallback callBack : this.map.onHexEnteredCallback) {
                    Hexagon hex;
                    if (callBack == null || (hex = this.map.getHexagon(pos)) == null) continue;
                    callBack.handle(hex);
                }
            });
            hexagon.addEventFilter(MouseEvent.MOUSE_EXITED, me -> {
                GridPosition pos = ((Hexagon)((Object)((Object)me.getSource()))).position;
                for (HexagonCallback callBack : this.map.onHexExitCallback) {
                    Hexagon hex;
                    if (callBack == null || (hex = this.map.getHexagon(pos)) == null) continue;
                    callBack.handle(hex);
                }
            });
            root.getChildren().add((Object)hexagon);
            if (!this.map.renderCoordinates) continue;
            Text text = new Text(hexagon.position.getCoordinates());
            text.setFont(this.font);
            double textWidth = text.getBoundsInLocal().getWidth();
            double textHeight = text.getBoundsInLocal().getHeight();
            text.setX((double)hexagon.getGraphicsXoffset() - textWidth / 2.0);
            text.setY((double)hexagon.getGraphicsYoffset() + textHeight / 4.0);
            root.getChildren().add((Object)text);
        }
    }

    void draw(Canvas canvas) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, gc.getCanvas().getWidth(), gc.getCanvas().getHeight());
        for (Hexagon hexagon : this.map.getAllHexagons()) {
            hexagon.draw(gc);
            if (!this.map.renderCoordinates) continue;
            hexagon.renderCoordinates(gc);
        }
    }

    void drawContour(Canvas canvas) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, gc.getCanvas().getWidth(), gc.getCanvas().getHeight());
        for (Hexagon hexagon : this.map.getAllHexagons()) {
            hexagon.drawContour(gc);
            if (!this.map.renderCoordinates) continue;
            hexagon.renderCoordinates(gc);
        }
    }

    public static GridPosition pixelToPosition(int x, int y, int hexagonHeight, int xPadding, int yPadding) {
        double hexagonRadius = (double)hexagonHeight / 2.0;
        double q = (0.3333333333333333 * Math.sqrt(3.0) * (double)(x -= xPadding) - 0.3333333333333333 * (double)(y -= yPadding)) / hexagonRadius;
        double r = 0.6666666666666666 * (double)y / hexagonRadius;
        return GridPosition.hexRound(q, r);
    }

    void setFont(Font font) {
        this.font = font;
    }
}

